/*
    si - Version 1.0 - By Joe Turgeon (jturgeon@isd.net)
    data.c

    si - System Information Viewer
    Copyright (C) 1999  Joe Turgeon (jturgeon@isd.net)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#include "main.h"


// display_data ()
void display_data () {
	int i;

	dumpstr ("exinfo",    0, PROCINFO[PROC_EXINFO]);
	dumpstr ("cmdline",   0, PROCINFO[PROC_CMDLINE]);
	dumpstr ("domain",    0, PROCINFO[PROC_DOMAINNAME]);
	dumpstr ("hostname",  0, PROCINFO[PROC_HOSTNAME]);
	dumpstr ("modprobe",  0, PROCINFO[PROC_MODPROBE]);
	dumpstr ("osrelver",  0, PROCINFO[PROC_OSRELEASE]);
	dumpstr ("ostype",    0, PROCINFO[PROC_OSTYPE]);
	dumpstr ("oscomver",  0, PROCINFO[PROC_VERSION]);
	dumpstr ("loadavg",   1, PROCINFO[PROC_LOADAVG_1]);
	dumpstr ("loadavg",   5, PROCINFO[PROC_LOADAVG_5]);
	dumpstr ("loadavg",  15, PROCINFO[PROC_LOADAVG_15]);
	dumpstr ("uptime",    0, PROCINFO[PROC_UPTIME]);
	dumpstr ("cpuuser",   0, PROCINFO[PROC_CPUUSER]);
	dumpstr ("cpunice",   0, PROCINFO[PROC_CPUNICE]);
	dumpstr ("cpusys",    0, PROCINFO[PROC_CPUSYS]);
	dumpstr ("cpuidle",   0, PROCINFO[PROC_CPUIDLE]);
	dumpint ("disk",      0, PROC_DISK);
	dumpint ("diskrio",   0, PROC_DISKRIO);
	dumpint ("diskwio",   0, PROC_DISKWIO);
	dumpint ("diskrblk",  0, PROC_DISKRBLK);
	dumpint ("diskwblk",  0, PROC_DISKWBLK);
	dumpstr ("pagein",    0, PROCINFO[PROC_PAGE_IN]);
	dumpstr ("pageout",   0, PROCINFO[PROC_PAGE_OUT]);
	dumpstr ("swapin",    0, PROCINFO[PROC_SWAP_IN]);
	dumpstr ("swapout",   0, PROCINFO[PROC_SWAP_OUT]);
	dumpstr ("context",   0, PROCINFO[PROC_CTXT]);
	dumpstr ("boottime",  0, PROCINFO[PROC_BTIME]);
	dumpstr ("process",   0, PROCINFO[PROC_PROCESS]);
	dumpstr ("memttl",    0, PROCINFO[PROC_MEMTOTAL]);
	dumpstr ("memfree",   0, PROCINFO[PROC_MEMFREE]);
	dumpstr ("memshare",  0, PROCINFO[PROC_MEMSHARED]);
	dumpstr ("buffers",   0, PROCINFO[PROC_BUFFERS]);
	dumpstr ("cached",    0, PROCINFO[PROC_CACHED]);
	dumpstr ("swapttl",   0, PROCINFO[PROC_SWAPTOTAL]);
	dumpstr ("swapfree",  0, PROCINFO[PROC_SWAPFREE]);
	dumpstr ("sounddrv",  0, PROCINFO[PROC_SOUNDDRV]);
	for (i=0; i<=NUM_CHARDEV; i++)
		dumpexp ("chardev",   i, "%d %s", CHARDEV[i]->NUMBER, CHARDEV[i]->NAME);
	for (i=0; i<=NUM_BLOCKDEV; i++)
		dumpexp ("blockdev",  i, "%d %s", BLOCKDEV[i]->NUMBER, BLOCKDEV[i]->NAME);
	for (i=0; i<=NUM_ISADMA; i++)
		dumpexp ("isadma",    i, "%d %s", ISADMA[i]->NUMBER, ISADMA[i]->NAME);
	for (i=0; i<=NUM_MISC; i++)
		dumpexp ("misc",      i, "%d %s", MISC[i]->NUMBER, MISC[i]->NAME);
	for (i=0; i<=NUM_FILESYS; i++)
		dumpexp ("filesys",   i, "%s %s", FILESYS[i]->NAME, FILESYS[i]->DEV);
	for (i=0; i<=NUM_CPU; i++) {
		dumpstr ("cpuvendr",  i, CPU[i]->VENDOR);
		dumpstr ("cpumodel",  i, CPU[i]->MODEL);
		dumpstr ("cpuspeed",  i, CPU[i]->SPEED);
		dumpstr ("cpucache",  i, CPU[i]->CACHE);
		dumpstr ("cpuuser",   i, CPU[i]->USER);
		dumpstr ("cpunice",   i, CPU[i]->NICE);
		dumpstr ("cpusys",    i, CPU[i]->SYS);
		dumpstr ("cpuidle",   i, CPU[i]->IDLE);
	}
	for (i=0; i<=NUM_SCSIDEV; i++) {
		dumpstr ("sdhost",    i, SCSIDEV[i]->HOST);
		dumpint ("sdchan",    i, SCSIDEV[i]->CHANNEL);
		dumpint ("sdid",      i, SCSIDEV[i]->ID);
		dumpint ("sdlun",     i, SCSIDEV[i]->LUN);
		dumpstr ("sdvendor",  i, SCSIDEV[i]->VENDOR);
		dumpstr ("sdmodel",   i, SCSIDEV[i]->MODEL);
		dumpstr ("sdrev",     i, SCSIDEV[i]->REV);
		dumpstr ("sdtype",    i, SCSIDEV[i]->TYPE);
		dumpstr ("sdansirv",  i, SCSIDEV[i]->ANSIREV);
	}
	for (i=0; i<=NUM_SCSIDRV; i++) {
		dumpstr ("sdrvname",  i, SCSIDRV[i]->NAME);
		dumpstr ("sdrvdesc",  i, SCSIDRV[i]->DESC);
	}
	for (i=0; i<=NUM_TTYDRIVERS; i++) {
		dumpstr ("ttydrvr",   i, TTYDRIVERS[i]->DRIVER);
		dumpstr ("ttyname",   i, TTYDRIVERS[i]->NAME);
		dumpstr ("ttymajor",  i, TTYDRIVERS[i]->MAJOR);
		dumpstr ("ttyrange",  i, TTYDRIVERS[i]->RANGE);
		dumpstr ("ttytype",   i, TTYDRIVERS[i]->TYPE);
	}
	for (i=0; i<=NUM_TTYLDISCS; i++) {
		dumpstr ("ttyldnm",   i, TTYLDISCS[i]->NAME);
		dumpint ("ttyldcnt",  i, TTYLDISCS[i]->COUNT);
	}
	for (i=0; i<=NUM_MTRR; i++) {
		dumpint ("mtrrreg",   i, MTRR[i]->REG);
		dumpstr ("mtrrohex",  i, MTRR[i]->OFFHEX);
		dumpint ("mtrromb",   i, MTRR[i]->OFFMB);
		dumpint ("mtrrsize",  i, MTRR[i]->SIZE);
		dumpstr ("mtrropt",   i, MTRR[i]->OPTION);
		dumpint ("mtrrcnt",   i, MTRR[i]->COUNT);
	}
	for (i=0; i<=NUM_IDEDRV; i++) {
		dumpstr ("idedrvnm",  i, IDEDRV[i]->NAME);
		dumpstr ("idedrvvr",  i, IDEDRV[i]->VERSION);
	}
	for (i=0; i<=NUM_IDEDEV; i++) {
		dumpstr ("idename",   i, IDEDEV[i]->NAME);
		dumpstr ("ideparnt",  i, IDEDEV[i]->PARENT);
		dumpstr ("idedrivr",  i, IDEDEV[i]->DRIVER);
		dumpstr ("idemedia",  i, IDEDEV[i]->MEDIA);
		dumpstr ("idemodel",  i, IDEDEV[i]->MODEL);
		dumpint ("idecyl",    i, IDEDEV[i]->CYL);
		dumpint ("idehead",   i, IDEDEV[i]->HEAD);
		dumpint ("idesect",   i, IDEDEV[i]->SECT);
	}
	for (i=0; i<=NUM_PARPORT; i++) {
		dumpstr ("ppname",    i, PARPORT[i]->NAME);
		dumpstr ("ppprobe",   i, PARPORT[i]->AUTOPROBE);
		dumpstr ("ppdevice",  i, PARPORT[i]->DEVICES);
		dumpstr ("ppioport",  i, PARPORT[i]->IOPORT);
		dumpstr ("ppdma",     i, PARPORT[i]->DMA);
		dumpstr ("ppirq",     i, PARPORT[i]->IRQ);
		dumpstr ("pptype",    i, PARPORT[i]->PORTTYPE);
	}
	for (i=0; i<=NUM_MOUNTS; i++) {
		dumpstr ("mntdev",    i, MOUNTS[i]->DEVICE);
		dumpstr ("mntpath",   i, MOUNTS[i]->MOUNTPOINT);
		dumpstr ("mntflsys",  i, MOUNTS[i]->FILESYS);
		dumpstr ("mntmode",   i, MOUNTS[i]->MODE);
	}
	for (i=0; i<=NUM_PROC; i++)
		dumpexp ("process",   PROC[i]->PID, "%s  (%s)", PROC[i]->NAME, PROC[i]->CMDLINE);
	for (i=0; i<=NUM_MODULES; i++)
		dumpstr ("modules",   i, (char *)MODULES[i]);
	for (i=0; i<=NUM_IRQINT; i++)
		dumpstr ("irqint",    i, (char *)IRQINT[i]);
	for (i=0; i<=NUM_IOPORTS; i++)
		dumpstr ("ioport",    i, (char *)IOPORTS[i]);
	for (i=0; i<=NUM_PARTS; i++)
		dumpstr ("dskpart",   i, (char *)PARTS[i]);
	for (i=0; i<=NUM_SWAPS; i++)
		dumpstr ("swap",      i, (char *)SWAPS[i]);
	for (i=0; i<=NUM_SNDDRV; i++)
		dumpstr ("snddrv",    i, (char *)SNDDRV[i]);
	for (i=0; i<=NUM_SNDCONF; i++)
		dumpstr ("sndconf",   i, (char *)SNDCONF[i]);
	for (i=0; i<=NUM_SNDAUDIO; i++)
		dumpstr ("sndaudio",  i, (char *)SNDAUDIO[i]);
	for (i=0; i<=NUM_SNDSYNTH; i++)
		dumpstr ("sndsynth",  i, (char *)SNDSYNTH[i]);
	for (i=0; i<=NUM_SNDMIDI; i++)
		dumpstr ("sndmidi",   i, (char *)SNDMIDI[i]);
	for (i=0; i<=NUM_SNDTIMERS; i++)
		dumpstr ("sndtimer",  i, (char *)SNDTIMERS[i]);
	for (i=0; i<=NUM_SNDMIXERS; i++)
		dumpstr ("sndmixer",  i, (char *)SNDMIXERS[i]);
	return;
}

// dumpstr ()
void dumpstr (char *field, int num, char *string) {
	if (strlen(string)==0) return;
	fprintf (fstdout, "%-8s[%4d]  %s\n", field, num, string);
	return;
}

// dumpint ()
void dumpint (char *field, int num, int value) {
	fprintf (fstdout, "%-8s[%4d]  %d\n", field, num, value);
	return;
}

// dumpexp ()
void dumpexp (char *field, int num, const char *format, ...) {
	va_list ap;
	fprintf (fstdout, "%-8s[%4d]  ", field, num);
	va_start (ap, format);
	vfprintf (fstdout, format, ap);
	va_end (ap);
	fprintf (fstdout, "\n");
	return;
}

