/*
    si - Version 1.0 - By Joe Turgeon (jturgeon@isd.net)
    interrupts.c

    si - System Information Viewer
    Copyright (C) 1999  Joe Turgeon (jturgeon@isd.net)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#include "main.h"


// handleinterrupts ()
// 	determine the correct procedure to use
void handleinterrupts () {
	//  proc/interrupts in kernel 2.4 is compatible with kernel 2.2
	if (KERNEL==VER24) handleinterruptsv22();
	if (KERNEL==VER22) handleinterruptsv22();
	//  kernel 2.0
	if (KERNEL==VER20) handleinterruptsv20();
}

// handleinterruptsv20() Function
// 	code specific to the Linux Kernel 2.0
void handleinterruptsv20 () {
	FILE *filep;
	char filename [INPUT_STRING];
	char tmpstring [INPUT_STRING];
	int intnum;
	char intname [INPUT_STRING];
	char intcalls [INPUT_STRING];
	int c=0;

	sprintf (filename, "%sinterrupts", PROCLOC);
	filep=fopen(filename, "r");
	if (filep==NULL) return;
	do {
		fgets (tmpstring, INPUT_STRING, filep);
		if (feof(filep)!=0) break;
		if (strlen(tmpstring)==1) continue;
		sscanf (tmpstring, "%i %*1s %11s", &intnum, intcalls);
		rstring (tmpstring, 17, intname);
		killcrlf (intname, strlen(intname));
		IRQINT[c]=malloc(STRING_ARRAY_SIZE);
		if (IRQINT[c]==NULL) error_handler(ERROR_MALLOC);
		sprintf (*IRQINT[c], "%3i  %12s  %s", intnum, intcalls, intname);
		c++;
		if (c==IRQINT_COUNT_MAX) break;
	} while (0==0);
	NUM_IRQINT=c-1;
	fclose (filep);
	return;
}

// handleinterruptsv22() Function
// 	code specific to the Linux Kernel 2.2
void handleinterruptsv22 () {
	FILE *filep;
	char filename [INPUT_STRING];
	char tmpstring [INPUT_STRING];
	int intnum;
	char intname [INPUT_STRING];
	char intcalls [INPUT_STRING];
	char intdesc [INPUT_STRING];
	int c=0;
	int i=0;

	sprintf (filename, "%sinterrupts", PROCLOC);
	filep=fopen(filename, "r");
	if (filep==NULL) return;
	do {
		fgets (tmpstring, INPUT_STRING, filep);
		if (feof(filep)!=0) break;
		if (strlen(tmpstring)==1) continue;
		if (strncmp(tmpstring, "           CPU0", 15)==0) continue;
		if (strncmp(tmpstring, "NMI", 3)==0) continue;
		if (strncmp(tmpstring, "ERR", 3)==0) continue;
		sscanf (tmpstring, "%i %*1s", &intnum);
		IRQINT[c]=malloc(STRING_ARRAY_SIZE);
		if (IRQINT[c]==NULL) error_handler(ERROR_MALLOC);
		sprintf (*IRQINT[c], "%3i", intnum);
		rstring (tmpstring, 5, tmpstring);
		for (i=0; i<=NUM_CPU; i++) {
			sscanf (tmpstring, "%11s", intcalls);
			sprintf (*IRQINT[c], "%s  %12s", *IRQINT[c], intcalls);
			rstring (tmpstring, 12, tmpstring);
		}
		killcrlf (tmpstring, strlen(tmpstring));
		sscanf (tmpstring, "%s %s", intdesc, intname);
		sprintf (*IRQINT[c], "%s  %15s  %s", *IRQINT[c], intdesc, intname);
		c++;
		if (c==IRQINT_COUNT_MAX) break;
	} while (0==0);
	NUM_IRQINT=c-1;
	fclose (filep);
	return;
}

