/*
    si - Version 1.0 - By Joe Turgeon (jturgeon@isd.net)
    isadma.c

    si - System Information Viewer
    Copyright (C) 1999  Joe Turgeon (jturgeon@isd.net)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#include "main.h"


// handleisadma ()
//	determine the correct procedure to use
void handleisadma () {
	//  proc/isadma in all kernels are compatible
	handleisadmav20 ();
}

// handleisadmav20() Function
void handleisadmav20 () {
	char filename [INPUT_STRING];
	char tmpstring [INPUT_STRING];
	FILE *filep;
	int c=0;

	sprintf (filename, "%sdma", PROCLOC);
	filep=fopen(filename, "r");
	if (filep==NULL) return;
	do {
		fgets (tmpstring, INPUT_STRING, filep);
		if (feof(filep)!=0) break;
		if (strlen(tmpstring)==1) continue;
		killcrlf (tmpstring, strlen(tmpstring));
		ISADMA[c]=malloc(DEV_STRUCT_SIZE);
		if (ISADMA[c]==NULL) error_handler(ERROR_MALLOC);
		initializedev (ISADMA[c]);
		sscanf (tmpstring, "%2d%*1s %s", &ISADMA[c]->NUMBER, ISADMA[c]->NAME);
		c++;
		if (c==ISADMA_COUNT_MAX) break;
	} while (0==0);
	NUM_ISADMA=c-1;
	fclose (filep);
	return;
}

