/*
    si - Version 1.0 - By Joe Turgeon (jturgeon@isd.net)
    loadinfo.h

    si - System Information Viewer
    Copyright (C) 1999  Joe Turgeon (jturgeon@isd.net)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


// Location of /proc Filesystem
// 	in form of: "/proc/"
#define PROCLOC		"/proc/"
// Global Variables
extern time_t BOOTTIME;
extern long int UPTIME;
// PROCFS Filename Defines
#define PROC_EXINFO	0	// program defined values
#define	PROC_CMDLINE	1	// cmdline
#define PROC_DOMAINNAME	2	// sys/kernel/domainname
#define PROC_HOSTNAME	3	// sys/kernel/hostname
#define PROC_MODPROBE	4	// sys/kernel/modprobe
#define PROC_OSRELEASE	5	// sys/kernel/osrelease
#define PROC_OSTYPE	6	// sys/kernel/ostype
#define PROC_VERSION	7	// sys/kernel/version
#define PROC_LOADAVG_1	8	// loadavg
#define PROC_LOADAVG_5	9
#define PROC_LOADAVG_15	10
#define PROC_UPTIME	11	// uptime
#define PROC_CPUUSER	16	// stat
#define PROC_CPUNICE	17
#define PROC_CPUSYS	18
#define PROC_CPUIDLE	19
// strings replaced by integers in version 1.0
//   #define PROC_DISK		20
//   #define PROC_DISKRIO	21
//   #define PROC_DISKWIO	22
//   #define PROC_DISKRBLK	23
//   #define PROC_DISKWBLK	24
#define PROC_PAGE_IN	25
#define PROC_PAGE_OUT	26
#define PROC_SWAP_IN	27
#define PROC_SWAP_OUT	28
#define PROC_CTXT	29
#define PROC_BTIME	30
#define PROC_PROCESS	31
#define PROC_MEMTOTAL	32	// meminfo
#define PROC_MEMFREE	33
#define PROC_MEMSHARED	34
#define PROC_BUFFERS	35
#define PROC_CACHED	36
#define PROC_SWAPTOTAL	37
#define PROC_SWAPFREE	38
#define PROC_SOUNDDRV	39	// sound
//  PROCINFO_COUNT_MAX
#define PROCINFO_COUNT_MAX	40


// Global Variable Definitions
#define READPROCLINE_COUNT	128
/*  string size changed in version 0.6 to conserve memory
#define STRING_MAX		4096
*/
#define STORAGE_STRING		128
#define INPUT_STRING		4096
typedef char string [STORAGE_STRING];


// Structure Size Definitions
extern const size_t STRING_ARRAY_SIZE;
extern const size_t DEV_STRUCT_SIZE;
extern const size_t FILESYS_STRUCT_SIZE;
extern const size_t CPU_STRUCT_SIZE;
extern const size_t PROC_STRUCT_SIZE;
extern const size_t SCSIDEV_STRUCT_SIZE;
extern const size_t SCSIDRV_STRUCT_SIZE;
extern const size_t TTYDRIVERS_STRUCT_SIZE;
extern const size_t TTYLDISCS_STRUCT_SIZE;
extern const size_t MTRR_STRUCT_SIZE;
extern const size_t IDEDRV_STRUCT_SIZE;
extern const size_t IDEDEV_STRUCT_SIZE;
extern const size_t PARPORT_STRUCT_SIZE;
extern const size_t MOUNTS_STRUCT_SIZE;


// Structure Definitions
struct DEV_STRUCT {
	int NUMBER;
	char NAME  [STORAGE_STRING];
};
struct FILESYS_STRUCT {
	char NAME  [STORAGE_STRING];
	char DEV   [STORAGE_STRING];
};
struct CPU_STRUCT {
	char VENDOR [STORAGE_STRING];
	char MODEL  [STORAGE_STRING];
	char SPEED  [STORAGE_STRING];
	char CACHE  [STORAGE_STRING];
	char USER   [STORAGE_STRING];
	char NICE   [STORAGE_STRING];
	char SYS    [STORAGE_STRING];
	char IDLE   [STORAGE_STRING];
};
struct PROC_STRUCT {
	long int PID;
	char NAME       [STORAGE_STRING];
	char STATE      [STORAGE_STRING];
	char CMDLINE    [STORAGE_STRING];
	char CWD        [STORAGE_STRING];
	char EXE        [STORAGE_STRING];
	char FILES      [128][STORAGE_STRING];
	int NUM_FILES;
	int PPID;
	int PGRP;
	int SESSION;
	char TTY        [STORAGE_STRING];
	int TPGID;
	int UTIME;
	int STIME;
	int PRIORITY;
	char STARTTIME  [STORAGE_STRING];
	int VSIZE;
	unsigned int STARTCODE;
	unsigned int ENDCODE;
	// Calculated with STARTTIME and localtime Data
	char TOTALTIME  [STORAGE_STRING];
};
struct SCSIDEV_STRUCT {
	char HOST     [STORAGE_STRING];
	int CHANNEL;
	int ID;
	int LUN;
	char VENDOR   [STORAGE_STRING];
	char MODEL    [STORAGE_STRING];
	char REV      [STORAGE_STRING];
	char TYPE     [STORAGE_STRING];
	char ANSIREV  [STORAGE_STRING];
};
struct SCSIDRV_STRUCT {
	char NAME  [STORAGE_STRING];
	char DESC  [STORAGE_STRING];
};
struct TTYDRIVERS_STRUCT {
	char DRIVER  [STORAGE_STRING];
	char NAME    [STORAGE_STRING];
	char MAJOR   [STORAGE_STRING];
	char RANGE   [STORAGE_STRING];
	char TYPE    [STORAGE_STRING];
};
struct TTYLDISCS_STRUCT {
	char NAME  [STORAGE_STRING];
	int COUNT;
};
struct MTRR_STRUCT {
	int REG;
	char OFFHEX  [STORAGE_STRING];
	int OFFMB;
	int SIZE;
	char OPTION  [STORAGE_STRING];
	int COUNT;
};
struct IDEDRV_STRUCT {
	char NAME     [STORAGE_STRING];
	char VERSION  [STORAGE_STRING];
};
struct IDEDEV_STRUCT {
	char NAME    [STORAGE_STRING];
	char PARENT  [STORAGE_STRING];
	char DRIVER  [STORAGE_STRING];
	char MEDIA   [STORAGE_STRING];
	char MODEL   [STORAGE_STRING];
	int CYL;
	int HEAD;
	int SECT;
};
struct PARPORT_STRUCT {
	char NAME       [STORAGE_STRING];
	char AUTOPROBE  [STORAGE_STRING];
	char DEVICES    [STORAGE_STRING];
	char IOPORT     [STORAGE_STRING];
	char DMA        [STORAGE_STRING];
	char IRQ        [STORAGE_STRING];
	char PORTTYPE   [STORAGE_STRING];
};
struct MOUNTS_STRUCT {
	char DEVICE      [STORAGE_STRING];
	char MOUNTPOINT  [STORAGE_STRING];
	char FILESYS     [STORAGE_STRING];
	char MODE        [STORAGE_STRING];
};
#define MODULES_COUNT_MAX	512
#define CHARDEV_COUNT_MAX	128
#define BLOCKDEV_COUNT_MAX	128
#define ISADMA_COUNT_MAX	128
#define FILESYS_COUNT_MAX	128
#define IRQINT_COUNT_MAX	128
#define IOPORTS_COUNT_MAX	READPROCLINE_COUNT
#define PARTS_COUNT_MAX		READPROCLINE_COUNT
#define MOUNTS_COUNT_MAX	128
#define SWAPS_COUNT_MAX		128
#define CPU_COUNT_MAX		128
#define PROC_COUNT_MAX		128
#define SCSIDEV_COUNT_MAX	128
#define SCSIDRV_COUNT_MAX	128
#define TTYDRIVERS_COUNT_MAX	128
#define TTYLDISCS_COUNT_MAX	128
#define SNDDRV_COUNT_MAX	128
#define SNDCONF_COUNT_MAX	128
#define SNDAUDIO_COUNT_MAX	128
#define SNDSYNTH_COUNT_MAX	128
#define SNDMIDI_COUNT_MAX	128
#define SNDTIMERS_COUNT_MAX	128
#define SNDMIXERS_COUNT_MAX	128
#define MTRR_COUNT_MAX		128
#define IDEDRV_COUNT_MAX	128
#define IDEDEV_COUNT_MAX	128
#define PARPORT_COUNT_MAX	128
#define MISC_COUNT_MAX		128
string PROCINFO  [PROCINFO_COUNT_MAX];
extern int PROC_DISK;
extern int PROC_DISKRIO;
extern int PROC_DISKWIO;
extern int PROC_DISKRBLK;
extern int PROC_DISKWBLK;
string  *MODULES    [MODULES_COUNT_MAX];
struct DEV_STRUCT  *CHARDEV    [CHARDEV_COUNT_MAX];
struct DEV_STRUCT  *BLOCKDEV   [BLOCKDEV_COUNT_MAX];
struct DEV_STRUCT  *ISADMA     [ISADMA_COUNT_MAX];
struct FILESYS_STRUCT  *FILESYS    [FILESYS_COUNT_MAX];
string  *IRQINT     [IRQINT_COUNT_MAX];
string  *IOPORTS    [IOPORTS_COUNT_MAX];
string  *PARTS      [PARTS_COUNT_MAX];
struct MOUNTS_STRUCT  *MOUNTS     [MOUNTS_COUNT_MAX];
string  *SWAPS      [SWAPS_COUNT_MAX];
extern struct CPU_STRUCT   *CPU   [CPU_COUNT_MAX];
extern struct PROC_STRUCT  *PROC  [PROC_COUNT_MAX];
extern struct SCSIDEV_STRUCT  *SCSIDEV  [SCSIDEV_COUNT_MAX];
extern struct SCSIDRV_STRUCT  *SCSIDRV  [SCSIDRV_COUNT_MAX];
extern struct TTYDRIVERS_STRUCT  *TTYDRIVERS  [TTYDRIVERS_COUNT_MAX];
extern struct TTYLDISCS_STRUCT   *TTYLDISCS   [TTYLDISCS_COUNT_MAX];
string  *SNDDRV     [SNDDRV_COUNT_MAX];
string  *SNDCONF    [SNDCONF_COUNT_MAX];
string  *SNDAUDIO   [SNDAUDIO_COUNT_MAX];
string  *SNDSYNTH   [SNDAUDIO_COUNT_MAX];
string  *SNDMIDI    [SNDMIDI_COUNT_MAX];
string  *SNDTIMERS  [SNDTIMERS_COUNT_MAX];
string  *SNDMIXERS  [SNDMIXERS_COUNT_MAX];
extern struct MTRR_STRUCT  *MTRR  [MTRR_COUNT_MAX];
extern struct IDEDRV_STRUCT  *IDEDRV  [IDEDRV_COUNT_MAX];
extern struct IDEDEV_STRUCT  *IDEDEV  [IDEDEV_COUNT_MAX];
extern struct PARPORT_STRUCT  *PARPORT  [PARPORT_COUNT_MAX];
struct DEV_STRUCT  *MISC       [MISC_COUNT_MAX];
extern int NUM_MODULES;
extern int NUM_CHARDEV;
extern int NUM_BLOCKDEV;
extern int NUM_ISADMA;
extern int NUM_FILESYS;
extern int NUM_IRQINT;
extern int NUM_IOPORTS;
extern int NUM_PARTS;
extern int NUM_MOUNTS;
extern int NUM_SWAPS;
extern int NUM_CPU;
extern int NUM_PROC;
extern int NUM_SCSIDEV;
extern int NUM_SCSIDRV;
extern int NUM_TTYDRIVERS;
extern int NUM_TTYLDISCS;
extern int NUM_SNDDRV;
extern int NUM_SNDCONF;
extern int NUM_SNDAUDIO;
extern int NUM_SNDSYNTH;
extern int NUM_SNDMIDI;
extern int NUM_SNDTIMERS;
extern int NUM_SNDMIXERS;
extern int NUM_MTRR;
extern int NUM_IDEDRV;
extern int NUM_IDEDEV;
extern int NUM_PARPORT;
extern int NUM_MISC;




