//                     usage.cc

#include "main.ih"

//        --totalrisk (-T) path   - path name of the file containing the
//                                  cumulative total risk proportions (default:
//                                  '<base>/totalrisk-$.txt', use 'no' to
//                                  suppress) 
//
//        --id-base (-i) nr       - Use the IDPoool, starting with value 'nr'
//                                  (specify 0 to use the std. RandomPool,
//                                  1 is used by default)


namespace {
char const info[] = R"_( [options] analyses
Where:
        [options] - optional arguments (short options between parentheses):
        --base (-B) dirname     - base directory (by default './', below
                                  referred to as '<base>/')
        --config (-C) path      - path name to the config file (by default
                                  '~/.config/simrisc')
        --data (-D) path        - path name of the file containing the data
                                  generated by the simulation (default:
                                  '<base>/data-$.txt', use 'no' to suppress)
        --death-age (-a) age    - run one simulation using a specific natural
                                  death-age (also requires --tumor-age)
        --help (-h)             - provide this help

        --last-case (-l) nCases - perform simulations until 'nCases' have been
                                  analyzed and only write the data for the 
                                  final case to the data file; 
        --one-analysis (-o)     - run a single scenario analysis. The
                                  program's arguments may be used to specify 
                                  comma-separated configuration parameters
        --parameters (-P) path  - path name of the parameters-file (default:
                                  not used)
        --rounds (-R) path      - path name of the file containing the summary
                                  info of the simulation rounds (default:
                                  '<base>/rounds-$.txt', use 'no' to suppress) 
        --sensitivity (-S) path - path name of the sensitivity-file (default:
                                  '<base>/sensitivity.txt', use 'no' to
                                  suppress) 
        --tumor-age (-t) age    - run one simulation using 'age' as the 
                                  self-detect age of the tumor (also requires
                                  --death-age)
        --verbose (-V)          - write informative messages to the stdandard 
                                  output stream
        --version (-v)          - show version information and terminate

    
    analyses - analyses to perform. See the simrisc(1) man-page for details.
    
    $ characters in non-default filenames are replaced by iteration indices.
    The first + characterr of non-default filenames is replaced by the
    base-directory.

    The structure of the configuration file is described in the
    simriscinput(7) man-page.

)_";

}

void usage(std::string const &progname)
{
    cout << "\n" <<
    progname << " by " << Icmake::author << "\n" <<
    progname << " V" << Icmake::version << " " << Icmake::years << "\n"
    "\n"
    "Usage: " << progname << info;
}
