/*
**  Sinek (Video Player)
**  Copyright (c) 2001 - 2002 the Sinek Team, see the AUTHORS file.
**
**  This code is free software; you can redistribute it and/or
**  modify it under the terms of the GNU General Public License.
**
**  common structures, macros, and prototypes
*/

#ifndef SINEK_COMMON_H
#define SINEK_COMMON_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "i18n.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <limits.h>
#include <math.h>
#include <time.h>

#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <glib.h>
#include <X11/Xlib.h>
#include <xine.h>

typedef enum
{
	CMD_NONE = 0,
	CMD_QUIT,
	CMD_PLAY,
	CMD_PAUSE,
	CMD_STOP,
	CMD_NEXT,
	CMD_PREVIOUS,
	CMD_SPEED_FAST,
	CMD_SPEED_SLOW,
	CMD_AV_OFFSET_DOWN,
	CMD_AV_OFFSET_UP,
	CMD_GOTO_MARK_0,
	CMD_GOTO_MARK_1,
	CMD_GOTO_MARK_2,
	CMD_GOTO_MARK_3,
	CMD_GOTO_MARK_4,
	CMD_GOTO_MARK_5,
	CMD_GOTO_MARK_6,
	CMD_GOTO_MARK_7,
	CMD_GOTO_MARK_8,
	CMD_GOTO_MARK_9,
	CMD_SET_MARK_1,
	CMD_SET_MARK_2,
	CMD_SET_MARK_3,
	CMD_SET_MARK_4,
	CMD_SET_MARK_5,
	CMD_SET_MARK_6,
	CMD_SET_MARK_7,
	CMD_SET_MARK_8,
	CMD_SET_MARK_9,
	CMD_SHOW_ABOUT,
	CMD_SHOW_TUNER,
	CMD_SHOW_KEYS,
	CMD_SHOW_PLAYLIST,
	CMD_SHOW_CONTROLS,
	CMD_SHOW_VIDEO,
	CMD_SHOW_PREFS,
	CMD_TOGGLE_FULLSCREEN,
	CMD_TOGGLE_GUI,
	CMD_TOGGLE_ASPECT,
	CMD_TOGGLE_INTERLEAVE,
	CMD_TOGGLE_SUBTITLES,
	CMD_TOGGLE_MUTE,
	CMD_TOGGLE_REPEAT,
	CMD_SPU_NEXT,
	CMD_SPU_PREVIOUS,
	CMD_AUDIO_NEXT,
	CMD_AUDIO_PREVIOUS,
	CMD_ZOOM_IN,
	CMD_ZOOM_OUT,
	CMD_ZOOM_RESET,
	CMD_WINDOW_REDUCE,
	CMD_WINDOW_ENLARGE,
	CMD_EVENT_MENU1,
	CMD_EVENT_MENU2,
	CMD_EVENT_MENU3,
	CMD_EVENT_UP,
	CMD_EVENT_DOWN,
	CMD_EVENT_LEFT,
	CMD_EVENT_RIGHT,
	CMD_EVENT_PRIOR,
	CMD_EVENT_NEXT,
	CMD_EVENT_ANGLE_NEXT,
	CMD_EVENT_ANGLE_PRIOR,
	CMD_EVENT_SELECT
} cmd_type;

struct sinek_globals
{
	/* xine library */
	xine_t *xine;
	config_values_t *conf;
	vo_driver_t *vd;
	ao_driver_t *ad;

	/* command line options */
	char *audio_id;
	char *video_id;
	int spu_channel;
	int audio_channel;
	int hide_gui;
	char *script;
	char *start_mrl;

	/* widgets */
	int nr_mapped;
	GtkWidget *control_win;
	GtkWidget *prefs_win;
	GtkWidget *playlist_win;
	GtkWidget *repeat_chk, *repeat_tog;
	GtkWidget *mute_tog;

	/* video stuff */
	Display *display;
	Window video_win;
	int fs_w, fs_h;
	int vid_w, vid_h;
	char *mrl;

	int marks[10];

	/* states */
	int playing;
	int fullscreen;
	int fs_req;
	int pause;
	int mute;
	int hide;
	int osd_place;
	int osd_subtitles;
	int repeat_one, repeat_all;
	int seeking;
	int cursor_timer;
};

extern struct sinek_globals sinek;

typedef struct subtitle_struct
{
	struct subtitle_struct *next, *prev;
	unsigned long start;
	unsigned long end;
	int lines;
	char *text[5];
} subtitle_t;

int control_init(void);
void control_current_time(int secs);
void control_total_time(int secs);
void control_volume(int value);
void control_mrl(char *mrl);

int video_init(void);
void video_show(void);
void video_hide(void);
int video_play(char *mrl);
void video_seek(int secs);
void video_pause(void);
void video_toggle_fullscreen(void);
void video_lift(GtkWidget *win);
void video_scale(float factor);
void video_zoom(int fx, int fy);
void video_cursor(int show);

void prf_init(int argc, char *argv[]);
void print_version(void);
void prf_show(void);

int pl_init(void);
void pl_append(char *mrl);
void pl_remove_all(void);
void pl_load(char *fname);
void pl_save(char *filename);
void pl_show(void);
void pl_next(void);
void pl_prev(void);
char *pl_get_mrl(int row);

int audio_init(void);
void audio_slide_volume(int value);
void audio_set_volume(int value);
int audio_get_volume(void);
void audio_toggle_mute(void);

void about_show(void);

void key_init(void);
void key_handle(unsigned long keyval, int modifier);
cmd_type find_cmd(char *command);
void execute_cmd(cmd_type cmd);

void tune_show(void);

void popup_init(void);
void popup_pop(int time);

#define WM_KEYS 1
#define WM_MENU 2
#define WM_VOLUME 4
#define WM_AUTOHIDE 8
#define WM_NORMAL WM_KEYS | WM_MENU | WM_VOLUME | WM_AUTOHIDE

void add_tooltip(GtkWidget *w, char *tip);
GtkWidget *create_url(const char *url);
GtkWidget *create_pix_button(char *xpm[], cmd_type cmd, char *tip);
GtkWidget *create_pix_toggle(char *on_xpm[], char *off_xpm[], cmd_type cmd, char *tip);
void update_pix_toggle(GtkWidget *w);
void wm_manage(GtkWidget *win, int flags);
void wm_relayer_all(void);
void wm_show_all(void);
void wm_hide_all(void);
GtkWidget *file_request(int mode);
void warning(char *fmt, ...);
void select_file(void (*func)(char *filename), char *title);

void osd_init(void);
void osd_display(char **msg);
void osd_font_selection(void);
void osd_load(char *filename);
void osd_position(int x, int y);
void osd_update(void);
void osd_show(void);
void osd_hide(void);

int subtitle_load(const char *filename);
subtitle_t *subtitle_find(unsigned long msec);
void subtitle_delete(void);
GtkWidget *subtitle_create(void);

void enable_blanking(void);
void disable_blanking(void);

#ifdef USE_GUILE
void guile_init(void);
void guile_execute(char *filename);
int guile_stop_hook(void);
#else
#define guile_init() do {} while(0)
#define guile_execute(x) do {} while(0)
#define guile_stop_hook() (0)
#endif


#endif    /* SINEK_COMMON_H */
