#include <iostream>
#include "basicmessages.h"
#include "messagebasictypes.h"
#include "messagesinfotypes.h"
#include "messagecomplextypes.h"
#include "sinfoserver.h"
using namespace std;
using namespace Msg;


SinfoServer::SinfoServer(std::list < Wsinfo > & _wsinfoList)
    :wsinfoList(_wsinfoList)
{
}


void SinfoServer::commandSinfoRequest(Message & returnMessage, Message & message)
{
  // how many info structs?
  unsigned int wsinfocount = wsinfoList.size();
  pushBackuint16(returnMessage, wsinfocount);

  // Daten bermitteln
  for (std::list < Wsinfo > ::iterator wit = wsinfoList.begin();
       wit != wsinfoList.end();
       wit++)
  {
    pushBackstring8(returnMessage, wit->name);
    pushBackstring8(returnMessage, wit->inetaddr);
    pushBackuint8(returnMessage, wit->cpuinfo.cpus);
    pushBackfloat32(returnMessage, wit->cpuinfo.speedmhz);
    pushBackfloat32(returnMessage, wit->cpustat.idlep);
  }
}


void SinfoServer::commandSinfoFullRequest(Message & returnMessage, Message & message)
{
  // how many info structs?
  unsigned int wsinfocount = wsinfoList.size();
  pushBackuint16(returnMessage, wsinfocount);

  // Daten bermitteln
  for (std::list < Wsinfo > ::iterator wit = wsinfoList.begin();
       wit != wsinfoList.end();
       wit++)
  {
    pushBackWsinfo(returnMessage, *wit);
  }
}


void SinfoServer::commandSinfoFullRequestFilter(Message & returnMessage, Message & message)
{
  string filterMarker;
  popFrontstring8(message, filterMarker);


  // how many info structs?
  unsigned int wsinfocount=0;
  for (std::list < Wsinfo > ::iterator wit = wsinfoList.begin();
       wit != wsinfoList.end();
       wit++)
  {
    if ((*wit).marker == filterMarker)
    {
      wsinfocount++;
    }
  }
  pushBackuint16(returnMessage, wsinfocount);


  // Daten bermitteln
  for (std::list < Wsinfo > ::iterator wit = wsinfoList.begin();
       wit != wsinfoList.end();
       wit++)
  {
    if ((*wit).marker == filterMarker)
    {
      pushBackWsinfo(returnMessage, *wit);
    }
  }
}


void SinfoServer::topLevelOneMGSParser(Message & returnMessage, Message & message)
{
  uint8 messageID;
  popFrontuint8(message, messageID);

  switch (messageID)
  {
  case 1:
    basicMessagesParser(returnMessage, message);
    pushFrontuint8(returnMessage,1);
    break;

  case 3:
    commandSinfoRequest(returnMessage, message);
    pushFrontuint8(returnMessage,4);
    break;

  case 5:
    commandSinfoFullRequest(returnMessage, message);
    pushFrontuint8(returnMessage,6);
    break;

  case 7:
    commandSinfoFullRequestFilter(returnMessage, message);
    pushFrontuint8(returnMessage,8);
    break;

  }
}


void SinfoServer::receiveMessageSlot(Message & returnMessage, Message & message)
{
  try
  {
    topLevelOneMGSParser(returnMessage, message);
  }
  catch (MessageException ex)
  {
    cout << "MessageException caught: " << ex.what() << endl;
  }
}


