=begin
 * Name: SiSU - Simple information Structuring Universe - Structured information, Serialized Units
 * Author: Ralph Amissah
   * http://www.jus.uio.no/sisu
   * http://www.jus.uio.no/sisu/SiSU/download.html

 * Description: shared html parts

 * Copyright (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006 Ralph Amissah

 * License: GPL 2 or later

  Summary of GPL 2

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the Free
  Software Foundation; either version 2 of the License, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA

  If you have Internet connection, the latest version of the GPL should be
  available at these locations:
    http://www.fsf.org/licenses/gpl.html
    http://www.gnu.org/copyleft/gpl.html
    http://www.jus.uio.no/sisu/gpl2.fsf

  SiSU was first released to the public on January 4th 2005

  SiSU uses:
  
  *  Standard SiSU markup syntax,
  *  Standard SiSU meta-markup syntax, and the
  *  Standard SiSU object citation numbering and system
  
  © Ralph Amissah 1997, current 2006.
  All Rights Reserved.

 * Ralph Amissah: ralph@amissah.com
                  ralph.amissah@gmail.com

 * Notes: configure rc in ~/.sisu/sisurc.yaml
=end
module SiSU_HTML_table
  require SiSU_lib + '/defaults'
  class Table
    @@tablehead=0
    @@tablefoot=[] #watch
    def initialize(one)
      @one,@parablock,@margin,@paragraph,@table=one,one,SiSU_Viz::Margin.new,SiSU_Viz::Paragraph.new,SiSU_Viz::Table.new
    end
    def table_head(inf)
      %{<table summary="normal text css" width="100%" border="0" bgcolor="white" cellpadding="2" align="center">
  <tr>
    <td valign="top" align="justify">
      <p class="norm" id="o#{inf}"><a name="#{inf}"></a></p>
    </td>
    <td>
<table summary="normal text css" width="100%" border="0" bgcolor="white" cellpadding="2" align="center">}
    end
    def table_end(tablefoot='')
      %{</table>#{@margin.num}#{@margin.num}&nbsp;#{@table.close}
#{tablefoot}}
    end
    def table_row(inf,h=false)
      bold=if h; '<b>'
      else       ''
      end
      %{
<tr>
  <td width="#{inf}%" valign="top">#{@paragraph.table}#{bold}}
    end
    def table_cell(inf,h=false)
      if h; %{</b></font></td><td width="#{inf}%" valign="top">#{@paragraph.table}<b>}
      else  %{</font></td><td width="#{inf}%" valign="top">#{@paragraph.table}}
      end
    end
    def table_row_close(h=false)
      bold_close=if h; '</b>'
      else             ''
      end
      "#{bold_close}</font></td></tr>"
    end
    def table
      m=@parablock[/<!f(.+?)!>/,1]
      @@tablefoot << m if m 
      @parablock.gsub!(/<!f.+?!>/,'')
      @@tablehead=1 if @parablock =~/<!Th¡/
      if @parablock =~/<!Th?¡.+?!~(\d+);\w\d+;\w\d+>/; @parablock=table_head($1)
      end
      if @parablock =~/<!TZ!>/
        tablefoot=[]
        @@tablefoot.each {|x| tablefoot << ''}
        @@tablefoot=[]
        if @parablock =~/<!TZ!>/; @parablock=table_end
        end
      end
      if @@tablehead == 1
        if @parablock =~/¡¡/
          if @parablock =~/<!¡¡(\d+?)¡/
            @parablock.gsub!(/<!¡¡(\d+?)¡/,table_row($1,true))
          end
          if @parablock =~/¡¡(\d+?)¡/ 
            @parablock.gsub!(/¡¡(\d+?)¡/,table_cell($1,true))
          end
          if @parablock =~/!>/
            @parablock.gsub!(/!>/,table_row_close(true))
          end
          @@tablehead=0
        end
        @parablock
      else
        if @parablock =~/<!¡¡(\d+?)¡/
          @parablock.gsub!(/<!¡¡(\d+?)¡/,table_row($1))
        end
        if @parablock =~/¡¡(\d+?)¡/
          @parablock.gsub!(/¡¡(\d+?)¡/,table_cell($1))
        end
        if @parablock =~/!>/
          @parablock.gsub!(/!>/,table_row_close)
        end
        @parablock
      end
      @parablock
    end
    def table_split
      @new_content=[]
      @one.split(/\n/).each do |parablock|
        table=Table.new("#{parablock}\n")
        @new_content << table.table
      end
      @new_content.join
    end
  end
end
__END__
