=begin
 * Name: SiSU - Simple information Structuring Universe - Structured information, Serialized Units
 * Author: Ralph Amissah
   * http://www.jus.uio.no/sisu
   * http://www.jus.uio.no/sisu/SiSU/download.html

 * Description: urls for output files
 
 * Copyright (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006 Ralph Amissah

 * License: GPL 2 or later

  Summary of GPL 2

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the Free
  Software Foundation; either version 2 of the License, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA

  If you have Internet connection, the latest version of the GPL should be
  available at these locations:
    http://www.fsf.org/licenses/gpl.html
    http://www.gnu.org/copyleft/gpl.html
    http://www.jus.uio.no/sisu/gpl2.fsf

  SiSU was first released to the public on January 4th 2005

  SiSU uses:
  
  *  Standard SiSU markup syntax,
  *  Standard SiSU meta-markup syntax, and the
  *  Standard SiSU object citation numbering and system
  
  © Ralph Amissah 1997, current 2006.
  All Rights Reserved.

 * Ralph Amissah: ralph@amissah.com
                  ralph.amissah@gmail.com
=end
module SiSU_urls
  require SiSU_lib + '/sysenv'
  include SiSU_Env
  include SiSU_Screen
  require SiSU_lib + '/param'
  include SiSU_Param
  class Source
    attr_reader :opt
    def initialize(opt)
      @opt=opt
    end
    def read
      begin
        SiSU_urls::Output_urls.new(@opt).songsheet if @opt.fnb #fnb[/.+?\.(?:[_-]?sst|ssm)$/]
      rescue; SiSU_Errors::Info_error.new($!,$@,nil,@opt.cmd).error
      ensure
      end
    end
  end
  class Output_urls
    include SiSU_Param
    attr_reader :fns,:fnb,:cmd,:dir,:m_regular,:u
    def initialize(opt)
      @opt=opt
      fn_set_lang=SiSU_Env::Standardise_language.new.file_to_language(@opt.fns)
      @cmd=@opt.cmd
      env=SiSU_Env::Env_call.new(@opt.fns)
      @fnb=env.fnb
      @env=SiSU_Env::Info_env.new(@opt.fns)
      fn_set_lang=SiSU_Env::Standardise_language.new.file_to_language(@opt.fns)
      @fnl=@env.i18n.lang_filename(fn_set_lang[:c])
      @fn=SiSU_Env::Env_call.new(@opt.fns).lang(fn_set_lang[:c])
      @m_regular=/(.+?)\.(?:[_-]?sst|ssm)$/
      @path=SiSU_Env::Info_env.new(@opt.fns)
      @webserv_url=@path.url.output_tell
      @tool=@env.program.text_editor
      @editor=@env.program.text_editor
      @browser=@env.program.web_browser
      @console_browser=@env.program.console_web_browser
      @pdf_viewer=@env.program.pdf_viewer
      @odf_viewer=@env.program.odf_viewer
      source=if @opt.fns =~/\.sst$/; @opt.fns
      elsif @opt.fns =~/\._sst/; "#@fnb.composite.sst"
      else 'not recognised file'
      end
      @u ||= {
        'a (Plain-text (footnotes))'=>@fn[:plain],
        'A (Plain-text (footnotes) dos)'=>@fn[:plain],
        'b (XHTML)'=>@fn[:xhtml],
        'B (Docbook XML)'=>@fn[:docbook],
        'D[iu] (DBI import/update postgresql)'=>'dbi psql',
        'd[iu] (DBI import/update sqlite)'=>'dbi sqlite',
        'e (Plain-text (endnotes))'=>@fn[:plain],
        'E (Plain-text (endnotes) dos)'=>@fn[:plain],
        'h (HTML segmented)'=>@fn[:toc],
        'H (HTML segmented)'=>@fn[:toc],
        'h (HTML scroll)'=>@fn[:doc],
        'H (HTML scroll)'=>@fn[:doc],
        'I (Info file)'=>'info',
        'm (metaverse)'=>'meta',
        'N (Digests md5/sha256)'=>@fn[:digest],
        'o (ODF:ODT - Open Document)'=>@fn[:odf],
        'p (PDF landscape)'=>@fn[:pdf_l],
        'p (PDF portrait)'=>@fn[:pdf_p],
        'P[iu] (DB postgresql import/update)'=>'psql',
        's (sisu markup)'=>source,
        'S (sisupod)'=>'sisupod.zip',
        'x (XML sax type)'=>@fn[:sax],
        'X (XML dom type)'=>@fn[:dom],
        'y (Manifest, html)'=>@fn[:manifest],
        'Y (Sitemap, xml)'=>@fn[:sitemap],
        'w (Concordance, html)'=>@fn[:concordance],
      }.sort {|a,b| a[0].downcase<=>b[0].downcase}
    end
    def songsheet
      begin
        urls_all if @opt.cmd=~/U/
        urls_select if @opt.cmd=~/[uvVM]/
      rescue; SiSU_Errors::Info_error.new($!,$@,@opt.cmd,@opt.fns).error
      ensure
      end
    end
    def urls_maintenance(opt,x,y)
      if x=~/^([aAbBceEhHmNopwxXy])/ and opt.cmd =~/[aAbBceEhHmNopwxXy]/ and x=~/^[#{opt.cmd}]/
        m=$1
        f=y
        tool=@editor
        if x =~/^m/ and @opt.cmd=~/m/ and x=~/^[#{opt.cmd}]/ and @opt.cmd =~/M/
          tell=SiSU_Screen::Ansi.new(@opt.cmd,"-#{x}","#@editor #{@env.path.metaverse}/#{@opt.fns}.meta")
          tell.maintenance unless @opt.cmd =~/q/
        end
        if x=~/^([hHw])/ and @opt.cmd=~/[hHw]/ and x=~/^[#{@opt.cmd}]/
          f=if x !~/segmented/; "#{y}.html"
          else                  "#{y}.index.html"
          end
        end
        if x=~/^p/ and @opt.cmd=~/p/ and x=~/^[#{@opt.cmd}]/
          tool=@pdf_viewer
          if opt.cmd =~/M/
            fns=@opt.fns.gsub(/~/,'-')
            tell=if y =~/landscape/
              SiSU_Screen::Ansi.new(@opt.cmd,"-#{x}","#@editor #{@env.path.tex}/#{fns}.landscape.tex")
            else SiSU_Screen::Ansi.new(@opt.cmd,"-#{x}","#@editor #{@env.path.tex}/#{fns}.tex")
            end
            tell.maintenance unless @opt.cmd =~/q/
          end
        end
        if x=~/^o/ and @opt.cmd=~/o/ and x=~/^[#{@opt.cmd}]/
          tool=@odf_viewer
        end
        if x !~/^m/
          tell=SiSU_Screen::Ansi.new(@opt.cmd,"-#{x}","#{tool} #{@env.path.output}/#@fnb/#{y}")
          tell.maintenance unless @opt.cmd =~/q/
        end
        @opt.cmd.gsub!(/#{m}/,'')
      end
    end
    def urls_select
      tell=SiSU_Screen::Ansi.new(@opt.cmd,"URLs")
      tell.grey_title_hi unless @opt.cmd =~/q/
      tell=SiSU_Screen::Ansi.new(@opt.cmd,@opt.fns,"#{@env.path.output}/#@fnb")
      tell.flow unless @opt.cmd =~/q/
      m=/.+\/(\S+)/m
      @pwd_stub="#@webserv_url"[m,1]
      @u.each do |x,y|
        if @opt.fns =~ @m_regular
          if x=~/^([aAbBceEhHNopsSwxXyY])/ and @opt.cmd=~/[aAbBceEhHNopsSwxXyY]/ and x=~/^[#{@opt.cmd}]/
            m=$1
            tell=SiSU_Screen::Ansi.new(@opt.cmd,"-#{x}","#@browser #@webserv_url/#@fnb/#{y}")
            tell.result unless @opt.cmd =~/q/
            @opt.cmd.gsub!(/#{m}/,'')
          end
          if x=~/^I/ and @opt.cmd =~/I/
            tell=SiSU_Screen::Ansi.new(@opt.cmd,"-#{x}","cd #{@path.path.texinfo}; pinfo ./#@fnb.#{y}; cd -")
            tell.result unless @opt.cmd =~/q/
            @opt.cmd.gsub!(/I/,'')
          end
          if x=~/^D/ and @opt.cmd =~/D/
            tell=SiSU_Screen::Ansi.new(@opt.cmd,"-#{x} DBI psql","#@pwd_stub::#{@opt.fns}",y)
            tell.result unless @opt.cmd =~/q/
            @opt.cmd.gsub!(/D[iu]/,'')
          end
          if x=~/^d/ and @opt.cmd =~/d/
            tell=SiSU_Screen::Ansi.new(@opt.cmd,"-#{x} DBI sqlite","sqlite #{@env.path.output}/sisu_sqlite.db", "#{y}")
            tell.result unless @opt.cmd =~/q/
            @opt.cmd.gsub!(/d[iu]/,'')
          end
          if x=~/^P/ and @opt.cmd =~/P/
            tell=SiSU_Screen::Ansi.new(@opt.cmd,"-#{x} Psql","#@pwd_stub::#{@opt.fns}",y)
            tell.result unless @opt.cmd =~/q/
            @opt.cmd.gsub!(/P[iu]/,'')
          end
          urls_maintenance(@opt,x,y) if @opt.cmd =~/[MV]/
        end
      end
    end
    def urls_all
      tell=SiSU_Screen::Ansi.new(@opt.cmd,'URLs')
      tell.grey_title_hi unless @opt.cmd =~/q/
      tell=SiSU_Screen::Ansi.new(@opt.cmd,@opt.fns,"#{@env.path.output}/#@fnb")
      tell.flow unless @opt.cmd =~/q/
      @u.each do |x,y|
        tell=case x
        when /^m/
          SiSU_Screen::Ansi.new(@opt.cmd,"-#{x}","#{@env.program.text_editor} ~#{y}/#@fnb.#{y}")
        when /^[aAbBcdeEhHNopswxXy]/
          tellx=SiSU_Screen::Ansi.new(@opt.cmd,"-p (LaTeX)","#{@env.program.text_editor} ~work/tex_rz/#@fnb.tex") if y=~/landscape/
          SiSU_Screen::Ansi.new(@opt.cmd,"-#{x}","#@browser #@webserv_url/#@fnb/#{y}")
        when /^Y/
          SiSU_Screen::Ansi.new(@opt.cmd,"-#{x}","#@browser #@webserv_url/sitemap/#{y}")
        when /^I/
          SiSU_Screen::Ansi.new(@opt.cmd,"-#{x}","cd #{@path.path.texinfo}; pinfo ./#@fnb.#{y}; cd -")
        end
        tellx.result if tellx
        tell.result if tell
        tellx=nil
      end
    end
  end
end
__END__
