#===========================================================================
# 

package Sitescooper::CacheObject;

require Exporter;
use Carp;

use Sitescooper::Main;
use Sitescooper::PerSiteCache;

@ISA = qw();
use vars qw{ @ISA $SLASH };
use strict;

# ---------------------------------------------------------------------------

sub new {
  my $class = shift; $class = ref($class) || $class;

  my ($main, $cache, $pagehtml, $lastmod) = @_;

  my $self = {
    'main'		=> $main,
    'cache'		=> $cache,
    'pagehtml'		=> $pagehtml,
    'lastmod'		=> $lastmod,
  };

  bless ($self, $class);
  $self;
}

# ---------------------------------------------------------------------------

sub get_page {
  my ($self) = @_;
  $self->{pagehtml};
}

sub get_lastmod {
  my ($self) = @_;
  $self->{lastmod};
}

# ---------------------------------------------------------------------------

# ensure that the cleaned-up HTML doesn't match the cleaned-up cached
# HTML. Sometimes the ad banners will be the only things that have
# changed between retrieves, and html_to_text will have stripped those
# out.
#
sub text_matches_cached_text {
  my ($self, $url, $urlproc, $text) = @_;

  my $html = $urlproc->strip_story ($url, $self->{pagehtml}, " (cached)");
  $html = $urlproc->html_to_text
  		($url, $html, $self->{main}->{cf}->{output_style});
  
  if ($urlproc->text_equals ($text, $html)) {
    return 1;
  } else {
    return 0;
  }
}

# ---------------------------------------------------------------------------

1;
