# ===========================================================================

package Sitescooper::ForkedPasswordAsker;
  
use Sitescooper::PasswordAsker;
  
@Sitescooper::ForkedPasswordAsker::ISA = qw(Sitescooper::PasswordAsker);
@Sitescooper::ForkedPasswordAsker::EXPORT= qw();
      
$Sitescooper::ForkedPasswordAsker::VERSION = "0.1";
sub Version { $Sitescooper::ForkedPasswordAsker::VERSION; }
      
use strict;
      
sub new {
  my ($class, $scoop) = @_; $class = ref($class) || $class;

  my $self = $class->SUPER::new ();
  bless ($self, $class);
  $self->{scoop} = $scoop;
  $self;
}

sub ask_user_for_credentials {
  my ($self, $realm, $uri, $proxy) = @_;
  local ($_);

  $proxy ||= 0;

  print STDOUT "300 Need-Credentials: <realm>$realm</realm> ".
                        "<uri>$uri</uri> <proxy>$proxy</proxy>\n";
  $_ = <STDIN>;
  if (!s/^Provide-Credentials //) {
    croak ("got unexpected line for credentials: $_");
  }

  my $user = undef;
  my $pass = undef;

  s,<user>(.*)</user>,,g and $user = $1;
  s,<pass>(.*)</pass>,,g and $pass = $1;

  if (!defined $user || !defined $pass) {
    $self->reply_with_err (401, "missing parameter",
            "A parameter was missing from Provide-Credentials message");
    next;
  }

  ($user, $pass);
}

1;
