#===========================================================================

package Sitescooper::ImageURLProcessor;

use Sitescooper::URLProcessor;
use Carp;

@ISA = qw(Sitescooper::URLProcessor);

use strict;

sub new {
  my $class = shift; $class = ref($class) || $class;
  my ($scoop, $robot, $scf, $ref, $url, $tag) = @_;
  my $self = $class->SUPER::new($scoop, $robot, $scf, $ref, $url);

  $self->{tag} = $tag;
  $self->{fname} = undef;
  $self->{relative} = undef;
  $self;
}

# ---------------------------------------------------------------------------

sub start_get {
  my $self = shift;
  my $url = $self->{url};

  if ($self->get_state() != $Sitescooper::URLProcessor::STATE_PRE_GET) {
    croak ("state != Sitescooper::URLProcessor::STATE_PRE_GET");
  }

  my $newurl = $self->apply_url_preproc($url);

  if (!defined $newurl) {
    $self->{scoop}->dbg ("URLProcess says URL should be ignored: $url"); return;
  } elsif ($newurl ne $url) {
    $self->{url} = $url = $newurl;
  }

  return if (defined $self->{already_tried_download}{$url});
  $self->{already_tried_download}{$url} = 1;

  my $type = '.gif';
  if ($url =~ /\.jp[eg]+/i) { $type = '.jpg'; }
  if ($url =~ /\.png/i) { $type = '.png'; }

  $self->{fname} = $self->{robot}->href_to_multipage_filename ($url, $type);
  $self->{relative} = $self->{robot}->href_to_multipage_href ($url, $type);

  if (${$self->{robot}->{output_links_snarfed}}{$url}) {
    return;
  }
  $self->{robot}->add_snarfed_link ($url);
  $self->{robot}->add_snarfed_link ($self->{relative});

  $self->{scoop}->verbose ("Image: $url");

  return unless $self->get_img ($url, 1);
  1;
}

# ---------------------------------------------------------------------------

sub finish_get {
  my $self = shift;

  $self->set_state ($Sitescooper::URLProcessor::STATE_POST_GET);
  if ($Sitescooper::Main::got_intr_flag) { return; }

  my $url = $self->{url};
  my $img = $self->get_url_reply();

  if ($self->does_need_http_retry()) {
    my $handler = new Sitescooper::ImageURLProcessor ($self->{scoop},
        $self->{robot}, $self->{scf}, $self->{url},
	$self->get_http_retry_url(), $self->{tag});
    $self->{robot}->re_request_page ($handler);
    return;
  }

  my ($redir_from, $newbase);
  ($redir_from, $url, $newbase) =
		 $self->handle_redirects_and_base_url ($url, "");

  if (!defined $img) {
    $self->{scoop}->verbose ("Skipping (get_img returned nothing): $url");
    return;
  }

  $self->{cache}->cache_page_now ($url, $redir_from, $img);
  my $fname = $self->{fname};

  my $proc = $self->{scf}->get_story_param ('image_process', $url);
  if (defined $proc) {
    my $img_in = $fname;
    $img_in =~ s/\.([^\.]+)$/_orig\.$1/;
    open (OUT, ">".$img_in); binmode OUT; print OUT $img; close OUT;

    my $img_out = $fname;
    my $site_level = 1;

    if (!eval $proc."; 1;") {
      $self->sitewarn ("ImageProcess failed: $@");
      unlink ($fname, $img_in);
      return;

    } elsif (!-e $img_out) {
      $self->{scoop}->dbg ("ImageProcess says image should be ignored: $url");
      return;

    } else {
      unlink ($img_in);
    }

  } else {
    if (!open (OUT, ">".$fname)) {
      warn "failed to write to $fname!\n"; return "";
    }
    binmode OUT; print OUT $img;
    close OUT or warn ("failed to write to $fname!\n");
  }

  $self->{robot}->up_file_size ($url, (-s $fname), "image");

  if ($self->writing_images) {
    $self->{robot}->add_image ($self->{relative});
  }

  $self->{relative};
}

# ---------------------------------------------------------------------------

1;
