/* # skkinput (Simple Kana-Kanji Input)
 * skkconv.c
 * This file is part of skkinput.
 * Copyright (C) 1997
 * Takashi SAKAMOTO (sakamoto@yajima.kuis.kyoto-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>

#include "skkmain.h"
#include "skkproto.h"
#include "SkkInput.h"

/*
 * ȤˤʤäƤؿ
 */
/* skksvect.c */
void free_SkkinpSearchVector( SkkinpSearchVector **top ) ;
void free_VectorIndex( VectorIndex **top ) ;
VectorIndex *makeSearchVectorIndex
( SkkinpSearchVector *top, int *totalnum, int flag ) ;
/* skksoc.c */
SkkinpSearchVector *skkinput_Request( char *str, SkkinpSearchVector *top ) ;
/* skkldic.c */
SkkinpSearchVector *j_search_skkinput_local_jisyo
( unsigned char *key, SkkinpSearchVector *top, int okuri ) ;
void skkinput_updateLocalJisyo( void ) ;
SkkinpSearchVector *j_completion_skkinput_local_jisyo
( SkkinpSearchVector *top, unsigned char *completion_key ) ;
/* skkldrec.c */
SkkinpSearchVector *searchSudeniHenkanKakuteiShitamono
( char *henkankey, SkkinpSearchVector *top, int okuei ) ;
SkkinpSearchVector *searchSudeniPurgeSaretamono
( char *henkankey, SkkinpSearchVector *top, int okuri ) ;
void add_SudeniHenkanKakuteiShitamono
( char *henkankey, VectorIndex **vectorindextop,
  VectorIndex *hresult, int okuri ) ;
void add_SudeniHenkanKakuteiShitamonoByString
( char *henkankey, char *hresult, int okuri ) ;
void purge_SudeniHenkanKakuteiShitamono
( struct SKKInputNode *node ) ;
SkkinpSearchVector *j_completion_search_sudeniKakuteiShitaKouho
( SkkinpSearchVector *top, unsigned char *completion_key ) ;
SkkinpSearchVector *j_completion_search_sudeniPurgeSaretamono
( SkkinpSearchVector *top, unsigned char *completion_key ) ;

/* local prototype */
static void skkinput_jhenkanStartCallback
( Widget gw, caddr_t client, caddr_t caller ) ;
static void skkinput_jhenkanEndCallback
( Widget gw, caddr_t client, caddr_t caller ) ;
static void skkinput_jsavejisyoCallback
( Widget gw, caddr_t client, caddr_t caller ) ;
static void skkinput_jtangotourokuCallback
( Widget gw, caddr_t client, caddr_t caller ) ;
static void skkinput_jtangosakujoCallback
( Widget gw, caddr_t client, caddr_t caller ) ;
static void skkinput_jcompletionCallback
( Widget gw, caddr_t client, caddr_t caller ) ;
static void skkinput_jcompletionCloseCallback
( Widget gw, caddr_t client, caddr_t caller ) ;
static void skkinput_notmodifiedCallback
( Widget gw, caddr_t client, caddr_t caller ) ;

/*
 * Хѿ
 */
unsigned long skkinput_j_count_kakutei ;
unsigned long skkinput_j_count_touroku ;

extern int skkinput_jisyo_dirty ;

/*
 * Kinput Protocol ¾˴طʤɬ
 */
int setSkkInputConversionCallback( SKKInputRootNode *rNode )
{
  /* ̾Ѵ򳫻Ϥ˸ƤФ callback */
  XtAddCallback( rNode->skkinp, XtNjhenkanNotify,
		 (XtCallbackProc)skkinput_jhenkanStartCallback,
		 (XtPointer)NULL ) ;
  /* ̾Ѵλ˸ƤФ callback */
  XtAddCallback( rNode->skkinp, XtNjhenkanendNotify,
		 (XtCallbackProc)skkinput_jhenkanEndCallback,
		 (XtPointer)NULL ) ;
  /*  save ˸ƤФ callback */
  XtAddCallback( rNode->skkinp, XtNjsavejisyoNotify,
		 (XtCallbackProc)skkinput_jsavejisyoCallback,
		 (XtPointer)NULL ) ;
  /* ñϿ˸ƤФ callback */
  XtAddCallback( rNode->skkinp, XtNjtangotourokuNotify,
		 (XtCallbackProc)skkinput_jtangotourokuCallback,
		 (XtPointer)NULL ) ;
  /* ñ˸ƤФ callback */
  XtAddCallback( rNode->skkinp, XtNjtangosakujoNotify,
		 (XtCallbackProc)skkinput_jtangosakujoCallback,
		 (XtPointer)NULL ) ;
  /* ñ˸ƤФ callback */
  XtAddCallback( rNode->skkinp, XtNjcompletionNotify,
		 (XtCallbackProc)skkinput_jcompletionCallback,
		 (XtPointer)NULL ) ;
  /* ñ˸ƤФ callback */
  XtAddCallback( rNode->skkinp, XtNjcompletioncloseNotify,
		 (XtCallbackProc)skkinput_jcompletionCloseCallback,
		 (XtPointer)NULL ) ;
  /* ιä(?)˻Ȥ callback */
  XtAddCallback( rNode->skkinp, XtNnotmodifiedNotify,
		 (XtCallbackProc)skkinput_notmodifiedCallback,
		 (XtPointer)NULL ) ;
  return 0 ;
}

int removeSkkInputConversionCallback( SKKInputRootNode *rNode )
{
  /* ̾Ѵ򳫻Ϥ˸ƤФ callback */
  XtRemoveAllCallbacks( rNode->skkinp, XtNjhenkanNotify ) ;
  /* ̾Ѵλ˸ƤФ callback */
  XtRemoveAllCallbacks( rNode->skkinp, XtNjhenkanendNotify ) ;
  /*  save ˸ƤФ callback */
  XtRemoveAllCallbacks( rNode->skkinp, XtNjsavejisyoNotify ) ;
  /* ñϿ˸ƤФ callback */
  XtRemoveAllCallbacks( rNode->skkinp, XtNjtangotourokuNotify ) ;
  /* ñ˸ƤФ callback */
  XtRemoveAllCallbacks( rNode->skkinp, XtNjtangosakujoNotify ) ;
  /* ñ˸ƤФ callback */
  XtRemoveAllCallbacks( rNode->skkinp, XtNjcompletionNotify ) ;
  /* ñ˸ƤФ callback */
  XtRemoveAllCallbacks( rNode->skkinp, XtNjcompletioncloseNotify ) ;
  return 0 ;
}

/*
 * ̾Ѵ򳫻Ϥ˸ƽФ륳Хåؿ
 */
static void skkinput_jhenkanStartCallback
( Widget gw, caddr_t client, caddr_t caller )
{
  struct SKKInputNode *node = ( struct SKKInputNode *)caller ;
  SkkinpSearchVector *j_purge_vector_top ;
  VectorIndex *j_purge_vector_index_top ;
  char *henkankey ;

  /* Ѵ򤹤롣*/
  henkankey = ( node->j_okurigana_mode )?
    node->j_henkan_key : node->j_search_key ;

  node->j_henkan_vector_top = NULL ;
  /* ˵Ƥ뼭񤫤鸡Ԥ*/
  node->j_henkan_vector_top = searchSudeniHenkanKakuteiShitamono
    ( henkankey, node->j_henkan_vector_top,
      node->j_okurigana_mode ) ;
  /* ޤɽ꼭񤫤鸡Ԥ*/
  node->j_henkan_vector_top = j_search_skkinput_local_jisyo
    ( henkankey, node->j_henkan_vector_top, node->j_okurigana_mode ) ;
  /* SKK ֻϤޤ */
  node->j_henkan_vector_top = skkinput_Request
    ( henkankey,   node->j_henkan_vector_top ) ;
  /* ơɤ줫ĤǤѴġ*/
  if( node->j_henkan_vector_top != NULL ){
    /* äϥѡθ*/
    j_purge_vector_index_top = NULL ;
    j_purge_vector_top = NULL ;
    j_purge_vector_top = searchSudeniPurgeSaretamono
      ( henkankey, j_purge_vector_top,
	node->j_okurigana_mode ) ;
    /* öϥå˸ߥѡƤáࡣ*/
    /* ڤФ˥ϥå夬ꥢƤϺΤǡFalse Ǥ *
     * 롣ɤ줫ĤǤҥåȤʤСѡꥹȤ򸡺 *
     * ̵̣*/
    if( j_purge_vector_top != NULL ){
      int tmp ;
      j_purge_vector_index_top = makeSearchVectorIndex
	( j_purge_vector_top, &tmp, False ) ;
    }
    /* SKK ֻڤФ*/
    node->j_henkan_vector_index_top =
      makeSearchVectorIndex( node->j_henkan_vector_top,
			     &node->j_henkan_vector_index_length, True ) ;
    /* purge ʤ󤫤ι򤫤路ڤФΤä *
     * ν*/
    if( node->j_henkan_vector_index_top != NULL ){
      /* Ѵꡣ*/
      node->j_henkan_count = 1 ;
      /* Ƭθؤ褦ˤ롣*/
      node->j_current_henkan_vector_index = 
	node->j_henkan_vector_index_top ;
    } else {
      /* purge αƶĲ񤫤äƤɡϤ *
       * ߤܤäʤλȤä㤤ʤä*/
      free_SkkinpSearchVector( &node->j_henkan_vector_top ) ;
      node->j_current_henkan_vector_index = NULL ;
      /* Ѵꡣ*/
      node->j_henkan_count = 0 ;
    }
    /* ѡΤξϤ⤷Ƥ⤦ס */
    free_VectorIndex( &j_purge_vector_index_top ) ;
    free_SkkinpSearchVector( &j_purge_vector_top ) ;
  }
  return ;
}

/*
 * Ѵνλ˸ƽФ륳Хåؿ
 */
static void skkinput_jhenkanEndCallback
( Widget gw, caddr_t client, caddr_t caller )
{
  struct SKKInputNode *node = ( struct SKKInputNode *)caller ;

  /* ѤƤβ*/
  free_VectorIndex( &( node->j_henkan_vector_index_top ) ) ;
  free_SkkinpSearchVector( &( node->j_henkan_vector_top ) ) ;
  node->j_current_henkan_vector_index = NULL ;
  return ;
}

/*
 * 򹹿˸ƽФ륳Хåؿ
 */
static void skkinput_jsavejisyoCallback
( Widget gw, caddr_t client, caddr_t caller )
{
  skkinput_updateLocalJisyo() ;
  return ;
}

/*
 * ñϿ˸ƤӽФؿ
 */
static void skkinput_jtangotourokuCallback
( Widget gw, caddr_t client, caddr_t caller )
{
  struct SKKTangoInfo *jtango = ( struct SKKTangoInfo *)caller ;

  if( jtango->tangotype ){
    add_SudeniHenkanKakuteiShitamono
      ( jtango->henkankey, jtango->vectortop,
	jtango->vector,    jtango->okuri ) ;
  } else {
    add_SudeniHenkanKakuteiShitamonoByString
      ( jtango->henkankey, jtango->string, jtango->okuri ) ;
    /* Ͽñο䤹*/
    skkinput_j_count_touroku ++ ;
  }
  skkinput_j_count_kakutei ++ ;
  return ;
}

/*
 * ñ˸ƤӽФؿ
 */
static void skkinput_jtangosakujoCallback
( Widget gw, caddr_t client, caddr_t caller )
{
  struct SKKInputNode *node = ( struct SKKInputNode *)caller ;
  /* ƤθܤƤѴä롣*/
  purge_SudeniHenkanKakuteiShitamono( node ) ;
  return ;
}

/*
 * ̾Ѵ򳫻Ϥ˸ƽФ륳Хåؿ
 */
static void skkinput_jcompletionCallback
( Widget gw, caddr_t client, caddr_t caller )
{
  struct SKKInputNode *node = ( struct SKKInputNode *)caller ;
  SkkinpSearchVector *j_purge_vector_top ;
  VectorIndex *j_purge_vector_index_top ;
  int tmp ;

  /* Ѥ줿⤷ʤץ꡼ξϼΤƤ롣*/
  free_VectorIndex( &node->j_completion_vector_index_top ) ;
  free_SkkinpSearchVector( &node->j_completion_vector_top ) ;

  node->j_completion_vector_top = NULL ;
  /* ˵Ƥ뼭񤫤鸡Ԥ*/
  node->j_completion_vector_top =
    j_completion_search_sudeniKakuteiShitaKouho
    ( node->j_completion_vector_top, node->j_henkan_key ) ;
  /* ޤɽ꼭񤫤鸡Ԥ*/
  node->j_completion_vector_top = 
    j_completion_skkinput_local_jisyo
    ( node->j_completion_vector_top, node->j_henkan_key ) ;
  /* ơɤ줫ĤǤѴġ*/
  if( node->j_completion_vector_top != NULL ){
    /* äϥѡθ*/
    j_purge_vector_index_top = NULL ;
    j_purge_vector_top       = NULL ;
    j_purge_vector_top = j_completion_search_sudeniPurgeSaretamono
      ( j_purge_vector_top, node->j_henkan_key ) ;
    /* öϥå˸ߥѡƤáࡣ*/
    /* ڤФ˥ϥå夬ꥢƤϺΤǡFalse Ǥ *
     * 롣ɤ줫ĤǤҥåȤʤСѡꥹȤ򸡺 *
     * ̵̣*/
    if( j_purge_vector_top != NULL ){
      j_purge_vector_index_top = makeSearchVectorIndex
	( j_purge_vector_top, &tmp, False ) ;
    }
    /* SKK ֻڤФ*/
    node->j_completion_vector_index_top =
      makeSearchVectorIndex( node->j_completion_vector_top, &tmp, True ) ;
    /* purge ʤ󤫤ι򤫤路ڤФΤä *
     * ν*/
    if( node->j_completion_vector_index_top != NULL ){
      /* Ƭθؤ褦ˤ롣*/
      node->j_current_completion_vector_index = 
	node->j_completion_vector_index_top ;
      node->j_completion_mode = True ;
    } else {
      /* purge αƶĲ񤫤äƤɡϤ *
       * ߤܤäʤλȤä㤤ʤä*/
      free_SkkinpSearchVector( &node->j_completion_vector_top ) ;
      node->j_current_completion_vector_index = NULL ; 
   }
    /* ѡΤξϤ⤷Ƥ⤦ס */
    free_VectorIndex( &j_purge_vector_index_top ) ;
    free_SkkinpSearchVector( &j_purge_vector_top ) ;
  }
  return ;
}

static void skkinput_jcompletionCloseCallback
( Widget gw, caddr_t client, caddr_t caller )
{
  struct SKKInputNode *node = ( struct SKKInputNode *)caller ;

  /* Ѥ줿⤷ʤץ꡼ξϼΤƤ롣*/
  free_VectorIndex( &node->j_completion_vector_index_top ) ;
  free_SkkinpSearchVector( &node->j_completion_vector_top ) ;

  node->j_completion_vector_top           = NULL ;
  node->j_completion_vector_index_top     = NULL ;
  node->j_current_completion_vector_index = NULL ;
  node->j_completion_mode                 = False ;
  return ;
}

/*
 * ѹե饰õؿ
 *-----
 */
static void skkinput_notmodifiedCallback
( Widget gw, caddr_t client, caddr_t caller )
{
  /* ѹե饰õ롣*/
  skkinput_jisyo_dirty = False ;
  return ;
}
