/* # skkinput (Simple Kana-Kanji Input)
 * skksoc.c --- communicate with skkserv.
 * This file is part of skkinput.
 * Copyright (C) 1997
 * Takashi SAKAMOTO (sakamoto@yajima.kuis.kyoto-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/* skkserv ȤäʬޤȤ᤿*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include <X11/keysym.h>

#include "skkmain.h"

/* skksvect.c */
void free_SkkinpSearchVector( SkkinpSearchVector **top ) ;

/* skkserv Ȥ̿ѤǤ륳ޥɤΰ*/
enum {
  SKKSERV_BYE = 0, SKKSERV_SEARCH, SKKSERV_VERSION, SKKSERV_HOSTNAME,
} ;

/* skkserv ȤäݤΥХåե*/
static char message_buffer[ TRANSBUFSIZE * 2 ] ;
/* SKK server ξ*/
struct sockaddr_in server ;
/* SKK server  Host ξ*/
static struct hostent *host ;
/* skkserv äΤѤ socket */
static int skkserv_soc ;
/* skkserv ȤΤä˻Ȥեݥ󥿡*/
static FILE *read_skkserv_fp, *write_skkserv_fp ;
/* skkserv Ƥ뤫ݤ */
static int skkserv_alive ;

/*
 * ץȥ
 */
static void clear_ServerSend( void ) ;
/* skksvect.c */
SkkinpSearchVector *add_SkkinpSearchVector( SkkinpSearchVector *topp,
					    char *str,
					    SkkinpSearchVector **rnode,
					    int *rpos ) ;

/*
 * åȤؿ
 *------------
 * server ̾ͿȡФƤ socket 褦
 * Ȼߤ롣
 */
static int makeSocket( char *server_name, int port_num )
{
  struct protoent *proto;
  /* Protocol ꡣ*/
  if( ( proto = getprotobyname( "tcp" ) ) == NULL ){
    return 1 ;
  }
  /* åȤ */
  if( ( skkserv_soc = socket( AF_INET, SOCK_STREAM, proto->p_proto ) ) < 0 ){
    fprintf( stderr, "Cannot make socket.\n" ) ;
    return 1 ;
  }
  /* ФξФ*/
#ifdef HAVE_BZERO
  bzero( ( char *)&server, sizeof( server ) ) ;
#else
  memset( ( char *)&server, 0, sizeof( server ) ) ;
#endif
  server.sin_family = AF_INET ;
  if( ( host = gethostbyname( server_name ) ) == NULL ){
    shutdown( skkserv_soc, 2 ) ;
    close( skkserv_soc ) ;
    fprintf( stderr, "%s: Unknown host.\n", server_name ) ;
    return 1 ;
  }
#ifdef HAVE_BCOPY
  bcopy( host->h_addr, &server.sin_addr, host->h_length ) ;
#else
  memcpy( &server.sin_addr, host->h_addr, host->h_length ) ;
#endif
  server.sin_port = htons( port_num ) ;

  read_skkserv_fp  = fdopen( skkserv_soc, "r" ) ;
  write_skkserv_fp = fdopen( skkserv_soc, "w" ) ;

  /* fdopen ˼Ԥ */
  if( read_skkserv_fp == NULL || write_skkserv_fp == NULL )
    return 1 ; 

  return 0 ;
}

/*
 * skkserv  message ؿ
 */
static int send_to_server( int funcno, char *string )
{
  /* 楳ɤ˴ְ㤤¸ߤʤ */
  switch( funcno ){
    /* 楳ɤΥޥɡ*/
  case SKKSERV_BYE :
  case SKKSERV_VERSION :
  case SKKSERV_HOSTNAME :
    /* С˹Ԥäߤǽꡣ*/
    fprintf( write_skkserv_fp, "%d\n", funcno ) ;
    fflush( write_skkserv_fp ) ;
    break ;

    /* äơʸɬפʥޥɡ*/
  case SKKSERV_SEARCH :
    /* С˹Ԥäߤǽ = ָפꡣ*/
    fprintf( write_skkserv_fp, "1%s \n", string ) ;
    fflush( write_skkserv_fp ) ;
    break ;

  default :
    fprintf( stderr, "WARNING : Unknown function code.\n" ) ;
    return 1 ;
  }
#if 0
  fprintf( stderr, "To skkserv : \"%s\".", message_buffer ) ;
#endif
  return 0 ;
}

/*
 * skkserv ʸؿ
 * ----
 * ɤΰ̤Ĺʸ󤬵äΤȽʤΤǡꥹȤǼ
 * Ȥˤʤ롣
 */
static SkkinpSearchVector *skkinput_ReadRequestsResult( SkkinpSearchVector *top )
{
  /* С֤Хåե*/
  int i, ret ;
  unsigned char pbuf ;

  i = 0 ;
  for( ; ; ){
    /* server ʸ롣*/
    ret = read( skkserv_soc, &pbuf, 1 ) ;
    /* 顼ȯν*/
    if( ret <= 0 ){
      /* ԡ*/
      perror( "read" ) ;
      /* ݤʬޤ礦*/
      free_SkkinpSearchVector( &top ) ;
      shutdown( skkserv_soc, 2 ) ;
      close( skkserv_soc ) ;
      exit( 1 ) ;
    }
    message_buffer[ i ++ ] = pbuf ;

    /* ʸɤ߹Τʤ顢Ͽ⡼ɤ˰ư롣*/
    if( i >= TEXTMAXLEN ){
      message_buffer[ i ] = '\0' ;
      i = 0 ;
#ifdef DEBUG_LV0
      fprintf( stderr, "%s%d\n", message_buffer,
	       strlen( message_buffer ) ) ;
#endif
      top = add_SkkinpSearchVector( top, message_buffer, NULL, NULL ) ;
      continue ;
    }
    /* üʸɤ߹Τʤ顢λ롣skkserv νüʸ *
     * EOL(0x0a) Ǥ롣*/
    if( pbuf == 0x0a ){
      message_buffer[ i ] = '\0' ;
#ifdef DEBUG_LV0
      fprintf( stderr, "%s%d\n", message_buffer,
	       strlen( message_buffer ) ) ;
#endif
      top = add_SkkinpSearchVector( top, message_buffer, NULL, NULL ) ;
      break ;
    }
  }
  return top ;
}

/*
 * 饤ȤΥС뤿˥Ф̿ؿ
 */
char *skkinput_GetClientVersion( void )
{
  int i ;

  /* С˥饤ȤΥС֤褦ؼ롣*/
  send_to_server( SKKSERV_VERSION, NULL ) ;

  /* server ֤Сֹ롣*/
  i = 0 ;
  if( read( skkserv_soc, message_buffer, TEXTMAXLEN ) <= 0 ){
    perror( "read" ) ;
    return NULL ;
  }
  message_buffer[ TEXTMAXLEN ] = '\0' ;
  return message_buffer ;
}

/*
 * 饤ȤΥС뤿˥Ф̿ؿ
 */
char *skkinput_GetClientHost( void )
{
  /* С˥饤ȤΥС֤褦ؼ롣*/
  send_to_server( SKKSERV_HOSTNAME, NULL ) ;

  /* server ֤ hostname 롣*/
  if( read( skkserv_soc, message_buffer, TEXTMAXLEN ) <= 0 ){
    perror( "read" ) ;
    return NULL ;
  }
  message_buffer[ TEXTMAXLEN ] = '\0' ;
  return message_buffer ;
}

/*
 * Фμ򥯥ꥢؿ
 */
static void clear_ServerSend( void )
{
  unsigned char pbuf ;

  for( ; ; ){
    if( read( skkserv_soc, &pbuf, 1 ) <= 0 ){
      /* ԡ*/
      perror( "read" ) ;
      shutdown( skkserv_soc, 2 ) ;
      /* ݤʬޤ礦*/
      close( skkserv_soc ) ;
      exit( 1 ) ;
    }
    if( pbuf == 0x0a )
      break ;
  }
  return ;
}

/*
 * socket Ѱդskkerv ³ؿ
 *----
 */
int skkinput_StartCommunication( char *server_name, int port_num )
{
  /* skkserv Ƥ뤫ɤʬʤΤǡFalse ˤƤ*/
  skkserv_alive = False ;

  /* skkerv ̿뤿ΥåȤפޤ*/
  if( makeSocket( server_name, port_num ) ){
    fprintf( stderr, "Warning : cannot make a socket." ) ;
    return 1 ;
  }
  /* ³׵ᡣ*/
  if( connect( skkserv_soc, 
	       ( struct sockaddr *)&server, sizeof( server ) ) < 0 ){
    perror( "connect" ) ;
    fprintf( stderr, "Warning : cannot connect SKK server." ) ;
    shutdown( skkserv_soc, 2 ) ;
    close( skkserv_soc ) ;
#if 0
    exit( 1 ) ;
#endif
    return 1 ;
  }
  /* ̵λǤ*/
  skkserv_alive = True ;
  return 0 ;
}

/*
 * SKK server Ȥ³λؿ
 *----
 * λˤɬٸƤФ줿ɤȻפؿǤ롣
 */
int skkinput_CloseCommunication( void )
{
  /* SKK server ˡ֤褦ʤפ롣*/
  send_to_server( SKKSERV_BYE, NULL ) ;
  /* fp Ĥ롣*/
  fclose( write_skkserv_fp ) ;
  fclose( read_skkserv_fp ) ;
  /* ⤦ socket ѤʤȤ롣*/
  shutdown( skkserv_soc, 2 ) ;
  /* Socket Ĥ롣*/
  close( skkserv_soc ) ;
  /* λ*/
  skkserv_alive = False ;
  return 0 ;
}

/*
 * skkserv ˸ REQUEST ؿ
 *----
 * ϤϸǤ롣
 */
SkkinpSearchVector *skkinput_Request( char *str, SkkinpSearchVector *top )
{
  /* skkserv ƤʤСå褦̵Τǽλ롣*/
  if( !skkserv_alive )
    return top ;

  /* С˸Ԥ褦ؼ롣*/
  send_to_server( SKKSERV_SEARCH, str ) ;

  /* skkserv  connect ɤ֤Τǡ롣*/
  if( read( skkserv_soc, message_buffer, 1 ) <= 0 ){
    /* ԡ*/
    perror( "read" ) ;
    skkserv_alive = False ;
    return top ;
#if 0
    exit( 1 ) ;
#endif
  }
  /* Сå롣*/
  switch( message_buffer[ 0 ] ){
    /* С顼֤ν*/
  case '0' :
    fprintf( stderr, "SKK server error." ) ;
    break ;

    /* Сȸդäν*/
  case '1' :
    top = skkinput_ReadRequestsResult( top ) ;
    break ;

    /* СꥯȤǸդʤäν*/
  case '4' :
    /* Ѥʸ󤬤Τޤ֤ä롣*/
    /* ɤ߹Ǥ*/
    clear_ServerSend() ;
#ifdef DEBUG
    fprintf( stderr, "Return from skkserv : \"%s\"\n", message_buffer ) ;
#endif
    break ;

    /* Сʣ client ʤȤʤơäƤ硣*/
  case '9' :
    fprintf( stderr, "SKK server has too many clients." ) ;
    break ;

  default :
    clear_ServerSend() ;
    break ;
  }
  return top ;
}
