;; SKK tutorial for SKK version 9.4 and later versions
;; Copyright (C) 1988, 1989, 1990, 1991, 1992, 1993, 1994, 1995, 1996, 1997
;; Masahiko Sato <masahiko@kuis.kyoto-u.ac.jp>

;; Author: Masahiko Sato <masahiko@kuis.kyoto-u.ac.jp>
;; Version: 4.0.8
;; Keywords: japanese
;; Last Modified: Wed Nov 27 06:27:07 1996

;; This program is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either versions 2, or (at your option)
;; any later version.

;; This program is distributed in the hope that it will be useful
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SKK, see the file COPYING.  If not, write to the Free
;; Software Foundation Inc., 59 Temple Place - Suite 330, Boston,
;; MA 02111-1307, USA.

;;; Commentary:

;; Following people contributed modifications to skk-tut.el
;; (Alphabetical order):
;;      Haru'yasu Ueda <hal@sics.se>
;;      Hideki Sakurada <sakurada@kusm.kyoto-u.ac.jp>
;;      Hitoshi SUZUKI <h-suzuki@ael.fujitsu.co.jp>
;;      IIDA Yosiaki <iida@sayla.secom-sis.co.jp>
;;      Koji Uchida <uchida@cfd.tytlabs.co.jp>
;;      Mikio Nakajima <gy2m-nkjm@asahi-net.or.jp>
;;      Shuhei KOBAYASHI <shuhei-k@jaist.ac.jp>
;;      Toyonobu Yoshida <toyono-y@is.aist-nara.ac.jp>
;;      Wataru Matsui <matsui@gf.hm.rd.sanyo.co.jp>
;;      ͦ <jshen@cas.org>

;;; Change log:
;; version 4.0.8 released 1996.11.27
;; version 3.9 released 1996.2.7
;; version 3.8 released 1995.5.13
;; version 3.7 released 1993.5.20
;; version 3.6 released 1992.9.19
;; version 3.5 released 1992.5.31
;; version 3.4 released 1992.4.12
;; version 3.3 released 1991.4.20
;; version 3.2 released 1990.4.15
;; version 2.2 released 1989.4.15

;;; Code:
(require 'skk)
(require 'skk-gadget)

(defvar skk-tut-file "/usr/local/share/skk/SKK.tut"
  "*SKK 塼ȥꥢΥե̾
For English version use SKK.tut.E." )

(defvar skktut-japanese-tut
  (string= (file-name-nondirectory skk-tut-file) "SKK.tut")
  "Non-nil ǤС塼ȥꥢ뤬ܸǤ뤳Ȥ򼨤" )

(defvar skktut-use-face skk-emacs19
  "*Non-nil ǤС塼ȥꥢ face ѤɽԤʤ
Emacs 19 ѤƤΤͭ" )                                        

(defvar skktut-section-face
  (and skktut-use-face
       (cond ((and (eq skk-background-mode 'mono) (skk-terminal-face-p))
              'bold-italic )
             ((eq skk-background-mode 'light)
              (skk-make-face 'yellow/dodgerblue) )
             (t (skk-make-face 'yellow/slateblue)) ))
  "*塼ȥꥢΥɽʬ face" )

(defvar skktut-do-it-face
  (and skktut-use-face
       (cond ((and (eq skk-background-mode 'mono) (skk-terminal-face-p))
              'bold )
             ((eq skk-background-mode 'light)
              (skk-make-face 'DarkGoldenrod) )
             (t (skk-make-face 'LightGoldenrod)) ))
  "*塼ȥꥢλؼܤɽʬ face" )

(defvar skktut-question-face
  (and skktut-use-face
       (cond ((and (eq skk-background-mode 'mono) (skk-terminal-face-p))
              'underline )
             ((eq skk-background-mode 'light)
              (skk-make-face 'Blue) )
             (t (skk-make-face 'LightSkyBlue)) ))
  "*塼ȥꥢɽʬ face" )

(defvar skktut-key-bind-face
  (and skktut-use-face
       (cond ((and (eq skk-background-mode 'mono) (skk-terminal-face-p))
              'bold )
             ((eq skk-background-mode 'light)
              (skk-make-face 'Firebrick) )
             (t (skk-make-face 'OrangeRed)) ))
  "*塼ȥꥢΥХɤɽʬ face" )

(defvar skktut-hint-face
  (and skktut-use-face
       (cond ((and (eq skk-background-mode 'mono) (skk-terminal-face-p))
              'italic )
             ((eq skk-background-mode 'light)
              (skk-make-face 'CadetBlue) )
             (t (skk-make-face 'Aquamarine)) ))
  "*塼ȥꥢΥҥȤɽʬ face
ߤΤȤSKK.tut.E ǤѤƤʤ" )

(defconst skktut-problem-numbers 37 "SKK 塼ȥꥢ")

(defconst skktut-tut-jisyo "~/skk-tut-jisyo"
  "SKK 塼ȥꥢѤΥߡ" )

(defconst skktut-init-variables
  ;; C-x C-f skk.el
  ;; M-x occur ^(skk-defvar
  ;; C-xb *Occur*
  ;; C-k, C-k (if the variable `kill-whole-line' is non-nil just C-k once.)
  ;; M->
  ;; C-u M-| awk '{print $2}'
  ;; -- Now copy and yank. --
  ;; Do the same for skk-comp.el, skk-e1[89].el, skk-gadget.el, skk-kcode.el
  ;; and skk-num.el.
  ;; M-x sort-columns
  ;; M-C-a
  ;; M-C-q
  (nconc
   (if skk-emacs19
       '(skk-e19-load-hook skk-henkan-face)
     '(skk-e18-load-hook) )
  '(skk-abbrev-map
    skk-allow-spaces-newlines-and-tabs
    skk-ascii-cursor-color
    skk-auto-fill-mode-hook
    skk-auto-insert-paren
    skk-auto-okuri-process
    skk-auto-paren-string-alist
    skk-auto-start-henkan
    skk-auto-start-henkan-keyword-list
    skk-aux-large-jisyo
    skk-backup-jisyo
    skk-byte-compile-init-file
    skk-char-type-vector
    skk-comp-load-hook
    skk-compare-jisyo-size-when-saving
    skk-convert-okurigana-into-katakana
    skk-count-private-jisyo-candidates-exactly
    skk-dabbrev-like-completion
    skk-date-ad
    skk-default-cursor-color
    skk-delete-implies-kakutei
    skk-delete-okuri-when-quit
    skk-echo
    skk-egg-like-newline
    skk-gadget-load-hook
    skk-henkan-face
    skk-henkan-okuri-strictly
    skk-henkan-show-candidates-keys
    skk-hirakana-mode-string
    skk-init-file
    skk-initial-search-jisyo
    skk-input-by-code-menu-keys1
    skk-input-by-code-menu-keys2
    skk-input-vector
    skk-insert-new-word-hook
    skk-japanese-message-and-error
    skk-jisyo
    skk-jisyo-code
    skk-jisyo-save-count
    skk-kakutei-early
    skk-kakutei-jisyo
    skk-kakutei-key
    skk-kana-cursor-color
    skk-katakana-cursor-color
    skk-katakana-mode-string
    skk-kcode-load-hook
    skk-keep-record
    skk-large-jisyo
    skk-load-hook
    skk-map
    skk-minibuff-map
    skk-mode-hook
    skk-mode-string
    skk-num-load-hook
    skk-num-type-list
    skk-number-style
    skk-numeric-conversion-float-num
    skk-process-okuri-early
    skk-record-file
    skk-report-set-cursor-error
    skk-rom-kana-rule-list
    skk-roma-kana-a
    skk-roma-kana-e
    skk-roma-kana-i
    skk-roma-kana-o
    skk-roma-kana-u
    skk-search-prog-list
    skk-setup-abbrev-map-hook
    skk-setup-map-hook
    skk-setup-minibuff-map-hook
    skk-setup-zenkaku-map-hook
    skk-special-midashi-char-list
    skk-use-color-cursor
    skk-use-numeric-conversion
    skk-use-face
    skk-use-vip
    skk-zenei-mode-string
    skk-zenkaku-cursor-color
    skk-zenkaku-map
    skk-zenkaku-vector ))
  "skk.el Υ桼ѿΥꥹȡ" )

(defvar skktut-right-answer nil "ʸ")
(defvar skktut-problem-count 0 "SKK 塼ȥꥢθߤֹ档")
(defvar skktut-tutorial-end nil "SKK 塼ȥꥢνλ򼨤ե饰")
(defvar skktut-tutorial-map nil "SKK 塼ȥꥢΤΥޥåס")

(defvar skktut-original-buffer nil
  "skk-tutorial ƤȤΥХåե̾" )

(defvar skktut-skk-on nil
  "Non-nil ǤСskk-tutorial ưȤ SKK ˵ưƤȤ򼨤" )

;; -- macros
(defmacro skktut-message (japanese english &rest arg)
  ;; skktut-japanese-tut  non-nil ä JAPANESE  nil Ǥ ENGLISH 
  ;; 򥨥ꥢɽ롣
  ;; ARG  message ؿ裲ʹߤΰȤϤ롣
  (append (list 'message (list 'if 'skktut-japanese-tut japanese english))
          arg ))
      
(defmacro skktut-error (japanese english &rest arg)
  ;; skktut-japanese-tut  non-nil ä JAPANESE  nil Ǥ ENGLISH 
  ;; 򥨥ꥢɽ顼ȯ롣
  ;; ARG  error ؿ裲ʹߤΰȤϤ롣
  (append (list 'error (list 'if 'skktut-japanese-tut japanese english))
          arg ))

(defmacro skktut-yes-or-no-p (japanese english)
  (list 'yes-or-no-p (list 'if 'skktut-japanese-tut japanese english)) )

;;;###autoload
(defun skk-tutorial ()
  "SKK 塼ȥꥢư롣"
  (interactive)
  (let ((inhibit-quit t))
    (if (not (or (string= "9.4" (skk-version))
                 (string< "9.4" (skk-version)) ))
        (error "skk.el version 9.4 or later is required")
      (skktut-pre-setup-tutorial)
      (skktut-setup-jisyo-buffer)
      (skktut-setup-working-buffer)
      (skktut-setup-problem-buffer)
      (skktut-setup-answer-buffer) )))

(defun skktut-save-buffers-kill-emacs (&optional query)
  (interactive "P")
  (if (skktut-yes-or-no-p "Tutorial  Emacs ⽪λޤǤ͡ "
                          "Quit tutorial and kill emacs? " )
      (progn (skktut-quit-tutorial 'now)
             (save-buffers-kill-emacs query) )))

(defun skktut-tutorial-again ()
  (interactive)
  (if (skktut-yes-or-no-p "ǽ餫 Tutorial ľޤǤ͡ "
                          "Quit tutorial and start from question 1 again? " )
      (progn (skktut-quit-tutorial 'now)
             (skk-tutorial) )))

(defun skktut-mode ()
  (interactive)
  (if (eq skktut-problem-count 1)
      (skktut-error "ΥϤޤȤޤ"
                    "Cannot use this key yet" )
    (if skk-mode
        (progn
          (skk-change-mode-line skk-hirakana-mode-string)
          (setq skk-j-mode t)
          (skk-use-local-map skk-map) )
      (if skk-emacs19
          (add-hook 'before-make-frame-hook
                    'skktut-before-move-to-other-frame-func ))
      (if (not (boundp 'select-window-hook))
          nil
        (if (and select-window-hook
                 (not (eq select-window-hook 'skk-select-window-func) ))
            (setq skk-other-select-window-hook-func-list
                  (cons (symbol-value 'select-window-hook)
                        skk-other-select-window-hook-func-list )))
        (setq select-window-hook 'skk-select-window-func) )
      (or skk-mode-line
          (setq mode-line-format
                (cons "" (cons 'skk-mode-line
                               (cdr (default-value 'mode-line-format)) ))))
      (skk-change-mode-line skk-hirakana-mode-string)
      (setq skk-mode t
            skk-j-mode t
            skk-katakana nil
            skk-zenkaku nil
            skk-prefix-tree (skk-compute-prefix-tree) )
      (setq skk-emacs-local-map
            (skk-convert-to-vector (copy-keymap (current-local-map))) )
      (define-key minibuffer-local-map "\C-j" 'skk-mode)
      (define-key minibuffer-local-map "\C-m" 'skk-newline)
      (skk-setup-map)
      (skk-setup-zenkaku-map)
      (skk-setup-abbrev-map)
      (skk-make-henkan-marker)
      (skk-use-local-map skk-map) )))

(defun skktut-kakutei (&optional word)
  (interactive)
  (if (eq skktut-problem-count 1)
      (skktut-error "ΥϤޤȤޤ"
                    "Cannot use this key yet" )
    (skk-kakutei word) ))

(defun skktut-error-command ()
  (interactive)
  (switch-to-buffer-other-window "**") )

(defun skktut-quit-tutorial (&optional now)
  (interactive)
  (if (or now (skktut-yes-or-no-p "˥塼ȥꥢޤ? "
                                  "Quit tutorial? " ))
      (let ((inhibit-quit t))
        (delete-other-windows)
        ;; ٥塼ȥꥢȤ褦ˡѿƤ
        (setq skktut-japanese-tut nil
              skktut-problem-count 0
              skktut-right-answer nil
              skktut-tutorial-end nil
              skktut-tutorial-map nil )
        (if skk-emacs19
            (progn
              (remove-hook 'minibuffer-setup-hook
                           'skktut-localize-and-init-variables )
              (remove-hook 'before-make-frame-hook
                           'skktut-before-move-to-other-frame-func )
              ;;(ad-enable-advice 'use-local-map 'after 'skk-ad)
              (ad-remove-advice 'other-frame 'before 'skktut-ad)
              (ad-remove-advice 'select-frame 'before 'skktut-ad) )
          (if (boundp 'select-window-hook)
              (setq skk-other-select-window-hook-func-list
                    (delq 'skktut-select-window-hook-func
                          skk-other-select-window-hook-func-list ))))
        (if (featurep 'mule)
            (if (fboundp 'skktut-save-set-henkan-point)
                (skktut-change-func-def 'skk-set-henkan-point
                                        'skktut-save-set-henkan-point ))
          (if (fboundp 'skktut-nemacs-set-henkan-point)
              (skktut-change-func-def 'skk-set-henkan-point
                                      'skktut-nemacs-set-henkan-point )))
        (if (fboundp 'skktut-save-abbrev-input)
            (skktut-change-func-def 'skk-abbrev-input
                                    'skktut-save-abbrev-input ))
        (fmakunbound 'skktut-save-set-henkan-point)
        (fmakunbound 'skktut-save-abbrev-input)
        (fmakunbound 'skktut-nemacs-set-henkan-point)
        ;; skk-jisyo ;; for debugging
        (let ((buff (get-file-buffer skktut-tut-jisyo)))
          (if buff
              (progn
                (set-buffer buff)
                (set-buffer-modified-p nil)
                (kill-buffer buff))))
        (kill-buffer " *skk-tutorial*")
        (kill-buffer "**")
        (kill-buffer "**")
        ;;(skk-kill-local-variables)
        (switch-to-buffer skktut-original-buffer)
        ;; SKK ưˤʤ 
        ;; skk-tutorial ¹ԤȤ skk-jisyo ХåեʤΤ 
        ;; skk-setup-jisyo-buffer ǥ顼ȤʤꡢEmacs νλǤʤ
        ;; ʤΤ SKK ⡼ɤٵƤ
        (skk-mode 1)
        ;; 塼ȥꥢ뵯ưľ˳ƤХåեǡskk-mode ư
        ;; 顢ξ֤ˤơ塼ȥꥢλ롣
        ;; skk-jisyo  ;; for debugging
        (or skktut-skk-on
            (skk-mode -1) ))))

(defun skktut-answer-window ()
  (interactive)
  (let (p)
    (save-match-data
      (goto-char (point-max))
      (search-backward "\n>>")
      (forward-char 1)
      (setq skktut-right-answer
            (skk-buffer-substring (+ 3 (point))
                                  (save-excursion (end-of-line) (point)) ))
      (switch-to-buffer-other-window "**")
      (insert ">> \n\n")
      (setq p (point))
      (if skktut-japanese-tut
          (insert "* ǤC-x n; ǤˤϡC-x q; "
                  "åפˤϡC-x s *" )
        (insert "* For next question `C-x n'; to quit `C-x q'; "
                "to skip this question `C-x s' *" ))
      (if skktut-use-face
          (put-text-property p (point) 'face skktut-key-bind-face) )
      (if skk-emacs19 (put-text-property p (point) 'read-only t))
      (goto-char (+ (point-min) 3)) )))

(defun skktut-next-window ()
  (interactive)
  (save-match-data
    (let (user-ans)
      (save-excursion
        (goto-char (point-min))
        (end-of-line)
        (skip-chars-backward " \t")
        (setq user-ans (skk-buffer-substring (+ 3 (point-min)) (point))) )
      (if (not (string= skktut-right-answer user-ans))
          (progn
            (skktut-message "㤤ޤ⤦٤äƤߤƲ"
                            "Wrong.  Try again")
            (ding) )
        (skktut-erase-buffer)
        (message "")
        (other-window 1)
        (setq skktut-problem-count (1+ skktut-problem-count))
        (skktut-get-page skktut-problem-count)
        (if (>= skktut-problem-count (1+ skktut-problem-numbers))
            (skktut-quit-tutorial t)
          (skktut-answer-window) )))))

(defun skktut-skip-problem (arg)
  (interactive "p")
  (skktut-erase-buffer)
  (setq skktut-problem-count (+ skktut-problem-count arg))
  (if (< skktut-problem-count 1) (setq skktut-problem-count 1))
  (if (> skktut-problem-count skktut-problem-numbers)
      (setq skktut-problem-count skktut-problem-numbers))
  (if (and (>= skktut-problem-count 3) (not skk-j-mode))
      (skktut-mode) )
  (other-window 1)
  (skktut-get-page skktut-problem-count)
  (if skktut-tutorial-end (skktut-quit-tutorial 'now) (skktut-answer-window)) )

(defun skktut-set-henkan-point-tmp ()
  (interactive)
  (if skk-j-mode
      (skktut-error "/ʥ⡼ɤǤϡʸϤޤȤޤ"
                    "Cannot use upper case character in kana/katakana mode" )
    (insert (if skk-zenkaku (concat (char-to-string 163)
                                  (char-to-string (+ last-command-char 128)))
              last-command-char))))

(defun skktut-abbrev-input-tmp ()
  (interactive)
  (if skk-j-mode
      (skktut-error "ΥϤޤȤޤ"
                    "Cannot use this key yet" )
    (insert last-command-char)))

(defun skktut-get-page (page)
  (save-match-data
    (save-excursion
      (let (pos)
        (set-buffer " *skk-tutorial*")
        (goto-char (point-min))
        (search-forward "--\n" nil t page)
        (if (looking-at ";")
            (progn (forward-char 3)
                   (setq pos (point))
                   (end-of-line)
                   (save-excursion
                     (eval-region pos (point) nil) )
                   (forward-char 1) ))
        (if (not skktut-tutorial-end)
            (progn
              (setq pos (point))
              (search-forward "\n>>")
              (end-of-line)
              (copy-to-buffer "**" pos (point)) ))))
    (if (>= page 12)
        (skktut-enable) )
    (setq mode-line-buffer-identification
          (concat "ӣˣ˥塼ȥꥢ:  "
                  (int-to-string page)
                  " ʻĤ "
                  (int-to-string (- skktut-problem-numbers page))
                  ""))
    (set-buffer-modified-p nil)
    (sit-for 0) ))

(defun skktut-disable ()
  (if (not (fboundp 'skktut-save-set-henkan-point))
      (progn
        (skktut-change-func-def 'skktut-save-set-henkan-point
                                'skk-set-henkan-point )
        (skktut-change-func-def 'skk-set-henkan-point
                                'skktut-set-henkan-point-tmp )))
  (if (not (fboundp 'skktut-save-abbrev-input))
      (progn
        (skktut-change-func-def 'skktut-save-abbrev-input 'skk-abbrev-input)
        (skktut-change-func-def 'skk-abbrev-input 'skktut-abbrev-input-tmp) )))

(defun skktut-enable ()
  (if (fboundp 'skktut-save-abbrev-input)
      (progn (skktut-change-func-def 'skk-abbrev-input 'skktut-save-abbrev-input)
             (fmakunbound 'skktut-save-abbrev-input) ))
  (if (fboundp 'skktut-save-set-henkan-point)
      (progn (skktut-change-func-def 'skk-set-henkan-point
                                     'skktut-save-set-henkan-point )
             (fmakunbound 'skktut-save-set-henkan-point) )))

(defun skktut-pre-setup-tutorial ()
  (setq skktut-original-buffer (current-buffer)
        skktut-skk-on skk-mode
        skktut-problem-count 1 )
  (if skk-emacs19
      (progn
        ;;(ad-disable-advice 'use-local-map 'after 'skk-ad)

        (defadvice other-frame (before skktut-ad activate)
          (skktut-before-move-to-other-frame-func) )
        
        (defadvice select-frame (before skktut-ad activate)
          (skktut-before-move-to-other-frame-func) )
        
        (add-hook 'minibuffer-setup-hook 'skktut-localize-and-init-variables) )
    ;; Emacs 18 Ǥ minibuffer-setup-hook ϻȤʤMule (version 1-x 
    ;; ) Ǥ `select-window-hook' Ȥ̤ʥեåѰդƤ롣
    (if (boundp 'select-window-hook)
        (progn
          (setq skk-other-select-window-hook-func-list
                (cons 'skktut-select-window-hook-func
                      skk-other-select-window-hook-func-list ))
          (if (eq (symbol-value 'select-window-hook)
                  'skk-select-window-hook-func )
              (setq skk-other-select-window-hook-func-list
                    (cons (symbol-value 'select-window-hook)
                          skk-other-select-window-hook-func-list ))))
        ;; Nemacs Ǥϡminibufer-setup-hook  select-window-hook Ȥʤ
      (skktut-change-func-def 'skk-set-henkan-point ; old
                              'skktut-set-henkan-point ; new
                              'skktut-nemacs-set-henkan-point )))) ;save 

(defun skktut-setup-jisyo-buffer ()
  ;; setup skktut-tut-jisyo buffer.
  (set-buffer (get-buffer-create " *skk-tut-jisyo*"))
  (setq case-fold-search nil
        buffer-file-name (expand-file-name skktut-tut-jisyo) )
  (buffer-disable-undo (current-buffer))
  (insert (concat ";; okuri-ari entries.\n"
                  "ۤs //\n"
                  "Ĥt //\n"
                  "s /ã/\n"
                  "t //\n"
                  "k /ư/\n"
                  ";; okuri-nasi entries.\n"
                  "Greek /////////////////"
                  "////////\n"
                  "Russia /////////////////"
                  "/////////////////\n"
                  "greek /////////////////"
                  "////////\n"
                  "russia /////////////////"
                  "/////////////////\n"
                  " /첯/\n"
                  " //\n"
                  " /̾/\n"
                  " ///ƻ/\n"
                  "夦 /ؽ/\n"
                  " //////\n"
                  " ////////////////"
                  "//////////////////"
                  "//////////////////"
                  "///////////////////"
                  "///////////////////"
                  "//////////////////"
                  "/\n"
                  "礦 //\n"
                  " //\n"
                  " //////////////////"
                  "/\n"
                  " ////\n"
                  " /ǽ/\n"
                  "Ȥ /ƣ/\n"
                  "Ȥ /ƣ/\n"
                  "夦礦 /λ/\n"
                  " //Ͻ/\n"
                  "󤳤 /͸/\n"
                  "󤿤 ///\n"
                  " //\n"
                  " ////\n"
                  "Ƥ /Ū/Ũ/ũ/Ŭ/Ŧ/\n"
                  "Ȥ //\n"
                  "Ȥۤ //\n"
                  "Ȥ /Ͽ/\n"
                  "Ȥ /Ͽ/\n"
                  "ɤ /ư/\n"
                  "ˤ夦礯 //\n"
                  "Ҥ /Ե/\n"
                  "ؤ󤫤 /Ѵ/\n"
                  "ۤ //\n"
                  "ߤ礦 /̾/\n"
                  "褦 /ư/Ѱ/\n" ))
  (skk-setup-jisyo-buffer)
  (skktut-localize-and-init-variables) )

(defun skktut-setup-working-buffer ()
  (save-match-data
    (let (sexp)
      (set-buffer (get-buffer-create " *skk-tutorial*"))
      ;; " *skk-tut-jisyo*" Хåե skk.el ѿХåե벽
      ;; 롣
      (skktut-localize-and-init-variables)
      (erase-buffer)
      (insert-file-contents skk-tut-file)
      (goto-char (point-min))
      ;; 塼ȥꥢ뤬ܸ줫Ѹ줫å
      (setq skktut-japanese-tut (looking-at ";; SKK Japanese"))
      ;; Nemacs ȤäƤΤʤС塼ȥꥢƥȤ Mule ʸ
      ;; Nemacs ѹ
      (if (not (featurep 'mule))
          (progn
            (while (search-forward "Mule" nil t nil)
              (delete-region (match-beginning 0) (match-end 0))
              (insert "Nemacs") )
            (goto-char (point-min))
            (while (search-forward "ͣ" nil t nil)
              (delete-region (match-beginning 0) (match-end 0))
              (insert "Σ") )
            (goto-char (point-min)) ))
      (while (re-search-forward "^>> \\((.+)\\)$" nil t nil)
        (setq sexp (skk-buffer-substring (match-beginning 1) (match-end 1)))
        (delete-region (match-beginning 1) (match-end 1))
        (insert (eval (car (read-from-string sexp)))) )
      (goto-char (point-min))
      (if skktut-use-face
          (skktut-colored) ))))

(defun skktut-setup-problem-buffer ()
  (switch-to-buffer (get-buffer-create "**"))
  (erase-buffer)
  (setq skktut-tutorial-map (make-keymap))
  (fillarray (if skk-emacs19
                 (nth 1 skktut-tutorial-map)
               skktut-tutorial-map ) 'skktut-error-command)
  (skk-use-local-map skktut-tutorial-map)
  (skktut-get-page skktut-problem-count)
  (delete-other-windows)
  (split-window-vertically nil)
  (other-window 1)
  (enlarge-window (- (window-height (selected-window)) 20)) )

(defun skktut-setup-answer-buffer ()
  (switch-to-buffer (get-buffer-create "**"))
  ;; "**" Хåե skk.el ѿХåե벽롣
  (skktut-localize-and-init-variables)
  (local-set-key "\C-j" 'skktut-kakutei)
  (local-set-key "\C-x\C-c" 'skktut-save-buffers-kill-emacs)
  (local-set-key "\C-x\C-j" 'skktut-mode)
  (local-set-key "\C-xj" 'skktut-error-command)
  (local-set-key "\C-xn" 'skktut-next-window)
  (local-set-key "\C-xq" 'skktut-quit-tutorial)
  (local-set-key "\C-xs" 'skktut-skip-problem)
  (local-set-key "\C-xt" 'skktut-tutorial-again)
  (skktut-disable)
  (auto-fill-mode -1)
  (switch-to-buffer-other-window "**")
  (goto-char (point-max))
  (beginning-of-line)
  (skktut-answer-window)
  (message "") )

(defun skktut-localize-and-init-variables ()
  ;; 桼 skk.el ѿ򥫥ޥƤǽΤǡ
  ;; Хåե skk.el ѿХåե벽롣
  (let ((vl skktut-init-variables)
        tut-var v )
    (while vl
      (setq v (car vl)
            vl (cdr vl)
            tut-var (skk-get v 'skktut-value 'no-value) )
      (if (not (eq tut-var 'no-value))
          (progn
            (make-local-variable v)
            (set v tut-var) )))
    (make-local-variable 'skk-mode-invoked)
    (setq skk-mode-invoked 'invoked) ))

(defun skktut-erase-buffer ()
  (if skk-emacs19
      (let ((inhibit-read-only t))
        (set-text-properties (point-min) (point-max) nil) ))
  (erase-buffer) )

(if skk-emacs19
    ;; For Emacs 19
    (progn
      (defun skktut-before-move-to-other-frame-func ()
        (if (skktut-yes-or-no-p "Tutorial λޤǤ͡ "
                                "Quit tutorial?" )
            (skktut-quit-tutorial 'now)
          (skktut-error "Tutorial λ¾Υե졼˰ܤ뤳ȤϤǤޤ"
                        "Quit tutorial or you cannot move to other frame" )))

      (defun skktut-colored ()
        (while (re-search-forward "\\([^ --]+\\)" nil t nil)
          (put-text-property (match-beginning 1) (match-end 1) 'face
                             'highlight ))
        (goto-char (point-min))
        (while (re-search-forward "^==.+==$" nil t nil)
          (put-text-property (match-beginning 0) (match-end 0)
                             'face skktut-section-face ))
        (goto-char (point-min))
        (while (re-search-forward "^!!.+" nil t nil)
          (put-text-property (match-beginning 0) (match-end 0)
                             'face skktut-do-it-face ))
        (goto-char (point-min))
        (while (re-search-forward "^>> \\(.+\\)$" nil t nil)
          (put-text-property (match-beginning 1) (match-end 1)
                             'face skktut-question-face ))
        (if skktut-japanese-tut
            nil
          (goto-char (point-min))
          (while (re-search-forward "Hint: .*$" nil t nil)
            (put-text-property (match-beginning 0) (match-end 0)
                               'face skktut-hint-face )))))
  ;; For Emacs 18
  (if (boundp 'MULE)
      ;; Mule-1.x ˤ minibuffer-setup-hook ʤ select-window-hook 
      ;; 롣
      (defun skktut-select-window-hook-func (old new)
        ;; OLD, NEW  2 ̵롣
        (if (skk-in-minibuffer-p)
            (skktut-localize-and-init-variables) ))

    ;; Nemacs ˤϡselect-window-hook  minibuffer-setup-hook ʤ
    (defun skktut-set-henkan-point (&optional arg)
      (interactive "*P")
      (if (skk-in-minibuffer-p)
          (skktut-localize-and-init-variables) )
      (skktut-nemacs-set-henkan-point arg) )))

(defun skktut-change-func-def (old new &optional save)
  ;; ؿ OLD  NEW ֤Ѥ롣
  ;; ץʥ SAVE ꤹȡOLD  SAVE ¸롣
  (if save (defalias save (symbol-function old)))
  (defalias old (symbol-function new)) )

;; The following function is tricky, since they are executed by "eval-region".

(defun skktut-today ()
  (save-match-data
    (let (str p)
      (widen)
      (search-forward "\n>> ")
      (if (re-search-forward ".*" (save-excursion (end-of-line) (point)) t)
          (delete-region (match-beginning 0) (match-end 0)) )
      (setq p (point)
            str (concat "֤礦ϡ" (skk-date) "Ǥ") )
      (insert str)
      (narrow-to-region (point-min) (point))
      (if skktut-use-face
          (put-text-property p (point) 'face skktut-question-face) ))))

(defun skktut-end-tutorial ()
  (message "")
  (switch-to-buffer "**")
  (delete-other-windows)
  (erase-buffer)
  (goto-char (point-min))
  (if skktut-japanese-tut
      (insert
       (concat "SKK 塼ȥꥢϤǽǤ\n\n"
               "SKK ˴ؤ䡢ȡbug report \n\n"
               "\tskk@kuis.kyoto-u.ac.jp\n\n"
               "겼ʤΥɥ쥹 SKK ᥤ󥰥ꥹȤ"
               "ɥ쥹Ǥ\n"
               "̾盧Υɥ쥹ФƤʤΤǡСǤʤ"
               "Ϥλݤ\n"
               "ƥ᡼꤯ SKK ᥤ󥰥ꥹȤػô"
               "˾ξ\n\n"
               "\tskk-join@kuis.kyoto-u.ac.jp\n\n"
               "إ᡼꤯\n\n"
               "!! Ǹ <return> 򲡤Ƥ" ))
    (insert
     (concat "Now we end the SKK tutorial.\n\n"
             "Please send comments, questions and bug reports on SKK to:\n\n"
             "\tskk@kuis.kyoto-u.ac.jp\n\n"
             "This is the address of the SKK mailing list, and normally the "
             "responces\n"
             "will be sent only to the ML members.  So, if you are not a ML "
             "member,\n"
             "please say so in your mail.  If you are interested in joining "
             "the SKK ML,\n"
             "send a mail to:\n\n"
             "\tskk-join@kuis.kyoto-u.ac.jp\n\n"
             "!! Hit <return> key when you are ready." )))
  (if skktut-use-face
      (save-match-data
        (goto-char (point-min))
        (re-search-forward "^!!.+" nil t nil)
        (put-text-property (match-beginning 0) (match-end 0)
                           'face skktut-do-it-face )))
  (while (not (= ?\C-m (read-char)))
    (skktut-message "<return> 򲡤Ƥ" "Hit <return> key")
    (ding) )
  (setq skktut-tutorial-end t) )

(provide 'skk-tut)
;;; skk-tut.el ends here
