/*
  Interface to the parser for permission mappings.
  Copyright (C) 2005 The MITRE Corporation

  Author: John D. Ramsdell

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
*/

#if !defined SLAT_H
#define SLAT_H

typedef enum {
  FLOW_NONE, FLOW_READ, FLOW_WRITE, FLOW_BOTH, FLOW_UNDEF
} flow_dir_t;

inline static int
read_like(flow_dir_t flow)
{
  return flow & 1;
}

inline static int
write_like(flow_dir_t flow)
{
  return flow & 2;
}

int action(int common, char *name, char *perm, flow_dir_t flow);

#endif
