#include "petscsys.h"
#include "petscfix.h"
#include "private/fortranimpl.h"
/* ipdot.c */
/* Fortran interface file */

/*
* This file was generated automatically by bfort from the C source
* file.  
 */

#ifdef PETSC_USE_POINTER_CONVERSION
#if defined(__cplusplus)
extern "C" { 
#endif 
extern void *PetscToPointer(void*);
extern int PetscFromPointer(void *);
extern void PetscRmPointer(void*);
#if defined(__cplusplus)
} 
#endif 

#else

#define PetscToPointer(a) (*(long *)(a))
#define PetscFromPointer(a) (long)(a)
#define PetscRmPointer(a)
#endif

#include "slepcip.h"
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define ipnorm_ IPNORM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define ipnorm_ ipnorm
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define ipnormbegin_ IPNORMBEGIN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define ipnormbegin_ ipnormbegin
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define ipnormend_ IPNORMEND
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define ipnormend_ ipnormend
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define ipinnerproduct_ IPINNERPRODUCT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define ipinnerproduct_ ipinnerproduct
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define ipinnerproductbegin_ IPINNERPRODUCTBEGIN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define ipinnerproductbegin_ ipinnerproductbegin
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define ipinnerproductend_ IPINNERPRODUCTEND
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define ipinnerproductend_ ipinnerproductend
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define ipminnerproduct_ IPMINNERPRODUCT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define ipminnerproduct_ ipminnerproduct
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define ipminnerproductbegin_ IPMINNERPRODUCTBEGIN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define ipminnerproductbegin_ ipminnerproductbegin
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define ipminnerproductend_ IPMINNERPRODUCTEND
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define ipminnerproductend_ ipminnerproductend
#endif


/* Definitions of Fortran Wrapper routines */
#if defined(__cplusplus)
extern "C" {
#endif
void PETSC_STDCALL  ipnorm_(IP *ip,Vec x,PetscReal *norm, int *__ierr ){
*__ierr = IPNorm(*ip,
	(Vec)PetscToPointer((x) ),norm);
}
void PETSC_STDCALL  ipnormbegin_(IP *ip,Vec x,PetscReal *norm, int *__ierr ){
*__ierr = IPNormBegin(*ip,
	(Vec)PetscToPointer((x) ),norm);
}
void PETSC_STDCALL  ipnormend_(IP *ip,Vec x,PetscReal *norm, int *__ierr ){
*__ierr = IPNormEnd(*ip,
	(Vec)PetscToPointer((x) ),norm);
}
void PETSC_STDCALL  ipinnerproduct_(IP *ip,Vec x,Vec y,PetscScalar *p, int *__ierr ){
*__ierr = IPInnerProduct(*ip,
	(Vec)PetscToPointer((x) ),
	(Vec)PetscToPointer((y) ),p);
}
void PETSC_STDCALL  ipinnerproductbegin_(IP *ip,Vec x,Vec y,PetscScalar *p, int *__ierr ){
*__ierr = IPInnerProductBegin(*ip,
	(Vec)PetscToPointer((x) ),
	(Vec)PetscToPointer((y) ),p);
}
void PETSC_STDCALL  ipinnerproductend_(IP *ip,Vec x,Vec y,PetscScalar *p, int *__ierr ){
*__ierr = IPInnerProductEnd(*ip,
	(Vec)PetscToPointer((x) ),
	(Vec)PetscToPointer((y) ),p);
}
void PETSC_STDCALL  ipminnerproduct_(IP *ip,Vec x,PetscInt *n, Vec y[],PetscScalar *p, int *__ierr ){
*__ierr = IPMInnerProduct(*ip,
	(Vec)PetscToPointer((x) ),*n,y,p);
}
void PETSC_STDCALL  ipminnerproductbegin_(IP *ip,Vec x,PetscInt *n, Vec y[],PetscScalar *p, int *__ierr ){
*__ierr = IPMInnerProductBegin(*ip,
	(Vec)PetscToPointer((x) ),*n,y,p);
}
void PETSC_STDCALL  ipminnerproductend_(IP *ip,Vec x,PetscInt *n, Vec y[],PetscScalar *p, int *__ierr ){
*__ierr = IPMInnerProductEnd(*ip,
	(Vec)PetscToPointer((x) ),*n,y,p);
}
#if defined(__cplusplus)
}
#endif
