/*
 * imgstat
 * The Sleuth Kit 
 *
 * $Date: 2006/09/01 15:23:03 $
 *
 * Brian Carrier [carrier@sleuthkit.org]
 * Copyright (c) 2005 Brian Carrier.  All rights reserved 
 *
 *
 * This software is distributed under the Common Public License 1.0
 *
 */
#include "img_tools.h"

static TCHAR *progname;

static void
usage()
{
    TFPRINTF(stderr, _T("usage: %s [-tvV] [-i imgtype] image\n"),
	progname);
    tsk_fprintf(stderr, "\t-t: display type only\n");
    tsk_fprintf(stderr,
	"\t-i imgtype: The format of the image file (use '-i list' for list of supported types)\n");
    tsk_fprintf(stderr, "\t-v: verbose output to stderr\n");
    tsk_fprintf(stderr, "\t-V: Print version\n");

    exit(1);
}


int
MAIN(int argc, TCHAR ** argv)
{
    IMG_INFO *img;
    TCHAR *imgtype = NULL;
    int ch;
    uint8_t type = 0;

    progname = argv[0];

    while ((ch = getopt(argc, argv, _T("i:tvV"))) > 0) {
	switch (ch) {
	case _T('?'):
	default:
	    TFPRINTF(stderr, _T("Invalid argument: %s\n"), argv[optind]);
	    usage();

	case _T('i'):
	    imgtype = optarg;
	    if (TSTRCMP(imgtype, _T("list")) == 0) {
		img_print_types(stderr);
		exit(1);
	    }
	    break;

	case _T('t'):
	    type = 1;
	    break;

	case _T('v'):
	    verbose++;
	    break;

	case _T('V'):
	    print_version(stdout);
	    exit(0);
	}
    }

    /* We need at least one more argument */
    if (optind >= argc) {
	tsk_fprintf(stderr, "Missing image name\n");
	usage();
    }

    if ((img =
	    img_open(imgtype, argc - optind,
		(const TCHAR **) &argv[optind])) == NULL) {
	tsk_error_print(stderr);
	exit(1);
    }

    if (type) {
	char *str = img_get_type(img->itype);
	tsk_printf("%s\n", str);
    }
    else {
	img->imgstat(img, stdout);
    }

    img->close(img);
    exit(0);
}
