/*
 This file is part of slPIM.
 
 Copyright (c) 2001 John J. Ruthe <phaust@users.sourceforge.net>

 This program is free software; you can redistribute it and/or modify it
 under the terms of the GNU General Public License as published by the Free
 Software Foundation; either version 2 of the License, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 more details.

 You should have received a copy of the GNU General Public License along
 with this program; if not, write to the Free Software Foundation, Inc., 675
 Mass Ave, Cambridge, MA 02139, USA. 
*/

#include <stdlib.h>
#include <curses.h>
#include <string.h>
#include <stdio.h>
#include <time.h>
#include "defs.h"
#include "conf.h"

char *slpim_SCREEN_message, *slpim_string_top, *slpim_string_bot;
int slpim_SCREEN_mtype;

int NORM_COLOR, CURSORBAR_COLOR, STATUS_COLOR, MESSAGE_I_COLOR,
	MESSAGE_W_COLOR, MESSAGE_E_COLOR, AB_HEAD_COLOR, INPUT_COLOR;

#if 0
void slpim_do_config_colors(void) {
	/* normal color */
	NORM_COLOR = COLOR_PAIR(0);

	/* cursorbar color */
	init_pair(1, COLOR_WHITE, COLOR_GREEN);
	CURSORBAR_COLOR = COLOR_PAIR(1) | A_BOLD;

	/* statusbar color */
	init_pair(2, COLOR_YELLOW, COLOR_BLUE);
	STATUS_COLOR = COLOR_PAIR(2) | A_BOLD;

	/* info message color */
	init_pair(3, COLOR_YELLOW, COLOR_BLACK);
	MESSAGE_I_COLOR = COLOR_PAIR(3) | A_BOLD;

	/* warning message color */
	init_pair(4, COLOR_RED, COLOR_BLACK);
	MESSAGE_W_COLOR = COLOR_PAIR(4);

	/* error message color */
	init_pair(5, COLOR_BLACK, COLOR_RED);
	MESSAGE_E_COLOR = COLOR_PAIR(5);

	/* window's first line color */
	init_pair(6, COLOR_WHITE, COLOR_BLACK);
	AB_HEAD_COLOR = COLOR_PAIR(6) | A_BOLD;

	/* input line color */
	init_pair(7, COLOR_WHITE, COLOR_BLACK);
	INPUT_COLOR = COLOR_PAIR(7) | A_BOLD;
}
#endif

/* TODO: improve this func - now it's a bit primitive */
char *slpim_input_read(char *prompt, char *deflt) {
	char *s, *p, *d;
	int i;

	d = deflt;
	if(d != NULL)
		if(*d == 0)
			d = NULL;
	i = strlen(prompt) + 3;
	if(d != NULL)
		i += strlen(deflt) + 3;
	p = malloc(i);
	if(d != NULL) {
		snprintf(p, i, "%s [%s]: ", prompt, deflt);
	} else
		snprintf(p, i, "%s: ", prompt);

	attrset(INPUT_COLOR);
	mvaddstr(LINES -1, 0, p);
	clrtoeol();
	move(LINES - 1, strlen(p));
	free(p);

	/* FIXME */
	s = malloc(256);
	echo();
	getnstr(s, 255);
	noecho();

	if((*s == 0) && (d != NULL))
		strcpy(s, deflt);

	return(s);
}

int slpim_input_yesno(char *prompt, int deflt) {
	char *p;
	int i;

	i = strlen(prompt) + 9;
	p = malloc(i);
	if(deflt) {
		snprintf(p, i, "%s [Y/n]: ", prompt);
	} else
		snprintf(p, i, "%s [y/N]: ", prompt);

	attrset(INPUT_COLOR);
	mvaddstr(LINES -1, 0, p);
	clrtoeol();
	move(LINES - 1, strlen(p));
	free(p);

	echo();
	i = getch();
	noecho();
	
	switch(i) {
		case 'y':
		case 'Y':
			i = 1;
			break;
		case 'n':
		case 'N':
			i = 0;
			break;
		default:
			i = deflt;
	}

	return(i);
}
	

void slpim_update_top_line(void) {
	struct tm *lt;
	time_t t;
	char *s;
		
	t = time(NULL);
	lt = localtime(&t);
	s = (char *) malloc((strlen(slpim_string_top) + 12) * sizeof(char));
	sprintf(s, "[%2d:%02d] ** %s", lt->tm_hour, lt->tm_min, slpim_string_top);
	attrset(STATUS_COLOR);
	mvaddstr(0, 0, s);
	free(s);
	clrtoeol();
	move(0, 0);
	chgat(COLS, STATUS_COLOR, PAIR_NUMBER(STATUS_COLOR), NULL);
	attrset(NORM_COLOR);
}

void slpim_update_bot_line(void) {
	char *s;
		
	s = (char *) malloc((strlen(slpim_string_bot) + strlen(VERSION) + 14) * sizeof(char));
	sprintf(s, "---slPIM %s ** %s", VERSION, slpim_string_bot);
	attrset(STATUS_COLOR);
	mvaddstr(LINES - 2, 0, s);
	free(s);
	clrtoeol();
	move(LINES - 2, 0);
	chgat(COLS, STATUS_COLOR, PAIR_NUMBER(STATUS_COLOR), NULL);
	attrset(NORM_COLOR);
}

void slpim_write_message(char *mess, int mtype) {
	
	if(slpim_SCREEN_message)
		free(slpim_SCREEN_message);

	if(mess != NULL) {
		slpim_SCREEN_message = (char *) malloc((strlen(mess) + 1) * sizeof(char));
		strcpy(slpim_SCREEN_message, mess);
	} else
		slpim_SCREEN_message = NULL;
	
	slpim_SCREEN_mtype = mtype;
}

void slpim_draw_message(void) {
	int i;
	
	switch(slpim_SCREEN_mtype) {
		case ERROR_MESSAGE:
			i = MESSAGE_E_COLOR;
			break;
		case WARN_MESSAGE:
			i = MESSAGE_W_COLOR;
			break;
		default:
			i = MESSAGE_I_COLOR;
	}

	attrset(i);
	mvaddstr(LINES - 1, 0, slpim_SCREEN_message);
        clrtoeol();
        move(LINES - 1, 0);
        chgat(COLS, i, PAIR_NUMBER(i), NULL);
	attrset(NORM_COLOR);
}

void slpim_screen_refresh(void) {
        slpim_update_top_line();
	slpim_update_bot_line();
        slpim_draw_message();
	refresh();
	slpim_write_message(NULL, INFO_MESSAGE);
}

void slpim_screen_init(void) {
	initscr();
	start_color();
	cbreak();
	noecho();
	nonl();
	intrflush(stdscr, 0);
	keypad(stdscr, 1);
	slpim_do_config_colors();
}

void slpim_screen_finish(void) {
	endwin();
}

int slpim_getkey(void) {
	return(getch());
}

