%  slrnface - feeble attempt at delivering X-Faces to slrn users
%  Copyright (C) 2000  Drazen Kacar
%
%  This program is free software; you can redistribute it and/or modify
%  it under the terms of the GNU General Public License as published by
%  the Free Software Foundation; either version 2 of the License, or
%  (at your option) any later version.
%
%  This program is distributed in the hope that it will be useful,
%  but WITHOUT ANY WARRANTY; without even the implied warranty of
%  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%  GNU General Public License for more details.
%
%  You should have received a copy of the GNU General Public License
%  along with this program; if not, write to the Free Software
%  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.


variable xfacefp;

define startup_hook ()
{
   variable success, home, reason, envvar;

   xfacefp = NULL;

   home = getenv ("HOME");
   if (home == NULL)
   {
      message_now ("Cannot run slrnface: $HOME undefined.");
      return;
   }

   % If DISPLAY is not set slrnface can't run, but the user probably
   % knows that, so fail silently.
   envvar = getenv ("DISPLAY");
   if (envvar == NULL)
      return;

   % On the other hand, yell if WINDOWID is not set.
   envvar = getenv ("WINDOWID");
   if (envvar == NULL)
   {
      message_now ("Cannot run slrnface: $WINDOWID undefined.");
      return;
   }

   home = home + "/.slrnfaces";
   if (mkdir (home, 0700) != 0)
   {
      if (errno != EEXIST)
      {
	 reason = "cannot create " + home + ": " + errno_string(errno);
         message_now ("Cannot run slrnface: " + reason);
	 return;
      }
   }
   else
   {
      variable fp, message;

      fp = fopen (home + "/README", "w");
      if (fp != NULL)
      {
         message =
"This directory is used to create named pipes for communication between\n" +
"slrnface and its parent process. It should normally be empty because\n" +
"the pipe is deleted right after it has been opened by both processes.\n\n" +
"File names generated by slrnface have the form \"hostname.pid\". It is\n" +
"probably an error if they linger here longer than a fraction of a second.\n" +
"\nHowever, if the directory is mounted from an NFS server, you might see\n" +
"special files created by your NFS server while slrnface is running.\n" +
"Do not try to remove them.\n";
	 fputs (message, fp);
	 fclose (fp);
      }
   }

   % This is our FIFO.
   home = home + "/" + uname().nodename + "." + string(getpid());

   % If it already exists, we'll delete it first. Because it really
   % shouldn't exist.
   remove (home);

   if (mkfifo (home, 0600) != 0)
   {
      reason = "cannot create FIFO: " + errno_string(errno);
      message_now ("Cannot run slrnface: " + reason);
      return;
   }

   success = system ("slrnface " + home) shr 8;

   switch (success)
   { case 0: xfacefp = fopen (home, "w");
      	     if (xfacefp != NULL)
	     {
		fputs ("start\n", xfacefp);
		fflush (xfacefp);
		remove (home);
		return;
	     }
	     else
		reason = "cannot open " + home + ": " + errno_string(errno);
   }
   % case 1 means DISPLAY is set, but slrnface couldn't connect. Probably
   % because X server refused. We need to inform the user about this.
   { case 1: reason = "couldn't connect to display."; }
   { case 2: reason = "WINDOWID not found in environment."; }
   { case 3: reason = "couldn't find controlling terminal."; }
   { case 4: reason = "terminal doesn't export width and height."; }
   { case 5: reason = "cannot open " + home + " as FIFO."; }
   { case 6: reason = "fork() failed."; }
   { reason = "error " + string (success) + " (unknown reason)."; }

   % Delete the FIFO.
   remove (home);

   message_now ("Slrnface failed: " + reason);
}

define clear_xface ()
{
   if (xfacefp != NULL)
   {
      fputs ("clear\n", xfacefp);
      fflush (xfacefp);
   }
}

define read_article_hook ()
{
   variable xface;

   if (xfacefp != NULL)
   {
      xface = extract_article_header ("X-Face");
      if (xface != "")
      {
	 fputs ("xface " + xface + "\n", xfacefp);
	 fflush (xfacefp);
      }
      else
	 clear_xface ();
   }
}


define group_mode_hook ()
{
   clear_xface ();
}

define reply_hook ()
{
   clear_xface ();
}

define followup_hook ()
{
   clear_xface ();
}

define post_hook ()
{
   clear_xface ();
}

define forward_hook ()
{
   clear_xface ();
}

define xface_hide_article ()
{
   call ("hide_article");
   if (xfacefp != NULL)
   {
      if (is_article_visible ())
      {
	 variable xface;

	 xface = extract_article_header ("X-Face");
	 fputs ("xface " + xface + "\n", xfacefp);
	 fflush (xfacefp);
      }
      else
      {
	 fputs ("clear\n", xfacefp);
	 fflush (xfacefp);
      }
   }
}

definekey ("xface_hide_article", "h", "article");
