/***************************************************************************
    smb4kglobal  -  This is the global namespace for Smb4K.
                             -------------------
    begin                : Sa Apr 2 2005
    copyright            : (C) 2005-2008 by Alexander Reinholdt
    email                : dustpuppy@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,   *
 *   MA  02111-1307 USA                                                    *
 ***************************************************************************/

#ifndef SMB4KGLOBAL_H
#define SMB4KGLOBAL_H

// Qt includes
#include <QString>

// KDE includes
#include <kdemacros.h>

// forward declarations
class Smb4KWorkgroup;
class Smb4KHost;
class Smb4KShare;

/**
 * This is the global namespace for the core classes of Smb4K.
 *
 * @author    Alexander Reinholdt <dustpuppy@users.berlios.de>
 */

namespace Smb4KGlobal
{
  /**
   * This function returns the interval of the timer.
   *
   * @returns           The interval of the timer in msec.
   */
  KDE_EXPORT int timerInterval();

  /**
   * This function creates a temporary directory and returns its name. If it already
   * exists, only the name will be returned. If an failure occurrs, an error message
   * will be shown and an empty string is returned.
   *
   * @returns           the name of the temporary directory.
   */
  KDE_EXPORT const QString &tempDir();

  /**
   * This function returns the global list of workgroups that were discovered by
   * Smb4K. Use this if you want to access and modify the list with your code.
   *
   * @returns the global list of known workgroups.
   */
  KDE_EXPORT QList<Smb4KWorkgroup *> *workgroupsList();

  /**
   * This function returns the global list of hosts that were discovered by
   * Smb4K. Use this if you want to access and modify the list with your code.
   *
   * @returns the global list of known hosts.
   */
  KDE_EXPORT QList<Smb4KHost *> *hostsList();

  /**
   * This function returns the global list of mounted shares that were discovered by
   * Smb4K. Use this if you want to access and modify the list with your code.
   *
   * @returns the global list of known mounted shares.
   */
  KDE_EXPORT QList<Smb4KShare *> *mountedSharesList();

  /**
   * This function returns the workgroup or domain that matches the name @p name or
   * NULL if there is no such workgroup.
   *
   * @returns a pointer to the workgroup with name @p name.
   */
  KDE_EXPORT Smb4KWorkgroup *findWorkgroup( const QString &name );

  /**
   * This function returns the host matching the name @p name or NULL if there is no
   * such host. The name of the host is mandatory. The workgroup may be empty, but
   * should be given, because this will speed up the search process.
   *
   * @param name          The name of the host
   *
   * @param workgroup     The workgroup where the host is located
   *
   * @returns an Smb4KHost item of NULL if none was found that matches @p name.
   */
  KDE_EXPORT Smb4KHost *findHost( const QString &name,
                                  const QString &workgroup = QString() );

  /**
   * Find a mounted share by its path (i.e. mount point).
   *
   * @returns the share that is mounted to @p path.
   */
  KDE_EXPORT Smb4KShare *findShareByPath( const QByteArray &path );

  /**
   * Find all mounts of a particular share with UNC @p unc on the system.
   * The UNC has to be defined as //[USER@]HOST/SHARE.
   *
   * @param unc         The UNC of the share
   *
   * @returns the complete list of mounts with the UNC @p unc.
   */
  KDE_EXPORT QList<Smb4KShare *> findShareByUNC( const QString &unc );

  /**
   * This function returns the list of inaccessible shares.
   *
   * @returns the list of inaccessible shares.
   */
  KDE_EXPORT QList<Smb4KShare *> findInaccessibleShares();
};

#endif
