/***************************************************************************
    smb4kdataitem  -  A data container for use in the core classes.
                             -------------------
    begin                : Sa Jul 30 2005
    copyright            : (C) 2005 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,   *
 *   MA  02111-1307 USA                                                    *
 ***************************************************************************/

#ifndef SMB4KDATAITEM_H
#define SMB4KDATAITEM_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// Qt includes
#include <qstring.h>

/**
 * This class is a container for the private data that is needed by the core
 * classes.
 *
 * @author Alexander Reinholdt <dustpuppy@users.berlios.de>
 */

class Smb4KDataItem
{
  public:
    /**
     * The constructor.
     *
     * @param workgroup       The workgroup
     *
     * @param host            The host
     *
     * @param share           The share
     *
     * @param ip              The IP address of the server
     *
     * @param path            The path (scanner: preview, mounter: mount point)
     */
    Smb4KDataItem( const QString &workgroup, const QString &host, const QString &share = QString::null, const QString &ip = QString::null, const QString &path = QString::null );

    /**
     * This is an empty constructor. If you use this one, you'll have to
     * set each item you want to use by yourself.
     */
    Smb4KDataItem();

    /**
     * The destructor.
     */
    ~Smb4KDataItem();

    /**
     * This function returns the workgroup.
     *
     * @returns the workgroup
     */
    QString workgroup() const { return m_workgroup; }

    /**
     * This function returns the host.
     *
     * @returns the host name
     */
    QString host() const { return m_host; }

    /**
     * This function returns the share.
     *
     * @returns the name of the share
     */
    QString share() const { return m_share; }

    /**
     * This function returns the IP adress.
     *
     * @returns the IP address
     */
    QString ip() const { return m_ip; }

    /**
     * This function returns the path. It is either used by the scanner
     * for preview purposes or by the mounter as mount point.
     *
     * @returns the path/mountpoint
     */
    QString path() const { return m_path; }

    /**
     * This function returns the filesystem of a share.
     *
     * @returns the filesystem
     */
    QString filesystem() const { return m_filesystem; }

    /**
     * This function returns the CIFS login for a share.
     *
     * @returns the CIFS login
     */
    QString cifsLogin() const { return m_cifs_login; }

    /**
     * This function sets the workgroup.
     *
     * @param workgroup             The workgroup name
     */
    void setWorkgroup( const QString &workgroup );

    /**
     * This function sets the host name.
     *
     * @param host                  The host name
     */
    void setHost( const QString &host );

    /**
     * This function sets the share name.
     *
     * @param share                 The share name
     */
    void setShare( const QString &share );

    /**
     * This functions sets the IP address.
     *
     * @param ip                    The IP address
     */
    void setIP( const QString &ip );

    /**
     * This function sets the path or mount point.
     *
     * @param path                  The path/mount point
     */
    void setPath( const QString &path );

    /**
     * This function sets the type of the share's filesystem.
     *
     * @param filesystem            The filesystem type
     */
    void setFilesystem( const QString &filesystem );

    /**
     * This function sets the CIFS login name.
     *
     * @param login                 The CIFS login
     */
    void setCIFSLogin( const QString &login );

  private:
    /**
     * The workgroup object.
     */
    QString m_workgroup;

    /**
     * The host object.
     */
    QString m_host;

    /**
     * The share object.
     */
    QString m_share;

    /**
     * The IP address object.
     */
    QString m_ip;

    /**
     * The path object.
     */
    QString m_path;

    /**
     * The filesystem object.
     */
    QString m_filesystem;

    /**
     * The (CIFS) login name.
     */
    QString m_cifs_login;
};


#endif
