/*==================================================================
 * seq_oss.h - Header file for OSS sequencer routines
 *
 * Smurf Sound Font Editor
 * Copyright (C) 1999-2001 Josh Green
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA or point your web browser to http://www.gnu.org.
 *
 * To contact the author of this program:
 * Email: Josh Green <jgreen@users.sourceforge.net>
 * Smurf homepage: http://smurf.sourceforge.net
 *==================================================================*/
#ifndef __SEQ_OSS_H__
#define __SEQ_OSS_H__

#include "config.h"

#ifdef OSS_SUPPORT

#include <glib.h>

gint seq_oss_fd;
gint seq_oss_dev;
gboolean seq_oss_fdactive;

/* sequencer routines */
gint seq_oss_init (void);
gint seq_oss_init_synth (int subtype, char *name);
void seq_oss_fd_close (void);
void seq_oss_set_bank (gint chan, gint bank);
void seq_oss_set_preset (gint chan, gint preset);
void seq_oss_note_on (gint chan, gint note, gint vel);
void seq_oss_note_off (gint chan, gint note, gint vel);
void seq_oss_pitch_bender (gint chan, gint val);
void seq_oss_pitch_bend_range (gint chan, gint val);
void seq_oss_main_volume (gint chan, gint val);
void seq_oss_chorus (gint chan, gint val);
void seq_oss_reverb (gint chan, gint val);

#endif /* #ifdef OSS_SUPPORT */

#endif /* __SEQ_OSS_H__ */
