/*==================================================================
 * pcm.c - Driver independent PCM audio interface routines
 *
 * Smurf Sound Font Editor
 * Copyright (C) 1999-2001 Josh Green
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA or point your web browser to http://www.gnu.org.
 *
 * To contact the author of this program:
 * Email: Josh Green <jgreen@users.sourceforge.net>
 * Smurf homepage: http://smurf.sourceforge.net
 *==================================================================*/
#include "config.h"

#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include <string.h>
#include <glib.h>
#include "pcm.h"
#include "i18n.h"
#include "smurfcfg.h"
#include "util.h"

#include "drivers/pcm_alsa.h"

PCMDriverInfo pcm_drivers[] = {
  {N_("NONE"), NULL, NULL, NULL},

/* currently disabled */
#if 0
#ifdef ALSA_SUPPORT
  {N_("ALSA"),			/* ALSA audio driver */
   pcm_alsa_load_config,
   pcm_alsa_play,
   pcm_alsa_stop
  },
#endif
#ifdef OSS_SUPPORT
  {N_("OSS"),
     NULL,
     NULL,
     NULL,
  }
#endif
#endif
};

gint pcm_driver = PCM_NONE;
gboolean pcm_active = TRUE;
gboolean pcm_playing = FALSE;
gboolean pcm_recording = FALSE;

gint
pcm_auto_select (void)
{
  return (OK);
}

gint
pcm_locate_byname (gchar * name)
{
  gint i;

  for (i = 0; i < PCM_COUNT; i++)
    {
      if (strcmp (name, pcm_drivers[i].name) == 0)
	return (i);
    }
  return (-1);
}

void
pcm_set_driver (gint driver)
{
  if (driver >= PCM_COUNT)
    return;

  pcm_driver = driver;
}

gint
pcm_play (gint width, gboolean signd, gint chans, gint rate,
	  PCMPlayBackFunc *play_func)
{
  gint rv;

  if (!pcm_active) return (OK);
  if (!pcm_drivers[pcm_driver].play) return (OK);

  if ((rv = (*pcm_drivers[pcm_driver].play)(width, signd, chans, rate,
					   play_func)))
    pcm_playing = TRUE;

  return (rv);
}

void
pcm_stop (void)
{
  if (!pcm_active) return;
  if (!pcm_drivers[pcm_driver].play) return;

  (*pcm_drivers[pcm_driver].stop)();

  pcm_playing = FALSE;
}
