/*==================================================================
 * uif_pianospan.h - Header file for user interface piano and span
 * 		     functions
 *
 * Smurf Sound Font Editor
 * Copyright (C) 1999-2001 Josh Green
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA or point your web browser to http://www.gnu.org.
 *
 * To contact the author of this program:
 * Email: Josh Green <jgreen@users.sourceforge.net>
 * Smurf homepage: http://smurf.sourceforge.net
 *==================================================================*/
#ifndef __UIF_PIANOSPAN__
#define __UIF_PIANOSPAN__

#include <gtk/gtk.h>
#include "sfont.h"
#include "widgets/piano.h"
#include "widgets/keyspan.h"

enum
{ PIANOSPAN_PIANO, PIANOSPAN_VELOCITY };

/* Global vars */
GtkWidget *pianospan_piano;

/* Prototypes */
void pianospan_set_mode (gint mode);
void pianospan_update (void);
void pianospan_clear (void);
void pianospan_select_span (gint spannum);
void pianospan_clear_selection (void);
void pianospan_clear_rootkey_ptrstrip (void);
void pianospan_update_rootkey_ptrstrip (void);
GtkWidget *pianospan_create (void);
gboolean piano_cb_key_event (GtkWidget * widg, GdkEventKey * event, gint press);


#endif /* __UIF_PIANOSPAN__ */
