/*==================================================================
 * util.h - Header file for utility functions
 *
 * Smurf Sound Font Editor
 * Copyright (C) 1999-2001 Josh Green
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA or point your web browser to http://www.gnu.org.
 *
 * To contact the author of this program:
 * Email: Josh Green <jgreen@users.sourceforge.net>
 * Smurf homepage: http://smurf.sourceforge.net
 *==================================================================*/
#ifndef __UTIL_H__
#define __UTIL_H__

#include <stdio.h>
#include <gtk/gtk.h>

#define FAIL	0
#define OK	1

typedef void (*UtilQuickFunc) (gpointer userdata, GtkWidget *popup);

#define GBUF_MAXSIZE		1024	/* error buffer size */

/* log levels */
enum { LogInfo, LogWarn, LogBad, LogFubar, LogLast };

#define LogLevelMask 0x7

/* flag that goes with a log level, which will display system errno info */
#define LogErrno  (1 << 3)

/* GTK convenience macros */

/* stores the active GTK option menu entry index into ndx */
#define UTIL_OPMENU_INDEX(ndx, op) G_STMT_START {		\
    GtkWidget *_menu, *_actv;					\
    _menu = gtk_option_menu_get_menu(GTK_OPTION_MENU(op));	\
    _actv = gtk_menu_get_active(GTK_MENU(_menu));		\
    ndx = g_list_index(GTK_MENU_SHELL(_menu)->children, _actv);	\
} G_STMT_END

gboolean log_viewactive;
gint log_poplevel;

GtkWidget *util_quick_popup (gchar * msg, gchar * btn1, ...);
GtkWidget *util_lookup_unique_dialog (gchar *strkey, gint key2);
gboolean util_register_unique_dialog (GtkWidget *dialog, gchar *strkey,
				      gint key2);
void util_unregister_unique_dialog (GtkWidget *dialog);
gboolean util_activate_unique_dialog (gchar *strkey, gint key2);

gpointer util_waitfor_widget_action (GtkWidget *widg);
void util_widget_action (GtkWidget *cbwidg, gpointer value);

GtkWidget *util_create_pixmap (gchar ** xpmdata);

void log_view (gchar * title);
gint logit (gint ev, gchar * fmt, ...);
void log_vargs (const gchar * message, va_list args);
void log_message (const gchar * message, ...);
void log_group_enter (gint popup_lvl);
void log_group_leave (void);
gint log_length (void);
void log_clear (void);

gint safe_fread (void *buf, gint count, FILE * fd);
gint safe_fwrite (void *buf, gint count, FILE * fd);
gint safe_fseek (FILE * fd, long ofs, gint whence);
void *safe_malloc (size_t size);

gchar *str_crlf2lf (gchar * str);
gchar *str_lf2crlf (gchar * str);
gint substrcmp (gchar * sub, gchar * str);

#endif
