/* Somaplayer - Copyright (C) 2003-5 bakunin - Andrea Marchesini 
 *                                     <bakunin@autistici.org>
 *
 * This source code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published 
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * This source code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * Please refer to the GNU Public License for more details.
 *
 * You should have received a copy of the GNU Public License along with
 * this source code; if not, write to:
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This program is released under the GPL with the additional exemption that
 * compiling, linking, and/or using OpenSSL is allowed.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#else
# error Use configure; make; make install
#endif

#include "player.h"
#include "other.h"
#include "tty.h"
#include "bad_list.h"

#ifdef ENABLE_GTK
#include "gtk/graphic.h"
#endif

/* Msg: like printf (only text!) */
void
msg (char *str, ...)
{
  va_list va;
  static char buf[SIZE_BUFFER];
  char b[SIZE_BUFFER];
  static int time = 0;

  va_start (va, str);
  vsnprintf (b, SIZE_BUFFER, str, va);

  if (!strcmp (buf, b))
    {
      if (!time)
	fprintf (stderr, "* Message repeat: %s\n", b);
      else
	fprintf (stderr, ".");
      time++;
    }
  else
    {
      fprintf (stderr, "* %s\n", b);
      strncpy (buf, b, SIZE_BUFFER);
      time = 0;
    }

  va_end (va);
}

/* Msg_Error: like msg but in graphic mode */
void
msg_error (char *str, ...)
{
  va_list va;
  static char buf[SIZE_BUFFER];
  char b[SIZE_BUFFER];
  static int time = 0;

  va_start (va, str);
  vsnprintf (b, SIZE_BUFFER, str, va);

  if (!strcmp (buf, b))
    {
      if (!time)
	{

#ifdef ENABLE_GTK
	  if (!play->graphic || !play->go_graphic)
	    {
#endif

	      fprintf (stderr, "* Message repeat: %s\n", b);
#ifdef ENABLE_GTK
	    }
	  else
	    {
	      /* This is an hack. 
	       * With GTK you can not open a window in another process
	       * by gtk_main. So I make a buffer. When it is full, i
	       * open the window, in the principal process */
	      snprintf (graphic_dialog_text, SIZE_BUFFER,
			"Message repeat: %s", b);
	    }
#endif
	}
      else
	fprintf (stderr, ".");

      time++;
    }
  else
    {

#ifdef ENABLE_GTK
      if (!play->graphic || !play->go_graphic)
	{
#endif

	  fprintf (stderr, "* %s\n", b);

#ifdef ENABLE_GTK
	}
      else
	{
	  /* This is an hack. 
	   * With GTK you can not open a window in another process
	   * by gtk_main. So I make a buffer. When it is full, i
	   * open the window, in the principal process */
	  strncpy (graphic_dialog_text, b, SIZE_BUFFER);
	}
#endif

      strncpy (buf, b, SIZE_BUFFER);
      time = 0;
    }

  va_end (va);
}

/* Print and exit */
void
fatal (char *str, ...)
{
  va_list va;
  va_start (va, str);

#ifdef ENABLE_GTK
  if (!play->graphic || !play->go_graphic)
    {
#endif

      fprintf (stderr, "\n* ");
      vfprintf (stderr, str, va);
      fprintf (stderr, "\n");

      va_end (va);

      quit (1);
#ifdef ENABLE_GTK
    }
  else
    {
      char a[SIZE_BUFFER];
      GtkWidget *dialog;
      int ret;

      vsnprintf (a, SIZE_BUFFER, str, va);
      va_end (va);

      dialog =
	gtk_message_dialog_new (GTK_WINDOW (winmain),
				GTK_DIALOG_MODAL |
				GTK_DIALOG_DESTROY_WITH_PARENT,
				GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, a);

      ret = gtk_dialog_run (GTK_DIALOG (dialog));
      gtk_widget_destroy (dialog);
      gtk_main_quit ();
      quit (1);
    }
#endif
}

/* Usage */
int
usage (void)
{
  fprintf (stderr, "%s %s - %s\n", NAME, VERSION, AUTHOR_COPYRIGHT);
  fprintf (stderr,
	   "\n\t%s [-ao <opt> [-dv <opt>]] file.mp3 file.ogg file.wav cdrom://2-6 mic://* directory/ http://...\n\n",
	   NAME);
  fprintf (stderr, _("-ao or --audiooutput   output audio:\n"));
#ifdef ENABLE_AO
  fprintf (stderr, _("\nCard / Daemon / Device / Dsp\n"));
  fprintf (stderr,
	   _
	   ("         audio           Try to search your audio interface\n"));
  fprintf (stderr, _("         oss             Open Sound System\n"));
  fprintf (stderr,
	   _("         alsa            Advanced Linux Sound Architecture\n"));
  fprintf (stderr,
	   _
	   ("         alsa09          Advanced Linux Sound Architecture v 0.9.x\n"));
  fprintf (stderr, _("         esd             Enlightened Sound Daemon\n"));
  fprintf (stderr, _("         arts            Arts Sound Server\n"));
  fprintf (stderr, _("         sun             Sun Audio\n"));
  fprintf (stderr, _("         irix            IRIX Audio\n"));
  fprintf (stderr, _("         null            Null Device\n"));
  fprintf (stderr, _("         output          Write on Standard Output\n"));
#endif

#ifdef ENABLE_SNDFILE
  fprintf (stderr, _("\nFile Types 1-1\n"));
  fprintf (stderr,
	   _
	   ("         wav             Microsoft WAV format (little endian)\n"));
  fprintf (stderr,
	   _
	   ("         aiff            Apple/SGI AIFF format (big endian)\n"));
  fprintf (stderr,
	   _
	   ("         au              Sun/NeXT AU file format (big endian)\n"));
  fprintf (stderr, _("         raw             Raw PCM data\n"));
  fprintf (stderr, _("         paf             Ensoniq PARIS file format\n"));
  fprintf (stderr,
	   _("         svx             Amiga IFF / SVX8 / SV16 format\n"));
  fprintf (stderr, _("         nist            Sphere NIST format\n"));
  fprintf (stderr, _("         voc             Voc files\n"));
  fprintf (stderr, _("         ircam           Berkeley/IRCAM/CARL\n"));
  fprintf (stderr,
	   _("         w64             Sonic Foundry's 64 bit RIFF/WAV\n"));
  fprintf (stderr,
	   _("         mat4            Matlab (tm) V4.2 / GNU Octave 2.0\n"));
  fprintf (stderr,
	   _("         mat5            Matlab (tm) V5.0 / GNU Octave 2.1\n"));
  fprintf (stderr, _("         pvf             Portable Voice Format\n"));
  fprintf (stderr,
	   _("         xi              Fasttracker 2 Extended Instrument\n"));
  fprintf (stderr, _("         htk             HMM Tool Kit format\n"));
#ifdef USE_MIDI
  fprintf (stderr, _("         midi            Midi Sample Dump Standard\n"));
#endif

#ifdef USE_AVR
  fprintf (stderr, _("         avr             Audio Visual Research\n"));
#endif

#ifdef USE_WAVEX
  fprintf (stderr, _("         wavex           MS WAVE with WAVEFORMATEX\n"));
#endif

#endif

#ifdef ENABLE_STREAMING
  fprintf (stderr, _("\nStreaming Server\n"));
#ifdef ENABLE_ICECAST
  fprintf (stderr, _("         icecast         Icecast Streaming Server\n"));
#endif

#ifdef ENABLE_ICECAST2
  fprintf (stderr, _("         icecast2        Icecast2 Streaming Server\n"));
#endif

#ifdef ENABLE_SHOUTCAST
  fprintf (stderr,
	   _("         shoutcast       Shoutcast Streaming Server\n"));
#endif
#endif

  fprintf (stderr, _("\nOther\n"));
#ifdef ENABLE_LAME
  fprintf (stderr, _("         lame            Encode Mp3 File\n"));
#endif

#ifdef ENABLE_OGG
  fprintf (stderr, _("         vorbis          Encode Ogg File\n"));
#endif

#ifdef ENABLE_DAEMON
  fprintf (stderr,
	   _("         sds             Soma Didstribuited Sound Server\n"));
#endif

  fprintf (stderr, "\n");

  fprintf (stderr,
	   _
	   ("-ad  or --audiodevice    [options] options for output audio. Read man page.\n"));
  fprintf (stderr, _("-no  or --nooutput       no audio output\n"));
  fprintf (stderr,
	   _("-nr  or --norealtime     no output realtime control\n"));
  fprintf (stderr,
	   _
	   ("-so  or --splitoutput    stop and start the single outputs when change the song\n"));
  fprintf (stderr,
	   _
	   ("-tf  or --timeforced     play with correct time.\n"));
  fprintf (stderr,
	   _
	   ("-blt or --badlist_timer  how many seconds between one retry and the next one\n"
	    "                         [greater then 0] default %d\n"),
	   BAD_LIST_TIMER);
  fprintf (stderr,
	   _
	   ("-blmr  or --badlist_max_retry how many retry for output problems\n"
	    "                              [-1 always | 0 disactivated] default %d\n"),
	   BAD_MAX_RETRY);
#ifdef ENABLE_CDAUDIO
  fprintf (stderr, _("-cd  or --cdromdevice    [your cdaudio device]"));
#ifdef DEVDSP
  fprintf (stderr, " default %s\n", CDROM_DEVICE);
#else
  fprintf (stderr, "\n");
#endif

#endif

#ifdef ENABLE_MIC
  fprintf (stderr, _("-dsp or --devicedsp      [your dsp device]"));

#ifdef DEVDSP
  fprintf (stderr, " default %s\n", DEVDSP);
#else
  fprintf (stderr, "\n");
#endif

#endif

  fprintf (stderr, _("-z   or --random         active random playing\n"));
  fprintf (stderr, _("-r   or --repeat         repeat your playlist\n"));
#ifdef ENABLE_GTK
  fprintf (stderr, _("-g   or --graphic        active the gtk interface\n"));
#endif
  fprintf (stderr,
	   _
	   ("-nb  or --nobuffer       no buffering [dangerous for streaming files]\n"));
  fprintf (stderr,
	   _("-b   or --buffer         [size of buffer] default %d kbyte\n"),
	   SIZE_BUFFER * 5 / 1024);
  fprintf (stderr, _("-nv  or --noverbose      no verbose output\n"));
  fprintf (stderr, _("-v   or --volume         [volume 0-100]\n"));
#ifdef ENABLE_MIC
  fprintf (stderr, _("-m   or --mic            input mic or line-in\n"));
#endif
#ifdef ENABLE_DAEMON
  fprintf (stderr,
	   _
	   ("-s   or --sds            [protocol[://server[:port]]] input sds\n"));
#endif
  fprintf (stderr, _("-d   or --daemon         active SdS\n"));
  fprintf (stderr,
	   _
	   ("-a   or --admin          active unix/tcp socket controller. Read man page.\n"));
  fprintf (stderr, _("-h   or --help           this help.\n\n"));

  return 1;
}

/* Quit */
void
quit (int ret)
{
  echo_on ();
  exit (ret);
}

/* EOF */
