/* Sdsvumeter - Copyright (C) 2003-5 bakunin - Andrea Marchesini 
 *                                       <bakunin@autistici.org>
 *
 * This source code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published 
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * This source code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * Please refer to the GNU Public License for more details.
 *
 * You should have received a copy of the GNU Public License along with
 * this source code; if not, write to:
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This program is released under the GPL with the additional exemption that
 * compiling, linking, and/or using OpenSSL is allowed.
 */

#include "../src/sds/sds.h"
#include <gtkled.h>
#include <gtkledbar.h>
#include <gtk/gtk.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#define NAME_TOOL "sdsvumeter"
#define NSAMP 2048
#define BUFS 8
#define LAG 2

static int fd;
static float left;
static float right;
static GtkWidget *ledbar_l;
static GtkWidget *ledbar_r;
static short ledbar_buf[BUFS][NSAMP];
static int ledbar_cur = 0;

int usage (void);
void graphic (void);
int ledbar_timeout (gpointer);
void handle_read (gpointer, int, GdkInputCondition);

int
main (int argc, char *argv[])
{
  char *server = NULL;
  int port = 0;

  if (argc < 2 || argc > 3 || (argc == 2 && (!strcmp (argv[1], "-h") || !strcmp (argv[1], "--help"))))
    return usage ();

  if (argc > 1)
    server = argv[1];
  if (argc > 2)
    port = atoi (argv[1]);

  if ((fd = sds_open (server)) < 0)
    {
      fprintf (stderr, "SdS Connect error.\n");
      return 1;
    }

  if (fcntl (fd, F_SETFL, O_NONBLOCK) < 0)
    {
      fprintf (stderr, "Error non-blocking filedescriptor.");
      return 1;
    }

  sds_monitor (fd);

  gdk_input_add (fd, GDK_INPUT_READ, handle_read, NULL);

  gtk_init (NULL, NULL);

  graphic ();

  gtk_main ();

  return 0;
}

int
usage (void)
{
  fprintf (stderr, "Usage:\n\n\t%s [server] [port]\n\n", NAME_TOOL);
  return 1;
}

void
graphic (void)
{
  GtkWidget *win;
  GtkWidget *box;

  win = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title (GTK_WINDOW (win), "SdS Vumeter");

  box = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (box);
  gtk_container_add (GTK_CONTAINER (win), box);

  ledbar_l = gtk_led_bar_new (20, GTK_ORIENTATION_HORIZONTAL);
  gtk_widget_show (ledbar_l);
  gtk_box_pack_start (GTK_BOX (box), ledbar_l, TRUE, TRUE, 0);

  ledbar_r = gtk_led_bar_new (20, GTK_ORIENTATION_HORIZONTAL);
  gtk_widget_show (ledbar_r);
  gtk_box_pack_start (GTK_BOX (box), ledbar_r, TRUE, TRUE, 0);

  g_signal_connect ((gpointer) win, "destroy", G_CALLBACK (gtk_main_quit),
		    NULL);

  gtk_widget_show (win);

  g_timeout_add (100, ledbar_timeout, NULL);
}

int
ledbar_timeout (gpointer data)
{
  gtk_led_bar_light_percent (ledbar_l, left);
  gtk_led_bar_light_percent (ledbar_r, right);

  left = (left > 0.0) ? left - 5.0 : 0.0;
  right = (right > 0.0) ? right - 5.0 : 0.0;

  return 1;
}

void
handle_read (gpointer data, int source, GdkInputCondition condition)
{
  static int pos = 0;
  static int to_get = NSAMP * 2;
  static int count;
  int buf;
  register int i;
  register short val_l, val_r;
  static unsigned short bigl, bigr;

  count = read (source, ledbar_buf[ledbar_cur] + pos, to_get);
  if (count < 0)
    exit (1);

  pos += count;
  to_get -= count;

  if (to_get == 0)
    {
      to_get = NSAMP * 2;
      pos = 0;

      if (ledbar_cur >= BUFS)
	ledbar_cur = 0;

      buf = ((BUFS * 2) + ledbar_cur - LAG) % BUFS;

      if ((ledbar_cur % 2))
	return;

      bigl = bigr = 0;


      for (i = 0; i < NSAMP / 2; i++)
	{
	  val_l = abs (ledbar_buf[ledbar_cur][i]);
	  i++;

	  val_r = abs (ledbar_buf[ledbar_cur][i]);
	  bigl = (val_l > bigl) ? val_l : bigl;
	  bigr = (val_r > bigr) ? val_r : bigr;
	}

      bigl /= (NSAMP / 8);
      bigr /= (NSAMP / 8);

      left = bigl * 1.27;
      right = bigr * 1.27;
    }
}
