/*  Sonicmail - POP3 email notifier
 *  Copyright (C) 2000  Cameron Edwards
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "sonicmail-callbacks.h"

void sonicmail_callbacks_init(SonicmailVars *vars)
{
   applet_widget_register_stock_callback(APPLET_WIDGET(vars->applet), 
                                         "about", GNOME_STOCK_MENU_ABOUT, 
                                       _("About"), &sonicmail_about, NULL);
   
   applet_widget_register_stock_callback(APPLET_WIDGET(vars->applet), 
                                         "properties", GNOME_STOCK_MENU_PROP, 
                                       _("Properties"), &sonicmail_properties, (gpointer)vars);

   applet_widget_register_stock_callback(APPLET_WIDGET(vars->applet),
                                   "checkmail", GNOME_STOCK_MENU_REFRESH,
                                   _("Check Mail Now"), &sonicmail_wakeup_adapter, (gpointer)vars);
   
   gtk_signal_connect(GTK_OBJECT(vars->applet),"destroy", 
                      GTK_SIGNAL_FUNC(sonicmail_finish), NULL);
   
   /* Added for making sonic-mail check for mails immediately, if the user
      clicks on the applet
      -- Saravanan Subbiah saravanan_subbiah@mailcity.com
      -- Date : 29- Aug - 2k
   */
   
   gtk_signal_connect(GTK_OBJECT(vars->applet), "button_press_event", 
                      GTK_SIGNAL_FUNC(sonicmail_wakeup), (gpointer)vars);


}




void sonicmail_about(AppletWidget *caller, gpointer data)
{
   const gchar *authors[] = {
    "Cameron Edwards",
    NULL
   };
   
   gtk_widget_show (gnome_about_new ("Sonicmail", VERSION,
                  "Copyright (C) 2001 Cameron Edwards",
                   (const gchar **) authors,
                  _("Sonicmail is a simple GNOME applet POP email notifier." 
           "It will notify you when you have unread email"
           " on a POP3 server."
           "Sonicmail is distributed under the GNU General Public License."
           "For latest release see http://sonicmail.sourceforge.net"
                    ),
                    NULL));

}

void sonicmail_properties(AppletWidget *caller, gpointer data)
{
   SonicmailVars *vars = (SonicmailVars *)data;
   SonicmailProperties *p_vars = &(vars->properties);
   
   /* Make a new property box widget: */
   p_vars->property_box = gnome_property_box_new();
   
   /* Make some widgets as pages in the property box note book: */
   
   /* Mail Server Info: */
   p_vars->server_table = gtk_table_new(4, 2, TRUE);
   gtk_table_set_homogeneous(GTK_TABLE(p_vars->server_table), FALSE);
   
    /* Create widgets: */
    p_vars->server_entry = gtk_entry_new();
    p_vars->user_entry = gtk_entry_new();
    p_vars->passwd_entry = gtk_entry_new();
     gtk_entry_set_visibility(GTK_ENTRY(p_vars->passwd_entry), FALSE);
    p_vars->min_adj = gtk_adjustment_new((gfloat)vars->mins, 0, 120, 1, 10, 10);
    p_vars->sec_adj = gtk_adjustment_new((gfloat)vars->secs, 0, 59, 1, 10, 10);
    
    p_vars->min_spin = gtk_spin_button_new(GTK_ADJUSTMENT(p_vars->min_adj), 1, 0);
    p_vars->sec_spin = gtk_spin_button_new(GTK_ADJUSTMENT(p_vars->sec_adj), 1, 0);
 
    /* Initial widget values: */
    gtk_entry_set_text(GTK_ENTRY(p_vars->server_entry), vars->servername);
    gtk_entry_set_text(GTK_ENTRY(p_vars->user_entry), vars->username);
    gtk_entry_set_text(GTK_ENTRY(p_vars->passwd_entry), vars->pword);
    
    /* Packing: */
    p_vars->freq_box = gtk_hbox_new(FALSE, 0);
    gtk_box_pack_start_defaults(GTK_BOX(p_vars->freq_box), p_vars->min_spin);
    gtk_box_pack_start_defaults(GTK_BOX(p_vars->freq_box), gtk_label_new("min"));
    gtk_box_pack_start_defaults(GTK_BOX(p_vars->freq_box), p_vars->sec_spin);
    gtk_box_pack_start_defaults(GTK_BOX(p_vars->freq_box), gtk_label_new("sec"));
    
    /* Setup signal handlers for when each widget changes value: */
    gtk_signal_connect(GTK_OBJECT(p_vars->server_entry),"changed", GTK_SIGNAL_FUNC(sonicmail_prop_changed), p_vars->property_box);
    gtk_signal_connect(GTK_OBJECT(  p_vars->user_entry),"changed", GTK_SIGNAL_FUNC(sonicmail_prop_changed), p_vars->property_box);
    gtk_signal_connect(GTK_OBJECT(p_vars->passwd_entry),"changed", GTK_SIGNAL_FUNC(sonicmail_prop_changed), p_vars->property_box);
    gtk_signal_connect(GTK_OBJECT(    p_vars->min_spin),"changed", GTK_SIGNAL_FUNC(sonicmail_prop_changed), p_vars->property_box);
    gtk_signal_connect(GTK_OBJECT(    p_vars->sec_spin),"changed", GTK_SIGNAL_FUNC(sonicmail_prop_changed), p_vars->property_box);
   

    /* Add the widgets to a table: */
    gtk_table_attach(GTK_TABLE(p_vars->server_table), gtk_label_new("POP3 Server:"), 0, 1, 0, 1, 
                  GTK_EXPAND|GTK_FILL, GTK_EXPAND|GTK_FILL, 2, 2);
    gtk_table_attach(GTK_TABLE(p_vars->server_table), gtk_label_new("POP3 User Name:"), 0, 1, 1, 2, 
                  GTK_EXPAND|GTK_FILL, GTK_EXPAND|GTK_FILL, 2, 2);
    gtk_table_attach(GTK_TABLE(p_vars->server_table), gtk_label_new("POP3 Password:"), 0, 1, 2, 3, 
                    GTK_EXPAND|GTK_FILL, GTK_EXPAND|GTK_FILL, 2, 2);
    gtk_table_attach(GTK_TABLE(p_vars->server_table), gtk_label_new("Check Mail Every:"), 0, 1, 3, 4,
                    GTK_EXPAND|GTK_FILL, GTK_EXPAND|GTK_FILL, 2, 2);
    gtk_table_attach(GTK_TABLE(p_vars->server_table), p_vars->server_entry, 1, 2, 0, 1,
                    GTK_EXPAND|GTK_FILL, GTK_EXPAND|GTK_FILL, 2, 2);
    gtk_table_attach(GTK_TABLE(p_vars->server_table), p_vars->user_entry, 1, 2, 1, 2,
                    GTK_EXPAND|GTK_FILL, GTK_EXPAND|GTK_FILL, 2, 2);
    gtk_table_attach(GTK_TABLE(p_vars->server_table), p_vars->passwd_entry, 1, 2, 2, 3,
                    GTK_EXPAND|GTK_FILL, GTK_EXPAND|GTK_FILL, 2, 2);
    gtk_table_attach(GTK_TABLE(p_vars->server_table), p_vars->freq_box, 1, 2, 3, 4,
                    GTK_EXPAND|GTK_FILL, GTK_EXPAND|GTK_FILL, 2, 2);
   
   /* Pixmap Image Info: */
   p_vars->images_table = gtk_table_new(4, 2, TRUE);
   gtk_table_set_homogeneous(GTK_TABLE(p_vars->images_table), FALSE);
   
    p_vars->pmempty_entry = gnome_file_entry_new( NULL, "Mailbox Empty Pixmap");
    p_vars->pmfull_entry = gnome_file_entry_new( NULL, "Mailbox Full Pixmap");
    p_vars->pmoffline_entry = gnome_file_entry_new( NULL, "Offline Pixmap");
    p_vars->transp_color_picker = gnome_color_picker_new();
     gnome_color_picker_set_use_alpha(GNOME_COLOR_PICKER(p_vars->transp_color_picker), FALSE);
    
    /* Initial widget values: */
    gtk_entry_set_text(GTK_ENTRY(gnome_file_entry_gtk_entry(GNOME_FILE_ENTRY(p_vars->pmempty_entry))), vars->empty_pm_filename);
    gtk_entry_set_text(GTK_ENTRY(gnome_file_entry_gtk_entry(GNOME_FILE_ENTRY(p_vars-> pmfull_entry))), vars->full_pm_filename);
    gtk_entry_set_text(GTK_ENTRY(gnome_file_entry_gtk_entry(GNOME_FILE_ENTRY(p_vars->pmoffline_entry))), vars->offline_pm_filename);
    gnome_color_picker_set_i16(GNOME_COLOR_PICKER(vars->properties.transp_color_picker), vars->transp_col.red, vars->transp_col.green, vars->transp_col.blue, 0);    
 
    /* Setup signal handlers for when each widget changes value: */
    gtk_signal_connect(GTK_OBJECT(gnome_file_entry_gtk_entry(GNOME_FILE_ENTRY(p_vars->pmempty_entry))),"changed", GTK_SIGNAL_FUNC(sonicmail_prop_changed), p_vars->property_box);
    gtk_signal_connect(GTK_OBJECT(gnome_file_entry_gtk_entry(GNOME_FILE_ENTRY(p_vars->pmfull_entry))),"changed", GTK_SIGNAL_FUNC(sonicmail_prop_changed), p_vars->property_box);
    gtk_signal_connect(GTK_OBJECT(gnome_file_entry_gtk_entry(GNOME_FILE_ENTRY(p_vars->pmoffline_entry))),"changed", GTK_SIGNAL_FUNC(sonicmail_prop_changed), p_vars->property_box);
    gtk_signal_connect(GTK_OBJECT(p_vars->transp_color_picker),"clicked", GTK_SIGNAL_FUNC(sonicmail_prop_changed), p_vars->property_box);
 
    /* Add the widgets to a table: */
    gtk_table_attach(GTK_TABLE(p_vars->images_table), gtk_label_new("Mailbox Empty Pixmap:"), 0, 1, 0, 1,
                    GTK_EXPAND|GTK_FILL, GTK_EXPAND|GTK_FILL, 2, 2);
    gtk_table_attach(GTK_TABLE(p_vars->images_table), gtk_label_new("Mailbox Full Pixmap:"), 0, 1, 1, 2,
                    GTK_EXPAND|GTK_FILL, GTK_EXPAND|GTK_FILL, 2, 2);
    gtk_table_attach(GTK_TABLE(p_vars->images_table), gtk_label_new("Offline Pixmap:"), 0, 1, 2, 3,
                    GTK_EXPAND|GTK_FILL, GTK_EXPAND|GTK_FILL, 2, 2);
    gtk_table_attach(GTK_TABLE(p_vars->images_table), gtk_label_new("Pixmap Transparent Colour:"), 0, 1, 3, 4,
                    GTK_EXPAND|GTK_FILL, GTK_EXPAND|GTK_FILL, 2, 2);
    gtk_table_attach(GTK_TABLE(p_vars->images_table), p_vars->pmempty_entry, 1, 2, 0, 1,
                    GTK_EXPAND|GTK_FILL, GTK_EXPAND|GTK_FILL, 2, 2);
    gtk_table_attach(GTK_TABLE(p_vars->images_table), p_vars->pmfull_entry, 1, 2, 1, 2,
                    GTK_EXPAND|GTK_FILL, GTK_EXPAND|GTK_FILL, 2, 2);
    gtk_table_attach(GTK_TABLE(p_vars->images_table), p_vars->pmoffline_entry, 1, 2, 2, 3,
                    GTK_EXPAND|GTK_FILL, GTK_EXPAND|GTK_FILL, 2, 2);
    gtk_table_attach(GTK_TABLE(p_vars->images_table), p_vars->transp_color_picker, 1, 2, 3, 4,
                    GTK_EXPAND|GTK_FILL, GTK_EXPAND|GTK_FILL, 2, 2);

   /* Audio Info: */
   p_vars->audio_table = gtk_table_new(3, 2, FALSE);
   gtk_table_set_homogeneous(GTK_TABLE(p_vars->images_table), TRUE);
   
    p_vars->audio_check = gtk_check_button_new_with_label("Play sound when mailbox becomes non empty");
    p_vars->audio_repeat_check = gtk_check_button_new_with_label("Play sound when subsequent mail arrives");
    p_vars->wavfile_entry = gnome_file_entry_new( NULL, "Mail Arrived WAV Filename");
 
    /* Initial widget values: */
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(p_vars->audio_check), vars->audio_on);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(p_vars->audio_repeat_check), vars->audio_repeat_on);
    gtk_entry_set_text(GTK_ENTRY(gnome_file_entry_gtk_entry(GNOME_FILE_ENTRY(p_vars->wavfile_entry))), vars->wavfile_filename);
    
 
    /* Setup signal handlers for when each widget changes value: */
    gtk_signal_connect(GTK_OBJECT(p_vars->audio_check),"clicked", GTK_SIGNAL_FUNC(sonicmail_prop_changed), p_vars->property_box);
    gtk_signal_connect(GTK_OBJECT(p_vars->audio_repeat_check),"clicked", GTK_SIGNAL_FUNC(sonicmail_prop_changed), p_vars->property_box);
    gtk_signal_connect(GTK_OBJECT(gnome_file_entry_gtk_entry(GNOME_FILE_ENTRY(p_vars->wavfile_entry))),"changed", GTK_SIGNAL_FUNC(sonicmail_prop_changed), p_vars->property_box);
 
    /* Add the widgets to a table: */
    gtk_table_attach(GTK_TABLE(p_vars->audio_table), gtk_label_new("Mail Arrived WAV Filename:"), 0, 1, 2, 3,
                    GTK_EXPAND|GTK_FILL, GTK_EXPAND|GTK_FILL, 2, 2);
    gtk_table_attach(GTK_TABLE(p_vars->audio_table), p_vars->audio_check, 0, 2, 0, 1,
                    GTK_EXPAND|GTK_FILL, GTK_EXPAND|GTK_FILL, 2, 2);
    gtk_table_attach(GTK_TABLE(p_vars->audio_table), p_vars->audio_repeat_check, 0, 2, 1, 2,
                    GTK_EXPAND|GTK_FILL, GTK_EXPAND|GTK_FILL, 2, 2);
    gtk_table_attach(GTK_TABLE(p_vars->audio_table), p_vars->wavfile_entry, 1, 2, 2, 3,
                    GTK_EXPAND|GTK_FILL, GTK_EXPAND|GTK_FILL, 2, 2);
 
   gnome_property_box_append_page(GNOME_PROPERTY_BOX(p_vars->property_box), p_vars->server_table, gtk_label_new("Mail Server"));
   gnome_property_box_append_page(GNOME_PROPERTY_BOX(p_vars->property_box), p_vars->images_table, gtk_label_new("Pixmaps"));
   gnome_property_box_append_page(GNOME_PROPERTY_BOX(p_vars->property_box), p_vars->audio_table, gtk_label_new("Audio"));
   
   /* Connect an apply signal handler: */
   gtk_signal_connect(GTK_OBJECT(p_vars->property_box),"apply", GTK_SIGNAL_FUNC(sonicmail_prop_apply), (gpointer)vars);
   
   gtk_widget_show_all(p_vars->server_table);
   gtk_widget_show_all(p_vars->images_table);
   gtk_widget_show_all(p_vars->audio_table);
   
   gtk_widget_show(p_vars->property_box);
}


void sonicmail_prop_changed(GtkWidget *w, gpointer data)
{
   /* When a property widget changes, we want to enable the property box append button: */
   gnome_property_box_changed((GnomePropertyBox *)data);
}

void sonicmail_prop_apply(GnomePropertyBox *propertybox, gint page_num, gpointer data)
{
   SonicmailVars *vars;
   SonicmailProperties *pvars;
   gushort tmp;
   
   vars = (SonicmailVars *)data;
   pvars = &(vars->properties);
   
   if (page_num != -1) /* Only apply after all pages have been applied */
      return;
   
   /* Free old values: */
   
   /* FIXME: THIS SEEMS TO CAUSE PROBLEMS????: */
   /*
   g_free(vars->servername);
   g_free(vars->username);
   g_free(vars->pword);
   g_free(vars->empty_pm_filename);
   g_free(vars->full_pm_filename);
   g_free(vars->offline_pm_filename);
   g_free(vars->offline_pm_filename);
   g_free(vars->wavfile_filename);*/
   
   //printf("Variables freed\n");fflush(stdout);
   
   
   /* Extract all current property values from the widgets: */
   vars->servername = gtk_editable_get_chars(GTK_EDITABLE(pvars->server_entry), 0, -1);
   vars->username = gtk_editable_get_chars(GTK_EDITABLE(pvars->user_entry), 0, -1);
   vars->pword = gtk_editable_get_chars(GTK_EDITABLE(pvars->passwd_entry), 0, -1);
   vars->mins = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(pvars->min_spin));
   vars->secs = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(pvars->sec_spin));
   vars->empty_pm_filename = gnome_file_entry_get_full_path(GNOME_FILE_ENTRY(pvars->pmempty_entry), FALSE);
   vars->full_pm_filename = gnome_file_entry_get_full_path(GNOME_FILE_ENTRY(pvars->pmfull_entry), FALSE);
   vars->offline_pm_filename = gnome_file_entry_get_full_path(GNOME_FILE_ENTRY(pvars->pmoffline_entry), FALSE);
   gnome_color_picker_get_i16(GNOME_COLOR_PICKER(pvars->transp_color_picker),
                              &(vars->transp_col.red), &(vars->transp_col.green), 
                              &(vars->transp_col.blue), &tmp);
   
   vars->audio_on = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(pvars->audio_check));
   vars->audio_repeat_on = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(pvars->audio_repeat_check));
   vars->wavfile_filename = gnome_file_entry_get_full_path(GNOME_FILE_ENTRY(pvars->wavfile_entry), FALSE);
   
   /* Enforce at least a 30 second mail check period: */
   if(vars->mins == 0 && vars->secs <30) {
      gnome_error_dialog("Sonicmail:\n\n Mail should not be checked more frequently than every 30 seconds!\n Defaulting to minimum mail check period of 30 seconds.");
      gtk_spin_button_set_value(GTK_SPIN_BUTTON(pvars->sec_spin), 30);
      vars->secs = 30;
   }
   
   
   /* Load the new pixmaps: */
   sonicmail_pixmap_gdk_load( &(vars->pixmaps.offline_pixmap), vars, vars->offline_pm_filename);
   sonicmail_pixmap_gdk_load( &(vars->pixmaps.empty_pixmap), vars, vars->empty_pm_filename);
   sonicmail_pixmap_gdk_load( &(vars->pixmaps.full_pixmap), vars, vars->full_pm_filename);
   
   /* Refresh the displayed pixmap: */
   sonicmail_pixmap_refresh(vars);
   
   /* Save the properties: */
   sonicmail_properties_save(vars);
   
   /* Break out of the current check loop by sending all processes in this 
      process group (ie 0) the SIGUSR2 signal (see sonicmail-mailcheck.c): */
   if(vars->mailcheck_thread_pid > 0) {
      kill(vars->mailcheck_thread_pid, SIGUSR2);
      SM_DEBUG_INT("Sending SIGUSR2 to PID =", vars->mailcheck_thread_pid);
   }
}

/* This was added to make sonic-mail check mails immediately, if the user
   clicks on the applet.
   --    Saravanan S. (saravanan_subbiah@mailcity.com)
   date : 29 - Aug - 2k
*/
void sonicmail_wakeup(GtkWidget *w, GdkEventButton *event, gpointer data)
{
   SonicmailVars *vars;
   
   vars = (SonicmailVars *)data;

   /* Break out of the current check loop by sending all processes in this 
      process group (ie 0) the SIGUSR1 signal (see sonicmail-mailcheck.c): */
   
   SM_DEBUG_INT("Applet clicked, mailcheck thread PID =", vars->mailcheck_thread_pid);
   
   if(vars->mailcheck_thread_pid > 0) {
      kill(vars->mailcheck_thread_pid, SIGUSR2);
      SM_DEBUG_INT("Sending SIGUSR2 to PID =", vars->mailcheck_thread_pid);
   }
}

void sonicmail_wakeup_adapter(AppletWidget *w, gpointer data)
{
   sonicmail_wakeup(GTK_WIDGET(w), NULL, data);
}

gint sonicmail_finish(GtkWidget *w, gpointer data)
{
   return(FALSE);
}
