-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

separate (Sem.Walk_Expression_P)
procedure Put_Exp_Record (R : in Sem.Exp_Record) is
   --# hide Put_Exp_Record;
   F : SPARK_IO.File_Type;
begin
   F := SPARK_IO.Standard_Output;
   SPARK_IO.Put_String (F, "Sort                 => ", 0);
   SPARK_IO.Put_Line (F, Exp_Record_Sort'Image (R.Sort), 0);

   SPARK_IO.Put_String (F, "Type_Symbol           => ", 0);
   E_Strings.Put_Line
     (File  => F,
      E_Str => LexTokenManager.Lex_String_To_String (Lex_Str => Dictionary.GetSimpleName (R.Type_Symbol)));

   SPARK_IO.Put_String (F, "Other_Symbol          => ", 0);
   E_Strings.Put_Line
     (File  => F,
      E_Str => LexTokenManager.Lex_String_To_String (Lex_Str => Dictionary.GetSimpleName (R.Other_Symbol)));

   SPARK_IO.Put_String (F, "String_Value         => ", 0);
   E_Strings.Put_Line (File  => F,
                       E_Str => LexTokenManager.Lex_String_To_String (R.String_Value));

   SPARK_IO.Put_String (F, "Value                => ", 0);
   E_Strings.Put_Line (File  => F,
                       E_Str => Maths.ValueToString (R.Value));

   SPARK_IO.Put_String (F, "Arg_List_Found         => ", 0);
   SPARK_IO.Put_Line (F, Boolean'Image (R.Arg_List_Found), 0);

   SPARK_IO.Put_String (F, "Range_RHS             => ", 0);
   E_Strings.Put_Line (File  => F,
                       E_Str => Maths.ValueToString (R.Range_RHS));

   SPARK_IO.Put_String (F, "Param_Count           =>", 0);
   SPARK_IO.Put_Line (F, Natural'Image (R.Param_Count), 0);

   SPARK_IO.Put_Line (F, "Param_List            => (...not printed...)", 0);

   SPARK_IO.Put_String (F, "Is_Static             => ", 0);
   SPARK_IO.Put_Line (F, Boolean'Image (R.Is_Static), 0);
   SPARK_IO.Put_String (F, "Is_Constant           => ", 0);
   SPARK_IO.Put_Line (F, Boolean'Image (R.Is_Constant), 0);
   SPARK_IO.Put_String (F, "Is_ARange             => ", 0);
   SPARK_IO.Put_Line (F, Boolean'Image (R.Is_ARange), 0);

   SPARK_IO.Put_String (F, "Variable_Symbol       => ", 0);
   E_Strings.Put_Line
     (File  => F,
      E_Str => LexTokenManager.Lex_String_To_String (Lex_Str => Dictionary.GetSimpleName (R.Variable_Symbol)));

   SPARK_IO.Put_String (F, "Is_AVariable          => ", 0);
   SPARK_IO.Put_Line (F, Boolean'Image (R.Is_AVariable), 0);
   SPARK_IO.Put_String (F, "Is_An_Entire_Variable   => ", 0);
   SPARK_IO.Put_Line (F, Boolean'Image (R.Is_An_Entire_Variable), 0);
   SPARK_IO.Put_String (F, "Errors_In_Expression   => ", 0);
   SPARK_IO.Put_Line (F, Boolean'Image (R.Errors_In_Expression), 0);
   SPARK_IO.Put_String (F, "Has_Operators         => ", 0);
   SPARK_IO.Put_Line (F, Boolean'Image (R.Has_Operators), 0);

   SPARK_IO.Put_String (F, "Stream_Symbol         => ", 0);
   E_Strings.Put_Line
     (File  => F,
      E_Str => LexTokenManager.Lex_String_To_String (Lex_Str => Dictionary.GetSimpleName (R.Stream_Symbol)));
end Put_Exp_Record;
