-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

with SPARK.Ada.Strings.Unbounded;

--# inherit SPARK.Ada.Strings.Unbounded;

package Files is

   type File_Types is (
                       Examiner_Files,   --  vcg, dpc, fdl, rls
                       Simplifier_Files, --  siv, sdp, slg, zlg, log, zsl
                       Victor_Files,     --  vct, vsm
                       POGS_Files,       --  sum
                       Unknown           --  anything else (must always be last)
                      );

   subtype Known_File_Types is File_Types range File_Types'First .. File_Types'Pred (Unknown);

   --  Given an extension (such as 'vcg') this function returns the
   --  type of the file as one of File_Types.
   function Filetype_From_Extension (Extension : in SPARK.Ada.Strings.Unbounded.Unbounded_String) return File_Types;

end Files;
