#!/usr/local/bin/perl
#
# This object represents a service in the History Service directory. This
# object inherits from the Service class. The filename function is overridden
# so we get the correct status information. The new function is overloaded
# becuase we needed the status time field to build the file name

# History
# (1) Created (Dec 27, 1999  Stephen L Johnson)

package Spong::HistoryService;

use Spong::Service;
@ISA = ("Spong::Service");

# This is an overloaded new function for the HistoryService close. It
# needs the update time in addition to host and service names

sub new {
   my( $proto, $host, $service, $time ) = @_;
   my( $class ) = ref($proto) || $proto;
   my $self = $class->SUPER::new($host,$service);  # Call the service new()

   $self->{'time'}    = $time;  # Add the stuff I need

   my $file = $self->filename();
   if (! -f "$main::SPONGDB/$file" ) { # If no file record found
      return undef;                    # Return undef
   }

   bless ($self,$class);  # reconsecrate
   return $self;
}

# These functions handle the loading of of the service data from the 
# database files

sub filename {
  my( $self ) = shift;
  my( $file ) = "";

   # This is a local hack to get around the procs/jobs problems, first look
   # for the jobs service, if it is not there, look for procs...
   
   if( $self->name() eq "jobs" ) {
      $file = $self->host()."/history/status/".$self->{'time'}."-".$self->{'name'};
      if( ! -f "$main::SPONGDB/$file" ) {
	 $file = $self->host()."/history/status/".$self->{'time'}."-procs";
      }
   } else {
      $file = $self->host()."/history/status/".$self->{'time'}."-".$self->{'name'};
   }

   return $file;
}

# Overridden html display function

sub display_html {
   my( $self, $format ) = @_;
   my $host  = $self->host;
   my $name  = $self->name();
   my $color = $self->color();
   my( $d1, $m1, $y1 ) = (localtime( $self->rtime()))[3,4,5];
   my( $d2, $m2, $y2 ) = (localtime())[3,4,5];

   if( $format eq "brief" ) {
      print "<a href=\"!!WWWSPONG!!/service/$host/$name\">\n";

      if( $main::WWW_USE_IMAGES == 1 ) {
	 print "<img src=\"!!WWWGIFS!!/$color.gif\" alt=$color border=0>";
      } else {
	 print "<table border=0 cellspacing=0 cellpadding=0><tr>";
	 print "<td width=20 bgcolor=\"" . $main::WWW_COLOR{$color} ;
	 print "\"><font color=\"" . $main::WWW_COLOR{$color} . "\">";
	 print "___</font></td></tr></table>\n";
      }
      print "</a>";
   } elsif( $format eq "standard_table" ) {
      print "<tr><td align=left valign=top nowrap>\n"; 
      print "<a href=\"!!WWWSPONG!!/service/$host/$name\">$name</a></td>\n";
      print "<td align=center valign=top>\n"; 

      if( $main::WWW_USE_IMAGES == 1 ) {
	 print "<a href=\"!!WWWSPONG!!/service/$host/$name\">\n";
	 print "<img src=\"!!WWWGIFS!!/$color.gif\" alt=$color border=0></a>";
      } else {
	 print "<table border=0 cellspacing=0 cellpadding=0><tr>";
	 print "<td width=20 bgcolor=\"" . $main::WWW_COLOR{$color} . "\">";
	 print "<a href=\"!!WWWSPONG!!/service/$host/$name\">";
	 print "<font color=\"" . $main::WWW_COLOR{$color} . "\">___</font>";
	 print "</a></td></tr></table>\n";
      }

      print "</td>\n"; 
      print "<td align=center valign=top nowrap>";

      if( $d1 == $d2 && $m1 == $m2 && $y1 == $y2 ) {
	 print POSIX::strftime( "%H:%M", localtime($self->rtime()) ), "  ";
      } else {
	 print POSIX::strftime( "%D", localtime($self->rtime()) ), "  ";
      }

      print "</td>\n";
      print "<td align=left valign=top>", $self->summary(), "</td></tr>\n";
   } elsif( $format eq "standard" ) {
      print "<table width=100% border=1 cellspacing=2 cellpadding=2><tr>\n";
      print "<td width=60 align=center><b>Service</b></td>\n";
      print "<td width=1%>&nbsp</td>\n";
      print "<td width=60 align=center><b>Updated</b></td>\n";
      print "<td width=100% align=center><b>Summary</b></td></tr>\n";

      $self->display_html( "standard_table" );

      print "</table>\n";
   } elsif( $format eq "full" ) {
      print "<font size=+2><b>", $self->host(), "/", $self->name();
      print "</b></font>\n";

      print "<table width=100% cellspacing=0 cellpadding=0 border=0>";
      print "<tr><td bgcolor=\"" . $main::WWW_COLOR{$color} . "\">&nbsp;</td>";
      print "</tr></table><p>";

      print "<b>Date:</b> ";
      print POSIX::strftime( "%H:%M, %D", localtime($self->rtime()) );

      print "<br><b>Summary:</b> ", $self->summary(), "<br>\n";
      print "<hr noshade><pre>", $self->message(), "</pre>\n";
   }
}

sub load {
   my( $self ) = shift;
   my $file = $self->filename();
  
   open( FILE, "$main::SPONGDB/$file" );
   my $header = <FILE>; chomp $header;
   # If a timestamp is present, read it and set start time
   if ($header =~ /^timestamp (\d+) (\d+)/ ) {
      $self->{'stime'} = $1; 
      $header = <FILE>; chomp $header;
   }
   if ($header =~ /^color (\S+)/) {
      $self->color($1);
      $header = <FILE>; chomp $header;
   }
     
   ($self->{'rtime'}, $self->{'summary'}) = ( $header =~ /^(\d+) (.*)$/ );
   while( <FILE> ) { $self->{'message'} .= $_; }
   close( FILE );
}


1;

