#ifdef __GNUC__
#  pragma implementation "opengl.H"
#endif

#include <GL/gl.h>
#include <GL/glut.h>
#include <math.h>
#include <string.h>
#include "opengl.H"

const real StrokeFontHeight = 119.05+33.33;

TOpenGL::TOpenGL(greal xmax1, greal ymax1,
				 greal titlefontsize1, greal labelfontsize1, greal axisfontsize1, greal annotfontsize1)
{
	glShadeModel(GL_FLAT);			// by default, draw flatly colored polygons
	glDisable(GL_LINE_SMOOTH);		// draw fast lines by default
//	glEnable(GL_DEPTH_TEST);
	xmax = xmax1;
	ymax = ymax1;
	titlefontsize = titlefontsize1;
	labelfontsize = labelfontsize1;
	axisfontsize = axisfontsize1;
	annotfontsize = annotfontsize1;
	font_is_bitmap = false/*true*/;
	if (font_is_bitmap) {
		font = GLUT_BITMAP_HELVETICA_12;
		fontheight = 12;
	} else {
		font = GLUT_STROKE_ROMAN;
		fontheight = 12;
	}
	Tgraph2D::setpalette(PALETTE_RAINBOW);
//	int i;
//	for (i=0; i<Ncolors; i++) pal[0][i] = pal[1][i] = pal[2][i] = i;
}

void TOpenGL::begin_line(greal x, greal y)
{
	glBegin(GL_LINE_STRIP);
	glVertex2f(x,y);
}

void TOpenGL::vertex(greal x1, greal y1)
{
	glVertex2f(x1,y1);
}

void TOpenGL::end_line()
{
	glEnd();
}

void TOpenGL::point(greal x, greal y)
{
	glBegin(GL_POINTS);
	glVertex2f(x,y);
	glEnd();
}

void TOpenGL::begin_fill(greal x, greal y)
{
	glBegin(GL_POLYGON);
	glVertex2f(x,y);
}

void TOpenGL::end_fill()
{
	glEnd();
}

void TOpenGL::circle(greal x, greal y, greal r)
{
	const int n = 10;
	const greal phistep = 2*M_PI/greal(n);
	greal phi;
	int i;
	begin_line(x+r,y);
	for (i=1,phi=phistep; i<=n; i++,phi+=phistep)
		vertex(x+r*cos(phi),y+r*sin(phi));
	end_line();
}

void TOpenGL::fillcircle(greal x, greal y, greal r)
{
	const int n = 10;
	const greal phistep = 2*M_PI/greal(n);
	greal phi;
	int i;
	glBegin(GL_TRIANGLE_FAN);
	glVertex2f(x,y);
	glVertex2f(x+r,y);
	for (i=1,phi=phistep; i<=n; i++,phi+=phistep)
		vertex(x+r*cos(phi),y+r*sin(phi));
	glEnd();
}

void TOpenGL::text(greal x, greal y, const char *s, int Xoffset, int Yoffset, bool rotate)
{
	if (!font_is_bitmap) {
		glMatrixMode(GL_MODELVIEW);
		glPushMatrix();
		glPushAttrib(GL_LINE_BIT | GL_POLYGON_BIT | GL_ENABLE_BIT);
		glEnable(GL_LINE_SMOOTH);
//		glEnable(GL_POLYGON_SMOOTH);
//		glEnable(GL_ALPHA_TEST);
//		glHint(GL_LINE_SMOOTH_HINT,GL_NICEST);
//		glLineWidth(2);
	}
	greal xx,yy;
	if (rotate && !font_is_bitmap) {
		glRotated(90,0,0,1);
		xx = y;
		yy = -x;
	} else {
		xx = x;
		yy = y;
	}
	const int L = strlen(s);
	int i;
	real stringwidth = 0, scaling = 1;
	if (font_is_bitmap) {
		for (i=0; i<L; i++) stringwidth+= glutBitmapWidth(font,s[i]);
	} else {
		for (i=0; i<L; i++) stringwidth+= glutStrokeWidth(font,s[i]);
		scaling = fontheight/StrokeFontHeight;
		stringwidth*= scaling;
	}
	if (Xoffset < 0)
		xx-= stringwidth;
	else if (Xoffset == 0)
		xx-= 0.5*stringwidth;
	if (Yoffset < 0)
		yy-= fontheight;
	else if (Yoffset == 0)
		yy-= 0.3*fontheight;
	if (font_is_bitmap) {
		glRasterPos2f(xx,yy);
		for (i=0; i<L; i++) glutBitmapCharacter(font,s[i]);
	} else {
		glTranslated(xx,yy,0);
		glScaled(scaling,scaling,1);
		for (i=0; i<L; i++) glutStrokeCharacter(font,s[i]);
		glPopAttrib();
		glPopMatrix();
	}
}

void TOpenGL::text_exponent(greal x, greal y, const char *mant, const char *expo, int Xoffset, int Yoffset)
{
	int i;
//	cerr << "text_exponent, mant=\"" << mant << "\", expo=\"" << expo << "\", Xoffset=" << Xoffset << ",Yoffset=" << Yoffset << "\n";
	if (font_is_bitmap) {
		if (Xoffset >= 0) {
			text(x,y,mant,Xoffset,Yoffset,false);
			y+= 0.4*fontheight;
			real mantlen = 0;
			for (i=0; mant[i]; i++) {
				if (!mant[i+1] && mant[i]==' ') break;
				mantlen+= glutBitmapWidth(font,mant[i]);
			}
			x+= mantlen;
			text(x,y,expo,Xoffset,Yoffset,false);
		} else {
			real expolen = 0;
			for (i=0; expo[i]; i++) {
				expolen+= glutBitmapWidth(font,expo[i]);
			}
			x-= expolen;
			text(x,y,mant,Xoffset,Yoffset,false);
			y+= 0.4*fontheight;
			text(x,y,expo,1,Yoffset,false);
		}
	} else {
		glPushMatrix();
		real mantlen = 0;
		text(x,y,mant,Xoffset,Yoffset,false);
		for (i=0; mant[i]; i++) mantlen+= glutStrokeWidth(font,mant[i]);
		mantlen*= fontheight/StrokeFontHeight;
		glTranslated(mantlen-0.2*fontheight,0.4*fontheight,0);
		text(x,y,expo,Xoffset,Yoffset,false);
		glPopMatrix();
	}
}

void TOpenGL::comment(greal x, greal y)
{
}

void TOpenGL::comment(const char *s)
{
}

void TOpenGL::setfont(TFontType fonttype)
{
	greal fh = axisfontsize;
	font_is_bitmap = true;
	switch (fonttype) {
	case FONT_TOPLABEL: fh = titlefontsize; break;
	case FONT_SIDELABEL: fh = labelfontsize; font_is_bitmap = false; break;
	case FONT_AXISLABEL: fh = axisfontsize; break;
	case FONT_ANNOTATION: fh = annotfontsize; break;
	case FONT_COPYRIGHT: fh = 6; break;
	default: cerr << "*** Unsupported font in TOpenGL::setfont()\n";
	}
	if (font_is_bitmap) {
		if (fh >= 24) {
			font = GLUT_BITMAP_TIMES_ROMAN_24;
			fontheight = 24;
		} else if (fh >= 18) {
			font = GLUT_BITMAP_HELVETICA_18;
			fontheight = 18;
		} else if (fh >= 12) {
			font = GLUT_BITMAP_HELVETICA_12;
			fontheight = 12;
		} else {
			font = GLUT_BITMAP_HELVETICA_10;
			fontheight = 10;
		}
	} else {
		font = GLUT_STROKE_ROMAN;
		fontheight = fh;
	}
}

void TOpenGL::setcolor(const greal rgb[3])
{
	glColor3f(rgb[0],rgb[1],rgb[2]);
}

void TOpenGL::setcolor(int i)
{
	if (i < 0) i = 0;
	if (i >= Ncolors) i = Ncolors-1;
	const real C = 1.0/Ncolors;
	glColor3f(pal[0][i]*C,pal[1][i]*C,pal[2][i]*C);
}

void TOpenGL::setlinewidth(greal lw)
{
	glLineWidth(lw);
}

void TOpenGL::setlinetype(TLineType lt)
{
	GLushort pat = 0xFFFF;
	switch (lt) {
	case LINE_NONE:
		pat = 0;
		break;
	case LINE_SOLID:
		pat = 0xFFFF;
		break;
	case LINE_DOTTED:
		pat = 0xCCCC;
		break;
	case LINE_DASHED:
		pat = 0xFF00;
		break;
	case LINE_DOTDASHED:
		pat = 0x4F4F;
		break;
	case LINE_GRIDDOTTED:
		pat = 0xAAAA;
		break;
	}
	glLineStipple(1,pat);
	if (lt == LINE_SOLID)
		glDisable(GL_LINE_STIPPLE);
	else
		glEnable(GL_LINE_STIPPLE);
	linetype_set = lt;
}

void TOpenGL::begin_clipped(greal x1, greal y1, greal x2, greal y2)
{
	double eqn[4] = {0,0,0,0};
	eqn[0] = 1;
	eqn[3] = -x1;
	glClipPlane(GL_CLIP_PLANE0,eqn);
	eqn[0] = -1;
	eqn[3] = x2;
	glClipPlane(GL_CLIP_PLANE1,eqn);
	eqn[0] = 0;
	eqn[1] = 1;
	eqn[3] = -y1;
	glClipPlane(GL_CLIP_PLANE2,eqn);
	eqn[1] = -1;
	eqn[3] = y2;
	glClipPlane(GL_CLIP_PLANE3,eqn);
	glEnable(GL_CLIP_PLANE0);
	glEnable(GL_CLIP_PLANE1);
	glEnable(GL_CLIP_PLANE2);
	glEnable(GL_CLIP_PLANE3);
}

void TOpenGL::end_clipped()
{
	glDisable(GL_CLIP_PLANE0);
	glDisable(GL_CLIP_PLANE1);
	glDisable(GL_CLIP_PLANE2);
	glDisable(GL_CLIP_PLANE3);
}

void TOpenGL::fillrrect(greal x1, greal y1, greal dx, greal dy)
{
	glBegin(GL_QUADS);
	glVertex2f(x1,y1);
	glVertex2f(x1+dx,y1);
	glVertex2f(x1+dx,y1+dy);
	glVertex2f(x1,y1+dy);
	glEnd();
}

void TOpenGL::fillrrect_interp(greal x1, greal y1, greal dx, greal dy, int u1, int u2, int u3, int u4)
{
	glShadeModel(GL_SMOOTH);
	glBegin(GL_QUADS);
	setcolor(u1);
	glVertex2f(x1,y1);
	setcolor(u2);
	glVertex2f(x1+dx,y1);
	setcolor(u3);
	glVertex2f(x1+dx,y1+dy);
	setcolor(u4);
	glVertex2f(x1,y1+dy);
	glEnd();
	glShadeModel(GL_FLAT);
}

void TOpenGL::setpalette(const int pal1[3][Ncolors])
{
	int d,i;
	for (d=0; d<3; d++) for (i=0; i<Ncolors; i++) pal[d][i] = pal1[d][i];
}

void TOpenGL::gsave() {glPushAttrib(GL_ALL_ATTRIB_BITS);}
void TOpenGL::grestore() {glPopAttrib();}

TOpenGL::~TOpenGL()
{
}
