/* Copyright (C) 2000-2003  Thomas Bopp, Thorsten Hampel, Ludger Merkens, Martin Baehr
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
inherit "/classes/Object";

//! The Date class features some DATE specific attributes. Dates are
//! usually found inside Calendars.

#include <macros.h>
#include <classes.h>
#include <assert.h>
#include <database.h>
#include <exception.h>
#include <attributes.h>
#include <types.h>


int get_object_class()
{
    return ::get_object_class() | CLASS_DATE;
}

string execute(mapping variables)
{
  return "Date"; 
}

string describe()
{
  return "Date()";
}

bool match(int start, int end)
{
  if ( (do_query_attribute(DATE_START_DATE) >= start &&
	do_query_attribute(DATE_START_DATE) <= end ) ||
       (do_query_attribute(DATE_END_DATE) >= start &&
	do_query_attribute(DATE_END_DATE) <= end) ||
       ( start <= do_query_attribute(DATE_END_DATE) &&
	 end >= do_query_attribute(DATE_START_DATE)) )
    return true;
  return false;
}

bool match_time(int starttime, int endtime)
{
  if ( (do_query_attribute(DATE_START_TIME) >= starttime &&
	do_query_attribute(DATE_START_TIME) <= endtime) ||
       (do_query_attribute(DATE_END_TIME) >= starttime &&
	do_query_attribute(DATE_END_TIME) <= endtime) ||
       ( starttime <= do_query_attribute(DATE_END_TIME) &&
	 endtime >= do_query_attribute(DATE_START_TIME) ) )
    return true;
  return false;
}



