//============================================================================
//
//   SSSS    tt          lll  lll       
//  SS  SS   tt           ll   ll        
//  SS     tttttt  eeee   ll   ll   aaaa 
//   SSSS    tt   ee  ee  ll   ll      aa
//      SS   tt   eeeeee  ll   ll   aaaaa  --  "An Atari 2600 VCS Emulator"
//  SS  SS   tt   ee      ll   ll  aa  aa
//   SSSS     ttt  eeeee llll llll  aaaaa
//
// Copyright (c) 1995-2012 by Bradford W. Mott, Stephen Anthony
// and the Stella Team
//
// See the file "License.txt" for information on usage and redistribution of
// this file, and for a DISCLAIMER OF ALL WARRANTIES.
//
// $Id: StellaLargeFont.hxx 2318 2011-12-31 21:56:36Z stephena $
//
//   Based on code from ScummVM - Scumm Interpreter
//   Copyright (C) 2002-2004 The ScummVM project
//============================================================================

#ifndef STELLALARGE_FONT_DATA_HXX
#define STELLALARGE_FONT_DATA_HXX

#include "Font.hxx"
#include "bspf.hxx"

namespace GUI {

/* Font information:
   name: l_10x20
   facename: -Misc-Fixed-Medium-R-Normal--20-200-75-75-C-100-ISO8859-1
   w x h: 10x20
   bbx: 10 20 0 -4
   size: 95
   ascent: 16
   descent: 4
   first char: 32 (0x20)
   last char: 126 (0x7e)
   default char: 32 (0x20)
   proportional: no
   Public domain font.  Share and enjoy.
*/

/* Font character bitmap data. */
static const uInt16 _stellaLarge_font_bits[] = {

/* Character 32 (0x20):
   width 10
   bbx ( 10, 20, 0, -4 )

   +----------+
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   +----------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 33 (0x21):
   width 10
   bbx ( 10, 20, 0, -4 )

   +----------+
   |          |
   |          |
   |          |
   |    **    |
   |    **    |
   |    **    |
   |    **    |
   |    **    |
   |    **    |
   |    **    |
   |    **    |
   |    **    |
   |    **    |
   |          |
   |    **    |
   |    **    |
   |          |
   |          |
   |          |
   |          |
   +----------+
*/
0x0000,
0x0000,
0x0000,
0x0c00,
0x0c00,
0x0c00,
0x0c00,
0x0c00,
0x0c00,
0x0c00,
0x0c00,
0x0c00,
0x0c00,
0x0000,
0x0c00,
0x0c00,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 34 (0x22):
   width 10
   bbx ( 10, 20, 0, -4 )

   +----------+
   |          |
   |          |
   |          |
   |  **  **  |
   |  **  **  |
   |  **  **  |
   |   *  *   |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   +----------+
*/
0x0000,
0x0000,
0x0000,
0x3300,
0x3300,
0x3300,
0x1200,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 35 (0x23):
   width 10
   bbx ( 10, 20, 0, -4 )

   +----------+
   |          |
   |          |
   |          |
   |          |
   |    ** ** |
   |    ** ** |
   |    ** ** |
   |  ********|
   |   ** **  |
   |   ** **  |
   |   ** **  |
   | ******** |
   |  ** **   |
   |  ** **   |
   |  ** **   |
   |          |
   |          |
   |          |
   |          |
   |          |
   +----------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0d80,
0x0d80,
0x0d80,
0x3fc0,
0x1b00,
0x1b00,
0x1b00,
0x7f80,
0x3600,
0x3600,
0x3600,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 36 (0x24):
   width 10
   bbx ( 10, 20, 0, -4 )

   +----------+
   |          |
   |          |
   |          |
   |    **    |
   |  ******  |
   | ** ** ** |
   | ** **    |
   | ** **    |
   | ** **    |
   |  ******  |
   |    ** ** |
   |    ** ** |
   |    ** ** |
   | ** ** ** |
   |  ******  |
   |    **    |
   |          |
   |          |
   |          |
   |          |
   +----------+
*/
0x0000,
0x0000,
0x0000,
0x0c00,
0x3f00,
0x6d80,
0x6c00,
0x6c00,
0x6c00,
0x3f00,
0x0d80,
0x0d80,
0x0d80,
0x6d80,
0x3f00,
0x0c00,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 37 (0x25):
   width 10
   bbx ( 10, 20, 0, -4 )

   +----------+
   |          |
   |          |
   |          |
   |          |
   |  ***  ** |
   | ** ** ** |
   | ** ****  |
   |  *** **  |
   |     **   |
   |     **   |
   |    **    |
   |    **    |
   |   ** *** |
   |   **** **|
   |  ** ** **|
   |  **  *** |
   |          |
   |          |
   |          |
   |          |
   +----------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x3980,
0x6d80,
0x6f00,
0x3b00,
0x0600,
0x0600,
0x0c00,
0x0c00,
0x1b80,
0x1ec0,
0x36c0,
0x3380,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 38 (0x26):
   width 10
   bbx ( 10, 20, 0, -4 )

   +----------+
   |          |
   |          |
   |          |
   |   ***    |
   |  ** **   |
   |  ** **   |
   |  ** **   |
   |  ****    |
   |   **     |
   |  ***     |
   | ** **    |
   | **  ** **|
   | **   *** |
   | **   **  |
   | *** **** |
   |  ****  **|
   |          |
   |          |
   |          |
   |          |
   +----------+
*/
0x0000,
0x0000,
0x0000,
0x1c00,
0x3600,
0x3600,
0x3600,
0x3c00,
0x1800,
0x3800,
0x6c00,
0x66c0,
0x6380,
0x6300,
0x7780,
0x3cc0,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 39 (0x27):
   width 10
   bbx ( 10, 20, 0, -4 )

   +----------+
   |          |
   |          |
   |          |
   |    **    |
   |    **    |
   |    **    |
   |    **    |
   |    *     |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   +----------+
*/
0x0000,
0x0000,
0x0000,
0x0c00,
0x0c00,
0x0c00,
0x0c00,
0x0800,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 40 (0x28):
   width 10
   bbx ( 10, 20, 0, -4 )

   +----------+
   |          |
   |          |
   |          |
   |      **  |
   |     **   |
   |    **    |
   |    **    |
   |   **     |
   |   **     |
   |   **     |
   |   **     |
   |   **     |
   |    **    |
   |    **    |
   |     **   |
   |      **  |
   |          |
   |          |
   |          |
   |          |
   +----------+
*/
0x0000,
0x0000,
0x0000,
0x0300,
0x0600,
0x0c00,
0x0c00,
0x1800,
0x1800,
0x1800,
0x1800,
0x1800,
0x0c00,
0x0c00,
0x0600,
0x0300,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 41 (0x29):
   width 10
   bbx ( 10, 20, 0, -4 )

   +----------+
   |          |
   |          |
   |          |
   |  **      |
   |   **     |
   |    **    |
   |    **    |
   |     **   |
   |     **   |
   |     **   |
   |     **   |
   |     **   |
   |    **    |
   |    **    |
   |   **     |
   |  **      |
   |          |
   |          |
   |          |
   |          |
   +----------+
*/
0x0000,
0x0000,
0x0000,
0x3000,
0x1800,
0x0c00,
0x0c00,
0x0600,
0x0600,
0x0600,
0x0600,
0x0600,
0x0c00,
0x0c00,
0x1800,
0x3000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 42 (0x2a):
   width 10
   bbx ( 10, 20, 0, -4 )

   +----------+
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |  **  **  |
   |  **  **  |
   |   ****   |
   | ******** |
   |   ****   |
   |  **  **  |
   |  **  **  |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   +----------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x3300,
0x3300,
0x1e00,
0x7f80,
0x1e00,
0x3300,
0x3300,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 43 (0x2b):
   width 10
   bbx ( 10, 20, 0, -4 )

   +----------+
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |    **    |
   |    **    |
   |    **    |
   | ******** |
   |    **    |
   |    **    |
   |    **    |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   +----------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0c00,
0x0c00,
0x0c00,
0x7f80,
0x0c00,
0x0c00,
0x0c00,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 44 (0x2c):
   width 10
   bbx ( 10, 20, 0, -4 )

   +----------+
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |    ***   |
   |    ***   |
   |   ***    |
   |          |
   |          |
   |          |
   +----------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0e00,
0x0e00,
0x1c00,
0x0000,
0x0000,
0x0000,

/* Character 45 (0x2d):
   width 10
   bbx ( 10, 20, 0, -4 )

   +----------+
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   | ******** |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   +----------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x7f80,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 46 (0x2e):
   width 10
   bbx ( 10, 20, 0, -4 )

   +----------+
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |    ***   |
   |    ***   |
   |    ***   |
   |          |
   |          |
   |          |
   |          |
   +----------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0e00,
0x0e00,
0x0e00,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 47 (0x2f):
   width 10
   bbx ( 10, 20, 0, -4 )

   +----------+
   |          |
   |          |
   |          |
   |          |
   |       ** |
   |       ** |
   |      **  |
   |      **  |
   |     **   |
   |     **   |
   |    **    |
   |    **    |
   |   **     |
   |   **     |
   |  **      |
   |  **      |
   |          |
   |          |
   |          |
   |          |
   +----------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0180,
0x0180,
0x0300,
0x0300,
0x0600,
0x0600,
0x0c00,
0x0c00,
0x1800,
0x1800,
0x3000,
0x3000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 48 (0x30):
   width 10
   bbx ( 10, 20, 0, -4 )

   +----------+
   |          |
   |          |
   |          |
   |    **    |
   |   ****   |
   |  **  **  |
   |  **  **  |
   | **    ** |
   | **    ** |
   | **    ** |
   | **    ** |
   | **    ** |
   |  **  **  |
   |  **  **  |
   |   ****   |
   |    **    |
   |          |
   |          |
   |          |
   |          |
   +----------+
*/
0x0000,
0x0000,
0x0000,
0x0c00,
0x1e00,
0x3300,
0x3300,
0x6180,
0x6180,
0x6180,
0x6180,
0x6180,
0x3300,
0x3300,
0x1e00,
0x0c00,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 49 (0x31):
   width 10
   bbx ( 10, 20, 0, -4 )

   +----------+
   |          |
   |          |
   |          |
   |    **    |
   |   ***    |
   |  ****    |
   | ** **    |
   |    **    |
   |    **    |
   |    **    |
   |    **    |
   |    **    |
   |    **    |
   |    **    |
   |    **    |
   | ******** |
   |          |
   |          |
   |          |
   |          |
   +----------+
*/
0x0000,
0x0000,
0x0000,
0x0c00,
0x1c00,
0x3c00,
0x6c00,
0x0c00,
0x0c00,
0x0c00,
0x0c00,
0x0c00,
0x0c00,
0x0c00,
0x0c00,
0x7f80,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 50 (0x32):
   width 10
   bbx ( 10, 20, 0, -4 )

   +----------+
   |          |
   |          |
   |          |
   |   ****   |
   |  **  **  |
   | **    ** |
   | **    ** |
   |       ** |
   |       ** |
   |      **  |
   |    ***   |
   |   **     |
   |  **      |
   | **       |
   | **       |
   | ******** |
   |          |
   |          |
   |          |
   |          |
   +----------+
*/
0x0000,
0x0000,
0x0000,
0x1e00,
0x3300,
0x6180,
0x6180,
0x0180,
0x0180,
0x0300,
0x0e00,
0x1800,
0x3000,
0x6000,
0x6000,
0x7f80,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 51 (0x33):
   width 10
   bbx ( 10, 20, 0, -4 )

   +----------+
   |          |
   |          |
   |          |
   |   ****   |
   |  **  **  |
   | **    ** |
   | **    ** |
   |       ** |
   |      **  |
   |    ***   |
   |      **  |
   |       ** |
   | **    ** |
   | **    ** |
   |  **  **  |
   |   ****   |
   |          |
   |          |
   |          |
   |          |
   +----------+
*/
0x0000,
0x0000,
0x0000,
0x1e00,
0x3300,
0x6180,
0x6180,
0x0180,
0x0300,
0x0e00,
0x0300,
0x0180,
0x6180,
0x6180,
0x3300,
0x1e00,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 52 (0x34):
   width 10
   bbx ( 10, 20, 0, -4 )

   +----------+
   |          |
   |          |
   |          |
   |       *  |
   |      **  |
   |     ***  |
   |    ****  |
   |   ** **  |
   |  **  **  |
   | **   **  |
   | **   **  |
   | ******** |
   |      **  |
   |      **  |
   |      **  |
   |      **  |
   |          |
   |          |
   |          |
   |          |
   +----------+
*/
0x0000,
0x0000,
0x0000,
0x0100,
0x0300,
0x0700,
0x0f00,
0x1b00,
0x3300,
0x6300,
0x6300,
0x7f80,
0x0300,
0x0300,
0x0300,
0x0300,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 53 (0x35):
   width 10
   bbx ( 10, 20, 0, -4 )

   +----------+
   |          |
   |          |
   |          |
   | ******** |
   | **       |
   | **       |
   | **       |
   | **       |
   | ** ***   |
   | ***  **  |
   |       ** |
   |       ** |
   |       ** |
   | **    ** |
   |  **  **  |
   |   ****   |
   |          |
   |          |
   |          |
   |          |
   +----------+
*/
0x0000,
0x0000,
0x0000,
0x7f80,
0x6000,
0x6000,
0x6000,
0x6000,
0x6e00,
0x7300,
0x0180,
0x0180,
0x0180,
0x6180,
0x3300,
0x1e00,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 54 (0x36):
   width 10
   bbx ( 10, 20, 0, -4 )

   +----------+
   |          |
   |          |
   |          |
   |   ****   |
   |  **  **  |
   | **    *  |
   | **       |
   | **       |
   | ** ***   |
   | ***  **  |
   | **    ** |
   | **    ** |
   | **    ** |
   | **    ** |
   |  **  **  |
   |   ****   |
   |          |
   |          |
   |          |
   |          |
   +----------+
*/
0x0000,
0x0000,
0x0000,
0x1e00,
0x3300,
0x6100,
0x6000,
0x6000,
0x6e00,
0x7300,
0x6180,
0x6180,
0x6180,
0x6180,
0x3300,
0x1e00,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 55 (0x37):
   width 10
   bbx ( 10, 20, 0, -4 )

   +----------+
   |          |
   |          |
   |          |
   | ******** |
   |       ** |
   |       ** |
   |      **  |
   |      **  |
   |     **   |
   |     **   |
   |    **    |
   |    **    |
   |   **     |
   |   **     |
   |  **      |
   |  **      |
   |          |
   |          |
   |          |
   |          |
   +----------+
*/
0x0000,
0x0000,
0x0000,
0x7f80,
0x0180,
0x0180,
0x0300,
0x0300,
0x0600,
0x0600,
0x0c00,
0x0c00,
0x1800,
0x1800,
0x3000,
0x3000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 56 (0x38):
   width 10
   bbx ( 10, 20, 0, -4 )

   +----------+
   |          |
   |          |
   |          |
   |   ****   |
   |  **  **  |
   | **    ** |
   | **    ** |
   | **    ** |
   |  **  **  |
   |   ****   |
   |  **  **  |
   | **    ** |
   | **    ** |
   | **    ** |
   |  **  **  |
   |   ****   |
   |          |
   |          |
   |          |
   |          |
   +----------+
*/
0x0000,
0x0000,
0x0000,
0x1e00,
0x3300,
0x6180,
0x6180,
0x6180,
0x3300,
0x1e00,
0x3300,
0x6180,
0x6180,
0x6180,
0x3300,
0x1e00,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 57 (0x39):
   width 10
   bbx ( 10, 20, 0, -4 )

   +----------+
   |          |
   |          |
   |          |
   |   ****   |
   |  **  **  |
   | **    ** |
   | **    ** |
   | **    ** |
   | **    ** |
   |  **  *** |
   |   *** ** |
   |       ** |
   |       ** |
   |  *    ** |
   |  **  **  |
   |   ****   |
   |          |
   |          |
   |          |
   |          |
   +----------+
*/
0x0000,
0x0000,
0x0000,
0x1e00,
0x3300,
0x6180,
0x6180,
0x6180,
0x6180,
0x3380,
0x1d80,
0x0180,
0x0180,
0x2180,
0x3300,
0x1e00,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 58 (0x3a):
   width 10
   bbx ( 10, 20, 0, -4 )

   +----------+
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |    ***   |
   |    ***   |
   |          |
   |          |
   |          |
   |          |
   |    ***   |
   |    ***   |
   |          |
   |          |
   |          |
   |          |
   +----------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0e00,
0x0e00,
0x0000,
0x0000,
0x0000,
0x0000,
0x0e00,
0x0e00,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 59 (0x3b):
   width 10
   bbx ( 10, 20, 0, -4 )

   +----------+
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |    ***   |
   |    ***   |
   |          |
   |          |
   |          |
   |          |
   |    ***   |
   |    ***   |
   |   ***    |
   |          |
   |          |
   |          |
   +----------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0e00,
0x0e00,
0x0000,
0x0000,
0x0000,
0x0000,
0x0e00,
0x0e00,
0x1c00,
0x0000,
0x0000,
0x0000,

/* Character 60 (0x3c):
   width 10
   bbx ( 10, 20, 0, -4 )

   +----------+
   |          |
   |          |
   |          |
   |       *  |
   |      **  |
   |     **   |
   |    **    |
   |   **     |
   |  **      |
   | **       |
   |  **      |
   |   **     |
   |    **    |
   |     **   |
   |      **  |
   |       *  |
   |          |
   |          |
   |          |
   |          |
   +----------+
*/
0x0000,
0x0000,
0x0000,
0x0100,
0x0300,
0x0600,
0x0c00,
0x1800,
0x3000,
0x6000,
0x3000,
0x1800,
0x0c00,
0x0600,
0x0300,
0x0100,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 61 (0x3d):
   width 10
   bbx ( 10, 20, 0, -4 )

   +----------+
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   | ******** |
   |          |
   |          |
   |          |
   |          |
   | ******** |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   +----------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x7f80,
0x0000,
0x0000,
0x0000,
0x0000,
0x7f80,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 62 (0x3e):
   width 10
   bbx ( 10, 20, 0, -4 )

   +----------+
   |          |
   |          |
   |          |
   |  *       |
   |  **      |
   |   **     |
   |    **    |
   |     **   |
   |      **  |
   |       ** |
   |      **  |
   |     **   |
   |    **    |
   |   **     |
   |  **      |
   |  *       |
   |          |
   |          |
   |          |
   |          |
   +----------+
*/
0x0000,
0x0000,
0x0000,
0x2000,
0x3000,
0x1800,
0x0c00,
0x0600,
0x0300,
0x0180,
0x0300,
0x0600,
0x0c00,
0x1800,
0x3000,
0x2000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 63 (0x3f):
   width 10
   bbx ( 10, 20, 0, -4 )

   +----------+
   |          |
   |          |
   |          |
   |   ****   |
   |  **  **  |
   | **    ** |
   | **    ** |
   | **    ** |
   |      **  |
   |     **   |
   |    **    |
   |    **    |
   |    **    |
   |          |
   |    **    |
   |    **    |
   |          |
   |          |
   |          |
   |          |
   +----------+
*/
0x0000,
0x0000,
0x0000,
0x1e00,
0x3300,
0x6180,
0x6180,
0x6180,
0x0300,
0x0600,
0x0c00,
0x0c00,
0x0c00,
0x0000,
0x0c00,
0x0c00,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 64 (0x40):
   width 10
   bbx ( 10, 20, 0, -4 )

   +----------+
   |          |
   |          |
   |          |
   |   ****   |
   |  **  **  |
   | **    ** |
   | **  **** |
   | ** ***** |
   | ** ** ** |
   | ** ** ** |
   | ** ** ** |
   | ** ****  |
   | **  **   |
   | **       |
   |  **   ** |
   |   *****  |
   |          |
   |          |
   |          |
   |          |
   +----------+
*/
0x0000,
0x0000,
0x0000,
0x1e00,
0x3300,
0x6180,
0x6780,
0x6f80,
0x6d80,
0x6d80,
0x6d80,
0x6f00,
0x6600,
0x6000,
0x3180,
0x1f00,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 65 (0x41):
   width 10
   bbx ( 10, 20, 0, -4 )

   +----------+
   |          |
   |          |
   |          |
   |    **    |
   |   ****   |
   |  **  **  |
   |  **  **  |
   | **    ** |
   | **    ** |
   | **    ** |
   | ******** |
   | **    ** |
   | **    ** |
   | **    ** |
   | **    ** |
   | **    ** |
   |          |
   |          |
   |          |
   |          |
   +----------+
*/
0x0000,
0x0000,
0x0000,
0x0c00,
0x1e00,
0x3300,
0x3300,
0x6180,
0x6180,
0x6180,
0x7f80,
0x6180,
0x6180,
0x6180,
0x6180,
0x6180,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 66 (0x42):
   width 10
   bbx ( 10, 20, 0, -4 )

   +----------+
   |          |
   |          |
   |          |
   | *****    |
   | **  **   |
   | **   **  |
   | **   **  |
   | **   **  |
   | **  **   |
   | ******   |
   | **   **  |
   | **    ** |
   | **    ** |
   | **    ** |
   | **   **  |
   | ******   |
   |          |
   |          |
   |          |
   |          |
   +----------+
*/
0x0000,
0x0000,
0x0000,
0x7c00,
0x6600,
0x6300,
0x6300,
0x6300,
0x6600,
0x7e00,
0x6300,
0x6180,
0x6180,
0x6180,
0x6300,
0x7e00,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 67 (0x43):
   width 10
   bbx ( 10, 20, 0, -4 )

   +----------+
   |          |
   |          |
   |          |
   |   ****   |
   |  **  **  |
   | **    ** |
   | **       |
   | **       |
   | **       |
   | **       |
   | **       |
   | **       |
   | **       |
   | **    ** |
   |  **  **  |
   |   ****   |
   |          |
   |          |
   |          |
   |          |
   +----------+
*/
0x0000,
0x0000,
0x0000,
0x1e00,
0x3300,
0x6180,
0x6000,
0x6000,
0x6000,
0x6000,
0x6000,
0x6000,
0x6000,
0x6180,
0x3300,
0x1e00,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 68 (0x44):
   width 10
   bbx ( 10, 20, 0, -4 )

   +----------+
   |          |
   |          |
   |          |
   | ******   |
   | **   **  |
   | **    ** |
   | **    ** |
   | **    ** |
   | **    ** |
   | **    ** |
   | **    ** |
   | **    ** |
   | **    ** |
   | **    ** |
   | **   **  |
   | ******   |
   |          |
   |          |
   |          |
   |          |
   +----------+
*/
0x0000,
0x0000,
0x0000,
0x7e00,
0x6300,
0x6180,
0x6180,
0x6180,
0x6180,
0x6180,
0x6180,
0x6180,
0x6180,
0x6180,
0x6300,
0x7e00,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 69 (0x45):
   width 10
   bbx ( 10, 20, 0, -4 )

   +----------+
   |          |
   |          |
   |          |
   | ******** |
   | **       |
   | **       |
   | **       |
   | **       |
   | **       |
   | ******   |
   | **       |
   | **       |
   | **       |
   | **       |
   | **       |
   | ******** |
   |          |
   |          |
   |          |
   |          |
   +----------+
*/
0x0000,
0x0000,
0x0000,
0x7f80,
0x6000,
0x6000,
0x6000,
0x6000,
0x6000,
0x7e00,
0x6000,
0x6000,
0x6000,
0x6000,
0x6000,
0x7f80,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 70 (0x46):
   width 10
   bbx ( 10, 20, 0, -4 )

   +----------+
   |          |
   |          |
   |          |
   | ******** |
   | **       |
   | **       |
   | **       |
   | **       |
   | **       |
   | ******   |
   | **       |
   | **       |
   | **       |
   | **       |
   | **       |
   | **       |
   |          |
   |          |
   |          |
   |          |
   +----------+
*/
0x0000,
0x0000,
0x0000,
0x7f80,
0x6000,
0x6000,
0x6000,
0x6000,
0x6000,
0x7e00,
0x6000,
0x6000,
0x6000,
0x6000,
0x6000,
0x6000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 71 (0x47):
   width 10
   bbx ( 10, 20, 0, -4 )

   +----------+
   |          |
   |          |
   |          |
   |   ****   |
   |  **  **  |
   | **    ** |
   | **       |
   | **       |
   | **       |
   | **  **** |
   | **    ** |
   | **    ** |
   | **    ** |
   | **    ** |
   |  **  *** |
   |   **** * |
   |          |
   |          |
   |          |
   |          |
   +----------+
*/
0x0000,
0x0000,
0x0000,
0x1e00,
0x3300,
0x6180,
0x6000,
0x6000,
0x6000,
0x6780,
0x6180,
0x6180,
0x6180,
0x6180,
0x3380,
0x1e80,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 72 (0x48):
   width 10
   bbx ( 10, 20, 0, -4 )

   +----------+
   |          |
   |          |
   |          |
   | **    ** |
   | **    ** |
   | **    ** |
   | **    ** |
   | **    ** |
   | **    ** |
   | ******** |
   | **    ** |
   | **    ** |
   | **    ** |
   | **    ** |
   | **    ** |
   | **    ** |
   |          |
   |          |
   |          |
   |          |
   +----------+
*/
0x0000,
0x0000,
0x0000,
0x6180,
0x6180,
0x6180,
0x6180,
0x6180,
0x6180,
0x7f80,
0x6180,
0x6180,
0x6180,
0x6180,
0x6180,
0x6180,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 73 (0x49):
   width 10
   bbx ( 10, 20, 0, -4 )

   +----------+
   |          |
   |          |
   |          |
   | ******** |
   |    **    |
   |    **    |
   |    **    |
   |    **    |
   |    **    |
   |    **    |
   |    **    |
   |    **    |
   |    **    |
   |    **    |
   |    **    |
   | ******** |
   |          |
   |          |
   |          |
   |          |
   +----------+
*/
0x0000,
0x0000,
0x0000,
0x7f80,
0x0c00,
0x0c00,
0x0c00,
0x0c00,
0x0c00,
0x0c00,
0x0c00,
0x0c00,
0x0c00,
0x0c00,
0x0c00,
0x7f80,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 74 (0x4a):
   width 10
   bbx ( 10, 20, 0, -4 )

   +----------+
   |          |
   |          |
   |          |
   |    ******|
   |      **  |
   |      **  |
   |      **  |
   |      **  |
   |      **  |
   |      **  |
   |      **  |
   |      **  |
   | **   **  |
   | **   **  |
   |  ** **   |
   |   ***    |
   |          |
   |          |
   |          |
   |          |
   +----------+
*/
0x0000,
0x0000,
0x0000,
0x0fc0,
0x0300,
0x0300,
0x0300,
0x0300,
0x0300,
0x0300,
0x0300,
0x0300,
0x6300,
0x6300,
0x3600,
0x1c00,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 75 (0x4b):
   width 10
   bbx ( 10, 20, 0, -4 )

   +----------+
   |          |
   |          |
   |          |
   | **    ** |
   | **    ** |
   | **   **  |
   | **   **  |
   | **  **   |
   | **  **   |
   | *****    |
   | **  **   |
   | **  **   |
   | **   **  |
   | **   **  |
   | **    ** |
   | **    ** |
   |          |
   |          |
   |          |
   |          |
   +----------+
*/
0x0000,
0x0000,
0x0000,
0x6180,
0x6180,
0x6300,
0x6300,
0x6600,
0x6600,
0x7c00,
0x6600,
0x6600,
0x6300,
0x6300,
0x6180,
0x6180,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 76 (0x4c):
   width 10
   bbx ( 10, 20, 0, -4 )

   +----------+
   |          |
   |          |
   |          |
   | **       |
   | **       |
   | **       |
   | **       |
   | **       |
   | **       |
   | **       |
   | **       |
   | **       |
   | **       |
   | **       |
   | **       |
   | ******** |
   |          |
   |          |
   |          |
   |          |
   +----------+
*/
0x0000,
0x0000,
0x0000,
0x6000,
0x6000,
0x6000,
0x6000,
0x6000,
0x6000,
0x6000,
0x6000,
0x6000,
0x6000,
0x6000,
0x6000,
0x7f80,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 77 (0x4d):
   width 10
   bbx ( 10, 20, 0, -4 )

   +----------+
   |          |
   |          |
   |          |
   | **    ** |
   | **    ** |
   | ***  *** |
   | ***  *** |
   | ******** |
   | ** ** ** |
   | ** ** ** |
   | ** ** ** |
   | ** ** ** |
   | **    ** |
   | **    ** |
   | **    ** |
   | **    ** |
   |          |
   |          |
   |          |
   |          |
   +----------+
*/
0x0000,
0x0000,
0x0000,
0x6180,
0x6180,
0x7380,
0x7380,
0x7f80,
0x6d80,
0x6d80,
0x6d80,
0x6d80,
0x6180,
0x6180,
0x6180,
0x6180,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 78 (0x4e):
   width 10
   bbx ( 10, 20, 0, -4 )

   +----------+
   |          |
   |          |
   |          |
   | **    ** |
   | ***   ** |
   | ***   ** |
   | ****  ** |
   | ****  ** |
   | ** ** ** |
   | ** ** ** |
   | **  **** |
   | **  **** |
   | **   *** |
   | **   *** |
   | **    ** |
   | **    ** |
   |          |
   |          |
   |          |
   |          |
   +----------+
*/
0x0000,
0x0000,
0x0000,
0x6180,
0x7180,
0x7180,
0x7980,
0x7980,
0x6d80,
0x6d80,
0x6780,
0x6780,
0x6380,
0x6380,
0x6180,
0x6180,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 79 (0x4f):
   width 10
   bbx ( 10, 20, 0, -4 )

   +----------+
   |          |
   |          |
   |          |
   |   ****   |
   |  **  **  |
   | **    ** |
   | **    ** |
   | **    ** |
   | **    ** |
   | **    ** |
   | **    ** |
   | **    ** |
   | **    ** |
   | **    ** |
   |  **  **  |
   |   ****   |
   |          |
   |          |
   |          |
   |          |
   +----------+
*/
0x0000,
0x0000,
0x0000,
0x1e00,
0x3300,
0x6180,
0x6180,
0x6180,
0x6180,
0x6180,
0x6180,
0x6180,
0x6180,
0x6180,
0x3300,
0x1e00,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 80 (0x50):
   width 10
   bbx ( 10, 20, 0, -4 )

   +----------+
   |          |
   |          |
   |          |
   | ******   |
   | **   **  |
   | **    ** |
   | **    ** |
   | **    ** |
   | **    ** |
   | **   **  |
   | ******   |
   | **       |
   | **       |
   | **       |
   | **       |
   | **       |
   |          |
   |          |
   |          |
   |          |
   +----------+
*/
0x0000,
0x0000,
0x0000,
0x7e00,
0x6300,
0x6180,
0x6180,
0x6180,
0x6180,
0x6300,
0x7e00,
0x6000,
0x6000,
0x6000,
0x6000,
0x6000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 81 (0x51):
   width 10
   bbx ( 10, 20, 0, -4 )

   +----------+
   |          |
   |          |
   |          |
   |   ****   |
   |  **  **  |
   | **    ** |
   | **    ** |
   | **    ** |
   | **    ** |
   | **    ** |
   | **    ** |
   | **    ** |
   | ** ** ** |
   | **  **** |
   |  **  **  |
   |   *****  |
   |       ** |
   |          |
   |          |
   |          |
   +----------+
*/
0x0000,
0x0000,
0x0000,
0x1e00,
0x3300,
0x6180,
0x6180,
0x6180,
0x6180,
0x6180,
0x6180,
0x6180,
0x6d80,
0x6780,
0x3300,
0x1f00,
0x0180,
0x0000,
0x0000,
0x0000,

/* Character 82 (0x52):
   width 10
   bbx ( 10, 20, 0, -4 )

   +----------+
   |          |
   |          |
   |          |
   | ******   |
   | **   **  |
   | **    ** |
   | **    ** |
   | **    ** |
   | **    ** |
   | **   **  |
   | ******   |
   | **  **   |
   | **   **  |
   | **   **  |
   | **    ** |
   | **    ** |
   |          |
   |          |
   |          |
   |          |
   +----------+
*/
0x0000,
0x0000,
0x0000,
0x7e00,
0x6300,
0x6180,
0x6180,
0x6180,
0x6180,
0x6300,
0x7e00,
0x6600,
0x6300,
0x6300,
0x6180,
0x6180,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 83 (0x53):
   width 10
   bbx ( 10, 20, 0, -4 )

   +----------+
   |          |
   |          |
   |          |
   |   ****   |
   |  **  **  |
   | **    ** |
   | **       |
   | **       |
   |  **      |
   |   ****   |
   |      **  |
   |       ** |
   |       ** |
   | **    ** |
   |  **  **  |
   |   ****   |
   |          |
   |          |
   |          |
   |          |
   +----------+
*/
0x0000,
0x0000,
0x0000,
0x1e00,
0x3300,
0x6180,
0x6000,
0x6000,
0x3000,
0x1e00,
0x0300,
0x0180,
0x0180,
0x6180,
0x3300,
0x1e00,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 84 (0x54):
   width 10
   bbx ( 10, 20, 0, -4 )

   +----------+
   |          |
   |          |
   |          |
   | ******** |
   |    **    |
   |    **    |
   |    **    |
   |    **    |
   |    **    |
   |    **    |
   |    **    |
   |    **    |
   |    **    |
   |    **    |
   |    **    |
   |    **    |
   |          |
   |          |
   |          |
   |          |
   +----------+
*/
0x0000,
0x0000,
0x0000,
0x7f80,
0x0c00,
0x0c00,
0x0c00,
0x0c00,
0x0c00,
0x0c00,
0x0c00,
0x0c00,
0x0c00,
0x0c00,
0x0c00,
0x0c00,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 85 (0x55):
   width 10
   bbx ( 10, 20, 0, -4 )

   +----------+
   |          |
   |          |
   |          |
   | **    ** |
   | **    ** |
   | **    ** |
   | **    ** |
   | **    ** |
   | **    ** |
   | **    ** |
   | **    ** |
   | **    ** |
   | **    ** |
   | **    ** |
   |  **  **  |
   |   ****   |
   |          |
   |          |
   |          |
   |          |
   +----------+
*/
0x0000,
0x0000,
0x0000,
0x6180,
0x6180,
0x6180,
0x6180,
0x6180,
0x6180,
0x6180,
0x6180,
0x6180,
0x6180,
0x6180,
0x3300,
0x1e00,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 86 (0x56):
   width 10
   bbx ( 10, 20, 0, -4 )

   +----------+
   |          |
   |          |
   |          |
   | **    ** |
   | **    ** |
   | **    ** |
   | **    ** |
   |  **  **  |
   |  **  **  |
   |  **  **  |
   |   ****   |
   |   ****   |
   |   ****   |
   |    **    |
   |    **    |
   |    **    |
   |          |
   |          |
   |          |
   |          |
   +----------+
*/
0x0000,
0x0000,
0x0000,
0x6180,
0x6180,
0x6180,
0x6180,
0x3300,
0x3300,
0x3300,
0x1e00,
0x1e00,
0x1e00,
0x0c00,
0x0c00,
0x0c00,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 87 (0x57):
   width 10
   bbx ( 10, 20, 0, -4 )

   +----------+
   |          |
   |          |
   |          |
   | **    ** |
   | **    ** |
   | **    ** |
   | **    ** |
   | **    ** |
   | ** ** ** |
   | ** ** ** |
   | ** ** ** |
   | ** ** ** |
   | ***  *** |
   | ***  *** |
   | **    ** |
   | **    ** |
   |          |
   |          |
   |          |
   |          |
   +----------+
*/
0x0000,
0x0000,
0x0000,
0x6180,
0x6180,
0x6180,
0x6180,
0x6180,
0x6d80,
0x6d80,
0x6d80,
0x6d80,
0x7380,
0x7380,
0x6180,
0x6180,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 88 (0x58):
   width 10
   bbx ( 10, 20, 0, -4 )

   +----------+
   |          |
   |          |
   |          |
   | **    ** |
   | **    ** |
   |  **  **  |
   |  **  **  |
   |   ****   |
   |   ****   |
   |    **    |
   |   ****   |
   |   ****   |
   |  **  **  |
   |  **  **  |
   | **    ** |
   | **    ** |
   |          |
   |          |
   |          |
   |          |
   +----------+
*/
0x0000,
0x0000,
0x0000,
0x6180,
0x6180,
0x3300,
0x3300,
0x1e00,
0x1e00,
0x0c00,
0x1e00,
0x1e00,
0x3300,
0x3300,
0x6180,
0x6180,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 89 (0x59):
   width 10
   bbx ( 10, 20, 0, -4 )

   +----------+
   |          |
   |          |
   |          |
   | **    ** |
   | **    ** |
   |  **  **  |
   |  **  **  |
   |   ****   |
   |   ****   |
   |    **    |
   |    **    |
   |    **    |
   |    **    |
   |    **    |
   |    **    |
   |    **    |
   |          |
   |          |
   |          |
   |          |
   +----------+
*/
0x0000,
0x0000,
0x0000,
0x6180,
0x6180,
0x3300,
0x3300,
0x1e00,
0x1e00,
0x0c00,
0x0c00,
0x0c00,
0x0c00,
0x0c00,
0x0c00,
0x0c00,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 90 (0x5a):
   width 10
   bbx ( 10, 20, 0, -4 )

   +----------+
   |          |
   |          |
   |          |
   | ******** |
   |       ** |
   |       ** |
   |      **  |
   |     **   |
   |     **   |
   |    **    |
   |   **     |
   |   **     |
   |  **      |
   | **       |
   | **       |
   | ******** |
   |          |
   |          |
   |          |
   |          |
   +----------+
*/
0x0000,
0x0000,
0x0000,
0x7f80,
0x0180,
0x0180,
0x0300,
0x0600,
0x0600,
0x0c00,
0x1800,
0x1800,
0x3000,
0x6000,
0x6000,
0x7f80,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 91 (0x5b):
   width 10
   bbx ( 10, 20, 0, -4 )

   +----------+
   |          |
   |          |
   |          |
   |  ******  |
   |  **      |
   |  **      |
   |  **      |
   |  **      |
   |  **      |
   |  **      |
   |  **      |
   |  **      |
   |  **      |
   |  **      |
   |  **      |
   |  ******  |
   |          |
   |          |
   |          |
   |          |
   +----------+
*/
0x0000,
0x0000,
0x0000,
0x3f00,
0x3000,
0x3000,
0x3000,
0x3000,
0x3000,
0x3000,
0x3000,
0x3000,
0x3000,
0x3000,
0x3000,
0x3f00,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 92 (0x5c):
   width 10
   bbx ( 10, 20, 0, -4 )

   +----------+
   |          |
   |          |
   |          |
   |          |
   |  **      |
   |  **      |
   |   **     |
   |   **     |
   |    **    |
   |    **    |
   |     **   |
   |     **   |
   |      **  |
   |      **  |
   |       ** |
   |       ** |
   |          |
   |          |
   |          |
   |          |
   +----------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x3000,
0x3000,
0x1800,
0x1800,
0x0c00,
0x0c00,
0x0600,
0x0600,
0x0300,
0x0300,
0x0180,
0x0180,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 93 (0x5d):
   width 10
   bbx ( 10, 20, 0, -4 )

   +----------+
   |          |
   |          |
   |          |
   |  ******  |
   |      **  |
   |      **  |
   |      **  |
   |      **  |
   |      **  |
   |      **  |
   |      **  |
   |      **  |
   |      **  |
   |      **  |
   |      **  |
   |  ******  |
   |          |
   |          |
   |          |
   |          |
   +----------+
*/
0x0000,
0x0000,
0x0000,
0x3f00,
0x0300,
0x0300,
0x0300,
0x0300,
0x0300,
0x0300,
0x0300,
0x0300,
0x0300,
0x0300,
0x0300,
0x3f00,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 94 (0x5e):
   width 10
   bbx ( 10, 20, 0, -4 )

   +----------+
   |          |
   |          |
   |          |
   |    **    |
   |   ****   |
   |  **  **  |
   | **    ** |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   +----------+
*/
0x0000,
0x0000,
0x0000,
0x0c00,
0x1e00,
0x3300,
0x6180,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 95 (0x5f):
   width 10
   bbx ( 10, 20, 0, -4 )

   +----------+
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   | *********|
   |          |
   |          |
   |          |
   +----------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x7fc0,
0x0000,
0x0000,
0x0000,

/* Character 96 (0x60):
   width 10
   bbx ( 10, 20, 0, -4 )

   +----------+
   |          |
   |          |
   |          |
   |   **     |
   |    **    |
   |     **   |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   +----------+
*/
0x0000,
0x0000,
0x0000,
0x1800,
0x0c00,
0x0600,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 97 (0x61):
   width 10
   bbx ( 10, 20, 0, -4 )

   +----------+
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |   *****  |
   |  **   ** |
   |       ** |
   |  ******* |
   | **    ** |
   | **    ** |
   | **    ** |
   |  ***** * |
   |          |
   |          |
   |          |
   |          |
   +----------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x1f00,
0x3180,
0x0180,
0x3f80,
0x6180,
0x6180,
0x6180,
0x3e80,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 98 (0x62):
   width 10
   bbx ( 10, 20, 0, -4 )

   +----------+
   |          |
   |          |
   |          |
   | **       |
   | **       |
   | **       |
   | **       |
   | **       |
   | ** ***   |
   | ***  **  |
   | **    ** |
   | **    ** |
   | **    ** |
   | **    ** |
   | ***  **  |
   | ** ***   |
   |          |
   |          |
   |          |
   |          |
   +----------+
*/
0x0000,
0x0000,
0x0000,
0x6000,
0x6000,
0x6000,
0x6000,
0x6000,
0x6e00,
0x7300,
0x6180,
0x6180,
0x6180,
0x6180,
0x7300,
0x6e00,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 99 (0x63):
   width 10
   bbx ( 10, 20, 0, -4 )

   +----------+
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |   *****  |
   |  **   ** |
   | **       |
   | **       |
   | **       |
   | **       |
   |  **   ** |
   |   *****  |
   |          |
   |          |
   |          |
   |          |
   +----------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x1f00,
0x3180,
0x6000,
0x6000,
0x6000,
0x6000,
0x3180,
0x1f00,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 100 (0x64):
   width 10
   bbx ( 10, 20, 0, -4 )

   +----------+
   |          |
   |          |
   |          |
   |       ** |
   |       ** |
   |       ** |
   |       ** |
   |       ** |
   |   *** ** |
   |  **  *** |
   | **    ** |
   | **    ** |
   | **    ** |
   | **    ** |
   |  **  *** |
   |   *** ** |
   |          |
   |          |
   |          |
   |          |
   +----------+
*/
0x0000,
0x0000,
0x0000,
0x0180,
0x0180,
0x0180,
0x0180,
0x0180,
0x1d80,
0x3380,
0x6180,
0x6180,
0x6180,
0x6180,
0x3380,
0x1d80,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 101 (0x65):
   width 10
   bbx ( 10, 20, 0, -4 )

   +----------+
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |   ****   |
   |  **  **  |
   | **    ** |
   | ******** |
   | **       |
   | **       |
   |  **   ** |
   |   *****  |
   |          |
   |          |
   |          |
   |          |
   +----------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x1e00,
0x3300,
0x6180,
0x7f80,
0x6000,
0x6000,
0x3180,
0x1f00,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 102 (0x66):
   width 10
   bbx ( 10, 20, 0, -4 )

   +----------+
   |          |
   |          |
   |          |
   |    ****  |
   |   **  ** |
   |   **  ** |
   |   **     |
   |   **     |
   | ******   |
   |   **     |
   |   **     |
   |   **     |
   |   **     |
   |   **     |
   |   **     |
   |   **     |
   |          |
   |          |
   |          |
   |          |
   +----------+
*/
0x0000,
0x0000,
0x0000,
0x0f00,
0x1980,
0x1980,
0x1800,
0x1800,
0x7e00,
0x1800,
0x1800,
0x1800,
0x1800,
0x1800,
0x1800,
0x1800,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 103 (0x67):
   width 10
   bbx ( 10, 20, 0, -4 )

   +----------+
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |  ***** * |
   | **   *** |
   | **   **  |
   | **   **  |
   | **   **  |
   |  *****   |
   | **       |
   |  ******  |
   | **    ** |
   | **    ** |
   | **    ** |
   |  ******  |
   +----------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x3e80,
0x6380,
0x6300,
0x6300,
0x6300,
0x3e00,
0x6000,
0x3f00,
0x6180,
0x6180,
0x6180,
0x3f00,

/* Character 104 (0x68):
   width 10
   bbx ( 10, 20, 0, -4 )

   +----------+
   |          |
   |          |
   |          |
   | **       |
   | **       |
   | **       |
   | **       |
   | **       |
   | ** ***   |
   | ***  **  |
   | **    ** |
   | **    ** |
   | **    ** |
   | **    ** |
   | **    ** |
   | **    ** |
   |          |
   |          |
   |          |
   |          |
   +----------+
*/
0x0000,
0x0000,
0x0000,
0x6000,
0x6000,
0x6000,
0x6000,
0x6000,
0x6e00,
0x7300,
0x6180,
0x6180,
0x6180,
0x6180,
0x6180,
0x6180,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 105 (0x69):
   width 10
   bbx ( 10, 20, 0, -4 )

   +----------+
   |          |
   |          |
   |          |
   |          |
   |          |
   |    **    |
   |    **    |
   |          |
   |  ****    |
   |    **    |
   |    **    |
   |    **    |
   |    **    |
   |    **    |
   |    **    |
   | ******** |
   |          |
   |          |
   |          |
   |          |
   +----------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0c00,
0x0c00,
0x0000,
0x3c00,
0x0c00,
0x0c00,
0x0c00,
0x0c00,
0x0c00,
0x0c00,
0x7f80,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 106 (0x6a):
   width 10
   bbx ( 10, 20, 0, -4 )

   +----------+
   |          |
   |          |
   |          |
   |          |
   |          |
   |       ** |
   |       ** |
   |          |
   |     **** |
   |       ** |
   |       ** |
   |       ** |
   |       ** |
   |       ** |
   |       ** |
   |       ** |
   |  **   ** |
   |  **   ** |
   |  **   ** |
   |   *****  |
   +----------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0180,
0x0180,
0x0000,
0x0780,
0x0180,
0x0180,
0x0180,
0x0180,
0x0180,
0x0180,
0x0180,
0x3180,
0x3180,
0x3180,
0x1f00,

/* Character 107 (0x6b):
   width 10
   bbx ( 10, 20, 0, -4 )

   +----------+
   |          |
   |          |
   |          |
   | **       |
   | **       |
   | **       |
   | **       |
   | **       |
   | **   **  |
   | **  **   |
   | ** **    |
   | ****     |
   | *****    |
   | **  **   |
   | **   **  |
   | **    ** |
   |          |
   |          |
   |          |
   |          |
   +----------+
*/
0x0000,
0x0000,
0x0000,
0x6000,
0x6000,
0x6000,
0x6000,
0x6000,
0x6300,
0x6600,
0x6c00,
0x7800,
0x7c00,
0x6600,
0x6300,
0x6180,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 108 (0x6c):
   width 10
   bbx ( 10, 20, 0, -4 )

   +----------+
   |          |
   |          |
   |          |
   |  ****    |
   |    **    |
   |    **    |
   |    **    |
   |    **    |
   |    **    |
   |    **    |
   |    **    |
   |    **    |
   |    **    |
   |    **    |
   |    **    |
   | ******** |
   |          |
   |          |
   |          |
   |          |
   +----------+
*/
0x0000,
0x0000,
0x0000,
0x3c00,
0x0c00,
0x0c00,
0x0c00,
0x0c00,
0x0c00,
0x0c00,
0x0c00,
0x0c00,
0x0c00,
0x0c00,
0x0c00,
0x7f80,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 109 (0x6d):
   width 10
   bbx ( 10, 20, 0, -4 )

   +----------+
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   | * ** **  |
   | ******** |
   | ** ** ** |
   | ** ** ** |
   | ** ** ** |
   | ** ** ** |
   | ** ** ** |
   | ** ** ** |
   |          |
   |          |
   |          |
   |          |
   +----------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x5b00,
0x7f80,
0x6d80,
0x6d80,
0x6d80,
0x6d80,
0x6d80,
0x6d80,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 110 (0x6e):
   width 10
   bbx ( 10, 20, 0, -4 )

   +----------+
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   | ** ***   |
   | ***  **  |
   | **    ** |
   | **    ** |
   | **    ** |
   | **    ** |
   | **    ** |
   | **    ** |
   |          |
   |          |
   |          |
   |          |
   +----------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x6e00,
0x7300,
0x6180,
0x6180,
0x6180,
0x6180,
0x6180,
0x6180,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 111 (0x6f):
   width 10
   bbx ( 10, 20, 0, -4 )

   +----------+
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |   ****   |
   |  **  **  |
   | **    ** |
   | **    ** |
   | **    ** |
   | **    ** |
   |  **  **  |
   |   ****   |
   |          |
   |          |
   |          |
   |          |
   +----------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x1e00,
0x3300,
0x6180,
0x6180,
0x6180,
0x6180,
0x3300,
0x1e00,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 112 (0x70):
   width 10
   bbx ( 10, 20, 0, -4 )

   +----------+
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   | ** ***   |
   | ***  **  |
   | **    ** |
   | **    ** |
   | **    ** |
   | **    ** |
   | ***  **  |
   | ** ***   |
   | **       |
   | **       |
   | **       |
   | **       |
   +----------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x6e00,
0x7300,
0x6180,
0x6180,
0x6180,
0x6180,
0x7300,
0x6e00,
0x6000,
0x6000,
0x6000,
0x6000,

/* Character 113 (0x71):
   width 10
   bbx ( 10, 20, 0, -4 )

   +----------+
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |   *** ** |
   |  **  *** |
   | **    ** |
   | **    ** |
   | **    ** |
   | **    ** |
   |  **  *** |
   |   *** ** |
   |       ** |
   |       ** |
   |       ** |
   |       ** |
   +----------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x1d80,
0x3380,
0x6180,
0x6180,
0x6180,
0x6180,
0x3380,
0x1d80,
0x0180,
0x0180,
0x0180,
0x0180,

/* Character 114 (0x72):
   width 10
   bbx ( 10, 20, 0, -4 )

   +----------+
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   | ** ****  |
   |  ***  ** |
   |  **      |
   |  **      |
   |  **      |
   |  **      |
   |  **      |
   |  **      |
   |          |
   |          |
   |          |
   |          |
   +----------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x6f00,
0x3980,
0x3000,
0x3000,
0x3000,
0x3000,
0x3000,
0x3000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 115 (0x73):
   width 10
   bbx ( 10, 20, 0, -4 )

   +----------+
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |  ******  |
   | **    ** |
   | **       |
   |  ******  |
   |       ** |
   |       ** |
   | **    ** |
   |  ******  |
   |          |
   |          |
   |          |
   |          |
   +----------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x3f00,
0x6180,
0x6000,
0x3f00,
0x0180,
0x0180,
0x6180,
0x3f00,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 116 (0x74):
   width 10
   bbx ( 10, 20, 0, -4 )

   +----------+
   |          |
   |          |
   |          |
   |          |
   |          |
   |   **     |
   |   **     |
   |   **     |
   | ******   |
   |   **     |
   |   **     |
   |   **     |
   |   **     |
   |   **     |
   |   **  ** |
   |    ****  |
   |          |
   |          |
   |          |
   |          |
   +----------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x1800,
0x1800,
0x1800,
0x7e00,
0x1800,
0x1800,
0x1800,
0x1800,
0x1800,
0x1980,
0x0f00,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 117 (0x75):
   width 10
   bbx ( 10, 20, 0, -4 )

   +----------+
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   | **    ** |
   | **    ** |
   | **    ** |
   | **    ** |
   | **    ** |
   | **    ** |
   |  **  *** |
   |   *** ** |
   |          |
   |          |
   |          |
   |          |
   +----------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x6180,
0x6180,
0x6180,
0x6180,
0x6180,
0x6180,
0x3380,
0x1d80,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 118 (0x76):
   width 10
   bbx ( 10, 20, 0, -4 )

   +----------+
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   | **    ** |
   | **    ** |
   |  **  **  |
   |  **  **  |
   |   ****   |
   |   ****   |
   |    **    |
   |    **    |
   |          |
   |          |
   |          |
   |          |
   +----------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x6180,
0x6180,
0x3300,
0x3300,
0x1e00,
0x1e00,
0x0c00,
0x0c00,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 119 (0x77):
   width 10
   bbx ( 10, 20, 0, -4 )

   +----------+
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   | **    ** |
   | **    ** |
   | **    ** |
   | ** ** ** |
   | ** ** ** |
   | ** ** ** |
   | ******** |
   |  **  **  |
   |          |
   |          |
   |          |
   |          |
   +----------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x6180,
0x6180,
0x6180,
0x6d80,
0x6d80,
0x6d80,
0x7f80,
0x3300,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 120 (0x78):
   width 10
   bbx ( 10, 20, 0, -4 )

   +----------+
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   | **    ** |
   |  **  **  |
   |   ****   |
   |    **    |
   |    **    |
   |   ****   |
   |  **  **  |
   | **    ** |
   |          |
   |          |
   |          |
   |          |
   +----------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x6180,
0x3300,
0x1e00,
0x0c00,
0x0c00,
0x1e00,
0x3300,
0x6180,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 121 (0x79):
   width 10
   bbx ( 10, 20, 0, -4 )

   +----------+
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   | **    ** |
   | **    ** |
   | **    ** |
   | **    ** |
   | **    ** |
   | **    ** |
   |  **  *** |
   |   *** ** |
   |       ** |
   | **    ** |
   |  **  **  |
   |   ****   |
   +----------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x6180,
0x6180,
0x6180,
0x6180,
0x6180,
0x6180,
0x3380,
0x1d80,
0x0180,
0x6180,
0x3300,
0x1e00,

/* Character 122 (0x7a):
   width 10
   bbx ( 10, 20, 0, -4 )

   +----------+
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |  ******* |
   |       ** |
   |      **  |
   |     **   |
   |    **    |
   |   **     |
   |  **      |
   |  ******* |
   |          |
   |          |
   |          |
   |          |
   +----------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x3f80,
0x0180,
0x0300,
0x0600,
0x0c00,
0x1800,
0x3000,
0x3f80,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 123 (0x7b):
   width 10
   bbx ( 10, 20, 0, -4 )

   +----------+
   |          |
   |          |
   |          |
   |     **** |
   |    **    |
   |    **    |
   |    **    |
   |    **    |
   |    **    |
   | ****     |
   |    **    |
   |    **    |
   |    **    |
   |    **    |
   |    **    |
   |     **** |
   |          |
   |          |
   |          |
   |          |
   +----------+
*/
0x0000,
0x0000,
0x0000,
0x0780,
0x0c00,
0x0c00,
0x0c00,
0x0c00,
0x0c00,
0x7800,
0x0c00,
0x0c00,
0x0c00,
0x0c00,
0x0c00,
0x0780,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 124 (0x7c):
   width 10
   bbx ( 10, 20, 0, -4 )

   +----------+
   |          |
   |          |
   |          |
   |    **    |
   |    **    |
   |    **    |
   |    **    |
   |    **    |
   |    **    |
   |    **    |
   |    **    |
   |    **    |
   |    **    |
   |    **    |
   |    **    |
   |    **    |
   |          |
   |          |
   |          |
   |          |
   +----------+
*/
0x0000,
0x0000,
0x0000,
0x0c00,
0x0c00,
0x0c00,
0x0c00,
0x0c00,
0x0c00,
0x0c00,
0x0c00,
0x0c00,
0x0c00,
0x0c00,
0x0c00,
0x0c00,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 125 (0x7d):
   width 10
   bbx ( 10, 20, 0, -4 )

   +----------+
   |          |
   |          |
   |          |
   | ****     |
   |    **    |
   |    **    |
   |    **    |
   |    **    |
   |    **    |
   |     **** |
   |    **    |
   |    **    |
   |    **    |
   |    **    |
   |    **    |
   | ****     |
   |          |
   |          |
   |          |
   |          |
   +----------+
*/
0x0000,
0x0000,
0x0000,
0x7800,
0x0c00,
0x0c00,
0x0c00,
0x0c00,
0x0c00,
0x0780,
0x0c00,
0x0c00,
0x0c00,
0x0c00,
0x0c00,
0x7800,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 126 (0x7e):
   width 10
   bbx ( 10, 20, 0, -4 )

   +----------+
   |          |
   |          |
   |          |
   |  ***  ** |
   | ** ** ** |
   | **  ***  |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   |          |
   +----------+
*/
0x0000,
0x0000,
0x0000,
0x3980,
0x6d80,
0x6700,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
};

/* Exported structure definition. */
static const FontDesc stellaLargeDesc = {
	"l_10x20",
	10,
	20,
	10, 20, 0, -4,
	16,
	32,
	95,
	_stellaLarge_font_bits,
	0,  /* no encode table*/
	0,  /* fixed width*/
	0,  /* fixed bbox*/
	32,
	sizeof(_stellaLarge_font_bits)/sizeof(uInt16)
};

} // namespace GUI

#endif
