/*
Copyright (C) 2000 Liam Girdwood
Copyright (C) 2003 Fabien Chreau

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

Some functions in this file use the VSOP87 solution by
Messrs. Bretagnon and Francou.

*/
#include <math.h>
#include "vsop87.h"
#include "misc_stellplanet.h"

#define LONG_L0 539
#define LONG_L1 224
#define LONG_L2 59
#define LONG_L3 18
#define LAT_B0 172
#define LAT_B1 49
#define LAT_B2 13
#define LAT_B3 2
#define RADIUS_R0 596
#define RADIUS_R1 251
#define RADIUS_R2 71
#define RADIUS_R3 23
#define RADIUS_R4 7

static const struct vsop neptune_longitude_l0[LONG_L0] = {
    {     5.31188633046,  0.00000000000,        0.00000000000}, 
    {     0.01798475530,  2.90101273890,       38.13303563780}, 
    {     0.01019727652,  0.48580922867,        1.48447270830}, 
    {     0.00124531845,  4.83008090676,       36.64856292950}, 
    {     0.00042064466,  5.41054993053,        2.96894541660}, 
    {     0.00037714584,  6.09221808686,       35.16409022120}, 
    {     0.00033784738,  1.24488874087,       76.26607127560}, 
    {     0.00016482741,  0.00007727998,      491.55792945680}, 
    {     0.00009198584,  4.93747051954,       39.61750834610}, 
    {     0.00008994250,  0.27462171806,      175.16605980020}, 
    {     0.00004216242,  1.98711875978,       73.29712585900}, 
    {     0.00003364807,  1.03590060915,       33.67961751290}, 
    {     0.00002284800,  4.20606949415,        4.45341812490}, 
    {     0.00001433516,  2.78339802539,       74.78159856730}, 
    {     0.00000900236,  2.07607168714,      109.94568878850}, 
    {     0.00000744997,  3.19032509437,       71.81265315070}, 
    {     0.00000506217,  5.74786069680,      114.39910691340}, 
    {     0.00000399552,  0.34972342836,     1021.24889455140}, 
    {     0.00000345189,  3.46185292806,       41.10198105440}, 
    {     0.00000306338,  0.49684052934,        0.52126486180}, 
    {     0.00000287322,  4.50523446022,        0.04818410980}, 
    {     0.00000323003,  2.24814943701,       32.19514480460}, 
    {     0.00000340303,  3.30376245107,       77.75054398390}, 
    {     0.00000266605,  4.88932605590,        0.96320784650}, 
    {     0.00000227079,  1.79713146385,      453.42489381900}, 
    {     0.00000244722,  1.24693366148,        9.56122755560}, 
    {     0.00000232888,  2.50459784128,      137.03302416240}, 
    {     0.00000282170,  2.24565589980,      146.59425171800}, 
    {     0.00000251941,  5.78166617117,      388.46515523820}, 
    {     0.00000150188,  2.99706170691,        5.93789083320}, 
    {     0.00000170404,  3.32390687638,      108.46121608020}, 
    {     0.00000151401,  2.19153150087,       33.94024994380}, 
    {     0.00000148305,  0.85949274408,      111.43016149680}, 
    {     0.00000118672,  3.67706211426,        2.44768055480}, 
    {     0.00000101821,  5.70539236951,        0.11187458460}, 
    {     0.00000097873,  2.80518417596,        8.07675484730}, 
    {     0.00000103059,  4.40432042649,       70.32818044240}, 
    {     0.00000103305,  0.04078966679,        0.26063243090}, 
    {     0.00000109299,  2.41599473953,      183.24281464750}, 
    {     0.00000073938,  1.32805035282,      529.69096509460}, 
    {     0.00000077725,  4.16446516489,        4.19278569400}, 
    {     0.00000086312,  4.22838781137,      490.07345674850}, 
    {     0.00000081558,  5.19840134548,      493.04240216510}, 
    {     0.00000071503,  5.29530376008,      350.33211960040}, 
    {     0.00000064418,  3.54540876782,      168.05251279940}, 
    {     0.00000062570,  0.15028731307,      182.27960680100}, 
    {     0.00000058488,  3.50107011546,      145.10977900970}, 
    {     0.00000048286,  1.11259007090,      112.91463420510}, 
    {     0.00000047229,  4.57373234943,       46.20979048510}, 
    {     0.00000039124,  1.66569494185,      213.29909543800}, 
    {     0.00000047728,  0.12906212459,      484.44438245600}, 
    {     0.00000046858,  3.01699530311,      498.67147645760}, 
    {     0.00000038659,  2.38685681991,        2.92076130680}, 
    {     0.00000047046,  4.49844734537,      173.68158709190}, 
    {     0.00000047565,  2.58404545035,      219.89137757700}, 
    {     0.00000044714,  5.47302844713,      176.65053250850}, 
    {     0.00000032279,  3.45758705244,       30.71067209630}, 
    {     0.00000028249,  4.13282449919,        6.59228213900}, 
    {     0.00000024432,  4.55736924822,      106.97674337190}, 
    {     0.00000024661,  3.67821364144,      181.75834193920}, 
    {     0.00000024505,  1.55095976661,        7.11354700080}, 
    {     0.00000021848,  1.04366945175,       39.09624348430}, 
    {     0.00000016835,  6.11092370371,       44.72531777680}, 
    {     0.00000022220,  2.74693585259,      256.53994050650}, 
    {     0.00000016614,  4.98189005162,       37.61177077600}, 
    {     0.00000017728,  3.55049134136,        1.37259812370}, 
    {     0.00000017348,  2.14093469791,       42.58645376270}, 
    {     0.00000014588,  0.69766675400,     1550.93985964600}, 
    {     0.00000014969,  3.36426560630,       98.89998852460}, 
    {     0.00000015677,  6.22011053513,      454.90936652730}, 
    {     0.00000013243,  5.61712395571,       68.84370773410}, 
    {     0.00000014837,  3.52556891759,       25.60286266560}, 
    {     0.00000012757,  0.04509403901,       11.04570026390}, 
    {     0.00000011988,  4.81688773476,       24.11838995730}, 
    {     0.00000011060,  1.78958328174,        7.42236354150}, 
    {     0.00000012104,  1.86916301309,       79.23501669220}, 
    {     0.00000011698,  0.49005698054,        1.59634729290}, 
    {     0.00000010459,  2.38743199573,      381.35160823740}, 
    {     0.00000011682,  3.85152266622,      218.40690486870}, 
    {     0.00000008744,  0.14169605624,      148.07872442630}, 
    {     0.00000009196,  1.00274082532,       72.07328558160}, 
    {     0.00000011343,  0.81432264944,      525.49817940060}, 
    {     0.00000010097,  5.03381894926,      601.76425067620}, 
    {     0.00000008035,  1.77685723010,        0.21244832110}, 
    {     0.00000008382,  3.07534786987,        1.27202438720}, 
    {     0.00000010803,  2.92080692152,      293.18850343600}, 
    {     0.00000007666,  1.52272200302,      115.88357962170}, 
    {     0.00000007531,  5.37537041047,        5.10780943070}, 
    {     0.00000008691,  4.74349171636,      143.62530630140}, 
    {     0.00000010183,  1.15395455831,     6244.94281435360}, 
    {     0.00000008287,  0.35990637292,      138.51749687070}, 
    {     0.00000009543,  4.02459127211,      152.53214255120}, 
    {     0.00000007268,  4.11164858892,      251.43213107580}, 
    {     0.00000007465,  1.72131360023,       31.01948863700}, 
    {     0.00000006902,  4.62452234150,        2.70831298570}, 
    {     0.00000007094,  5.11529809988,      312.19908396260}, 
    {     0.00000007929,  2.10765766676,       27.08733537390}, 
    {     0.00000006156,  3.50746819519,       28.57180808220}, 
    {     0.00000007134,  2.05292375736,      278.25883401880}, 
    {     0.00000008193,  2.58588219154,      141.22580985640}, 
    {     0.00000005499,  2.09250039025,        1.69692102940}, 
    {     0.00000005279,  4.09388735435,      983.11585891360}, 
    {     0.00000006933,  3.47729102004,      415.29185818120}, 
    {     0.00000005916,  0.68957254143,       62.25142559510}, 
    {     0.00000005925,  4.02508149455,      255.05546779820}, 
    {     0.00000004606,  1.17780552175,       43.24084506850}, 
    {     0.00000005357,  3.63061309594,        5.41662597140}, 
    {     0.00000005918,  2.57693824084,    10175.15251057320}, 
    {     0.00000005482,  3.07977337441,      329.83706636550}, 
    {     0.00000003956,  5.00417876355,      184.72728735580}, 
    {     0.00000005398,  3.31531091775,      528.20649238630}, 
    {     0.00000004767,  4.91981115318,      456.39383923560}, 
    {     0.00000003770,  1.57277409027,       32.71640966640}, 
    {     0.00000003924,  4.92761954552,      180.27386923090}, 
    {     0.00000003707,  4.82965059592,      221.37585028530}, 
    {     0.00000003802,  4.96279204998,      594.65070367540}, 
    {     0.00000004014,  1.63901581079,       40.58071619260}, 
    {     0.00000003061,  0.39712980415,        1.43628859850}, 
    {     0.00000003261,  4.65481470589,       29.22619938800}, 
    {     0.00000003474,  5.65891306563,      395.57870223900}, 
    {     0.00000002918,  5.91079083936,        1.22384027740}, 
    {     0.00000003225,  5.57423738665,     1014.13534755060}, 
    {     0.00000003442,  5.60791606864,      488.58898404020}, 
    {     0.00000002845,  0.56009439099,      144.14657116320}, 
    {     0.00000002841,  0.55459681230,      567.82400073240}, 
    {     0.00000003440,  1.70886719923,       12.53017297220}, 
    {     0.00000003456,  3.87315999467,      494.52687487340}, 
    {     0.00000003107,  5.79332348779,      105.49227066360}, 
    {     0.00000002712,  2.43722805817,       60.76695288680}, 
    {     0.00000003227,  4.68651708637,       82.85835341460}, 
    {     0.00000003202,  2.21481972921,       41.05379694460}, 
    {     0.00000003590,  5.69939670162,     1124.34166877000}, 
    {     0.00000002961,  0.54712452509,      135.54855145410}, 
    {     0.00000003173,  4.19788791291,      291.70403072770}, 
    {     0.00000002899,  5.99671470079,       22.63391724900}, 
    {     0.00000003143,  2.93495725805,       31.23193695810}, 
    {     0.00000002729,  4.62709462438,        5.62907429250}, 
    {     0.00000002513,  5.60391563025,       19.12245511120}, 
    {     0.00000002690,  5.32070934185,        2.00573757010}, 
    {     0.00000002630,  6.00855115785,       37.16982779130}, 
    {     0.00000002282,  6.07498178903,      451.94042111070}, 
    {     0.00000002858,  4.88680338436,      258.02441321480}, 
    {     0.00000002879,  5.12236912878,       38.65430049960}, 
    {     0.00000002270,  2.08633953722,       30.05628079050}, 
    {     0.00000002301,  3.35951602914,     1028.36244155220}, 
    {     0.00000003001,  3.59152016870,      211.81462272970}, 
    {     0.00000002238,  0.38455483182,        3.62333672240}, 
    {     0.00000002901,  3.24753792395,      366.48562929500}, 
    {     0.00000002592,  1.36262664245,       35.42472265210}, 
    {     0.00000002418,  4.93469145264,       47.69426319340}, 
    {     0.00000002089,  5.79838063413,        4.66586644600}, 
    {     0.00000002586,  2.69392971550,       38.18121974760}, 
    {     0.00000001971,  6.00790962923,       34.20088237470}, 
    {     0.00000002586,  6.24984047773,       38.08485152800}, 
    {     0.00000002098,  4.57817230839,     1019.76442184310}, 
    {     0.00000001839,  5.57608456495,      149.56319713460}, 
    {     0.00000001869,  3.85907708723,      911.04257333200}, 
    {     0.00000002486,  5.21233869943,      140.00196957900}, 
    {     0.00000001795,  1.68007697304,     1059.38193018920}, 
    {     0.00000002326,  2.82664069146,      807.94979911340}, 
    {     0.00000001936,  5.10955276726,      216.92243216040}, 
    {     0.00000001984,  5.54760871921,     1022.73336725970}, 
    {     0.00000001835,  5.97770747608,      172.19711438360}, 
    {     0.00000002004,  5.47803248635,       63.73589830340}, 
    {     0.00000002140,  2.65037925793,      700.66423920080}, 
    {     0.00000001988,  3.35856016133,      186.21176006410}, 
    {     0.00000001956,  5.01516643942,      294.67297614430}, 
    {     0.00000001966,  4.07957525462,       20.60692781950}, 
    {     0.00000001637,  0.53824150223,       67.35923502580}, 
    {     0.00000001871,  4.15223195600,      178.13500521680}, 
    {     0.00000001540,  2.62327824804,       41.75637236020}, 
    {     0.00000001820,  5.81768086494,      129.91947716160}, 
    {     0.00000001754,  4.36839235779,      328.35259365720}, 
    {     0.00000001460,  2.63664516309,        2.85707083200}, 
    {     0.00000001388,  2.10605065495,        3.93215326310}, 
    {     0.00000001352,  0.55618245459,        0.65439130580}, 
    {     0.00000001668,  2.77543377384,       16.15350969460}, 
    {     0.00000001338,  0.37645467215,       14.01464568050}, 
    {     0.00000001218,  0.73457000060,      426.59819087600}, 
    {     0.00000001610,  3.40993998127,      403.13419222450}, 
    {     0.00000001361,  4.48227243414,       17.63798240290}, 
    {     0.00000001589,  5.59323020112,     3302.47939106200}, 
    {     0.00000001464,  4.52431769151,      526.72201967800}, 
    {     0.00000001122,  5.66659544539,      151.04766984290}, 
    {     0.00000001357,  4.06398362517,       26.82670294300}, 
    {     0.00000001494,  4.98692083723,      666.72398925700}, 
    {     0.00000001077,  4.30911470250,        0.63313944640}, 
    {     0.00000001042,  6.02756893202,      106.01353552540}, 
    {     0.00000001060,  0.74665002402,      487.36514376280}, 
    {     0.00000001310,  3.78526234581,      386.98068252990}, 
    {     0.00000001342,  4.52683913540,      563.63121503840}, 
    {     0.00000000986,  0.00602637103,       81.37388070630}, 
    {     0.00000001233,  5.17442601841,      331.32153907380}, 
    {     0.00000000929,  4.51267466208,       38.39366806870}, 
    {     0.00000000956,  3.50447791020,       64.95973858080}, 
    {     0.00000000929,  4.43109514668,       37.87240320690}, 
    {     0.00000000926,  6.09803297747,        4.14460158420}, 
    {     0.00000000972,  0.59044574729,        8.90683624980}, 
    {     0.00000001246,  4.69840799242,      389.94962794650}, 
    {     0.00000001009,  5.98445003291,      142.14083359310}, 
    {     0.00000001020,  0.83233892293,       39.35687591520}, 
    {     0.00000001013,  0.37845632082,       36.90919536040}, 
    {     0.00000001193,  0.77431842880,       44.07092647100}, 
    {     0.00000000940,  2.42688217399,      343.21857259960}, 
    {     0.00000000974,  5.24721391344,      253.57099508990}, 
    {     0.00000000964,  5.09748188959,      357.44566660120}, 
    {     0.00000000835,  1.45570317496,       35.21227433100}, 
    {     0.00000001083,  2.27578915691,        6.90109867970}, 
    {     0.00000000938,  5.03471597364,       69.36497259590}, 
    {     0.00000001078,  1.20239572961,       35.68535508300}, 
    {     0.00000001027,  0.18244384186,       84.34282612290}, 
    {     0.00000000764,  4.62720907712,        0.83008140250}, 
    {     0.00000001013,  0.42234910440,       32.45577723550}, 
    {     0.00000000939,  4.50445790730,      365.00115658670}, 
    {     0.00000000756,  0.82872484721,       17.52610781830}, 
    {     0.00000000916,  3.89409205647,       38.24491022240}, 
    {     0.00000000736,  4.78125743795,        5.36844186160}, 
    {     0.00000000755,  2.28073625559,       42.32582133180}, 
    {     0.00000000762,  0.01897337130,      189.39315380180}, 
    {     0.00000000888,  3.20358484815,      348.84764689210}, 
    {     0.00000000916,  5.04967793164,       38.02116105320}, 
    {     0.00000000638,  0.63267398066,      244.31858407500}, 
    {     0.00000000870,  4.69158261795,      210.33015002140}, 
    {     0.00000000636,  1.02615137352,     2080.63082474060}, 
    {     0.00000000774,  5.44432672662,      367.97010200330}, 
    {     0.00000000644,  1.94044995543,      446.31134681820}, 
    {     0.00000000631,  4.82928478042,      460.53844081980}, 
    {     0.00000000855,  3.57592750113,      439.78275515400}, 
    {     0.00000000678,  4.48672134948,      351.81659230870}, 
    {     0.00000000724,  4.89125815316,      119.50691634410}, 
    {     0.00000000594,  0.59315717685,      491.03666459500}, 
    {     0.00000000655,  1.99014094340,       19.01058052660}, 
    {     0.00000000580,  2.57189536244,      492.07919431860}, 
    {     0.00000000694,  0.08328898350,        5.67725840230}, 
    {     0.00000000733,  5.81485239057,       29.74746424980}, 
    {     0.00000000666,  3.42196897591,      179.09821306330}, 
    {     0.00000000678,  0.29428615814,      171.23390653710}, 
    {     0.00000000635,  2.13805182663,      164.12035953630}, 
    {     0.00000000623,  5.61454940380,      285.37238101960}, 
    {     0.00000000529,  1.88036938507,      416.77633088950}, 
    {     0.00000000529,  5.13250788030,      697.74347789400}, 
    {     0.00000000500,  1.49548514012,      704.85702489480}, 
    {     0.00000000666,  6.26456825266,     1474.67378837040}, 
    {     0.00000000532,  0.25784352716,      477.33083545520}, 
    {     0.00000000477,  4.96717541029,      274.06604832480}, 
    {     0.00000000557,  0.71390028264,       80.71948940050}, 
    {     0.00000000556,  2.60791466171,      418.26080359780}, 
    {     0.00000000584,  4.29064541383,       16.67477455640}, 
    {     0.00000000524,  5.42714112993,      290.21955801940}, 
    {     0.00000000524,  0.29054995359,      247.23934538180}, 
    {     0.00000000541,  4.36400580938,      815.06334611420}, 
    {     0.00000000525,  4.70814258726,      401.64971951620}, 
    {     0.00000000544,  1.70619260267,       97.41551581630}, 
    {     0.00000000458,  6.13569488022,      178.78939652260}, 
    {     0.00000000432,  2.98508233021,      100.38446123290}, 
    {     0.00000000456,  4.35380290850,      180.79513409270}, 
    {     0.00000000382,  0.28067758468,        8.38557138800}, 
    {     0.00000000484,  0.01535334378,      738.79727483860}, 
    {     0.00000000518,  4.48916591410,      875.83029900100}, 
    {     0.00000000506,  5.38611153480,      404.61866493280}, 
    {     0.00000000396,  4.62747640832,        6.15033915430}, 
    {     0.00000000466,  0.23333349172,      120.99138905240}, 
    {     0.00000000409,  3.08848985159,       59.28248017850}, 
    {     0.00000000470,  5.01853077975,      313.68355667090}, 
    {     0.00000000442,  3.68919364372,      457.87831194390}, 
    {     0.00000000384,  3.69499925394,      160.93896579860}, 
    {     0.00000000364,  0.76172331873,      104.00779795530}, 
    {     0.00000000416,  0.26654216462,      103.09277421860}, 
    {     0.00000000401,  4.06530055968,       14.66903698630}, 
    {     0.00000000454,  3.72767803715,      476.43131808350}, 
    {     0.00000000434,  0.33532124451,      984.60033162190}, 
    {     0.00000000340,  0.99917090883,       31.54075349880}, 
    {     0.00000000420,  3.65147769264,       20.49505323490}, 
    {     0.00000000334,  0.35121412008,     1227.43444298860}, 
    {     0.00000000321,  0.46861755388,      118.02244363580}, 
    {     0.00000000323,  5.45836731979,      918.15612033280}, 
    {     0.00000000407,  4.19457842203,      309.79958751760}, 
    {     0.00000000381,  0.01364856960,      495.49008271990}, 
    {     0.00000000334,  4.05924071124,        8.33738727820}, 
    {     0.00000000380,  3.17063415023,      487.62577619370}, 
    {     0.00000000380,  2.70238752925,      134.11226285560}, 
    {     0.00000000305,  2.49866234194,    12566.15169998280}, 
    {     0.00000000296,  0.33794345250,      208.84567731310}, 
    {     0.00000000362,  4.88985810610,      438.29828244570}, 
    {     0.00000000327,  2.91090790412,      505.78502345840}, 
    {     0.00000000308,  0.96082817124,       21.14944454070}, 
    {     0.00000000282,  4.04208377539,     6205.32530600750}, 
    {     0.00000000288,  1.48123825325,      220.41264243880}, 
    {     0.00000000391,  4.00154736435,      674.80074410430}, 
    {     0.00000000326,  2.46105030955,      169.53698550770}, 
    {     0.00000000289,  2.63591886401,       55.77101804070}, 
    {     0.00000000288,  5.02487283285,     1440.73353842660}, 
    {     0.00000000344,  1.48931098748,      166.56804009110}, 
    {     0.00000000277,  2.56804940377,      662.53120356300}, 
    {     0.00000000268,  5.02354540478,      377.41945497430}, 
    {     0.00000000308,  1.50179611581,       77.22927912210}, 
    {     0.00000000324,  5.30240189409,      457.61767951300}, 
    {     0.00000000264,  0.83337660655,      488.37653571910}, 
    {     0.00000000290,  1.79966899809,      101.86893394120}, 
    {     0.00000000262,  2.30390003360,      494.73932319450}, 
    {     0.00000000293,  5.61946139216,      326.86812094890}, 
    {     0.00000000325,  5.52669903629,      441.26722786230}, 
    {     0.00000000253,  1.51157242351,       79.88940799800}, 
    {     0.00000000250,  1.08902686231,      450.45594840240}, 
    {     0.00000000254,  0.02957070469,      117.36805233000}, 
    {     0.00000000315,  5.34884988949,      183.76407950930}, 
    {     0.00000000243,  0.63404014969,       79.18683258240}, 
    {     0.00000000313,  5.45945846595,       13.49338081870}, 
    {     0.00000000306,  5.23048213432,       45.24658263860}, 
    {     0.00000000263,  2.66670757215,      464.73122651380}, 
    {     0.00000000242,  6.04858356336,       36.12729806770}, 
    {     0.00000000234,  1.82700149824,    52175.80628314840}, 
    {     0.00000000275,  5.04385701142,      156.15547927360}, 
    {     0.00000000247,  1.74540930625,       65.87476231750}, 
    {     0.00000000293,  3.98736984598,      141.48644228730}, 
    {     0.00000000269,  6.09827783249,     1654.03263386460}, 
    {     0.00000000229,  2.25830514766,      190.66517818900}, 
    {     0.00000000294,  5.45234088717,      206.18554843720}, 
    {     0.00000000230,  6.13158632762,      178.34745353790}, 
    {     0.00000000274,  4.10829870815,      518.38463239980}, 
    {     0.00000000225,  3.86300359251,      171.98466606250}, 
    {     0.00000000272,  5.61149862463,      148.33935685720}, 
    {     0.00000000239,  0.67204276457,      267.58564077040}, 
    {     0.00000000256,  5.53344401207,      266.10116806210}, 
    {     0.00000000214,  1.45987234069,      522.57741809380}, 
    {     0.00000000237,  0.88414073923,      304.23420369990}, 
    {     0.00000000266,  0.99036038827,      209.10630974400}, 
    {     0.00000000235,  1.45372667222,       69.15252427480}, 
    {     0.00000000230,  0.54049951530,      532.61172640140}, 
    {     0.00000000226,  3.84152961620,      283.62727588040}, 
    {     0.00000000243,  5.32730356188,      485.92885516430}, 
    {     0.00000000211,  4.62164373274,      110.20632121940}, 
    {     0.00000000209,  4.35051429228,      536.80451209540}, 
    {     0.00000000232,  3.01948719112,       10.93382567930}, 
    {     0.00000000244,  1.32007560700,      279.74330672710}, 
    {     0.00000000246,  0.37702127050,      157.63995198190}, 
    {     0.00000000219,  5.67679857772,    52099.54021187280}, 
    {     0.00000000251,  1.52353965506,        6.85291456990}, 
    {     0.00000000203,  5.44328634514,      145.63104387150}, 
    {     0.00000000238,  0.96169703532,      497.18700374930}, 
    {     0.00000000219,  4.52300776062,     1615.89959822680}, 
    {     0.00000000275,  2.37619204391,     2118.76386037840}, 
    {     0.00000000260,  5.73101715512,      490.33408917940}, 
    {     0.00000000221,  0.02848945752,      215.43795945210}, 
    {     0.00000000258,  5.12448148780,      608.87779767700}, 
    {     0.00000000260,  3.88543008475,      513.07988101300}, 
    {     0.00000000191,  3.72590321496,       65.22037101170}, 
    {     0.00000000189,  5.28013390816,      377.15882254340}, 
    {     0.00000000243,  4.35559887596,      482.95990974770}, 
    {     0.00000000208,  5.62023497734,      526.98265210890}, 
    {     0.00000000243,  6.06790724123,      154.01661525950}, 
    {     0.00000000188,  2.62629206555,      276.77436131050}, 
    {     0.00000000209,  2.55968827096,       75.74480641380}, 
    {     0.00000000187,  4.74390535167,     1189.30140735080}, 
    {     0.00000000216,  0.02830351243,       73.55775828990}, 
    {     0.00000000227,  3.27856938091,      522.52923398400}, 
    {     0.00000000249,  1.57215637373,       14.22709400160}, 
    {     0.00000000202,  1.28244949587,    20426.57109242200}, 
    {     0.00000000238,  1.93340172124,      500.15594916590}, 
    {     0.00000000209,  5.02893682321,      364.55921360200}, 
    {     0.00000000184,  4.83097075362,      315.16802937920}, 
    {     0.00000000227,  5.72984298540,     1543.82631264520}, 
    {     0.00000000198,  3.48843299287,      207.36120460480}, 
    {     0.00000000217,  2.45036922991,      187.17496791060}, 
    {     0.00000000181,  1.65699502247,     1627.20593092160}, 
    {     0.00000000214,  1.60213179145,       11.30633269480}, 
    {     0.00000000203,  0.74638490279,       14.55716240170}, 
    {     0.00000000227,  4.05259736056,      285.11174858870}, 
    {     0.00000000192,  3.17719161639,      343.47920503050}, 
    {     0.00000000206,  1.70602580638,      913.96333463880}, 
    {     0.00000000177,  1.50027795761,        9.44935297100}, 
    {     0.00000000177,  0.03038093848,      165.60483224460}, 
    {     0.00000000229,  3.63854889639,      139.74133714810}, 
    {     0.00000000208,  2.65835804847,      496.01134758170}, 
    {     0.00000000208,  0.12968873405,      252.91660378410}, 
    {     0.00000000174,  2.76107721407,       49.17873590170}, 
    {     0.00000000185,  6.01438406519,      355.96119389290}, 
    {     0.00000000184,  3.34554375681,       95.93104310800}, 
    {     0.00000000182,  0.17588831495,       91.78644152380}, 
    {     0.00000000172,  4.15140954379,       67.88049988760}, 
    {     0.00000000188,  6.17288910532,      535.32003938710}, 
    {     0.00000000215,  1.92414563346,      552.69738935910}, 
    {     0.00000000166,  5.49038139690,    10135.53500222710}, 
    {     0.00000000195,  5.50011081154,      179.31066138440}, 
    {     0.00000000209,  5.34065233845,       13.64213866500}, 
    {     0.00000000192,  5.83612790963,      987.30864460760}, 
    {     0.00000000204,  3.46033533181,      246.97871295090}, 
    {     0.00000000174,  1.95010683512,      319.31263096340}, 
    {     0.00000000165,  4.00537112057,      493.56366702690}, 
    {     0.00000000163,  1.73931497111,       39.50563376150}, 
    {     0.00000000173,  3.93200456456,      238.90195810360}, 
    {     0.00000000214,  1.44203805516,      340.88276662940}, 
    {     0.00000000177,  5.20505417820,      474.94684537520}, 
    {     0.00000000193,  0.10674418270,      104.52906281710}, 
    {     0.00000000189,  1.11279570541,     1127.26243007680}, 
    {     0.00000000193,  2.12636756833,    20350.30502114640}, 
    {     0.00000000181,  2.10814562080,      113.87784205160}, 
    {     0.00000000165,  2.90285982491,      944.98282327580}, 
    {     0.00000000194,  1.13504963784,       57.25549074900}, 
    {     0.00000000198,  5.68125942959,     6280.10690457480}, 
    {     0.00000000156,  1.44680882209,      524.06189080210}, 
    {     0.00000000194,  0.82038638816,    10210.31660079440}, 
    {     0.00000000199,  3.01674233707,      461.76228109720}, 
    {     0.00000000163,  1.08083105653,      556.51766803760}, 
    {     0.00000000205,  4.16096717573,      711.44930703380}, 
    {     0.00000000166,  5.82269892726,      363.51668387840}, 
    {     0.00000000199,  0.73336150031,      194.28851491140}, 
    {     0.00000000168,  0.52839376810,      487.10451133190}, 
    {     0.00000000148,  3.49775706709,      447.79581952650}, 
    {     0.00000000160,  4.77748329946,      524.01370669230}, 
    {     0.00000000200,  4.93953136966,      732.97125859000}, 
    {     0.00000000201,  4.60377078221,      142.71028256470}, 
    {     0.00000000188,  3.49370600377,     1967.71619053550}, 
    {     0.00000000146,  4.99570104768,      142.66209845490}, 
    {     0.00000000147,  5.91318176956,       70.11573212130}, 
    {     0.00000000158,  4.49935225328,      249.94765836750}, 
    {     0.00000000145,  2.01584284819,      282.14280317210}, 
    {     0.00000000139,  0.04417506218,      260.99335863140}, 
    {     0.00000000176,  0.41786563552,      222.86032299360}, 
    {     0.00000000137,  2.96534233094,     6206.80977871580}, 
    {     0.00000000138,  1.22183114912,      187.69623277240}, 
    {     0.00000000147,  5.47686077634,       15.49911838880}, 
    {     0.00000000144,  0.86582247161,      170.97327410620}, 
    {     0.00000000158,  1.64284142080,      563.37058260750}, 
    {     0.00000000163,  3.40763757343,       46.51860702580}, 
    {     0.00000000127,  0.55262902348,      245.49424024260}, 
    {     0.00000000131,  1.01890930568,      140.65636088480}, 
    {     0.00000000135,  5.22138226920,      439.19779981740}, 
    {     0.00000000125,  3.31010747037,       76.78733613740}, 
    {     0.00000000127,  2.50788482744,      191.31956949480}, 
    {     0.00000000130,  3.04810037778,      310.71461125430}, 
    {     0.00000000140,  5.78513367440,      604.73319609280}, 
    {     0.00000000155,  3.83835809042,     1512.80682400820}, 
    {     0.00000000120,  2.89920382272,      422.40540518200}, 
    {     0.00000000147,  3.51503910807,      421.22974901440}, 
    {     0.00000000143,  0.29840596863,      259.50888592310}, 
    {     0.00000000122,  3.01323328703,       70.84944530420}, 
    {     0.00000000142,  4.65284277800,      528.46712481720}, 
    {     0.00000000133,  4.59396705758,      497.49582029000}, 
    {     0.00000000124,  5.80857038334,      423.67742956920}, 
    {     0.00000000119,  5.02901764495,    12489.88562870720}, 
    {     0.00000000122,  1.86088175570,      116.53797092750}, 
    {     0.00000000111,  0.77447922936,      179.35884549420}, 
    {     0.00000000141,  0.18423856688,      131.40394986990}, 
    {     0.00000000118,  0.29375056913,      252.08652238160}, 
    {     0.00000000125,  1.93416839115,      335.77495719870}, 
    {     0.00000000109,  2.39031603899,      305.08553696180}, 
    {     0.00000000125,  0.61344782123,      408.17831118040}, 
    {     0.00000000142,  0.57310802423,      296.15744885260}, 
    {     0.00000000132,  4.76684757273,      353.04043258610}, 
    {     0.00000000130,  5.12925248080,      324.72925693480}, 
    {     0.00000000115,  1.53744955496,      406.10313764110}, 
    {     0.00000000118,  6.09863412341,      169.22816896700}, 
    {     0.00000000134,  1.63469028613,     6168.67674307800}, 
    {     0.00000000144,  2.02224512289,      589.34595228860}, 
    {     0.00000000124,  2.93224816514,      179.61947792510}, 
    {     0.00000000139,  5.00897329509,      636.66770846650}, 
    {     0.00000000102,  4.57322305433,       85.82729883120}, 
    {     0.00000000126,  1.32135490674,      598.79530525960}, 
    {     0.00000000102,  4.65261542673,       57.79800747020}, 
    {     0.00000000122,  3.73358839778,      104.83787935780}, 
    {     0.00000000111,  6.18471084965,      981.63138620530}, 
    {     0.00000000117,  1.60090805440,       18.48931566480}, 
    {     0.00000000136,  5.63003448986,      525.23754696970}, 
    {     0.00000000141,  2.63342759831,      381.61224066830}, 
    {     0.00000000133,  1.71663261072,      419.74527630610}, 
    {     0.00000000127,  3.05719879887,    10098.88643929760}, 
    {     0.00000000110,  5.25051232375,      986.08480433020}, 
    {     0.00000000101,  1.40363357063,      213.95348674380}, 
    {     0.00000000097,  3.61152071016,     1587.58842257550}, 
    {     0.00000000113,  1.13223480146,      604.47256366190}, 
    {     0.00000000099,  2.04721879617,       70.58881287330}, 
    {     0.00000000119,  2.90157321317,       94.75538694040}, 
    {     0.00000000096,  2.31674172036,      227.96813242430}, 
    {     0.00000000116,  4.30714911354,      189.83509678650}, 
    {     0.00000000106,  2.23888483610,      853.19638175200}, 
    {     0.00000000096,  3.86661212196,      240.12579838100}, 
    {     0.00000000120,  3.78748778119,     1057.89745748090}, 
    {     0.00000000094,  4.82757670972,      392.91857336310}, 
    {     0.00000000102,  4.41384282230,      603.24872338450}, 
    {     0.00000000100,  2.78834593110,     1017.05610885740}, 
    {     0.00000000093,  4.54014018836,       36.69674703930}, 
    {     0.00000000107,  0.03653394273,       95.27665180220}, 
    {     0.00000000094,  0.80425312383,      432.22726516850}, 
    {     0.00000000098,  5.60599279629,     1265.56747862640}, 
    {     0.00000000109,  4.83225302495,      235.93301268700}, 
    {     0.00000000090,  5.28097582589,      946.46729598410}, 
    {     0.00000000096,  1.44316147572,      347.41135829360}, 
    {     0.00000000122,  0.77697508887,      332.80601178210}, 
    {     0.00000000090,  0.24166205071,      449.23210812500}, 
    {     0.00000000095,  2.88593540245,     1511.32235129990}, 
    {     0.00000000093,  4.33568012755,      776.93031047640}, 
    {     0.00000000110,  0.31702511154,      264.61669535380}, 
    {     0.00000000088,  3.51795785198,      316.65250208750}, 
    {     0.00000000087,  4.62145192466,     1692.16566950240}, 
    {     0.00000000094,  4.21867891011,     1024.21783996800}, 
    {     0.00000000094,  1.55501457323,      287.25061260280}, 
    {     0.00000000092,  5.57906316341,      448.97147569410}, 
    {     0.00000000116,  1.22656968212,     2042.49778910280}, 
    {     0.00000000109,  2.15910046916,      289.56516671360}, 
    {     0.00000000104,  0.20665805247,      564.85505531580}, 
    {     0.00000000092,  5.09319278852,      600.01914553700}, 
    {     0.00000000096,  6.14431281930,     1050.99635880120}, 
    {     0.00000000081,  1.89134137927,       36.60037881970}, 
    {     0.00000000080,  4.38832609440,    10137.01947493540}, 
    {     0.00000000111,  2.93920408928,      384.27236954420}, 
    {     0.00000000079,  0.97793287738,       76.31425538540}, 
    {     0.00000000079,  4.53377022456,       76.21788716580}, 
    {     0.00000000090,  5.52318874603,      943.49835056750}, 
    {     0.00000000089,  0.86440255505,      398.68077409960}, 
    {     0.00000000084,  2.75719331074,      990.22940591440}, 
    {     0.00000000105,  3.05022136412,      233.53351624200}, 
    {     0.00000000088,  1.11114202915,      103.04459010880}, 
    {     0.00000000100,  5.59794770455,       63.47526587250}, 
    {     0.00000000083,  1.13342138644,      112.39336934330}, 
    {     0.00000000089,  5.47772001536,      515.46387109300}, 
    {     0.00000000097,  3.52796776171,      452.20105354160}, 
    {     0.00000000102,  4.28702103685,      171.02145821600}, 
    {     0.00000000085,  3.12585200036,     1158.28191871380}, 
    {     0.00000000085,  1.92685738761,     1082.01584743820}, 
    {     0.00000000098,  0.63359633835,      566.60016045500}, 
    {     0.00000000092,  4.62229215777,     2043.98226181110}, 
    {     0.00000000097,  2.01931678228,    10286.58267207000}, 
    {     0.00000000097,  5.84570418188,      477.91579079180}, 
    {     0.00000000102,  0.63659106649,      656.70518731440}, 
    {     0.00000000084,  0.81307057570,      170.71264167530}, 
    {     0.00000000094,  3.69951065430,      523.75307426140}, 
    {     0.00000000090,  0.60145820130,       36.76043751410}, 
    {     0.00000000086,  2.24624509383,      344.96367773880}, 
    {     0.00000000075,  1.25466323333,      378.64329525170}, 
    {     0.00000000074,  4.92603243986,     1549.45538693770}, 
    {     0.00000000076,  2.23758392622,     1310.81406126500}, 
    {     0.00000000076,  1.03858931347,     1234.54798998940}, 
    {     0.00000000094,  5.95660239987,      560.71045373160}, 
    {     0.00000000086,  3.90953269522,     1436.54075273260}, 
    {     0.00000000090,  2.80791662014,      639.63665388310}, 
    {     0.00000000091,  0.87037832675,      369.45457471160}, 
    {     0.00000000072,  2.86956711212,      134.06407874580}, 
    {     0.00000000084,  3.30910046360,       40.84134862350}, 
};


static const struct vsop neptune_longitude_l1[LONG_L1] = {
    {    38.13303563957,  0.00000000000,        0.00000000000}, 
    {     0.00016604172,  4.86323329249,        1.48447270830}, 
    {     0.00015744045,  2.27887427527,       38.13303563780}, 
    {     0.00001306261,  3.67285209620,        2.96894541660}, 
    {     0.00000604842,  1.50483042790,       35.16409022120}, 
    {     0.00000182909,  3.45225794434,       39.61750834610}, 
    {     0.00000195106,  0.88660326088,       76.26607127560}, 
    {     0.00000106410,  2.44986610969,        4.45341812490}, 
    {     0.00000105590,  2.75516054635,       33.67961751290}, 
    {     0.00000072757,  5.49395347003,       36.64856292950}, 
    {     0.00000057069,  5.21649804970,        0.52126486180}, 
    {     0.00000029871,  3.67043294114,      388.46515523820}, 
    {     0.00000028866,  5.16877538898,        9.56122755560}, 
    {     0.00000028742,  5.16732589024,        2.44768055480}, 
    {     0.00000025507,  5.24526281928,      168.05251279940}, 
    {     0.00000024869,  4.73193067879,      182.27960680100}, 
    {     0.00000020205,  5.78945415677,     1021.24889455140}, 
    {     0.00000019022,  1.82981144269,      484.44438245600}, 
    {     0.00000018661,  1.31606255521,      498.67147645760}, 
    {     0.00000015039,  4.94966181697,      137.03302416240}, 
    {     0.00000015094,  3.98706934679,       32.19514480460}, 
    {     0.00000010804,  1.93261742828,       41.10198105440}, 
    {     0.00000010720,  2.44148207341,        4.19278569400}, 
    {     0.00000011765,  4.87825331237,       71.81265315070}, 
    {     0.00000009363,  3.07523176644,       74.78159856730}, 
    {     0.00000009580,  1.23193270898,        5.93789083320}, 
    {     0.00000008968,  0.01758782577,        8.07675484730}, 
    {     0.00000009882,  6.08165614859,        7.11354700080}, 
    {     0.00000006992,  0.61688829918,        2.92076130680}, 
    {     0.00000006190,  5.32293546028,      114.39910691340}, 
    {     0.00000005543,  2.24141643357,       46.20979048510}, 
    {     0.00000005578,  5.45096032574,       73.29712585900}, 
    {     0.00000005858,  1.72552768872,       77.75054398390}, 
    {     0.00000003225,  4.82619066785,       98.89998852460}, 
    {     0.00000003233,  6.10277422759,       70.32818044240}, 
    {     0.00000002403,  2.90637675099,      601.76425067620}, 
    {     0.00000002398,  1.04343547015,        6.59228213900}, 
    {     0.00000002784,  4.95817105045,      108.46121608020}, 
    {     0.00000002894,  4.20148844767,      381.35160823740}, 
    {     0.00000002111,  5.93089610785,       25.60286266560}, 
    {     0.00000002343,  5.38519388332,      111.43016149680}, 
    {     0.00000002075,  5.20634366104,       30.71067209630}, 
    {     0.00000002126,  0.54976393131,       41.05379694460}, 
    {     0.00000001856,  0.89178118176,       24.11838995730}, 
    {     0.00000002223,  2.37864617899,      453.42489381900}, 
    {     0.00000002018,  3.42245277134,       31.01948863700}, 
    {     0.00000001700,  3.91715254179,       11.04570026390}, 
    {     0.00000001776,  3.86571077241,      395.57870223900}, 
    {     0.00000001646,  3.34591591398,       44.72531777680}, 
    {     0.00000001876,  2.59784473507,       33.94024994380}, 
    {     0.00000001468,  6.12983933526,     1550.93985964600}, 
    {     0.00000001405,  6.13184010665,      490.07345674850}, 
    {     0.00000001207,  0.59525736062,      312.19908396260}, 
    {     0.00000001607,  0.31467769026,      175.16605980020}, 
    {     0.00000001176,  5.87266726996,        5.41662597140}, 
    {     0.00000001333,  3.29176219816,      493.04240216510}, 
    {     0.00000001037,  4.89007314395,        1.27202438720}, 
    {     0.00000001034,  5.93741289103,       32.71640966640}, 
    {     0.00000001038,  1.13470380744,     1014.13534755060}, 
    {     0.00000001002,  1.85850922283,        5.10780943070}, 
    {     0.00000000983,  0.05347709280,        7.42236354150}, 
    {     0.00000000998,  1.73689827444,     1028.36244155220}, 
    {     0.00000001193,  4.63534810298,       60.76695288680}, 
    {     0.00000000940,  3.09103162869,       62.25142559510}, 
    {     0.00000000994,  4.11489180313,        4.66586644600}, 
    {     0.00000000890,  0.87049255398,       31.23193695810}, 
    {     0.00000001218,  3.13917786778,      491.55792945680}, 
    {     0.00000000852,  5.35508393873,      144.14657116320}, 
    {     0.00000000926,  5.11983602547,      145.10977900970}, 
    {     0.00000000789,  0.37496785039,       26.82670294300}, 
    {     0.00000000711,  3.14189997439,      278.25883401880}, 
    {     0.00000000727,  1.39886876821,      213.29909543800}, 
    {     0.00000000781,  0.11084554410,      173.68158709190}, 
    {     0.00000000669,  4.50554989404,       27.08733537390}, 
    {     0.00000000825,  1.35568911825,      129.91947716160}, 
    {     0.00000000738,  3.56612220900,      176.65053250850}, 
    {     0.00000000714,  6.24797506961,      106.97674337190}, 
    {     0.00000000650,  1.12660516258,       68.84370773410}, 
    {     0.00000000624,  0.01563274460,       28.57180808220}, 
    {     0.00000000608,  4.60180625368,      189.39315380180}, 
    {     0.00000000719,  0.22946487975,       42.58645376270}, 
    {     0.00000000530,  5.61201247156,       12.53017297220}, 
    {     0.00000000642,  0.70172928732,      529.69096509460}, 
    {     0.00000000494,  2.56554862431,      251.43213107580}, 
    {     0.00000000526,  3.02138731705,        5.62907429250}, 
    {     0.00000000456,  4.44331571392,       43.24084506850}, 
    {     0.00000000524,  3.43311475385,       38.65430049960}, 
    {     0.00000000436,  2.41601362194,       82.85835341460}, 
    {     0.00000000424,  1.95736011325,      477.33083545520}, 
    {     0.00000000443,  3.39350944965,      357.44566660120}, 
    {     0.00000000401,  0.17854032412,      567.82400073240}, 
    {     0.00000000382,  1.90239879977,       22.63391724900}, 
    {     0.00000000479,  5.55147421917,       37.61177077600}, 
    {     0.00000000462,  3.80436146981,      343.21857259960}, 
    {     0.00000000384,  5.60377408953,      594.65070367540}, 
    {     0.00000000369,  4.45577410338,        6.90109867970}, 
    {     0.00000000358,  3.69126615846,        3.93215326310}, 
    {     0.00000000352,  3.10946988482,      135.54855145410}, 
    {     0.00000000424,  5.29683941547,      181.75834193920}, 
    {     0.00000000361,  0.29019719613,       72.07328558160}, 
    {     0.00000000390,  5.49494308738,      350.33211960040}, 
    {     0.00000000378,  2.74122401337,      488.37653571910}, 
    {     0.00000000372,  0.39980033572,      494.73932319450}, 
    {     0.00000000353,  1.10614174053,       20.60692781950}, 
    {     0.00000000307,  3.30113579069,     1066.49547719000}, 
    {     0.00000000307,  5.39420288683,      160.93896579860}, 
    {     0.00000000369,  0.36210011664,       79.23501669220}, 
    {     0.00000000395,  1.93577214824,    10137.01947493540}, 
    {     0.00000000288,  2.28751244512,       47.69426319340}, 
    {     0.00000000291,  3.07789638770,       69.36497259590}, 
    {     0.00000000295,  2.48737537240,       19.12245511120}, 
    {     0.00000000293,  2.25797853419,     1052.26838318840}, 
    {     0.00000000298,  3.57815428349,       40.58071619260}, 
    {     0.00000000290,  0.18636083306,      143.62530630140}, 
    {     0.00000000274,  2.58630290331,      119.50691634410}, 
    {     0.00000000266,  1.21002824826,      505.78502345840}, 
    {     0.00000000252,  3.12744980468,      460.53844081980}, 
    {     0.00000000328,  0.50849285663,     6206.80977871580}, 
    {     0.00000000257,  3.64119923209,      446.31134681820}, 
    {     0.00000000239,  5.54080102299,      911.04257333200}, 
    {     0.00000000265,  0.62702473701,      253.57099508990}, 
    {     0.00000000287,  2.44403568436,       16.67477455640}, 
    {     0.00000000231,  2.47183469179,      454.90936652730}, 
    {     0.00000000281,  1.48514892087,      983.11585891360}, 
    {     0.00000000212,  5.41931177641,       64.95973858080}, 
    {     0.00000000213,  1.64175339637,     1089.12939443900}, 
    {     0.00000000238,  2.69801319489,      882.94384600180}, 
    {     0.00000000210,  4.53976756699,     1093.32218013300}, 
    {     0.00000000217,  3.52601381097,      152.53214255120}, 
    {     0.00000000216,  5.44223069507,       39.09624348430}, 
    {     0.00000000256,  0.42073598460,       23.90594163620}, 
    {     0.00000000202,  3.65153361854,      556.51766803760}, 
    {     0.00000000224,  4.43751404513,      639.89728631400}, 
    {     0.00000000198,  3.24942532936,    10251.41858184880}, 
    {     0.00000000191,  0.70266181509,      149.56319713460}, 
    {     0.00000000190,  2.64945536417,      984.60033162190}, 
    {     0.00000000189,  4.05785534221,      120.99138905240}, 
    {     0.00000000184,  2.24245977278,      815.06334611420}, 
    {     0.00000000202,  3.43517686770,       45.24658263860}, 
    {     0.00000000193,  2.15194865652,       67.35923502580}, 
    {     0.00000000175,  4.49165234532,      171.23390653710}, 
    {     0.00000000171,  5.50633466316,      179.09821306330}, 
    {     0.00000000200,  6.12663205401,       14.22709400160}, 
    {     0.00000000173,  2.61074067302,      389.94962794650}, 
    {     0.00000000192,  3.17111883673,      868.71675200020}, 
    {     0.00000000167,  3.94754384833,       77.22927912210}, 
    {     0.00000000166,  3.41009128748,       81.37388070630}, 
    {     0.00000000166,  4.89205139167,      872.90953769420}, 
    {     0.00000000170,  0.16973531975,      115.88357962170}, 
    {     0.00000000161,  2.55224034702,      487.36514376280}, 
    {     0.00000000164,  1.49614763031,       63.73589830340}, 
    {     0.00000000176,  3.86129425367,      148.33935685720}, 
    {     0.00000000171,  2.47073358147,      109.94568878850}, 
    {     0.00000000161,  2.22215642318,      574.93754773320}, 
    {     0.00000000188,  3.63784698745,      106.01353552540}, 
    {     0.00000000171,  0.66899426684,      179.31066138440}, 
    {     0.00000000158,  3.36297374123,      285.37238101960}, 
    {     0.00000000161,  1.21480182441,     1024.43028828910}, 
    {     0.00000000183,  5.45168150656,      218.40690486870}, 
    {     0.00000000156,  0.64321524870,     1029.84691426050}, 
    {     0.00000000151,  5.30865874765,      348.84764689210}, 
    {     0.00000000147,  1.80689177510,      377.41945497430}, 
    {     0.00000000193,  2.30767977885,     1447.84708542740}, 
    {     0.00000000149,  0.47455340012,      274.06604832480}, 
    {     0.00000000137,  2.14480227115,      563.63121503840}, 
    {     0.00000000137,  2.60839453958,      354.52490529440}, 
    {     0.00000000137,  1.41568352361,      386.98068252990}, 
    {     0.00000000136,  1.30429476661,      105.49227066360}, 
    {     0.00000000131,  5.83845597009,      419.48464387520}, 
    {     0.00000000127,  3.98728588464,       84.34282612290}, 
    {     0.00000000142,  1.22597408614,      142.14083359310}, 
    {     0.00000000123,  4.43184301227,      211.81462272970}, 
    {     0.00000000134,  4.16039500373,      169.53698550770}, 
    {     0.00000000121,  0.29301015084,      206.18554843720}, 
    {     0.00000000129,  2.67625064707,      180.79513409270}, 
    {     0.00000000119,  0.92800049940,       42.32582133180}, 
    {     0.00000000119,  4.35793909281,       14.01464568050}, 
    {     0.00000000134,  3.18869031781,      166.56804009110}, 
    {     0.00000000116,  4.81575725589,      560.71045373160}, 
    {     0.00000000135,  5.07450847539,      426.59819087600}, 
    {     0.00000000116,  4.29863269938,      138.51749687070}, 
    {     0.00000000129,  1.62619100480,      875.83029900100}, 
    {     0.00000000132,  2.97512323405,      258.02441321480}, 
    {     0.00000000129,  3.64795533299,      183.76407950930}, 
    {     0.00000000115,  1.48047840752,      219.89137757700}, 
    {     0.00000000116,  6.06435577890,      220.41264243880}, 
    {     0.00000000111,  5.34758096393,      670.91677495100}, 
    {     0.00000000123,  4.46585892600,     1022.73336725970}, 
    {     0.00000000111,  1.56986129352,      531.17543780290}, 
    {     0.00000000107,  0.80503196962,     1060.86640289750}, 
    {     0.00000000130,  3.49889244997,      799.56422772540}, 
    {     0.00000000108,  4.19624502746,      157.63995198190}, 
    {     0.00000000116,  5.58946533219,       35.68535508300}, 
    {     0.00000000102,  5.42185685225,       79.18683258240}, 
    {     0.00000000133,  4.95875659093,     6283.07584999140}, 
    {     0.00000000111,  1.45068439598,      433.71173787680}, 
    {     0.00000000108,  1.03915893069,      488.58898404020}, 
    {     0.00000000108,  2.10259280512,      494.52687487340}, 
    {     0.00000000114,  1.95389133455,       91.78644152380}, 
    {     0.00000000106,  0.86997192127,     1059.38193018920}, 
    {     0.00000000097,  4.22245180427,       67.88049988760}, 
    {     0.00000000126,  0.09441818431,    10213.28554621100}, 
    {     0.00000000109,  5.76793513384,      518.38463239980}, 
    {     0.00000000094,  3.29085817288,      949.17560896980}, 
    {     0.00000000090,  0.36813455675,      310.71461125430}, 
    {     0.00000000093,  2.03533728562,    10175.15251057320}, 
    {     0.00000000093,  1.45987720796,      422.40540518200}, 
    {     0.00000000097,  0.74486754369,      485.92885516430}, 
    {     0.00000000097,  4.49932032174,      632.78373931320}, 
    {     0.00000000095,  5.54259846730,      497.18700374930}, 
    {     0.00000000100,  3.82035103648,      110.20632121940}, 
    {     0.00000000085,  3.16062166564,      522.57741809380}, 
    {     0.00000000097,  6.05634816495,      482.95990974770}, 
    {     0.00000000095,  0.23111784604,      500.15594916590}, 
    {     0.00000000080,  5.79669381067,      313.68355667090}, 
    {     0.00000000084,  2.64687115752,      536.80451209540}, 
    {     0.00000000097,  3.21200267248,       97.41551581630}, 
    {     0.00000000078,  4.29527108326,      605.95703637020}, 
    {     0.00000000082,  2.59093334256,      244.31858407500}, 
    {     0.00000000079,  4.56190413535,      361.63845229520}, 
    {     0.00000000077,  2.35507598764,      184.72728735580}, 
    {     0.00000000073,  3.90646647360,     1019.76442184310}, 
    {     0.00000000092,  5.35417312882,       44.07092647100}, 
    {     0.00000000097,  1.10874938473,     1371.58101415180}, 
};


static const struct vsop neptune_longitude_l2[LONG_L2] = {
    {     0.00000286136,  1.18985661922,       38.13303563780}, 
    {     0.00000295650,  1.85520880574,        1.48447270830}, 
    {     0.00000102284,  0.00000000000,        0.00000000000}, 
    {     0.00000022987,  1.21060882957,        2.96894541660}, 
    {     0.00000007332,  0.53982718012,        2.44768055480}, 
    {     0.00000009112,  4.42541280638,       35.16409022120}, 
    {     0.00000005223,  0.67422237527,      168.05251279940}, 
    {     0.00000005201,  3.02334762854,      182.27960680100}, 
    {     0.00000003925,  3.53215364421,      484.44438245600}, 
    {     0.00000003741,  5.90239568618,      498.67147645760}, 
    {     0.00000003054,  0.28898269237,        4.45341812490}, 
    {     0.00000003382,  5.91086982903,       76.26607127560}, 
    {     0.00000003289,  1.84550132467,      175.16605980020}, 
    {     0.00000002157,  1.89134644831,      388.46515523820}, 
    {     0.00000002211,  4.37947574774,        7.11354700080}, 
    {     0.00000001955,  5.15138892758,       33.67961751290}, 
    {     0.00000001847,  3.48560457075,        9.56122755560}, 
    {     0.00000002436,  4.68322560973,      491.55792945680}, 
    {     0.00000001674,  2.55582666306,       36.64856292950}, 
    {     0.00000001309,  4.52441960698,     1021.24889455140}, 
    {     0.00000001081,  0.38230409887,      137.03302416240}, 
    {     0.00000000664,  0.87638209009,        4.19278569400}, 
    {     0.00000000516,  6.23450266091,      381.35160823740}, 
    {     0.00000000497,  2.24615784762,      395.57870223900}, 
    {     0.00000000486,  5.23098153853,       39.61750834610}, 
    {     0.00000000582,  5.25717304070,       31.01948863700}, 
    {     0.00000000395,  5.45450678888,        5.93789083320}, 
    {     0.00000000382,  4.60921220106,        8.07675484730}, 
    {     0.00000000435,  0.40412683723,       98.89998852460}, 
    {     0.00000000351,  1.32083544720,      601.76425067620}, 
    {     0.00000000270,  2.97193645281,       73.29712585900}, 
    {     0.00000000247,  2.89695614593,      189.39315380180}, 
    {     0.00000000235,  4.11675607570,      114.39910691340}, 
    {     0.00000000240,  3.56640034110,       41.10198105440}, 
    {     0.00000000242,  4.39232827391,      220.41264243880}, 
    {     0.00000000242,  5.56816734078,      343.21857259960}, 
    {     0.00000000220,  1.61117582925,      357.44566660120}, 
    {     0.00000000215,  1.21535463029,       74.78159856730}, 
    {     0.00000000198,  0.53499909652,       64.95973858080}, 
    {     0.00000000212,  0.05943058707,      493.04240216510}, 
    {     0.00000000206,  0.20022831995,     1028.36244155220}, 
    {     0.00000000264,  2.83515920571,      144.14657116320}, 
    {     0.00000000187,  0.52144835978,       46.20979048510}, 
    {     0.00000000247,  5.85680172451,     1059.38193018920}, 
    {     0.00000000228,  0.20021706844,       60.76695288680}, 
    {     0.00000000184,  3.01962045713,     1014.13534755060}, 
    {     0.00000000177,  3.63909894715,      983.11585891360}, 
    {     0.00000000172,  3.66036463613,      477.33083545520}, 
    {     0.00000000182,  1.92429336792,      183.76407950930}, 
    {     0.00000000171,  3.76746326227,      129.91947716160}, 
    {     0.00000000169,  4.91188584697,      166.56804009110}, 
    {     0.00000000157,  5.89309507727,      169.53698550770}, 
    {     0.00000000194,  1.51802955592,       71.81265315070}, 
    {     0.00000000114,  0.48567381491,      419.48464387520}, 
    {     0.00000000103,  2.80609907986,      433.71173787680}, 
    {     0.00000000093,  0.66549730538,      251.43213107580}, 
    {     0.00000000086,  5.12698345709,      567.82400073240}, 
    {     0.00000000086,  2.24868532014,      312.19908396260}, 
    {     0.00000000079,  2.04262119026,      274.06604832480}, 
};


static const struct vsop neptune_longitude_l3[LONG_L3] = {
    {     0.00000012472,  6.04427218715,        1.48447270830}, 
    {     0.00000011257,  6.11436681584,       38.13303563780}, 
    {     0.00000004354,  3.14159265359,        0.00000000000}, 
    {     0.00000001390,  4.95198243861,        2.96894541660}, 
    {     0.00000000745,  2.37751238105,      168.05251279940}, 
    {     0.00000000710,  1.29216892369,      182.27960680100}, 
    {     0.00000000540,  5.25465584672,      484.44438245600}, 
    {     0.00000000520,  4.18622893104,      498.67147645760}, 
    {     0.00000000664,  0.55871435877,       31.01948863700}, 
    {     0.00000000301,  2.69253200796,        7.11354700080}, 
    {     0.00000000192,  2.01562375989,      137.03302416240}, 
    {     0.00000000168,  6.26790496230,      357.44566660120}, 
    {     0.00000000183,  4.12898383544,       76.26607127560}, 
    {     0.00000000144,  2.84518337934,      460.53844081980}, 
    {     0.00000000144,  3.93173694550,      446.31134681820}, 
    {     0.00000000108,  3.45112519708,      522.57741809380}, 
    {     0.00000000108,  2.36456446266,      536.80451209540}, 
    {     0.00000000085,  4.34146183645,      433.71173787680}, 
};


static const struct vsop neptune_latitude_b0[LAT_B0] = {
    {     0.03088622933,  1.44104372644,       38.13303563780}, 
    {     0.00027780087,  5.91271884599,       76.26607127560}, 
    {     0.00027623609,  0.00000000000,        0.00000000000}, 
    {     0.00015355489,  2.52123799551,       36.64856292950}, 
    {     0.00015448133,  3.50877079215,       39.61750834610}, 
    {     0.00001999918,  1.50998668632,       74.78159856730}, 
    {     0.00001967540,  4.37778196626,        1.48447270830}, 
    {     0.00001015137,  3.21560997434,       35.16409022120}, 
    {     0.00000605767,  2.80246592015,       73.29712585900}, 
    {     0.00000594878,  2.12892696997,       41.10198105440}, 
    {     0.00000588806,  3.18655898167,        2.96894541660}, 
    {     0.00000401830,  4.16883411107,      114.39910691340}, 
    {     0.00000254333,  3.27120475878,      453.42489381900}, 
    {     0.00000261647,  3.76722702982,      213.29909543800}, 
    {     0.00000279963,  1.68165289071,       77.75054398390}, 
    {     0.00000205590,  4.25652269561,      529.69096509460}, 
    {     0.00000140455,  3.52969120587,      137.03302416240}, 
    {     0.00000098530,  4.16774786185,       33.67961751290}, 
    {     0.00000051257,  1.95120897519,        4.45341812490}, 
    {     0.00000067971,  4.66970488716,       71.81265315070}, 
    {     0.00000041931,  5.41783733708,      111.43016149680}, 
    {     0.00000041822,  5.94831807711,      112.91463420510}, 
    {     0.00000030637,  0.93620784844,       42.58645376270}, 
    {     0.00000011084,  5.88898642607,      108.46121608020}, 
    {     0.00000009620,  0.03946190739,       70.32818044240}, 
    {     0.00000009664,  0.22454439644,       79.23501669220}, 
    {     0.00000009728,  5.30069291338,       32.19514480460}, 
    {     0.00000007386,  3.00684969443,      426.59819087600}, 
    {     0.00000007087,  0.12539126589,      109.94568878850}, 
    {     0.00000006021,  6.20509673404,      115.88357962170}, 
    {     0.00000006169,  3.62095364534,      983.11585891360}, 
    {     0.00000004778,  0.75209801727,        5.93789083320}, 
    {     0.00000006391,  5.84641678934,      148.07872442630}, 
    {     0.00000006250,  2.41685076974,      152.53214255120}, 
    {     0.00000004538,  5.58174697144,      175.16605980020}, 
    {     0.00000005006,  4.60821553923,     1059.38193018920}, 
    {     0.00000004289,  4.19647890252,       47.69426319340}, 
    {     0.00000005795,  5.07512593683,      415.29185818120}, 
    {     0.00000004749,  2.51604900018,       37.61177077600}, 
    {     0.00000004119,  1.72780379682,       28.57180808220}, 
    {     0.00000004076,  6.00250763264,      145.10977900970}, 
    {     0.00000004429,  5.66004129948,       98.89998852460}, 
    {     0.00000003950,  2.74109077312,      350.33211960040}, 
    {     0.00000004091,  1.61788463987,       39.09624348430}, 
    {     0.00000004130,  4.40683058061,       37.16982779130}, 
    {     0.00000004710,  3.50928512298,       38.65430049960}, 
    {     0.00000004440,  4.78977105547,       38.08485152800}, 
    {     0.00000004433,  1.23386935925,       38.18121974760}, 
    {     0.00000003762,  4.83946937242,      491.55792945680}, 
    {     0.00000002606,  1.20948074983,      451.94042111070}, 
    {     0.00000002536,  2.18629981865,      454.90936652730}, 
    {     0.00000002328,  5.19777734610,       72.07328558160}, 
    {     0.00000002502,  0.85987169644,      106.97674337190}, 
    {     0.00000002342,  0.81385415125,        4.19278569400}, 
    {     0.00000001981,  0.46628243826,      184.72728735580}, 
    {     0.00000001963,  6.01908740123,       44.07092647100}, 
    {     0.00000002180,  0.70099749848,      206.18554843720}, 
    {     0.00000001814,  3.64693569553,      220.41264243880}, 
    {     0.00000001811,  0.40438727680,       40.58071619260}, 
    {     0.00000001706,  6.13546176473,      181.75834193920}, 
    {     0.00000001855,  5.61617808686,       35.68535508300}, 
    {     0.00000001595,  2.97142092029,       37.87240320690}, 
    {     0.00000001785,  2.42173650828,      388.46515523820}, 
    {     0.00000001595,  3.05261042370,       38.39366806870}, 
    {     0.00000001437,  1.48678263330,      135.54855145410}, 
    {     0.00000001387,  2.46128498127,      138.51749687070}, 
    {     0.00000001367,  1.52035493296,       68.84370773410}, 
    {     0.00000001575,  3.58964541604,       38.02116105320}, 
    {     0.00000001297,  5.06156596334,       33.94024994380}, 
    {     0.00000001487,  0.20211319124,       30.05628079050}, 
    {     0.00000001504,  5.80298305102,       46.20979048510}, 
    {     0.00000001192,  0.87274762791,       42.32582133180}, 
    {     0.00000001569,  2.43405967107,       38.24491022240}, 
    {     0.00000001207,  1.84658709550,      251.43213107580}, 
    {     0.00000001015,  0.53439848924,      129.91947716160}, 
    {     0.00000001000,  2.47430267510,      312.19908396260}, 
    {     0.00000000989,  3.41493531823,      144.14657116320}, 
    {     0.00000000963,  4.31728030609,      151.04766984290}, 
    {     0.00000001020,  0.98204578051,      143.62530630140}, 
    {     0.00000000940,  1.02983172757,      221.37585028530}, 
    {     0.00000000938,  2.43648016071,      567.82400073240}, 
    {     0.00000001111,  0.65217589630,      146.59425171800}, 
    {     0.00000000778,  0.00147489924,      218.40690486870}, 
    {     0.00000000895,  0.25116382531,       30.71067209630}, 
    {     0.00000000795,  5.80508903944,      149.56319713460}, 
    {     0.00000000737,  3.40041191615,      446.31134681820}, 
    {     0.00000000719,  1.43797240082,        8.07675484730}, 
    {     0.00000000720,  0.00651007550,      460.53844081980}, 
    {     0.00000000766,  4.03381639032,      522.57741809380}, 
    {     0.00000000666,  1.39459333877,       84.34282612290}, 
    {     0.00000000584,  1.01405548157,      536.80451209540}, 
    {     0.00000000596,  0.62385371171,       35.21227433100}, 
    {     0.00000000598,  5.39942003543,       41.05379694460}, 
    {     0.00000000475,  5.80146378263,        7.42236354150}, 
    {     0.00000000510,  1.34408868529,      258.02441321480}, 
    {     0.00000000458,  5.25296349653,       80.71948940050}, 
    {     0.00000000421,  3.24495106241,      416.77633088950}, 
    {     0.00000000446,  1.19100879284,      180.27386923090}, 
    {     0.00000000472,  0.92703398655,       44.72531777680}, 
    {     0.00000000388,  1.68493201140,      183.24281464750}, 
    {     0.00000000375,  0.15241043424,      255.05546779820}, 
    {     0.00000000354,  4.21553560271,        0.96320784650}, 
    {     0.00000000380,  2.17069237734,      105.49227066360}, 
    {     0.00000000341,  4.79196775965,      110.20632121940}, 
    {     0.00000000427,  5.15774558344,       31.54075349880}, 
    {     0.00000000301,  3.45817005630,      100.38446123290}, 
    {     0.00000000298,  2.26795857315,      639.89728631400}, 
    {     0.00000000279,  0.25689162963,       39.50563376150}, 
    {     0.00000000320,  3.58027351264,       45.24658263860}, 
    {     0.00000000269,  5.72024180826,       36.76043751410}, 
    {     0.00000000247,  0.60910176939,      186.21176006410}, 
    {     0.00000000245,  0.64173616285,      419.48464387520}, 
    {     0.00000000235,  0.73189197672,    10213.28554621100}, 
    {     0.00000000232,  0.37399769205,      490.07345674850}, 
    {     0.00000000230,  5.76579551439,       12.53017297220}, 
    {     0.00000000240,  4.13474003423,        0.52126486180}, 
    {     0.00000000279,  1.62813369297,      294.67297614430}, 
    {     0.00000000238,  2.18530921569,      219.89137757700}, 
    {     0.00000000262,  3.08411150984,        6.59228213900}, 
    {     0.00000000217,  2.93258397672,       27.08733537390}, 
    {     0.00000000217,  4.69259794345,      406.10313764110}, 
    {     0.00000000219,  1.35160367448,      216.92243216040}, 
    {     0.00000000200,  2.35228881303,      605.95703637020}, 
    {     0.00000000232,  3.92583619589,     1512.80682400820}, 
    {     0.00000000223,  5.52411141993,      187.69623277240}, 
    {     0.00000000190,  0.29170678080,      291.70403072770}, 
    {     0.00000000236,  3.12468256482,      563.63121503840}, 
    {     0.00000000193,  0.53307912023,       60.76695288680}, 
    {     0.00000000215,  3.78391258991,      103.09277421860}, 
    {     0.00000000172,  5.63262770751,        7.11354700080}, 
    {     0.00000000164,  4.14647236992,       77.22927912210}, 
    {     0.00000000162,  0.71904053601,       11.04570026390}, 
    {     0.00000000160,  4.23625258528,      487.36514376280}, 
    {     0.00000000191,  0.37601781666,       31.01948863700}, 
    {     0.00000000157,  1.02419759383,     6283.07584999140}, 
    {     0.00000000157,  4.42530429545,     6206.80977871580}, 
    {     0.00000000178,  6.24797160212,      316.39186965660}, 
    {     0.00000000161,  5.65988283675,      343.21857259960}, 
    {     0.00000000153,  5.58414765899,      252.08652238160}, 
    {     0.00000000189,  4.80791039970,      641.12112659140}, 
    {     0.00000000166,  5.50438043690,      662.53120356300}, 
    {     0.00000000146,  5.08949604858,      286.59622129700}, 
    {     0.00000000145,  2.13015521882,     2042.49778910280}, 
    {     0.00000000156,  2.19405770242,      274.06604832480}, 
    {     0.00000000148,  4.85749820683,      442.75170057060}, 
    {     0.00000000187,  4.96121139093,     1589.07289528380}, 
    {     0.00000000155,  2.28259405687,      142.14083359310}, 
    {     0.00000000134,  1.29277232397,      456.39383923560}, 
    {     0.00000000126,  5.59769497652,      179.35884549420}, 
    {     0.00000000146,  2.53463818201,      256.53994050650}, 
    {     0.00000000140,  1.57962199938,       75.74480641380}, 
    {     0.00000000123,  0.05437698562,      944.98282327580}, 
    {     0.00000000122,  1.90676170566,      418.26080359780}, 
    {     0.00000000154,  1.86816969261,      331.32153907380}, 
    {     0.00000000144,  5.52321332407,       14.01464568050}, 
    {     0.00000000139,  2.80726892154,       82.85835341460}, 
    {     0.00000000107,  0.66980589221,      190.66517818900}, 
    {     0.00000000114,  1.48896223432,      253.57099508990}, 
    {     0.00000000110,  5.32587573069,      240.12579838100}, 
    {     0.00000000105,  0.65340064265,      173.68158709190}, 
    {     0.00000000102,  2.58735834098,      450.45594840240}, 
    {     0.00000000099,  0.43935555771,      328.35259365720}, 
    {     0.00000000101,  4.71130182307,      117.36805233000}, 
    {     0.00000000095,  2.17590506749,      101.86893394120}, 
    {     0.00000000094,  0.55008356412,      293.18850343600}, 
    {     0.00000000093,  0.63642129305,      377.15882254340}, 
    {     0.00000000091,  5.84828809934,    10137.01947493540}, 
    {     0.00000000089,  1.02829282520,     1021.24889455140}, 
    {     0.00000000094,  1.79318047295,      493.04240216510}, 
    {     0.00000000080,  1.58140274465,       69.15252427480}, 
    {     0.00000000074,  0.23362667562,       63.73589830340}, 
    {     0.00000000071,  1.51961975694,      488.58898404020}, 
};


static const struct vsop neptune_latitude_b1[LAT_B1] = {
    {     0.00005150897,  2.14270496419,       38.13303563780}, 
    {     0.00000258298,  5.46539598920,       76.26607127560}, 
    {     0.00000251862,  4.40444268588,       36.64856292950}, 
    {     0.00000234436,  1.65983511437,       39.61750834610}, 
    {     0.00000208814,  0.00000000000,        0.00000000000}, 
    {     0.00000025312,  6.00917621033,       35.16409022120}, 
    {     0.00000017795,  4.95721064558,      213.29909543800}, 
    {     0.00000017841,  0.44821000048,       41.10198105440}, 
    {     0.00000013152,  1.49958304388,      529.69096509460}, 
    {     0.00000010729,  4.39946094022,       73.29712585900}, 
    {     0.00000008422,  1.55833887152,        2.96894541660}, 
    {     0.00000005650,  2.15782280490,       74.78159856730}, 
    {     0.00000005164,  3.68693766150,      114.39910691340}, 
    {     0.00000005439,  0.26747546514,       77.75054398390}, 
    {     0.00000004883,  5.47281451218,        1.48447270830}, 
    {     0.00000001863,  5.45718239014,       71.81265315070}, 
    {     0.00000001956,  0.59394993708,       33.67961751290}, 
    {     0.00000001486,  0.26979020045,        4.45341812490}, 
    {     0.00000001482,  5.46695876828,       42.58645376270}, 
    {     0.00000000881,  4.07805940363,       37.61177077600}, 
    {     0.00000000881,  1.94513348170,       38.65430049960}, 
    {     0.00000000851,  2.39564495000,      206.18554843720}, 
    {     0.00000000606,  1.99397575028,      220.41264243880}, 
    {     0.00000000552,  2.27385531237,      137.03302416240}, 
    {     0.00000000425,  5.31717031249,      112.91463420510}, 
    {     0.00000000444,  1.89596154412,       40.58071619260}, 
    {     0.00000000405,  2.23350335799,      129.91947716160}, 
    {     0.00000000445,  1.89735718846,       47.69426319340}, 
    {     0.00000000390,  3.00112052361,      111.43016149680}, 
    {     0.00000000444,  4.12778640748,       35.68535508300}, 
    {     0.00000000390,  1.72106368725,      144.14657116320}, 
    {     0.00000000447,  4.12632050294,       28.57180808220}, 
    {     0.00000000385,  0.60554020191,      426.59819087600}, 
    {     0.00000000443,  0.66667071474,      350.33211960040}, 
    {     0.00000000413,  2.53628535203,      453.42489381900}, 
    {     0.00000000322,  2.78214046965,      983.11585891360}, 
    {     0.00000000294,  5.10116120513,      446.31134681820}, 
    {     0.00000000332,  2.57248850528,     1059.38193018920}, 
    {     0.00000000288,  4.58741150748,      460.53844081980}, 
    {     0.00000000288,  0.74693614733,       70.32818044240}, 
    {     0.00000000275,  1.46123635585,      175.16605980020}, 
    {     0.00000000237,  6.26990493578,      522.57741809380}, 
    {     0.00000000254,  5.45401514230,      536.80451209540}, 
    {     0.00000000228,  2.46457859271,       98.89998852460}, 
    {     0.00000000204,  5.30009848697,        5.93789083320}, 
    {     0.00000000142,  1.52594076364,      109.94568878850}, 
    {     0.00000000167,  5.03534602485,       79.23501669220}, 
    {     0.00000000133,  2.11377639696,      152.53214255120}, 
    {     0.00000000082,  3.63263716103,      491.55792945680}, 
};


static const struct vsop neptune_latitude_b2[LAT_B2] = {
    {     0.00000042058,  1.91480759314,       38.13303563780}, 
    {     0.00000004359,  4.77459417163,       39.61750834610}, 
    {     0.00000004230,  1.12991232222,       36.64856292950}, 
    {     0.00000004166,  4.37185631758,       76.26607127560}, 
    {     0.00000001235,  0.13036455232,      213.29909543800}, 
    {     0.00000000905,  3.05640125957,      529.69096509460}, 
    {     0.00000000743,  3.14159265359,        0.00000000000}, 
    {     0.00000000380,  1.70771699530,       35.16409022120}, 
    {     0.00000000328,  4.23287817216,       41.10198105440}, 
    {     0.00000000188,  1.15191208244,      220.41264243880}, 
    {     0.00000000132,  4.73251124812,      206.18554843720}, 
    {     0.00000000084,  3.93928282212,      129.91947716160}, 
    {     0.00000000080,  0.01151271706,      144.14657116320}, 
};


static const struct vsop neptune_latitude_b3[LAT_B3] = {
    {     0.00000004131,  3.06928911462,       38.13303563780}, 
    {     0.00000000143,  4.00453590187,       36.64856292950}, 
};


static const struct vsop neptune_radius_r0[RADIUS_R0] = {
    {    30.07013205828,  0.00000000000,        0.00000000000}, 
    {     0.27062259632,  1.32999459377,       38.13303563780}, 
    {     0.01691764014,  3.25186135653,       36.64856292950}, 
    {     0.00807830553,  5.18592878704,        1.48447270830}, 
    {     0.00537760510,  4.52113935896,       35.16409022120}, 
    {     0.00495725141,  1.57105641650,      491.55792945680}, 
    {     0.00274571975,  1.84552258866,      175.16605980020}, 
    {     0.00135134092,  3.37220609835,       39.61750834610}, 
    {     0.00121801746,  5.79754470298,       76.26607127560}, 
    {     0.00100896068,  0.37702724930,       73.29712585900}, 
    {     0.00069791331,  3.79616637768,        2.96894541660}, 
    {     0.00046687836,  5.74938034313,       33.67961751290}, 
    {     0.00024594531,  0.50801745878,      109.94568878850}, 
    {     0.00016939478,  1.59422512526,       71.81265315070}, 
    {     0.00014229808,  1.07785898723,       74.78159856730}, 
    {     0.00012012320,  1.92059384991,     1021.24889455140}, 
    {     0.00008394349,  0.67818233586,      146.59425171800}, 
    {     0.00007571796,  1.07149207335,      388.46515523820}, 
    {     0.00005720872,  2.59061733345,        4.45341812490}, 
    {     0.00004840210,  1.90681013048,       41.10198105440}, 
    {     0.00004483493,  2.90573464537,      529.69096509460}, 
    {     0.00004269595,  3.41333526870,      453.42489381900}, 
    {     0.00004353588,  0.67984856103,       32.19514480460}, 
    {     0.00004420549,  1.74990681127,      108.46121608020}, 
    {     0.00002879755,  1.98627174527,      137.03302416240}, 
    {     0.00002635535,  3.09755951044,      213.29909543800}, 
    {     0.00003381113,  0.84810966225,      183.24281464750}, 
    {     0.00002877511,  3.67417203197,      350.33211960040}, 
    {     0.00002306505,  2.80964587883,       70.32818044240}, 
    {     0.00002529939,  5.79822254729,      490.07345674850}, 
    {     0.00002522868,  0.48612122962,      493.04240216510}, 
    {     0.00002085926,  0.61853857468,       33.94024994380}, 
    {     0.00001976522,  5.11703044560,      168.05251279940}, 
    {     0.00001904055,  1.72165893329,      182.27960680100}, 
    {     0.00001653525,  1.92781987560,      145.10977900970}, 
    {     0.00001434507,  1.69985856533,      484.44438245600}, 
    {     0.00001403029,  4.58914203187,      498.67147645760}, 
    {     0.00001499989,  1.01619882251,      219.89137757700}, 
    {     0.00001397976,  0.76199761055,      176.65053250850}, 
    {     0.00001402764,  6.07659120736,      173.68158709190}, 
    {     0.00001128278,  5.96666460978,        9.56122755560}, 
    {     0.00001228058,  1.59915900158,       77.75054398390}, 
    {     0.00000835562,  3.97050539397,      114.39910691340}, 
    {     0.00000811407,  3.00264146159,       46.20979048510}, 
    {     0.00000731543,  2.10445780662,      181.75834193920}, 
    {     0.00000615618,  2.97867866529,      106.97674337190}, 
    {     0.00000703453,  1.18748208693,      256.53994050650}, 
    {     0.00000501955,  1.38654746863,        5.93789083320}, 
    {     0.00000530475,  4.24112162150,      111.43016149680}, 
    {     0.00000437096,  2.27029212923,     1550.93985964600}, 
    {     0.00000399906,  1.25612321821,        8.07675484730}, 
    {     0.00000420992,  1.89248234590,       30.71067209630}, 
    {     0.00000382461,  3.29964092733,      983.11585891360}, 
    {     0.00000422891,  5.53099620330,      525.49817940060}, 
    {     0.00000355064,  2.27873080286,      218.40690486870}, 
    {     0.00000281092,  4.54185193503,       44.72531777680}, 
    {     0.00000314499,  3.95932948594,      381.35160823740}, 
    {     0.00000279604,  1.54525386438,       98.89998852460}, 
    {     0.00000268088,  5.13448119540,      112.91463420510}, 
    {     0.00000333260,  5.75014889084,       39.09624348430}, 
    {     0.00000291773,  4.02405440052,       68.84370773410}, 
    {     0.00000321430,  1.50624339061,      454.90936652730}, 
    {     0.00000309200,  2.85451259377,       72.07328558160}, 
    {     0.00000345541,  1.35801933629,      293.18850343600}, 
    {     0.00000307360,  0.31939966593,      601.76425067620}, 
    {     0.00000251026,  3.54039557458,      312.19908396260}, 
    {     0.00000248151,  3.41078778961,       37.61177077600}, 
    {     0.00000306000,  2.72475094464,     6244.94281435360}, 
    {     0.00000293530,  4.89079714624,      528.20649238630}, 
    {     0.00000234148,  0.59107513684,       42.58645376270}, 
    {     0.00000239159,  3.15940174394,      143.62530630140}, 
    {     0.00000214523,  3.62480267276,      278.25883401880}, 
    {     0.00000246198,  1.01506302015,      141.22580985640}, 
    {     0.00000174151,  5.54934515763,      567.82400073240}, 
    {     0.00000163736,  2.09772553888,        2.44768055480}, 
    {     0.00000162895,  2.48942845886,        4.19278569400}, 
    {     0.00000193252,  1.58538835107,      138.51749687070}, 
    {     0.00000155321,  3.28425560727,       31.01948863700}, 
    {     0.00000182280,  2.45335941387,      255.05546779820}, 
    {     0.00000177846,  4.14773474853,    10175.15251057320}, 
    {     0.00000174672,  1.53072472355,      329.83706636550}, 
    {     0.00000137774,  3.34926113123,        0.96320784650}, 
    {     0.00000160922,  5.16388154007,      211.81462272970}, 
    {     0.00000113312,  4.96838153028,      148.07872442630}, 
    {     0.00000129107,  3.25539370530,       24.11838995730}, 
    {     0.00000122785,  5.39724696402,       62.25142559510}, 
    {     0.00000107361,  3.26459113010,     1059.38193018920}, 
    {     0.00000119951,  3.07428550584,      184.72728735580}, 
    {     0.00000099006,  1.92575084098,       28.57180808220}, 
    {     0.00000097710,  2.59473517954,        6.59228213900}, 
    {     0.00000123604,  3.11899453253,      221.37585028530}, 
    {     0.00000124693,  2.97042402154,      251.43213107580}, 
    {     0.00000114252,  0.25039919123,      594.65070367540}, 
    {     0.00000110984,  3.34269023552,      180.27386923090}, 
    {     0.00000120812,  1.92944484022,       25.60286266560}, 
    {     0.00000104667,  0.94883561775,      395.57870223900}, 
    {     0.00000109779,  5.43147613574,      494.52687487340}, 
    {     0.00000096919,  0.86184760695,     1014.13534755060}, 
    {     0.00000098685,  0.89578101892,      488.58898404020}, 
    {     0.00000088965,  4.78114888597,      144.14657116320}, 
    {     0.00000107888,  0.98700578434,     1124.34166877000}, 
    {     0.00000097074,  2.62665185334,      291.70403072770}, 
    {     0.00000075666,  5.88963758122,       43.24084506850}, 
    {     0.00000093718,  6.09873436871,      526.72201967800}, 
    {     0.00000094822,  0.20662771116,      456.39383923560}, 
    {     0.00000069954,  2.39614984454,      426.59819087600}, 
    {     0.00000089656,  3.25464366223,      258.02441321480}, 
    {     0.00000076880,  4.20394189510,      105.49227066360}, 
    {     0.00000069133,  4.93031154435,     1028.36244155220}, 
    {     0.00000090474,  1.69635495867,      366.48562929500}, 
    {     0.00000073446,  3.14305202700,       82.85835341460}, 
    {     0.00000057870,  0.85902654510,       60.76695288680}, 
    {     0.00000078695,  1.09307575550,      700.66423920080}, 
    {     0.00000055696,  3.89047184339,       47.69426319340}, 
    {     0.00000063218,  4.39571226649,      149.56319713460}, 
    {     0.00000056877,  0.81233112899,        2.92076130680}, 
    {     0.00000056765,  5.14903738264,        0.52126486180}, 
    {     0.00000056174,  5.42986960794,      911.04257333200}, 
    {     0.00000061746,  6.16453594476,     1019.76442184310}, 
    {     0.00000070668,  0.08154675285,       40.58071619260}, 
    {     0.00000074941,  4.85541117469,      186.21176006410}, 
    {     0.00000062137,  4.79000169130,       11.04570026390}, 
    {     0.00000061135,  0.83712327235,     1022.73336725970}, 
    {     0.00000061658,  5.70207975404,      178.13500521680}, 
    {     0.00000053467,  0.37111991212,       27.08733537390}, 
    {     0.00000056400,  3.52361228973,      216.92243216040}, 
    {     0.00000048819,  5.10789123481,       64.95973858080}, 
    {     0.00000063989,  6.27428332013,        7.11354700080}, 
    {     0.00000063290,  4.39424910030,      807.94979911340}, 
    {     0.00000046355,  1.34731122935,      451.94042111070}, 
    {     0.00000060544,  3.40308211679,      294.67297614430}, 
    {     0.00000057140,  0.44713393582,      140.00196957900}, 
    {     0.00000046891,  0.16868575852,        7.42236354150}, 
    {     0.00000053760,  2.79644964300,      328.35259365720}, 
    {     0.00000056110,  1.06133412372,      172.19711438360}, 
    {     0.00000043828,  6.04649305744,      135.54855145410}, 
    {     0.00000049546,  0.64111181985,       41.05379694460}, 
    {     0.00000054352,  2.92484004653,      563.63121503840}, 
    {     0.00000042962,  5.40180687766,      487.36514376280}, 
    {     0.00000051507,  0.09101955359,      210.33015002140}, 
    {     0.00000042022,  3.11630465723,       29.22619938800}, 
    {     0.00000047855,  3.90929080860,       63.73589830340}, 
    {     0.00000041545,  6.27971504434,       32.71640966640}, 
    {     0.00000041412,  4.45532728136,       37.16982779130}, 
    {     0.00000040691,  0.15392324705,       79.23501669220}, 
    {     0.00000048205,  1.84198373010,      403.13419222450}, 
    {     0.00000036975,  0.44979453927,       30.05628079050}, 
    {     0.00000047762,  0.88083849566,     3302.47939106200}, 
    {     0.00000039465,  3.50565537871,      357.44566660120}, 
    {     0.00000042139,  0.63375113641,      343.21857259960}, 
    {     0.00000042780,  3.55125610401,       38.65430049960}, 
    {     0.00000038995,  5.26486175542,      415.29185818120}, 
    {     0.00000038872,  5.25715558452,      386.98068252990}, 
    {     0.00000040508,  1.36656945746,       31.23193695810}, 
    {     0.00000033786,  5.23988634904,       67.35923502580}, 
    {     0.00000040879,  3.55298595767,      331.32153907380}, 
    {     0.00000038768,  1.12288359393,       38.18121974760}, 
    {     0.00000036962,  6.08599078489,       35.42472265210}, 
    {     0.00000038831,  4.67876780698,       38.08485152800}, 
    {     0.00000038231,  6.26491109393,      389.94962794650}, 
    {     0.00000031356,  0.07745279153,       12.53017297220}, 
    {     0.00000026341,  4.59559782764,      106.01353552540}, 
    {     0.00000029746,  4.45828452713,       22.63391724900}, 
    {     0.00000027465,  5.99541587686,      206.18554843720}, 
    {     0.00000026195,  4.49611532896,       34.20088237470}, 
    {     0.00000024122,  5.17089442140,      129.91947716160}, 
    {     0.00000028998,  3.64928923192,      253.57099508990}, 
    {     0.00000026787,  4.37969316517,      142.14083359310}, 
    {     0.00000030385,  1.60122950634,      348.84764689210}, 
    {     0.00000024285,  1.01980822546,       41.75637236020}, 
    {     0.00000031322,  1.05975821421,      100.38446123290}, 
    {     0.00000022588,  4.72482137820,       81.37388070630}, 
    {     0.00000026405,  3.03479369857,      365.00115658670}, 
    {     0.00000021916,  3.48038797535,       69.15252427480}, 
    {     0.00000022498,  4.03487494425,       19.12245511120}, 
    {     0.00000021838,  3.92447477596,        5.10780943070}, 
    {     0.00000022885,  1.58977064672,      189.39315380180}, 
    {     0.00000025496,  2.43810677799,      351.81659230870}, 
    {     0.00000026083,  3.61207095239,      367.97010200330}, 
    {     0.00000019111,  2.59694457001,     2080.63082474060}, 
    {     0.00000019640,  6.15701741238,       35.21227433100}, 
    {     0.00000025688,  2.00512719767,      439.78275515400}, 
    {     0.00000021613,  3.32354204724,      119.50691634410}, 
    {     0.00000025389,  4.74025836522,     1474.67378837040}, 
    {     0.00000018107,  5.35129342595,      244.31858407500}, 
    {     0.00000022539,  4.79833880058,       84.34282612290}, 
    {     0.00000023295,  5.93767762095,      316.39186965660}, 
    {     0.00000016978,  3.05115560279,      220.41264243880}, 
    {     0.00000020022,  4.99276451168,      179.09821306330}, 
    {     0.00000020370,  1.86508317889,      171.23390653710}, 
    {     0.00000022628,  0.27205770382,      666.72398925700}, 
    {     0.00000018427,  3.39354245580,       69.36497259590}, 
    {     0.00000019046,  2.02999241631,        5.41662597140}, 
    {     0.00000015738,  3.40021239975,      274.06604832480}, 
    {     0.00000019072,  3.70882976684,      164.12035953630}, 
    {     0.00000018716,  0.90215956591,      285.37238101960}, 
    {     0.00000015889,  0.42011285882,      697.74347789400}, 
    {     0.00000014988,  3.08544843936,      704.85702489480}, 
    {     0.00000015972,  1.82864185268,      477.33083545520}, 
    {     0.00000016509,  5.04817895427,       36.90919536040}, 
    {     0.00000013892,  2.94161501165,       38.39366806870}, 
    {     0.00000014019,  2.86061049050,       37.87240320690}, 
    {     0.00000015302,  4.94041289914,      101.86893394120}, 
    {     0.00000017397,  5.81486997282,       35.68535508300}, 
    {     0.00000017379,  2.51842240176,       20.60692781950}, 
    {     0.00000016416,  3.63037693563,       45.24658263860}, 
    {     0.00000012943,  3.03051173423,      522.57741809380}, 
    {     0.00000015752,  5.00292909214,      247.23934538180}, 
    {     0.00000014362,  5.49004892867,       39.35687591520}, 
    {     0.00000012679,  0.20331109323,      460.53844081980}, 
    {     0.00000016260,  5.93480347217,      815.06334611420}, 
    {     0.00000012900,  3.51131840632,      446.31134681820}, 
    {     0.00000013891,  5.51064697666,       31.54075349880}, 
    {     0.00000015770,  3.77930539694,      404.61866493280}, 
    {     0.00000013399,  3.96033558345,      290.21955801940}, 
    {     0.00000015368,  2.45783892707,       26.82670294300}, 
    {     0.00000014246,  3.18588280921,      401.64971951620}, 
    {     0.00000012199,  4.94365391256,       14.01464568050}, 
    {     0.00000014368,  4.93297486962,      120.99138905240}, 
    {     0.00000013413,  3.79142222247,      151.04766984290}, 
    {     0.00000012073,  2.92823577017,        2.70831298570}, 
    {     0.00000014120,  4.69411530315,      738.79727483860}, 
    {     0.00000011566,  5.91003538993,      536.80451209540}, 
    {     0.00000015578,  2.91836788254,      875.83029900100}, 
    {     0.00000013125,  2.16051328657,      152.53214255120}, 
    {     0.00000012793,  1.97868575679,        1.37259812370}, 
    {     0.00000014101,  4.75302563115,        0.26063243090}, 
    {     0.00000012967,  0.00533471540,       97.41551581630}, 
    {     0.00000010788,  6.18639055862,      115.88357962170}, 
    {     0.00000013729,  2.32306473850,       38.24491022240}, 
    {     0.00000011606,  4.61702427262,      178.78939652260}, 
    {     0.00000011256,  0.79281130068,       42.32582133180}, 
    {     0.00000014500,  5.44688707180,       44.07092647100}, 
    {     0.00000011534,  5.26580538005,      160.93896579860}, 
    {     0.00000013411,  5.17996944056,       32.45577723550}, 
    {     0.00000013658,  2.15687632802,      476.43131808350}, 
    {     0.00000012788,  2.07356149992,       20.49505323490}, 
    {     0.00000013782,  3.47865209163,       38.02116105320}, 
    {     0.00000013257,  5.15138529480,      103.09277421860}, 
    {     0.00000009715,  0.74597883480,      918.15612033280}, 
    {     0.00000010378,  5.38520350123,      222.86032299360}, 
    {     0.00000013357,  5.89635739027,      748.09786996330}, 
    {     0.00000012632,  1.20306997433,       16.15350969460}, 
    {     0.00000011437,  1.58444114292,      495.49008271990}, 
    {     0.00000011424,  4.74142930795,      487.62577619370}, 
    {     0.00000009336,  0.97313630950,      662.53120356300}, 
    {     0.00000008911,  5.21180580479,      118.02244363580}, 
    {     0.00000009827,  4.48170250645,      505.78502345840}, 
    {     0.00000011615,  3.09644428293,       17.63798240290}, 
    {     0.00000009957,  4.03258124099,      169.53698550770}, 
    {     0.00000009818,  5.20376439002,        1.59634729290}, 
    {     0.00000010160,  3.74441320429,      457.61767951300}, 
    {     0.00000008661,  0.31247523804,     1440.73353842660}, 
    {     0.00000008496,  1.06445636872,       55.77101804070}, 
    {     0.00000011162,  1.92907822340,      564.85505531580}, 
    {     0.00000008434,  5.55699081873,       17.52610781830}, 
    {     0.00000008057,  0.31116345866,      377.41945497430}, 
    {     0.00000010070,  3.92554977184,      441.26722786230}, 
    {     0.00000007770,  0.14603509444,      944.98282327580}, 
    {     0.00000007938,  2.40417397694,      488.37653571910}, 
    {     0.00000009894,  0.63707319139,      183.76407950930}, 
    {     0.00000007633,  2.25662443193,       79.18683258240}, 
    {     0.00000007867,  3.87469522964,      494.73932319450}, 
    {     0.00000009203,  4.36605841970,       29.74746424980}, 
    {     0.00000009716,  3.06038536864,      166.56804009110}, 
    {     0.00000009377,  0.56416645296,      673.31627139600}, 
    {     0.00000008771,  5.24535317574,     1057.89745748090}, 
    {     0.00000008225,  5.42577676109,      104.00779795530}, 
    {     0.00000008367,  0.48337087236,       19.01058052660}, 
    {     0.00000009820,  5.88955818086,      358.40887444770}, 
    {     0.00000007009,  2.93493492342,        0.04818410980}, 
    {     0.00000008254,  3.47304582051,      156.15547927360}, 
    {     0.00000007684,  1.53844437652,       59.28248017850}, 
    {     0.00000009804,  6.06393995615,      784.74643289280}, 
    {     0.00000008516,  5.99059807952,      180.79513409270}, 
    {     0.00000008090,  1.38588221442,     1654.03263386460}, 
    {     0.00000009074,  4.03971490460,     1017.05610885740}, 
    {     0.00000006908,  1.41919832926,      178.34745353790}, 
    {     0.00000008713,  0.35913477738,      636.66770846650}, 
    {     0.00000008230,  2.53750470473,      518.38463239980}, 
    {     0.00000008594,  5.29103584901,      457.87831194390}, 
    {     0.00000006769,  5.43380191356,      171.98466606250}, 
    {     0.00000008995,  1.36992508507,     6209.77872413240}, 
    {     0.00000009278,  3.80308677009,    25558.21217647960}, 
    {     0.00000006562,  3.13520633691,      416.77633088950}, 
    {     0.00000006567,  4.01934954352,        0.11187458460}, 
    {     0.00000007032,  4.14454482953,      326.86812094890}, 
    {     0.00000008384,  5.49363770202,      532.61172640140}, 
    {     0.00000007471,  4.62144262894,      526.98265210890}, 
    {     0.00000007500,  0.61545750834,      485.92885516430}, 
    {     0.00000007716,  1.04880061527,      525.23754696970}, 
    {     0.00000008504,  2.79350586429,    10139.98842035200}, 
    {     0.00000008006,  5.70274817349,      209.10630974400}, 
    {     0.00000007580,  5.07865976334,      157.63995198190}, 
    {     0.00000007186,  6.22843514949,       77.22927912210}, 
    {     0.00000007754,  4.25725025641,      418.26080359780}, 
    {     0.00000007784,  1.89308086046,      984.60033162190}, 
    {     0.00000006060,  4.25541364939,       36.12729806770}, 
    {     0.00000006513,  0.07498932215,       79.88940799800}, 
    {     0.00000006050,  2.97979060439,       36.69674703930}, 
    {     0.00000007265,  4.94483532763,      131.40394986990}, 
    {     0.00000006984,  2.53239305821,      497.18700374930}, 
    {     0.00000007824,  2.31462643851,      513.07988101300}, 
    {     0.00000007175,  3.69203633127,      524.01370669230}, 
    {     0.00000006855,  0.14076801572,      283.62727588040}, 
    {     0.00000007476,  5.27896188334,      259.50888592310}, 
    {     0.00000006922,  3.36515011915,      438.29828244570}, 
    {     0.00000007349,  3.50406958122,      500.15594916590}, 
    {     0.00000006301,  0.14776691217,      608.87779767700}, 
    {     0.00000005892,  4.24403528888,        4.66586644600}, 
    {     0.00000005995,  4.84848023982,      215.43795945210}, 
    {     0.00000007128,  5.92696788834,      482.95990974770}, 
    {     0.00000006829,  1.01745137848,     1543.82631264520}, 
    {     0.00000006817,  6.12162829690,      395.05743737720}, 
    {     0.00000005369,  3.76855960849,    52099.54021187280}, 
    {     0.00000005776,  5.61434462641,      987.56927703850}, 
    {     0.00000007523,  5.60432148128,     2810.92146160520}, 
    {     0.00000007329,  3.76816058312,     1512.80682400820}, 
    {     0.00000005616,  2.13874186970,      145.63104387150}, 
    {     0.00000005260,  0.35171132812,       36.60037881970}, 
    {     0.00000005366,  2.33827486119,       65.22037101170}, 
    {     0.00000005688,  1.82274388581,     1227.43444298860}, 
    {     0.00000005658,  2.35049199704,        5.62907429250}, 
    {     0.00000006135,  4.23390394127,      496.01134758170}, 
    {     0.00000006472,  3.49494191669,      552.69738935910}, 
    {     0.00000004983,  3.91958511552,    10135.53500222710}, 
    {     0.00000005071,  2.99193131986,      313.68355667090}, 
    {     0.00000005964,  5.70758449643,      309.79958751760}, 
    {     0.00000004830,  1.15390722082,      134.06407874580}, 
    {     0.00000005091,  6.00974510144,     1409.71404978960}, 
    {     0.00000005205,  5.50271334510,      238.90195810360}, 
    {     0.00000005330,  0.31491843987,      319.31263096340}, 
    {     0.00000004943,  1.43051344597,      422.40540518200}, 
    {     0.00000005604,  2.05669305961,      207.36120460480}, 
    {     0.00000006310,  5.22966882627,      139.74133714810}, 
    {     0.00000004773,  3.06677020431,      464.73122651380}, 
    {     0.00000004867,  1.45874544328,       49.17873590170}, 
    {     0.00000004919,  3.57280542629,    52175.80628314840}, 
    {     0.00000006330,  5.80748895304,       57.25549074900}, 
    {     0.00000004762,  5.90654311203,      838.96928775040}, 
    {     0.00000004848,  0.77467099227,        1.69692102940}, 
    {     0.00000005694,  0.77313415569,      709.96483432550}, 
    {     0.00000005455,  0.90288890561,      208.84567731310}, 
    {     0.00000004901,  3.79986913631,       15.49911838880}, 
    {     0.00000004772,  0.15755140037,       39.50563376150}, 
    {     0.00000005673,  2.68359159067,     1127.26243007680}, 
    {     0.00000005477,  0.53123497431,      113.87784205160}, 
    {     0.00000005077,  1.59268428609,     1547.97091422940}, 
    {     0.00000004981,  1.44584050478,        1.27202438720}, 
    {     0.00000005938,  0.96886308551,     6280.10690457480}, 
    {     0.00000005206,  3.58003819370,      474.94684537520}, 
    {     0.00000005256,  0.61005270999,       95.97922721780}, 
    {     0.00000005531,  5.28764137194,       36.76043751410}, 
    {     0.00000005938,  0.65008179576,        6.90109867970}, 
    {     0.00000006158,  5.73176703797,      711.44930703380}, 
    {     0.00000005150,  5.58407480282,    26049.77010593640}, 
    {     0.00000005138,  4.55234158942,      670.91677495100}, 
    {     0.00000005609,  4.37272759780,       52.80207262410}, 
    {     0.00000005636,  2.39183054397,    10210.31660079440}, 
    {     0.00000005004,  4.99992587162,      421.22974901440}, 
    {     0.00000004512,  2.59978208967,     1234.54798998940}, 
    {     0.00000004314,  3.38846714337,      142.66209845490}, 
    {     0.00000004471,  3.94378336812,    12566.15169998280}, 
    {     0.00000005296,  1.12249063176,      134.11226285560}, 
    {     0.00000004188,  2.52490407427,     6205.32530600750}, 
    {     0.00000004645,  1.90644271528,    13324.31667116140}, 
    {     0.00000004501,  2.01956232903,      315.16802937920}, 
    {     0.00000004177,  2.09489065926,      803.75701341940}, 
    {     0.00000004675,  2.19237385948,      501.64042187420}, 
    {     0.00000005296,  3.88249567974,     2118.76386037840}, 
    {     0.00000005325,  4.28221258353,      477.91579079180}, 
    {     0.00000005519,  0.09960657331,      600.01914553700}, 
    {     0.00000004179,  0.14619703083,     6644.57629047010}, 
    {     0.00000004490,  1.07042724999,    52139.15772021889}, 
    {     0.00000003970,  6.13227798578,     1553.90880506260}, 
    {     0.00000005183,  3.52837189121,      110.20632121940}, 
    {     0.00000005259,  6.20809827528,      142.71028256470}, 
    {     0.00000004183,  5.17141470503,        3.62333672240}, 
    {     0.00000004196,  0.14530465304,       65.87476231750}, 
    {     0.00000003869,  5.25125030487,     1558.05340664680}, 
    {     0.00000004457,  2.10247889113,      487.10451133190}, 
    {     0.00000004893,  1.83678005941,       46.51860702580}, 
    {     0.00000003875,  5.60271074608,      385.49620982160}, 
    {     0.00000003826,  1.30946706974,     2176.61005195840}, 
    {     0.00000004591,  4.84657580441,     1337.64076420800}, 
    {     0.00000003928,  4.81049906938,       91.78644152380}, 
    {     0.00000005111,  1.18808726579,      981.63138620530}, 
    {     0.00000004709,  1.40878215308,    52213.93931878620}, 
    {     0.00000003891,  5.43661875415,      154.67100656530}, 
    {     0.00000004145,  4.32505910718,      363.51668387840}, 
    {     0.00000003926,  1.42639045134,       70.84944530420}, 
    {     0.00000004040,  5.26121759460,       80.71948940050}, 
    {     0.00000003885,  1.55337878207,      310.71461125430}, 
    {     0.00000004787,  3.65822147476,      589.34595228860}, 
    {     0.00000004020,  5.45643059988,     6641.60734505350}, 
    {     0.00000004288,  3.35265955957,      203.21660302060}, 
    {     0.00000004462,  2.86966056442,      353.04043258610}, 
    {     0.00000004657,  3.60514658478,      187.69623277240}, 
    {     0.00000003767,  0.05292047125,      320.27583880990}, 
    {     0.00000004632,  0.82011276589,     3265.83082813250}, 
    {     0.00000004555,  5.30391170376,    26013.12154300690}, 
    {     0.00000003555,  4.80240768951,      224.34479570190}, 
    {     0.00000003967,  1.01381988824,       75.74480641380}, 
    {     0.00000004302,  1.60914544159,    12529.50313705330}, 
    {     0.00000003493,  4.75315651083,    12489.88562870720}, 
    {     0.00000003722,  0.27433061822,      949.43624140070}, 
    {     0.00000003722,  4.61537211162,     1025.70231267630}, 
    {     0.00000004234,  5.25112033465,      194.28851491140}, 
    {     0.00000004796,  6.21059766333,      491.81856188770}, 
    {     0.00000003639,  1.25605018211,     2603.20824283440}, 
    {     0.00000004646,  5.71392664345,      321.76031151820}, 
    {     0.00000004523,  4.62812608060,      179.61947792510}, 
    {     0.00000003702,  2.08952561657,      491.03666459500}, 
    {     0.00000003433,  5.69102402866,      419.48464387520}, 
    {     0.00000003672,  2.87489628704,      497.49582029000}, 
    {     0.00000003428,  5.70553310685,      491.66980404140}, 
    {     0.00000004513,  4.38931096340,      425.11371816770}, 
    {     0.00000003404,  0.57791231752,      491.44605487220}, 
    {     0.00000003853,  0.61321572401,    12526.53419163670}, 
    {     0.00000003788,  3.32221995840,     3140.01275492980}, 
    {     0.00000003781,  5.58125317044,     1652.54816115630}, 
    {     0.00000003903,  5.31609723466,      408.17831118040}, 
    {     0.00000003945,  3.60558877186,     1589.07289528380}, 
    {     0.00000004299,  5.24473992747,      296.15744885260}, 
    {     0.00000004084,  0.83813879869,       52.36012963940}, 
    {     0.00000004084,  3.50290269471,       23.90594163620}, 
    {     0.00000004552,  1.80974055684,       73.55775828990}, 
    {     0.00000003336,  2.41413678320,       67.88049988760}, 
    {     0.00000003636,  5.31067380234,      141.48644228730}, 
    {     0.00000003345,  3.94392179077,    20389.92252949249}, 
    {     0.00000004639,  6.24618220184,      821.39499582230}, 
    {     0.00000003934,  0.26992234338,     1655.51710657290}, 
    {     0.00000004431,  2.48647437800,      549.72844394250}, 
    {     0.00000004168,  5.39993754642,      236.50246165860}, 
    {     0.00000003316,  0.82217489269,      305.08553696180}, 
    {     0.00000004524,  5.52532381522,      487.41332787260}, 
    {     0.00000004020,  0.07393243012,    52136.18877480229}, 
    {     0.00000003275,  0.98533127454,     1344.75431120880}, 
    {     0.00000003213,  2.97105590703,    20386.95358407589}, 
    {     0.00000004065,  5.41027187466,      332.80601178210}, 
    {     0.00000003183,  2.98783802386,      499.63468430410}, 
    {     0.00000004428,  0.06728869735,      491.29729702590}, 
    {     0.00000004063,  0.06192838570,     6168.67674307800}, 
    {     0.00000003530,  3.13717614844,      347.36317418380}, 
    {     0.00000003917,  1.33801660176,     1054.92851206430}, 
    {     0.00000003917,  5.67905809516,     1131.19458333990}, 
    {     0.00000003833,  0.87811168267,       52.69019803950}, 
    {     0.00000004020,  2.69209723289,     1439.46151403940}, 
    {     0.00000003424,  1.03296737020,      481.47543703940}, 
    {     0.00000003159,  1.04693380342,      703.37255218650}, 
    {     0.00000003364,  2.18084331708,       32.50396134530}, 
    {     0.00000003258,  4.65131076542,      696.25900518570}, 
    {     0.00000003427,  0.27003884843,     2389.90914739640}, 
    {     0.00000004349,  0.07531141761,    20426.57109242200}, 
    {     0.00000003383,  5.61838426864,      699.22795060230}, 
    {     0.00000003305,  1.41666877290,      562.14674233010}, 
    {     0.00000003297,  5.46677712589,     1442.21801113490}, 
    {     0.00000003277,  2.71815883511,      980.14691349700}, 
    {     0.00000003171,  4.49510885866,     1439.24906571830}, 
    {     0.00000004175,  4.24327636055,      381.61224066830}, 
    {     0.00000003155,  3.40776789576,       39.72938293070}, 
    {     0.00000004112,  0.90309319273,     1087.69310584050}, 
    {     0.00000003050,  5.01538526352,        8.90683624980}, 
    {     0.00000003725,  1.52448613082,     1058.10990580200}, 
    {     0.00000003650,  3.59798316565,      192.80404220310}, 
    {     0.00000003837,  1.48519528444,    10098.88643929760}, 
    {     0.00000002959,  1.23012121982,     2500.11546861580}, 
    {     0.00000003330,  6.12470287875,    10172.18356515660}, 
    {     0.00000003361,  4.31837298696,      492.07919431860}, 
    {     0.00000003294,  2.52694043155,     1692.16566950240}, 
    {     0.00000003013,  0.92957285991,     1515.77576942480}, 
    {     0.00000003403,  1.10932483984,      987.30864460760}, 
    {     0.00000003312,  0.67710158807,      977.48678462110}, 
    {     0.00000003030,  1.77996261146,   156489.28581380738}, 
    {     0.00000003605,  4.89955108152,     1043.88281180040}, 
    {     0.00000003276,  4.26765608367,     1189.30140735080}, 
    {     0.00000002966,  5.29808076929,       31.98269648350}, 
    {     0.00000002994,  2.58599359402,      178.08682110700}, 
    {     0.00000003905,  1.87748122254,     1158.28191871380}, 
    {     0.00000003110,  3.09203517638,      235.93301268700}, 
    {     0.00000003313,  2.70308129756,      604.47256366190}, 
    {     0.00000003276,  1.24440460327,      874.65464283340}, 
    {     0.00000003276,  5.58544609667,      950.92071410900}, 
    {     0.00000002863,  5.30797202030,      449.23210812500}, 
    {     0.00000003746,  0.33859914037,      913.96333463880}, 
    {     0.00000003552,  3.07180917863,      240.38643081190}, 
    {     0.00000002885,  6.01129889094,     1097.51496582700}, 
    {     0.00000003643,  5.11977873355,      452.20105354160}, 
    {     0.00000002761,  4.05534163585,     6283.07584999140}, 
    {     0.00000003226,  4.76711354367,     6241.97386893700}, 
    {     0.00000002988,  5.62906786113,      140.65636088480}, 
    {     0.00000003748,  4.84009347869,      341.73409989130}, 
    {     0.00000003847,  2.40982343643,    26086.41866886590}, 
    {     0.00000002702,  3.72061244391,      946.46729598410}, 
    {     0.00000002846,  4.90997675486,      488.84961647110}, 
    {     0.00000002723,  4.37517047024,       15.19030184810}, 
    {     0.00000002847,  5.22951186538,      661.04673085470}, 
    {     0.00000002680,  4.19379121323,       13.18456427800}, 
    {     0.00000003269,  0.43119778520,      496.97455542820}, 
    {     0.00000002878,  5.00361557843,      252.08652238160}, 
    {     0.00000003489,  3.82213189319,      625.99451521810}, 
    {     0.00000003742,  2.03372773652,        8.59801970910}, 
    {     0.00000003341,  2.91360557418,      304.23420369990}, 
    {     0.00000002915,  2.63627684599,     6681.22485339960}, 
    {     0.00000002915,  1.43773625890,     6604.95878212400}, 
    {     0.00000002629,  2.09824407450,     2713.41456405380}, 
    {     0.00000002901,  3.33924800230,      515.46387109300}, 
    {     0.00000002803,  1.23584865903,     6643.09181776180}, 
    {     0.00000002621,  3.27309087943,      483.48117460950}, 
    {     0.00000003045,  3.33515866438,      921.07688163960}, 
    {     0.00000002699,  5.42597794650,      925.26966733360}, 
    {     0.00000002808,  5.77870303237,     1024.21783996800}, 
    {     0.00000003028,  3.75501312393,      511.59540830470}, 
    {     0.00000003090,  2.49453093252,       14.66903698630}, 
    {     0.00000002630,  0.62190616803,      990.22940591440}, 
    {     0.00000002913,  4.83296711477,      515.93695184500}, 
    {     0.00000003139,  5.99134254710,      570.74476203920}, 
    {     0.00000002752,  3.08268180744,      853.19638175200}, 
    {     0.00000002643,  1.99093797444,      470.21728845440}, 
    {     0.00000002763,  4.01095972177,      448.97147569410}, 
    {     0.00000003426,  4.73955481174,     1050.99635880120}, 
    {     0.00000002613,  5.04769883328,      175.21424391000}, 
    {     0.00000003080,  1.08651068269,      260.99335863140}, 
    {     0.00000002605,  1.78290020063,      175.11787569040}, 
    {     0.00000002573,  2.01267457287,     1514.29129671650}, 
    {     0.00000002633,  1.63639954931,      170.71264167530}, 
    {     0.00000003025,  5.51446170055,      369.45457471160}, 
    {     0.00000002490,  0.15301603966,    78187.44335344699}, 
    {     0.00000002589,  0.79196093766,     1228.91891569690}, 
    {     0.00000003493,  3.88006738730,      495.70253104100}, 
    {     0.00000003143,  5.33170343283,     1542.34183993690}, 
    {     0.00000002816,  3.74486418363,        2.00573757010}, 
    {     0.00000003062,  4.88018345098,      227.96813242430}, 
    {     0.00000002971,  1.27359129352,      530.91480537200}, 
    {     0.00000003329,  2.71693827722,      171.02145821600}, 
    {     0.00000002648,  0.60304386920,       70.58881287330}, 
    {     0.00000003061,  5.05044834864,      378.64329525170}, 
    {     0.00000002738,  4.75405645015,      151.26011816400}, 
    {     0.00000002727,  5.89140709596,      213.95348674380}, 
    {     0.00000003411,  2.24137878065,      734.45573129830}, 
    {     0.00000002623,  0.54340876464,     1586.10394986720}, 
    {     0.00000003169,  5.84871429991,     1049.51188609290}, 
    {     0.00000002430,  2.34597429597,      450.45594840240}, 
    {     0.00000002907,  5.58085498481,      597.57146498220}, 
    {     0.00000003060,  5.27973140962,      523.75307426140}, 
    {     0.00000003300,  0.94221473935,       58.17051448570}, 
    {     0.00000002606,  4.76989264753,      391.43410065480}, 
    {     0.00000003175,  2.32600231924,      339.28641933650}, 
    {     0.00000003112,  4.24784219323,     1615.89959822680}, 
    {     0.00000003340,  1.36950315448,      384.27236954420}, 
    {     0.00000003301,  5.83023910521,       51.77517430280}, 
    {     0.00000002415,  0.69446923670,      489.55219188670}, 
    {     0.00000003310,  5.55595218696,      674.80074410430}, 
    {     0.00000002736,  5.74320864965,     1167.84314626940}, 
    {     0.00000002956,  5.22962139507,      199.85389872910}, 
    {     0.00000003262,  0.01501002027,     1545.31078535350}, 
    {     0.00000002506,  4.84043333582,      943.49835056750}, 
    {     0.00000003240,  2.46676155925,     1016.79547642650}, 
    {     0.00000003148,  4.62079057738,      233.53351624200}, 
    {     0.00000002327,  4.10421417326,       70.11573212130}, 
    {     0.00000002371,  4.79963943424,      271.14528701800}, 
    {     0.00000003006,  3.66877796077,     1476.15826107870}, 
    {     0.00000003033,  0.67157488690,      292.48592802040}, 
    {     0.00000002344,  1.83547256266,      492.30868898220}, 
    {     0.00000003117,  2.76268894894,     1473.18931566210}, 
    {     0.00000002323,  2.88799980853,      533.62311835770}, 
    {     0.00000002340,  4.44862573253,      490.80716993140}, 
    {     0.00000002919,  4.75889516601,     1511.32235129990}, 
    {     0.00000002493,  6.10541658597,     1225.94997028030}, 
    {     0.00000002691,  3.20679023131,      463.50738623640}, 
    {     0.00000002291,  5.81535163158,      246.97871295090}, 
    {     0.00000002319,  6.05514281470,      525.75881183150}, 
    {     0.00000003112,  0.89712836583,      314.90739694830}, 
    {     0.00000003085,  5.84605938859,     1192.22216865760}, 
    {     0.00000002897,  0.54747024257,    20350.30502114640}, 
    {     0.00000002469,  3.75373347656,      494.00561001160}, 
    {     0.00000003067,  2.22210324061,      248.46318565920}, 
    {     0.00000002252,  0.87483094907,       61.02758531770}, 
    {     0.00000002392,  3.62837597194,      439.19779981740}, 
    {     0.00000002817,  2.73562306571,       16.67477455640}, 
    {     0.00000002379,  6.17876088396,      467.65198782060}, 
    {     0.00000002607,  4.82656583469,      384.58118608490}, 
    {     0.00000002718,  1.01823841209,      215.95922431390}, 
    {     0.00000002998,  1.09755715300,     1964.74724511890}, 
    {     0.00000002883,  2.97813866507,      383.09671337660}, 
    {     0.00000002529,  5.81554218602,     1587.58842257550}, 
    {     0.00000002203,  2.23336308907,      481.26298871830}, 
    {     0.00000002260,  2.35404913660,      659.61044225620}, 
    {     0.00000002173,  4.95048919972,       76.78733613740}, 
    {     0.00000002491,  1.70236357070,      445.34813897170}, 
    {     0.00000002164,  4.91477263756,      249.94765836750}, 
    {     0.00000002289,  1.18497528002,     1552.42433235430}, 
    {     0.00000002975,  0.48272389481,     1052.48083150950}, 
    {     0.00000002339,  0.75318738767,      478.81530816350}, 
    {     0.00000003011,  0.16359500858,       54.28654533240}, 
    {     0.00000003011,  1.03494557852,       21.97952594320}, 
};


static const struct vsop neptune_radius_r1[RADIUS_R1] = {
    {     0.00236338618,  0.70497954792,       38.13303563780}, 
    {     0.00013220034,  3.32014387930,        1.48447270830}, 
    {     0.00008621779,  6.21626927537,       35.16409022120}, 
    {     0.00002701587,  1.88124996531,       39.61750834610}, 
    {     0.00002153060,  5.16877044933,       76.26607127560}, 
    {     0.00002154170,  2.09430333390,        2.96894541660}, 
    {     0.00001463314,  1.18410155089,       33.67961751290}, 
    {     0.00001603164,  0.00000000000,        0.00000000000}, 
    {     0.00001135663,  3.91905853528,       36.64856292950}, 
    {     0.00000897650,  5.24122933533,      388.46515523820}, 
    {     0.00000789359,  0.53295000718,      168.05251279940}, 
    {     0.00000760030,  0.02051033644,      182.27960680100}, 
    {     0.00000607183,  1.07706500350,     1021.24889455140}, 
    {     0.00000571622,  3.40060785432,      484.44438245600}, 
    {     0.00000560790,  2.88685815667,      498.67147645760}, 
    {     0.00000489973,  3.46822250901,      137.03302416240}, 
    {     0.00000264197,  0.86149368602,        4.45341812490}, 
    {     0.00000270304,  3.27489604455,       71.81265315070}, 
    {     0.00000203512,  2.41823214253,       32.19514480460}, 
    {     0.00000155180,  0.36515053081,       41.10198105440}, 
    {     0.00000132766,  3.60157672619,        9.56122755560}, 
    {     0.00000093942,  0.66658493388,       46.20979048510}, 
    {     0.00000083697,  3.26305475932,       98.89998852460}, 
    {     0.00000072205,  4.47717435693,      601.76425067620}, 
    {     0.00000068777,  1.46946530374,       74.78159856730}, 
    {     0.00000086953,  5.77228651853,      381.35160823740}, 
    {     0.00000068138,  4.52508272214,       70.32818044240}, 
    {     0.00000065250,  3.85934463923,       73.29712585900}, 
    {     0.00000068370,  3.39513994400,      108.46121608020}, 
    {     0.00000053375,  5.43650770516,      395.57870223900}, 
    {     0.00000043910,  3.61564394950,        2.44768055480}, 
    {     0.00000041546,  4.74846317654,        8.07675484730}, 
    {     0.00000048724,  1.98932271543,      175.16605980020}, 
    {     0.00000041744,  4.94257598763,       31.01948863700}, 
    {     0.00000044102,  1.41744904844,     1550.93985964600}, 
    {     0.00000041170,  1.41999405024,      490.07345674850}, 
    {     0.00000041099,  4.86312668872,      493.04240216510}, 
    {     0.00000036267,  5.30764043577,      312.19908396260}, 
    {     0.00000036321,  0.38296932117,       77.75054398390}, 
    {     0.00000040928,  2.27526815371,      529.69096509460}, 
    {     0.00000032141,  5.91285874340,        5.93789083320}, 
    {     0.00000031197,  2.70549944134,     1014.13534755060}, 
    {     0.00000032730,  5.22147683115,       41.05379694460}, 
    {     0.00000036035,  4.88125211442,      491.55792945680}, 
    {     0.00000029991,  3.30769367603,     1028.36244155220}, 
    {     0.00000029424,  3.63261469286,       30.71067209630}, 
    {     0.00000027478,  1.76175718511,       44.72531777680}, 
    {     0.00000027676,  4.54801642564,        7.11354700080}, 
    {     0.00000027475,  0.97228280623,       33.94024994380}, 
    {     0.00000024944,  3.10083196356,      144.14657116320}, 
    {     0.00000025956,  2.99728316628,       60.76695288680}, 
    {     0.00000021401,  0.68033795793,      251.43213107580}, 
    {     0.00000021369,  4.71270048898,      278.25883401880}, 
    {     0.00000023818,  5.11019967861,      176.65053250850}, 
    {     0.00000024486,  3.56527493795,      145.10977900970}, 
    {     0.00000023379,  1.65568321349,      173.68158709190}, 
    {     0.00000027004,  4.13984627053,      453.42489381900}, 
    {     0.00000020725,  0.89222104366,        4.19278569400}, 
    {     0.00000019795,  5.61602288526,       24.11838995730}, 
    {     0.00000023863,  0.99001670827,      213.29909543800}, 
    {     0.00000018408,  1.98233778039,       72.07328558160}, 
    {     0.00000018266,  6.17260374467,      189.39315380180}, 
    {     0.00000018960,  4.66648698212,      106.97674337190}, 
    {     0.00000017705,  1.59531409128,       62.25142559510}, 
    {     0.00000015648,  3.64570115017,        0.52126486180}, 
    {     0.00000016368,  1.70913999198,      357.44566660120}, 
    {     0.00000020132,  3.29521961100,      114.39910691340}, 
    {     0.00000015425,  4.38812302799,       25.60286266560}, 
    {     0.00000018932,  2.21630439663,      343.21857259960}, 
    {     0.00000014031,  0.55320290294,      129.91947716160}, 
    {     0.00000014328,  5.84024214567,       68.84370773410}, 
    {     0.00000015466,  4.20417846946,      567.82400073240}, 
    {     0.00000012746,  3.52815836608,      477.33083545520}, 
    {     0.00000011724,  5.57647263460,       31.23193695810}, 
    {     0.00000011533,  0.89138506506,      594.65070367540}, 
    {     0.00000010508,  4.35552732772,       32.71640966640}, 
    {     0.00000010777,  5.30551078064,        2.92076130680}, 
    {     0.00000010826,  5.21826226871,       26.82670294300}, 
    {     0.00000010084,  1.98102236804,       40.58071619260}, 
    {     0.00000011686,  5.14865195162,       42.58645376270}, 
    {     0.00000009207,  0.50092534158,       64.95973858080}, 
    {     0.00000009084,  5.86031317808,        6.59228213900}, 
    {     0.00000009231,  0.68180977710,      160.93896579860}, 
    {     0.00000010114,  4.51164596686,       28.57180808220}, 
    {     0.00000008350,  2.82449631025,       43.24084506850}, 
    {     0.00000009592,  3.76289614986,      181.75834193920}, 
    {     0.00000009969,  1.45995045237,       47.69426319340}, 
    {     0.00000007946,  2.40126769187,       11.04570026390}, 
    {     0.00000007629,  1.57125741752,      135.54855145410}, 
    {     0.00000007645,  4.07503370297,      389.94962794650}, 
    {     0.00000008004,  2.78082277326,      505.78502345840}, 
    {     0.00000009450,  0.27241260289,      426.59819087600}, 
    {     0.00000007192,  0.82841201068,      911.04257333200}, 
    {     0.00000006981,  1.86764180939,      206.18554843720}, 
    {     0.00000007897,  1.86554246391,       38.65430049960}, 
    {     0.00000006766,  0.85749934506,       82.85835341460}, 
    {     0.00000006357,  0.90093123522,      487.36514376280}, 
    {     0.00000006720,  1.33936767947,      220.41264243880}, 
    {     0.00000006344,  4.04005545219,       12.53017297220}, 
    {     0.00000007695,  5.13312500855,       23.90594163620}, 
    {     0.00000007059,  5.99832463478,      639.89728631400}, 
    {     0.00000008302,  3.85960902325,       37.61177077600}, 
    {     0.00000006412,  2.41743840961,     1059.38193018920}, 
    {     0.00000006751,  1.96860894470,       45.24658263860}, 
    {     0.00000006301,  4.04821192714,       35.68535508300}, 
    {     0.00000005517,  3.81325790890,      815.06334611420}, 
    {     0.00000005562,  0.41619602113,      563.63121503840}, 
    {     0.00000006115,  2.10934525342,      697.74347789400}, 
    {     0.00000006216,  4.79301628209,      143.62530630140}, 
    {     0.00000005346,  3.13071964722,      386.98068252990}, 
    {     0.00000006866,  0.62766858525,      350.33211960040}, 
    {     0.00000005245,  6.06245070403,      171.23390653710}, 
    {     0.00000005129,  0.79394555531,      179.09821306330}, 
    {     0.00000005099,  2.96677243218,       27.08733537390}, 
    {     0.00000005169,  6.18160132142,       63.73589830340}, 
    {     0.00000005168,  4.73765536370,      522.57741809380}, 
    {     0.00000005006,  2.37645082899,       77.22927912210}, 
    {     0.00000005005,  4.70632786719,      460.53844081980}, 
    {     0.00000005167,  5.20246890403,      446.31134681820}, 
    {     0.00000005119,  2.17338058771,      494.73932319450}, 
    {     0.00000005025,  4.21265519443,      536.80451209540}, 
    {     0.00000005125,  5.38138329172,      179.31066138440}, 
    {     0.00000004918,  4.09031782903,      488.37653571910}, 
    {     0.00000004711,  5.56542374115,       42.32582133180}, 
    {     0.00000004459,  1.30784829830,       69.36497259590}, 
    {     0.00000005485,  3.88088464259,      218.40690486870}, 
    {     0.00000004419,  4.22946309121,        5.41662597140}, 
    {     0.00000004559,  4.92224120952,      285.37238101960}, 
    {     0.00000004687,  2.21401153210,     1029.84691426050}, 
    {     0.00000004644,  1.87902594973,     1433.61999142580}, 
    {     0.00000005639,  3.05597013393,      983.11585891360}, 
    {     0.00000004317,  1.37172516583,        0.96320784650}, 
    {     0.00000004385,  2.35709104539,       84.34282612290}, 
    {     0.00000004430,  3.37768805833,      377.41945497430}, 
    {     0.00000004681,  2.14249250241,       97.41551581630}, 
    {     0.00000005845,  4.62301099402,     1024.21783996800}, 
    {     0.00000005769,  5.71579471638,      351.81659230870}, 
    {     0.00000004454,  5.20355311714,      274.06604832480}, 
    {     0.00000004398,  5.65312496227,        3.93215326310}, 
    {     0.00000004287,  0.66340266603,     1012.65087484230}, 
    {     0.00000004086,  0.14551174994,      385.28376150050}, 
    {     0.00000004029,  5.98399329775,      178.34745353790}, 
    {     0.00000004276,  3.68205082970,      348.84764689210}, 
    {     0.00000004012,  0.42559540783,   104313.47953065898}, 
    {     0.00000004309,  3.04099090488,      100.38446123290}, 
    {     0.00000003957,  0.86846121055,      171.98466606250}, 
    {     0.00000003961,  3.04953080906,     1017.31674128830}, 
    {     0.00000005559,  0.77714806229,     1447.84708542740}, 
    {     0.00000005071,  2.61075526868,     1536.71276564440}, 
    {     0.00000004225,  2.45845211305,      496.01134758170}, 
    {     0.00000004052,  5.00014006312,      391.64654897590}, 
    {     0.00000003763,  4.29449373755,      313.68355667090}, 
    {     0.00000004038,  2.82857942788,     1661.14618086540}, 
    {     0.00000004067,  5.73169928960,      169.53698550770}, 
    {     0.00000004826,  3.75589264710,      379.86713552910}, 
    {     0.00000004296,  5.90228488768,      142.14083359310}, 
    {     0.00000003721,  1.20062375429,     1026.87796884390}, 
    {     0.00000003929,  3.94354033755,       39.09624348430}, 
    {     0.00000004728,  4.73892221737,      382.83608094570}, 
    {     0.00000003489,  4.28865448963,     1025.18104781450}, 
    {     0.00000003714,  5.05021268365,      292.48592802040}, 
    {     0.00000003988,  2.82832650224,      134.11226285560}, 
    {     0.00000003471,  4.98900354066,       69.15252427480}, 
    {     0.00000003528,  2.80271543681,       14.01464568050}, 
    {     0.00000003745,  4.24728135115,      180.79513409270}, 
    {     0.00000003836,  1.02685786071,     1018.27994913480}, 
    {     0.00000003941,  5.21895739331,      183.76407950930}, 
    {     0.00000003780,  6.03723468132,     1022.73336725970}, 
    {     0.00000003647,  3.98130320367,      608.87779767700}, 
    {     0.00000003456,  5.54052355058,      846.08283475120}, 
    {     0.00000004047,  3.71041480907,     1018.06750081370}, 
    {     0.00000003865,  4.76002199091,      166.56804009110}, 
    {     0.00000003629,  3.29053233846,      447.79581952650}, 
    {     0.00000003337,  0.47308019225,       79.18683258240}, 
    {     0.00000003304,  1.49289552229,     1505.69327700740}, 
    {     0.00000003615,  3.68096122231,      494.52687487340}, 
    {     0.00000003209,  0.29676849415,       22.63391724900}, 
    {     0.00000003280,  3.62226152032,      531.17543780290}, 
    {     0.00000003337,  2.72502876320,      481.47543703940}, 
    {     0.00000003187,  0.08677634706,      399.51085550210}, 
    {     0.00000003389,  1.79454271219,     1519.92037100900}, 
    {     0.00000003154,  3.69356460843,      470.21728845440}, 
    {     0.00000003706,  2.79048710497,      462.02291352810}, 
    {     0.00000003682,  2.45952306167,      106.01353552540}, 
    {     0.00000003136,  4.38015969606,      385.49620982160}, 
    {     0.00000004279,  4.35633788890,     1066.49547719000}, 
    {     0.00000003392,  0.48037804731,      521.09294538550}, 
    {     0.00000003465,  0.93152295589,     2183.72359895920}, 
    {     0.00000003735,  0.98809808606,      487.41332787260}, 
    {     0.00000003285,  4.36830516894,      397.06317494730}, 
    {     0.00000003998,  3.38773325131,     6283.07584999140}, 
    {     0.00000002998,  2.61728063127,      487.62577619370}, 
    {     0.00000003295,  2.53821501556,        4.66586644600}, 
    {     0.00000002964,  3.66274645375,      495.49008271990}, 
    {     0.00000003901,  1.65463736406,      210.33015002140}, 
    {     0.00000002950,  1.99904237956,      872.90953769420}, 
    {     0.00000002936,  3.39722203959,      423.62924545940}, 
    {     0.00000003121,  5.89456985534,      105.49227066360}, 
    {     0.00000003904,  3.01022809543,      556.51766803760}, 
    {     0.00000003801,  4.23636257679,     1052.26838318840}, 
    {     0.00000002930,  6.15005257333,      164.12035953630}, 
    {     0.00000003267,  4.19718045293,      518.38463239980}, 
    {     0.00000003946,  2.88842759670,      151.26011816400}, 
    {     0.00000002823,  0.60712626756,      214.78356814630}, 
    {     0.00000002826,  2.91070227143,      391.43410065480}, 
    {     0.00000003347,  6.09373507569,     6246.42728706190}, 
    {     0.00000002792,  0.55248135990,        5.10780943070}, 
    {     0.00000003470,  5.06081504795,       79.23501669220}, 
    {     0.00000003010,  0.24656411754,       91.78644152380}, 
    {     0.00000002861,  6.17465663902,      422.40540518200}, 
    {     0.00000002989,  2.31620917965,      485.92885516430}, 
    {     0.00000003088,  2.29186342974,      110.20632121940}, 
    {     0.00000003030,  3.69866149100,      532.61172640140}, 
    {     0.00000003148,  6.25285869266,      535.32003938710}, 
    {     0.00000003020,  2.36422658177,      290.21955801940}, 
    {     0.00000002730,  3.34082732623,      394.09422953070}, 
    {     0.00000003170,  1.23078934548,    10176.63698328150}, 
    {     0.00000002673,  6.03366372927,      196.50670080260}, 
    {     0.00000002635,  3.39631667641,      148.07872442630}, 
    {     0.00000002838,  2.85241236576,      138.51749687070}, 
    {     0.00000002630,  0.46957619348,     1970.42450352120}, 
    {     0.00000002599,  4.86022081674,      439.19779981740}, 
    {     0.00000002878,  2.61946597178,      488.58898404020}, 
    {     0.00000002720,  1.71836225398,      364.55921360200}, 
    {     0.00000003053,  2.49346960035,     6243.45834164530}, 
    {     0.00000003332,  3.25113612987,       30.05628079050}, 
    {     0.00000003062,  6.23776299874,      419.48464387520}, 
    {     0.00000002786,  0.83078219939,      497.18700374930}, 
    {     0.00000002834,  3.52926079424,      457.87831194390}, 
    {     0.00000002932,  1.80245810977,      500.15594916590}, 
    {     0.00000002613,  0.97430899059,      244.31858407500}, 
    {     0.00000003030,  5.10152500393,      367.97010200330}, 
    {     0.00000002956,  5.76230870725,      986.08480433020}, 
    {     0.00000002658,  0.88044044504,      109.94568878850}, 
    {     0.00000003116,  2.20042242739,      495.70253104100}, 
    {     0.00000002554,  0.65945973992,       67.35923502580}, 
    {     0.00000002901,  3.91891656185,    10173.66803786490}, 
    {     0.00000002840,  1.34453183591,      482.95990974770}, 
    {     0.00000002458,  1.20012815574,      489.11024890200}, 
    {     0.00000002556,  3.86921927085,      487.10451133190}, 
    {     0.00000002614,  1.51881085312,      463.50738623640}, 
    {     0.00000002386,  4.58400538443,      615.99134467780}, 
    {     0.00000002438,  5.19827220476,      501.11915701240}, 
    {     0.00000002537,  1.64802783144,      519.60847267720}, 
    {     0.00000002444,  3.87859489652,      185.24855221760}, 
    {     0.00000002262,  5.79112288939,      605.95703637020}, 
    {     0.00000002795,  4.04265752580,      255.05546779820}, 
    {     0.00000002895,  3.26202698812,     1646.91908686380}, 
    {     0.00000002324,  3.99503920129,      481.26298871830}, 
    {     0.00000002962,  1.74151265966,     2080.63082474060}, 
    {     0.00000002621,  1.74442251671,       35.21227433100}, 
};


static const struct vsop neptune_radius_r2[RADIUS_R2] = {
    {     0.00004247776,  5.89911844921,       38.13303563780}, 
    {     0.00000217404,  0.34589546713,        1.48447270830}, 
    {     0.00000163025,  2.23872947130,      168.05251279940}, 
    {     0.00000156285,  4.59414467342,      182.27960680100}, 
    {     0.00000117940,  5.10295026024,      484.44438245600}, 
    {     0.00000112429,  1.19000583596,      498.67147645760}, 
    {     0.00000127836,  2.84821806298,       35.16409022120}, 
    {     0.00000099311,  3.41592669789,      175.16605980020}, 
    {     0.00000064814,  3.46214064840,      388.46515523820}, 
    {     0.00000076780,  0.01680343065,      491.55792945680}, 
    {     0.00000049511,  4.06995993334,       76.26607127560}, 
    {     0.00000039330,  6.09521855958,     1021.24889455140}, 
    {     0.00000036451,  5.17129778081,      137.03302416240}, 
    {     0.00000036709,  5.97476878862,        2.96894541660}, 
    {     0.00000029037,  3.58135470306,       33.67961751290}, 
    {     0.00000020862,  0.77341568423,       36.64856292950}, 
    {     0.00000013886,  3.59248623971,      395.57870223900}, 
    {     0.00000013001,  5.12870831936,       98.89998852460}, 
    {     0.00000011379,  1.18060018898,      381.35160823740}, 
    {     0.00000009132,  2.34787658568,      601.76425067620}, 
    {     0.00000008527,  5.25134685897,        2.44768055480}, 
    {     0.00000007608,  4.99805971093,        4.45341812490}, 
    {     0.00000007417,  4.46775409796,      189.39315380180}, 
    {     0.00000007225,  1.92287508629,        9.56122755560}, 
    {     0.00000007289,  1.65519525780,     1028.36244155220}, 
    {     0.00000008076,  5.84268048268,      220.41264243880}, 
    {     0.00000009415,  0.00000000000,        0.00000000000}, 
    {     0.00000006554,  0.69397520662,      144.14657116320}, 
    {     0.00000005628,  5.23383764266,       46.20979048510}, 
    {     0.00000005523,  4.59041448911,     1014.13534755060}, 
    {     0.00000007254,  1.14445074833,     1059.38193018920}, 
    {     0.00000005226,  0.02783946816,       74.78159856730}, 
    {     0.00000005177,  5.23116646157,      477.33083545520}, 
    {     0.00000005098,  3.50187769013,       39.61750834610}, 
    {     0.00000005503,  3.49522319102,      183.76407950930}, 
    {     0.00000005055,  0.19949888617,      166.56804009110}, 
    {     0.00000004751,  1.18054948270,      169.53698550770}, 
    {     0.00000004587,  2.13374192347,       41.10198105440}, 
    {     0.00000006170,  6.15456871599,       71.81265315070}, 
    {     0.00000004606,  3.91970908886,      587.53715667460}, 
    {     0.00000004536,  2.84337336954,        7.11354700080}, 
    {     0.00000004338,  0.51553847342,      446.31134681820}, 
    {     0.00000003891,  0.26338839265,     1550.93985964600}, 
    {     0.00000004465,  3.01487041336,      129.91947716160}, 
    {     0.00000004162,  1.58187532018,       73.29712585900}, 
    {     0.00000003727,  2.37977930658,      160.93896579860}, 
    {     0.00000004830,  2.23553496822,      176.65053250850}, 
    {     0.00000003842,  3.79387204230,      111.43016149680}, 
    {     0.00000003296,  1.07748822909,      505.78502345840}, 
    {     0.00000003966,  1.70648052846,      983.11585891360}, 
    {     0.00000004008,  0.30663868827,      494.73932319450}, 
    {     0.00000003974,  5.97351783840,      488.37653571910}, 
    {     0.00000003925,  4.85736421123,       60.76695288680}, 
    {     0.00000002966,  2.01608546009,      822.17689311500}, 
    {     0.00000003972,  1.07780371834,      374.23806123660}, 
    {     0.00000002848,  6.17799253802,      704.85702489480}, 
    {     0.00000003527,  0.79317138165,      274.06604832480}, 
    {     0.00000002773,  5.37132330836,      251.43213107580}, 
    {     0.00000003113,  5.12622288666,      426.59819087600}, 
    {     0.00000003344,  5.61433537548,     1124.34166877000}, 
    {     0.00000003552,  5.22645982165,      350.33211960040}, 
    {     0.00000002597,  0.67759426519,      312.19908396260}, 
    {     0.00000002580,  3.56031931199,      567.82400073240}, 
    {     0.00000002578,  1.45603792456,     1035.47598855300}, 
    {     0.00000002541,  5.19427579702,     1227.43444298860}, 
    {     0.00000002507,  1.31206832468,      386.98068252990}, 
    {     0.00000002510,  4.12148891512,      171.23390653710}, 
    {     0.00000002511,  2.71606957319,      179.09821306330}, 
    {     0.00000002342,  0.96469916587,     1019.76442184310}, 
    {     0.00000002500,  0.70282276030,      707.77778620160}, 
    {     0.00000002480,  4.59623030219,      693.55069220000}, 
};


static const struct vsop neptune_radius_r3[RADIUS_R3] = {
    {     0.00000166556,  4.55393495836,       38.13303563780}, 
    {     0.00000022380,  3.94830879358,      168.05251279940}, 
    {     0.00000021348,  2.86296778794,      182.27960680100}, 
    {     0.00000016233,  0.54226725872,      484.44438245600}, 
    {     0.00000015623,  5.75702251906,      498.67147645760}, 
    {     0.00000011412,  4.38291384655,        1.48447270830}, 
    {     0.00000006448,  5.19003066847,       31.01948863700}, 
    {     0.00000003655,  5.91335292846,     1007.02180054980}, 
    {     0.00000003681,  1.62865545676,      388.46515523820}, 
    {     0.00000003198,  0.70197118575,     1558.05340664680}, 
    {     0.00000003243,  1.88035665980,      522.57741809380}, 
    {     0.00000002688,  1.87062743473,      402.69224923980}, 
    {     0.00000003246,  0.79381356193,      536.80451209540}, 
    {     0.00000002650,  5.76858449026,      343.21857259960}, 
    {     0.00000002644,  4.64542905401,      500.15594916590}, 
    {     0.00000002541,  4.79217120822,      482.95990974770}, 
    {     0.00000002523,  1.72869889780,      395.57870223900}, 
    {     0.00000003040,  2.90934098363,       76.26607127560}, 
    {     0.00000002690,  2.21096415618,      446.31134681820}, 
    {     0.00000002355,  5.77381398401,      485.92885516430}, 
    {     0.00000002874,  6.19643340540,      815.06334611420}, 
    {     0.00000002450,  2.14451121185,       39.61750834610}, 
    {     0.00000002278,  3.66579603119,      497.18700374930}, 
};


static const struct vsop neptune_radius_r4[RADIUS_R4] = {
    {     0.00000004227,  2.40375758563,      477.33083545520}, 
    {     0.00000004333,  0.10459484545,      395.57870223900}, 
    {     0.00000003545,  4.78431259422,     1028.36244155220}, 
    {     0.00000003154,  3.88192942366,      505.78502345840}, 
    {     0.00000003016,  1.03609346831,      189.39315380180}, 
    {     0.00000002294,  1.10879658603,      182.27960680100}, 
    {     0.00000002295,  5.67776133184,      168.05251279940}, 
};


/* Chapter 31 Pg 206-207 Equ 31.1 31.2 , 31.3 using VSOP 87
 * Calculate neptune rectangular heliocentric ecliptical coordinates
 * for given julian day. Values are in UA.
 * params : Julian day, rect coords */
void get_neptune_helio_coords(double JD, double * X, double * Y, double * Z)
{
	double t, t2, t3, t4, t5;
	double L0, L1, L2, L3;
	double B0, B1, B2, B3;
	double R0, R1, R2, R3, R4;
	double L,B,R;

	/* get julian ephemeris day */
	t = (JD - 2451545.0) / 365250;
	t2 = t * t;
	t3 = t2 * t;
	t4 = t3 * t;
	t5 = t4 * t;
	
	/* calc L series */
	L0 = calc_series (neptune_longitude_l0, LONG_L0, t);
	L1 = calc_series (neptune_longitude_l1, LONG_L1, t);
	L2 = calc_series (neptune_longitude_l2, LONG_L2, t);
	L3 = calc_series (neptune_longitude_l3, LONG_L3, t);
	L = (L0 + L1 * t + L2 * t2 + L3 * t3);

	/* calc B series */
	B0 = calc_series (neptune_latitude_b0, LAT_B0, t);
	B1 = calc_series (neptune_latitude_b1, LAT_B1, t);
	B2 = calc_series (neptune_latitude_b2, LAT_B2, t);
	B3 = calc_series (neptune_latitude_b3, LAT_B3, t);
	B = (B0 + B1 * t + B2 * t2 + B3 * t3);

	/* calc R series */
	R0 = calc_series (neptune_radius_r0, RADIUS_R0, t);
	R1 = calc_series (neptune_radius_r1, RADIUS_R1, t);
	R2 = calc_series (neptune_radius_r2, RADIUS_R2, t);
	R3 = calc_series (neptune_radius_r3, RADIUS_R3, t);
	R4 = calc_series (neptune_radius_r4, RADIUS_R4, t);
	R = (R0 + R1 * t + R2 * t2 + R3 * t3 + R4 * t4);

	/* change to fk5 reference frame */
	vsop87_to_fk5(&L, &B, JD);

	/* convert to rectangular coord */
	sphe_to_rect(L, B, R, X, Y, Z);
}
