/*
 * The big star catalogue extension to Stellarium:
 * Author and Copyright: Johannes Gajdosik, 2006, 2007
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#include "StringArray.hpp"

#include <list>
#include <iostream>
#include <QFile>

using namespace std;

namespace BigStarCatalogExtension {

void StringArray::initFromFile(const QString& file_name) {
  clear();
  list<string> list;
  FILE *f = fopen(QFile::encodeName(file_name).constData(),"r");
  if (f) {
    char line[256];
    while (fgets(line, sizeof(line), f)) {
      string s = line;
      // remove newline
      s.erase(s.length()-1,1);
      list.push_back(s);
      size++;
    }
    fclose(f);
  }
  if (size > 0) {
    array = new string[size];
    if (array == 0) {
      cerr << "ERROR: StringArray::initFromFile: no memory" << endl;
      exit(1);
    }
    for (int i=0;i<size;i++) {
      array[i] = list.front();
      list.pop_front();
    }
  }
}

} // namespace BigStarCatalogExtension

