# -*- perl -*-

#
#   Copyright (C) Heinz-Josef Claes (2002)
#                 hjclaes@web.de
#   
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#   
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#   
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#


push @VERSION, '$Id: version.pl,v 1.5 2002/06/14 12:37:04 hjc Exp $ ';


sub printVersions
{
    my ($ARGV, $par) = @_;

    my ($flag) = 0;
    my ($entry);

    foreach $entry (@$ARGV)
    {
	if ($entry eq $par)
	{
	    $flag = 1;
	    last;
	}
    }
    return if ($flag == 0);

    my ($sum);

    foreach $entry (sort @VERSION)
    {
	print "$entry\n";
	$entry =~ /^\$Id:\s+(\S+)\s+(\S+)/;

	my ($letter, $s);
	foreach $letter (split(//, $1))
	{
	    $s += (ord($letter) - ord('0') + 1) / (ord('z') - ord('a'));
	}
	$sum += ($s / length($1)) * $2;
    }
    $sum /= 2;
    printf "overall checksum = %.4f\n",$sum / @VERSION;

    exit 0;
}


1
