""" MessageManager.py

Manages status messages
"""
__copyright__ = "Copyright (c) 2002-2005 Free Software Foundation, Inc."
__license__ = """
Straw is free software; you can redistribute it and/or modify it under the
terms of the GNU General Public License as published by the Free Software
Foundation; either version 2 of the License, or (at your option) any later
version.

Straw is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
A PARTICULAR PURPOSE. See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with
this program; if not, write to the Free Software Foundation, Inc., 59 Temple
Place - Suite 330, Boston, MA 02111-1307, USA. """

import Event

class MessageManager(Event.SignalEmitter):
    def __init__(self):
        Event.SignalEmitter.__init__(self)
        self.initialize_slots(Event.StatusDisplaySignal)
        self.__messages = []

    def post_message(self, message):
        self.__messages.append(message)
        self.emit_signal(Event.StatusDisplaySignal(self))

    def read_message(self):
        return self.__messages.pop(0)

    def number_of_messages(self):
        return len(self.__messages)

mm_instance = None

def get_instance():
    global mm_instance
    if mm_instance is None:
        mm_instance = MessageManager()
    return mm_instance

