/* This file is part of Strigi Desktop Search
 *
 * Copyright (C) 2006 Jos van den Oever <jos@vandenoever.info>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */
#include "hitmenuitem.h"
#include <qlabel.h>
#include <qpainter.h>
#include <krun.h>
#include <qfontmetrics.h>
#include <qfileinfo.h>
#include <qsimplerichtext.h>

HitMenuItem::HitMenuItem(const QPixmap& p, const QString& t, const QString& u)
        :icon(p), text(t), uri(u) {
}
void
HitMenuItem::paint( QPainter* p, const QColorGroup& /*cg*/, bool /*act*/,
        bool /*enabled*/, int /*x*/, int y, int w, int h ) {
    p->drawPixmap(0, y, icon);
    QSimpleRichText rt(text, p->font());
    rt.setWidth(8*icon.width());
    QRect r(icon.width(), y, w, h);//8*icon.width(), h);
    rt.draw(p, icon.width(), y, r, QColorGroup());
}
QSize
HitMenuItem::sizeHint() {
    int height = icon.height();
    QFontMetrics fm(font);
    if (2*fm.height() > height) height = 2*fm.height();
//    int width = icon.width() + fm.boundingRect(text).width();
    return QSize(8*icon.width(), height);
}
void
HitMenuItem::open() {
    QFileInfo fi(uri);
    KURL url;
    if (!fi.exists()) {
        url = "jstream:"+uri;
    } else {
        url = uri;
    }
    QString cmd = "kfmclient exec '"+url.url()+'\'';
    KRun::runCommand(cmd);
}
