/* ====================================================================
 * Copyright (c) 2006,      Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_ACTIONFACTORY_H
#define _SC_ACTIONFACTORY_H

// qt
class QAction;
class QObject;


enum ActionFactoryIds
{
  afNull = 0,
  afDiffDlg,  // open the diff dialog
  afMax
};


/**
 * Factory class for creating QActions.
 */
class ActionFactory
{
private:
  ActionFactory();

public:
  /**
   * create the qaction identifed by key and connect its activated() signal to
   * the given receiver/slot.
   */
  static QAction* createAction(
    long key, QObject* parent, const QObject* receiver, const char* slot );

  /**
   * create the qaction identifed by key and connect the given signal to the
   * given receiver/slot.
   */
  static QAction* createAction(
    long key, QObject* parent, const char* signal, const QObject* receiver,
    const char* slot );

private:
  static QAction* createAction( long key, QObject* parent );
};

#endif // _SC_ACTIONFACTORY_H
