/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "CopyCmd.h"
#include "CopyParam.h"
#include "CmdResultCallback.h"
#include "CmdProgressCallback.h"
#include "svn/Client.h"
#include "svn/CommitInfo.h"


CopyCmd::CopyCmd( CopyParam* param, CmdResultCallback* cb )
: ScCmd(param->getId()), _param(param), _cb(cb)
{
}

CopyCmd::~CopyCmd()
{
  delete _cb;
}

void CopyCmd::run()
{
  sc::Error*      err;
  svn::CommitInfo info;

  _prgscb->started( getId(), _param, getCancel() );

  err = _client->copy( _param->getCommitInfo(), _param->getSrcPathsOrUrls(),
    *_param->getSrcRevision(), _param->getDstPathOrUrl() );

  _param->setError( err );
  _prgscb->finished( getId(), _param );

  _cb->handleResult( _param, err );
}
