/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "MoveCmd.h"
#include "MoveParam.h"
#include "CmdResultCallback.h"
#include "CmdProgressCallback.h"
#include "svn/Client.h"
#include "svn/CommitInfo.h"
#include "util/Error.h"


MoveCmd::MoveCmd( MoveParam* param, CmdResultCallback* cb )
: ScCmd(param->getId()), _param(param), _cb(cb)
{
}

MoveCmd::~MoveCmd()
{
  delete _cb;
}

void MoveCmd::run()
{
  sc::Error*      err;
  svn::CommitInfo info;

  _prgscb->started( getId(), _param, getCancel() );

  err = _client->move( _param->getCommitInfo(), _param->getSrcPathsOrUrls(),
    *_param->getSrcRevision(), _param->getDstPathOrUrl(), _param->getForce() );

  _param->setError( err );
  _prgscb->finished( getId(), _param );

  _cb->handleResult( _param, err );
}
