/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_EXCEPTIONEVENT_H
#define _SC_EXCEPTIONEVENT_H

// sc
#include "CustomEvents.h"
#include "util/Stackframe.h"
namespace sc {
  class Error;
}

// qt
#include <qevent.h>

/**
 * Event class for an exception.
 */

class ExceptionEvent : public QCustomEvent
{
public:
  /**
   * Create a new ExceptionEvent.
   *
   * \param e     the error.
   * \param stack the stack.
   */
  ExceptionEvent( const sc::Error* e, const Stackframes& stack )
    : QCustomEvent(ScExceptionEvent), _err(e), _stack(stack)
  {
  }

  const sc::Error* getError() const
  {
    return _err;
  }

  const Stackframes& getStack() const
  {
    return _stack;
  }

private:
  const sc::Error*  _err;
  const Stackframes _stack;
};

#endif // _SC_EXCEPTIONEVENT_H
