/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_PROJECTSETTINGS_H
#define _SC_PROJECTSETTINGS_H

// sc
class Project;

// sys
#include <vector>


typedef std::vector<Project*> Projects;


class ProjectSettings
{
public:
  virtual ~ProjectSettings(){}

  virtual void getProjects( Projects& projects ) = 0;
  virtual void setProject( const Project* project ) = 0;
  virtual void removeProject( const Project* project ) = 0;
};

#endif // _SC_PROJECTSETTINGS_H
