/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_CONFIGMANAGER_H
#define _SC_CONFIGMANAGER_H

//sc
#include "settings/FontSettings.h"
#include "sublib/DebugSettings.h"
#include "sublib/settings/ColorSettings.h"
class ConfigFile;
class ConfigData;


class ConfigManager :
  public FontSettings,
  public ColorSettings,
  public DebugSettings
{
public:
  ConfigManager();
  ~ConfigManager();

  void load();
  void save();

  // FontSettings
  QFont getGeneralFont();
  void setGeneralFont( const QFont& );
  QFont getEditorFont();
  void setEditorFont( const QFont& );

  // ColorSettings
  void getColors( Colors& );
  void setColors( const Colors& );

  /**
   * \name DebugSettings.
   */
  // @{
  bool getDump();
  void setDump(bool);
  bool getLog();
  void setLog(bool);
  bool getL10n();
  void setL10n(bool);
  // @}

  /**
   * \name Options.
   */
  // @{
  bool getOptWhitespace() const;
  void setOptWhitespace( bool );
  // @}

private:
  Color getColor( long id, const sc::String& name, const QColor& def, const sc::String& desc );

  ConfigFile* _file;
  ConfigData* _cfg;

private:
  bool _dbgDump;  // DebugSettings, not persistent
};


#endif //  _SC_CONFIGMANAGER_H
