/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SVN_WCENTRY_H
#define _SVN_WCENTRY_H

// sc
#include "util/String.h"
#include "svn.h"

// svn
#include <svn_wc.h>


namespace svn
{

// wc/svn_wc_schedule_t
enum WcSchedule
{
  WcSchedule_Normal  = svn_wc_schedule_normal,
  WcSchedule_Add     = svn_wc_schedule_add,
  WcSchedule_Delete  = svn_wc_schedule_delete,
  WcSchedule_Replace = svn_wc_schedule_replace
};


// svn_wc_entry_t
class WcEntry
{
public:
  WcEntry( svn_wc_entry_t* );
  WcEntry( const WcEntry& src );

  Revnumber getRevnumber() const;
  NodeKind getKind() const;
  bool isDir() const;
  const sc::String& getUrl() const;

  Revnumber getCmtRevnumber() const;
  const sc::String& getCmtAuthor() const;

  const sc::String& getConflictOld() const;
  const sc::String& getConflictNew() const;
  const sc::String& getConflictWrk() const;

  const sc::String& getLockToken() const;

private:
  sc::String _name;
  Revnumber  _revision;
  sc::String _url;
  sc::String _reposUrl;
  sc::String _uuid;
  NodeKind   _kind;

  WcSchedule _schedule;
  bool       _copied;
  bool       _deleted;
  bool       _absent;
  bool       _incomplete;

  sc::String _copyFromUrl;
  Revnumber  _copyFromRev;

  sc::String _conflictOld;
  sc::String _conflictNew;
  sc::String _conflictWrk;
  sc::String _propReject;
  Date       _textTime;
  Date       _propTime;

  sc::String _checksum;

  Revnumber  _cmtRevision;
  Date       _cmtDate;
  sc::String _cmtAuthor;

  sc::String _lockToken;
  sc::String _lockOwner;
  sc::String _lockComment;
  Date       _lockTime;
};


} // namespace

#endif // _SVN_WCENTRY_H

