/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_UTIL_APR_EXCEPTION_H
#define _SC_UTIL_APR_EXCEPTION_H

// sc
#include "Exception.h"
namespace sc {
  class Error;
}

// apr
#include <apr_errno.h>


namespace apr
{

class Exception : public sc::Exception
{
public:
  Exception( apr_status_t status, const sc::String& msg = sc::NullString );
  virtual ~Exception();

  // Exception
  const sc::Error* getError() const;

private:
  const sc::Error* _error;
};


} // namespace

#endif //  _SC_UTIL_APR_EXCEPTION_H
