/* ====================================================================
 * Copyright (c) 2003-2007, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_PROPSETREVPARAM_H
#define _SC_PROPSETREVPARAM_H

// sc
#include "ScParam.h"
#include "ScParamVisitor.h"
#include "util/String.h"
#include "svn/Revision.h"


/**
 * Parameter class for PropSetRevCmd.
 */
class PropSetRevParam : public ScParam
{
public:
  PropSetRevParam( const sc::String& propName, const sc::String& propVal, const sc::String&
    pathOrUrl, const svn::RevisionPtr srcRev, bool force ) : _pathOrUrl(pathOrUrl),
     _srcRev(srcRev), _propName(propName), _propVal(propVal), _force(force)
  {
  }

  ~PropSetRevParam()
  {
  }

  const sc::String& getPropName() const
  {
    return _propName;
  }

  void setPropName( const sc::String& propName )
  {
    _propName = propName;
  }

  const sc::String& getPropVal() const
  {
    return _propVal;
  }

  void setPropVal( const sc::String& propVal )
  {
    _propVal = propVal;
  }

  const sc::String& getPathOrUrl() const
  {
    return _pathOrUrl;
  }

  void setPathOrUrl( const sc::String& pathOrUrl )
  {
    _pathOrUrl = pathOrUrl;
  }
  
  const svn::RevisionPtr getRevision()
  {
    return _srcRev;
  }

  void setRevision( svn::RevisionPtr rev )
  {
    _srcRev = rev;
  }

  bool getForce() const
  {
    return _force;
  }

  svn::Revnumber& getRevnumber()
  {
    return _revnum;
  }

  ScParamAccept(PropSetRevParam);

private:
  // in
  sc::String       _pathOrUrl;
  svn::RevisionPtr _srcRev;

  sc::String       _propName;
  sc::String       _propVal;
  bool             _force;

  // out
  svn::Revnumber   _revnum;
};

#endif // _SC_PROPSETREVPARAM_H
