/*
 *  Copyright (C) 2008 Nicolas Vion <nico@picapo.net>
 *
 *   This file is part of swac-explore.
 *
 *   Foobar is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   Foobar is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with swac-explore; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "gstreamer.hh"
#include "messages.hh"

static gboolean my_bus_callback (GstBus *bus, GstMessage *msg, gpointer data) {
	GMainLoop *loop = (GMainLoop *) data;

	switch (GST_MESSAGE_TYPE (msg)) {
		case GST_MESSAGE_EOS: {
			//g_print ("End-of-stream\n");
			g_main_loop_quit (loop);
			break;
		}
		case GST_MESSAGE_ERROR: {
			gchar *debug;
			GError *err;

			gst_message_parse_error (msg, &err, &debug);
			g_free (debug);

			g_print ("Error: %s\n", err->message);
			g_error_free (err);

			g_main_loop_quit (loop);
			break;
		}
		default:
			break;
	}
	return TRUE;
}



void tGst::init (int argc, char *argv[]) {
	gst_init (&argc, &argv);
	loop = g_main_loop_new (NULL, FALSE);

	play = gst_element_factory_make ("playbin", "play");
	
	if (!play) {
		message_error("Gstreamer error: can not create element \"playbin\".");
		return;
	}

	bus = gst_pipeline_get_bus (GST_PIPELINE (play));
	gst_bus_add_watch (bus, my_bus_callback, loop);
	gst_object_unref (bus);
}


void tGst::play_url(const char *url) {
	if (!play) 
		return;

	/* SET */
	g_object_set (G_OBJECT (play), "uri", url, NULL);

	/* PLAY */
	gst_element_set_state (play, GST_STATE_PLAYING);
	g_main_loop_run (loop);
	gst_element_set_state (play, GST_STATE_NULL);
}

void tGst::close() {
	if (!play) 
		return;

	gst_element_set_state (play, GST_STATE_NULL);
	gst_object_unref (GST_OBJECT (play));
}


/*

int main (int argc, char *argv[]) {
	if (argc != 2) {
		g_print ("Usage: %s <URI>\n", argv[0]);
		return -1;
	}

	tGst * gst = new class tGst;
	gst->init(argc, argv);

	gst->play_url(argv[1]);
	gst->close();
}

*/
